/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.Hint;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.TableReference;

public class InsertStatement
extends SQLStatement {
    private TableReference table;
    private ColumnReference[] columnList = null;
    private Query insertSource;
    private Hint[] hints;

    public InsertStatement(TableReference aTable, Query anInsertSource) {
        this.table = aTable;
        this.insertSource = anInsertSource;
    }

    public InsertStatement(TableReference aTable, ColumnReference[] aColumnList, Query anInsertSource) {
        this.table = aTable;
        this.columnList = aColumnList;
        this.insertSource = anInsertSource;
    }

    public void accept(SQLVisitor visitor) {
        visitor.setStatemntType(this.getStatementType());
        visitor.visitInsertStatementBefore(this);
        if (this.table != null) {
            this.table.accept(visitor);
        }
        if (this.columnList != null) {
            int i = 0;
            while (i < this.columnList.length) {
                this.columnList[i].accept(visitor);
                ++i;
            }
        }
        if (this.insertSource != null) {
            this.insertSource.accept(visitor);
        }
        visitor.visitInsertStatement(this);
    }

    public ColumnReference[] getColumnList() {
        return this.columnList;
    }

    public Query getInsertSource() {
        return this.insertSource;
    }

    public TableReference getTable() {
        return this.table;
    }

    public void setColumnList(ColumnReference[] cr) {
        this.columnList = cr;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append("INSERT INTO ");
        this.table.toSqlTxt(expert, strBuf);
        if (this.columnList != null && this.columnList.length > 0) {
            strBuf.append(" (");
            this.columnList[0].toSqlTxt(expert, strBuf);
            int col_i = 1;
            while (col_i < this.columnList.length) {
                strBuf.append(",");
                this.columnList[col_i].toSqlTxt(expert, strBuf);
                ++col_i;
            }
            strBuf.append(") ");
        } else {
            strBuf.append(" ");
        }
        this.insertSource.toSqlTxt(expert, strBuf);
    }

    public void setHints(Hint[] hints) {
        this.hints = hints;
    }

    public int getStatementType() {
        return 4;
    }
}

