/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;

public class DerivedTable
extends Query {
    private Query subquery;
    private String correlationName;
    private String[] columnNames = null;

    public DerivedTable(Query aSubquery, String aCorrelationName, String[] aColumnNameList) {
        this.subquery = aSubquery;
        this.correlationName = aCorrelationName;
        this.columnNames = aColumnNameList;
    }

    public DerivedTable(Query aSubquery, String aCorrelationName) {
        this.subquery = aSubquery;
        this.correlationName = aCorrelationName;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitDerivedTableBefore(this);
        if (this.subquery != null) {
            this.subquery.accept(visitor);
        }
        visitor.visitDerivedTable(this);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    public Query getSubquery() {
        return this.subquery;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append("(");
        this.subquery.toSqlTxt(expert, strBuf);
        strBuf.append(") ");
        expert.toDelimitedIdentifier(this.correlationName, strBuf);
        if (this.columnNames != null && this.columnNames.length > 0) {
            strBuf.append(" (");
            strBuf.append(this.columnNames[0]);
            int col_i = 1;
            while (col_i < this.columnNames.length) {
                strBuf.append(",");
                strBuf.append(this.columnNames[col_i]);
                ++col_i;
            }
            strBuf.append(")");
        }
    }
}

