/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;

public class CreateViewStatement
extends SQLStatement {
    private boolean isGrouped;
    private boolean isPossiblyUpdatable;
    private String viewName;
    private String[] columnNameList;
    private Query query;
    private boolean withCheckOption;

    public CreateViewStatement(String viewName, String[] columnNameList, Query query, boolean withCheckOption) {
        this.viewName = viewName;
        this.columnNameList = columnNameList;
        this.query = query;
        this.withCheckOption = withCheckOption;
    }

    public void accept(SQLVisitor visitor) {
        visitor.setStatemntType(this.getStatementType());
        visitor.visitCreateViewStatementBefore(this);
        this.query.accept(visitor);
        visitor.visitCreateViewStatement(this);
    }

    public String[] getColumnNameList() {
        return this.columnNameList;
    }

    public Query getQuery() {
        return this.query;
    }

    public String getName() {
        return this.viewName;
    }

    void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append("CREATE VIEW ");
        expert.toDelimitedIdentifier(this.viewName, strBuf);
        if (this.columnNameList != null && this.columnNameList.length > 0) {
            strBuf.append(" (");
            int i = 0;
            while (i < this.columnNameList.length) {
                if (i != 0) {
                    strBuf.append(',');
                }
                expert.toDelimitedIdentifier(this.columnNameList[i], strBuf);
                ++i;
            }
            strBuf.append(')');
        }
        strBuf.append(" AS ");
        this.query.toSqlTxt(expert, strBuf);
        if (this.withCheckOption) {
            strBuf.append(" WITH CHECK OPTION");
        }
    }

    public boolean hasCheckOption() {
        return this.withCheckOption;
    }

    public int getStatementType() {
        return 256;
    }

    public boolean isPossiblyUpdatable() {
        return this.isPossiblyUpdatable;
    }

    public boolean isGrouped() {
        return this.isGrouped;
    }

    public void setGrouped(boolean b) {
        this.isGrouped = b;
    }

    public void setPossiblyUpdatable(boolean b) {
        this.isPossiblyUpdatable = b;
    }
}

