/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.ComparisonOperator;
import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ComparisonPredicate
extends SearchCondition {
    private RowValue leftOperand;
    private RowValue rightOperand;
    private int comparisonOperator;

    public ComparisonPredicate(RowValue theLeftOperand, int aComparisonOperator, RowValue theRightOperand) {
        this.leftOperand = theLeftOperand;
        this.comparisonOperator = aComparisonOperator;
        this.rightOperand = theRightOperand;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitComparisonPredicateBefore(this);
        if (this.leftOperand != null) {
            this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand.accept(visitor);
        }
        visitor.visitComparisonPredicate(this);
    }

    public RowValue getLeftOperand() {
        return this.leftOperand;
    }

    public int getOperator() {
        return this.comparisonOperator;
    }

    public RowValue getRightOperand() {
        return this.rightOperand;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        if (this.leftOperand instanceof Query) {
            expert.toSubquery((Query)this.leftOperand, strBuf);
        } else {
            this.leftOperand.toSqlTxt(expert, strBuf);
        }
        strBuf.append(' ');
        strBuf.append(ComparisonOperator.getText(this.comparisonOperator));
        strBuf.append(' ');
        if (this.rightOperand instanceof Query) {
            expert.toSubquery((Query)this.rightOperand, strBuf);
        } else {
            this.rightOperand.toSqlTxt(expert, strBuf);
        }
    }

    public boolean evaluate(HostVariableValues values, ResultSet rs) throws SQLException {
        throw new SQLException("tmp");
    }

    public boolean supportsEvaluation() {
        return false;
    }
}

