/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.catalog.Column;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.ValueExpression;

public class ColumnReference
extends ValueExpression {
    private String tableName = null;
    private String columnName;
    private transient Column columnDescriptor = null;

    public ColumnReference(String aColumnName) {
        this.columnName = aColumnName;
    }

    public ColumnReference(String aTableName, String aColumnName) {
        this.tableName = aTableName;
        this.columnName = aColumnName;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitColumnReferenceBefore(this);
        visitor.visitColumnReference(this);
    }

    public Column getColumnDescriptor() {
        return this.columnDescriptor;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setColumnDescriptor(Column aColumnDescriptor) {
        this.columnDescriptor = aColumnDescriptor;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        expert.toQualifiedName(this.tableName, this.columnName, strBuf);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toSqlTxt(new SqlTextExpert(), buffer);
        return buffer.toString();
    }
}

