/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanAnd
extends SearchCondition {
    private SearchCondition[] operands;

    public BooleanAnd(SearchCondition[] aConditionList) {
        this.operands = aConditionList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitBooleanAndBefore(this);
        if (this.operands != null) {
            int i = 0;
            while (i < this.operands.length) {
                if (this.operands[i] != null) {
                    this.operands[i].accept(visitor);
                }
                ++i;
            }
        }
        visitor.visitBooleanAnd(this);
    }

    public SearchCondition[] getOperands() {
        return this.operands;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        int op_i = 0;
        while (op_i < this.operands.length) {
            boolean use_braces;
            boolean bl = use_braces = this.operands[op_i] instanceof BooleanOr && ((BooleanOr)this.operands[op_i]).getOperands().length > 1;
            if (op_i > 0) {
                strBuf.append(" AND ");
            }
            if (use_braces) {
                strBuf.append("(");
            }
            this.operands[op_i].toSqlTxt(expert, strBuf);
            if (use_braces) {
                strBuf.append(")");
            }
            ++op_i;
        }
    }

    public boolean evaluate(HostVariableValues hv, ResultSet rs) throws SQLException {
        int op_i = 0;
        while (op_i < this.operands.length) {
            if (!this.operands[op_i].evaluate(hv, rs)) {
                return false;
            }
            ++op_i;
        }
        return true;
    }
}

