/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Query;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.ValueExpression;

public class ArithmeticExpression
extends ValueExpression {
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    private ValueExpression leftOperand;
    private ValueExpression rightOperand;
    private int op;

    public ArithmeticExpression(ValueExpression theLeftOperand, int anOperator, ValueExpression theRightOperand) {
        this.leftOperand = theLeftOperand;
        this.op = anOperator;
        this.rightOperand = theRightOperand;
    }

    public ArithmeticExpression(int anOperator, ValueExpression theOperand) {
        this.leftOperand = null;
        this.op = anOperator;
        this.rightOperand = theOperand;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitArithmeticExpressionBefore(this);
        if (this.leftOperand != null) {
            this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand.accept(visitor);
        }
        visitor.visitArithmeticExpression(this);
    }

    public ValueExpression getLeftOperand() {
        return this.leftOperand;
    }

    public int getOperator() {
        return this.op;
    }

    public ValueExpression getRightOperand() {
        return this.rightOperand;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        if (this.leftOperand != null) {
            this.operandToTxt(this.leftOperand, expert, strBuf);
        }
        switch (this.op) {
            case 1: {
                strBuf.append(" + ");
                break;
            }
            case 2: {
                strBuf.append(" - ");
                break;
            }
            case 3: {
                strBuf.append(" * ");
                break;
            }
            case 4: {
                strBuf.append(" / ");
            }
        }
        this.operandToTxt(this.rightOperand, expert, strBuf);
    }

    private void operandToTxt(RowValue operand, SqlTextExpert expert, StringBuffer strBuf) {
        if (operand instanceof Query) {
            expert.toSubquery((Query)operand, strBuf);
        } else if (operand instanceof ArithmeticExpression) {
            strBuf.append("(");
            operand.toSqlTxt(expert, strBuf);
            strBuf.append(")");
        } else {
            operand.toSqlTxt(expert, strBuf);
        }
    }
}

