/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.engine.lib.time.SystemTime;
import com.sap.sql.trace.Attribute;
import com.sap.sql.trace.BindParams;
import com.sap.sql.trace.DbId;
import com.sap.sql.trace.Duration;
import com.sap.sql.trace.ErrCode;
import com.sap.sql.trace.FakeException;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.InParams;
import com.sap.sql.trace.MethodName;
import com.sap.sql.trace.Results;
import com.sap.sql.trace.SQLTracable;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.trace.Utils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLTracer {
    private Duration duration;
    private DbId dbId;
    private long startTime = 0L;
    private long startTimeStamp = 0L;
    private List params = new ArrayList(10);
    private String className = "";
    private MethodName methodNameObj = new MethodName("");
    private List ids = new ArrayList(3);
    private Map tmpIds = null;
    InParams inParams = null;
    BindParams bindParams = null;
    TraceContext traceContext = null;
    List additionalAttributes = null;

    public SQLTracer(String className, String sDbId) {
        if (this.dbId != null) {
            this.dbId = new DbId(sDbId);
        }
        if (className != null) {
            this.className = className;
        }
    }

    public SQLTracer(SQLTracable o) {
        if (o != null) {
            this.className = o.getClass().getName();
            Id[] ids = o.getIds();
            if (ids != null) {
                int i = 0;
                while (i < ids.length) {
                    if (ids[i] != null) {
                        this.ids.add(ids[i]);
                    }
                    ++i;
                }
            }
        }
        if (o.getDbIdForTrace() != null) {
            this.dbId = new DbId(o.getDbIdForTrace());
        }
    }

    public void startTimer() {
        long stamp = SystemTime.currentTimeMicros();
        this.startTime = stamp / 1000L;
        this.startTimeStamp = stamp;
    }

    public void stopTimer() {
        long stopTimeStamp = SystemTime.currentTimeMicros();
        this.duration = new Duration();
        if (this.startTime == 0L) {
            this.duration.setStartTime(stopTimeStamp / 1000L);
            this.duration.setDuration(-1L);
        } else {
            this.duration.setStartTime(this.startTime);
            this.duration.setDuration(stopTimeStamp - this.startTimeStamp);
            this.startTime = 0L;
        }
    }

    public void addId(Object o, String type) {
        this.ids.add(new Id(o, type));
    }

    public void setId(Object o, String type) {
        if (type == null) {
            return;
        }
        if (this.tmpIds == null) {
            this.tmpIds = new HashMap();
        }
        this.tmpIds.put(type, new Id(o, type));
    }

    public void addInParam(String param) {
        if (this.inParams == null) {
            this.inParams = new InParams();
        }
        this.inParams.add(param);
    }

    public void addBindParam(int position, String param) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.addParam(position, param);
    }

    public void clearBindParams() {
        this.bindParams = null;
    }

    public void setBatch(int nrOfVarsPerBatch) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setBatch(nrOfVarsPerBatch);
    }

    public void setTraceContext(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void addAttribute(String tagName, String value) {
        if (this.additionalAttributes == null) {
            this.additionalAttributes = new ArrayList();
        }
        this.additionalAttributes.add(new Attribute(tagName, value));
    }

    public void trace(String methodName, String message) {
        Iterator<Object> it;
        if (!SQLTrace.isOn()) {
            return;
        }
        this.params.add(this.duration);
        this.params.add(this.dbId);
        this.methodNameObj.setMethodName(this.className + "." + methodName);
        this.params.add(this.methodNameObj);
        if (!this.ids.isEmpty()) {
            it = this.ids.iterator();
            while (it.hasNext()) {
                this.params.add(it.next());
            }
        }
        if (this.inParams != null) {
            this.params.add(this.inParams);
        }
        if (this.bindParams != null) {
            this.params.add(this.bindParams);
        }
        if (this.traceContext != null) {
            this.params.add(this.traceContext);
        }
        if (this.additionalAttributes != null && !this.additionalAttributes.isEmpty()) {
            it = this.additionalAttributes.iterator();
            while (it.hasNext()) {
                this.params.add(it.next());
            }
        }
        if (this.tmpIds != null) {
            it = this.tmpIds.values().iterator();
            while (it.hasNext()) {
                this.params.add(it.next());
            }
        }
        if (this.isStackTrace(methodName)) {
            try {
                throw new FakeException();
            }
            catch (FakeException e) {
                String stack = e.getStackTraceAsString();
                stack = Utils.processStackTrace(stack);
                this.params.add(new Attribute("stacktrace", stack));
            }
        }
        SQLTrace.getLogger().pathT(message, this.params.toArray());
        this.params.clear();
        this.inParams = null;
        this.bindParams = null;
        this.traceContext = null;
        this.additionalAttributes = null;
        this.tmpIds = null;
    }

    public void trace(String methodName) {
        this.trace(methodName, methodName);
    }

    public void trace(String methodName, String message, String result) {
        if (!SQLTrace.isOn()) {
            return;
        }
        if (result != null) {
            this.params.add(new Results(result));
        }
        this.trace(methodName, message);
    }

    public void trace(String methodName, Id id) {
        if (!SQLTrace.isOn()) {
            return;
        }
        if (id != null) {
            this.params.add(id);
        }
        this.trace(methodName, methodName);
    }

    public void traceException(SQLException e, String methodName, String message) {
        this.stopTimer();
        this.params.add(new ErrCode(e.getErrorCode(), e.getSQLState()));
        this.trace(methodName, "SQL_EXCEPTION: " + message);
    }

    public void traceException(SQLException e, String methodName, String message, TraceContext traceContext) {
        this.stopTimer();
        this.params.add(new ErrCode(e.getErrorCode(), e.getSQLState()));
        this.setTraceContext(traceContext);
        this.trace(methodName, "SQL_EXCEPTION: " + message);
    }

    private boolean isStackTrace(String methodName) {
        long dur;
        if (!SQLTrace.getIsStackTrace()) {
            return false;
        }
        String methodPattern = SQLTrace.getMethodPattern();
        int threshold = SQLTrace.getStacktraceThreshold();
        if ((methodPattern == null || "".equals(methodPattern)) && threshold == 0) {
            return true;
        }
        if (methodName == null) {
            return true;
        }
        boolean bMethod = methodName.indexOf(methodPattern) != -1;
        boolean bThreshold = threshold == 0 ? true : (this.duration == null ? true : (dur = this.duration.getDuration()) >= (long)threshold);
        return bThreshold && bMethod;
    }
}

