/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import java.util.Arrays;

public class SQLParameters {
    protected static final int INVALID_INDEX = -1;
    protected int maxIndex = -1;
    protected Object[] params;

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getContextIndex() {
        if (this.maxIndex < 1) {
            return 1;
        }
        return this.maxIndex + 1;
    }

    public Object[] getArray(int startIndex) {
        int length = this.maxIndex - startIndex + 1;
        if (0 >= length) {
            return null;
        }
        Object[] adjustedParams = new Object[length];
        System.arraycopy(this.params, startIndex, adjustedParams, 0, length);
        return adjustedParams;
    }

    public String toString(int startIndex) {
        int length = this.maxIndex - startIndex + 1;
        if (0 >= length) {
            return "";
        }
        StringBuffer tmpString = new StringBuffer(10 * length);
        int index = startIndex;
        while (index <= this.maxIndex) {
            tmpString.append(" :" + index + " = " + this.params[index]);
            ++index;
        }
        return tmpString.toString();
    }

    public void addParam(int parameterIndex, Object bindParam) {
        if (parameterIndex <= -1) {
            return;
        }
        if (parameterIndex > this.maxIndex) {
            this.maxIndex = parameterIndex;
        }
        if (null == this.params || parameterIndex >= this.params.length) {
            this.params = this.resizeParams(this.params, 2 * (1 + parameterIndex));
        }
        this.params[parameterIndex] = bindParam;
    }

    public void clearParameters() {
        if (null != this.params) {
            Arrays.fill(this.params, null);
        }
        this.maxIndex = -1;
    }

    private Object[] resizeParams(Object[] sourceArray, int newSize) {
        Object[] resizedArray = new Object[newSize];
        if (null != sourceArray) {
            System.arraycopy(sourceArray, 0, resizedArray, 0, sourceArray.length);
        }
        return resizedArray;
    }
}

