/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrITrace;
import com.sap.sql.trace.Duration;

public class DsrITraceImpl
implements DsrITrace {
    private static final String moduleName = "NativeSQL";
    private static final String moduleTyp = "Jdbc driver";
    private static final int version = 1;
    private DsrIPassport passport;
    private Duration duration;
    private String message;

    public DsrITraceImpl(DsrIPassport passport, Duration duration, String message) {
        this.passport = passport;
        this.duration = duration;
        this.message = message;
    }

    public int getTraceLevel() {
        return 1;
    }

    public String getComponentName() {
        return this.passport.getCompName();
    }

    public String getModuleName() {
        return moduleName;
    }

    public String getModuleType() {
        return moduleTyp;
    }

    public int getVersion() {
        return 1;
    }

    public String getExternalAccess() {
        return null;
    }

    public String GetTransId() {
        return this.passport.getTransId();
    }

    public int getDuration() {
        if (this.duration != null) {
            long d = this.duration.getDuration();
            if (d > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)d;
        }
        return -1;
    }

    public String getMessage() {
        return this.message;
    }

    public void reset(DsrIPassport passport, Duration duration, String message) {
        this.passport = passport;
        this.duration = duration;
        this.message = message;
    }
}

