/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tabstat;

import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.tabstat.StatItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class TableStatistics {
    private static boolean tabStatIsOn = false;
    private static HashMap tabStat = null;
    private static int limit = 0;
    private static int level = 0;

    public static synchronized void init(ConnectionContext connectionContext) {
        Properties props = connectionContext.getProperties();
        boolean activeProp = Boolean.valueOf(props.getProperty("com.sap.sql.tabstat.active"));
        if (activeProp) {
            int limitProp = Integer.parseInt(props.getProperty("com.sap.sql.tabstat.tablimit"));
            TableStatistics.start(limitProp);
        }
    }

    public static synchronized void start(int capacity) {
        if (capacity > 0) {
            tabStatIsOn = true;
            tabStat = new HashMap(capacity);
            limit = capacity;
        }
    }

    public static synchronized void stop() {
        tabStatIsOn = false;
        tabStat = null;
        level = 0;
        limit = 0;
    }

    public static synchronized boolean isSwitchedOn() {
        return tabStatIsOn;
    }

    public static synchronized void addSelectOp(String tableName) {
        if (tabStatIsOn) {
            TableStatistics.addOpCnt(tableName, (short)1, 1L);
        }
    }

    public static synchronized void addInsertOp(String tableName, long cnt) {
        if (tabStatIsOn) {
            TableStatistics.addOpCnt(tableName, (short)2, cnt);
        }
    }

    public static synchronized void addUpdateOp(String tableName, long cnt) {
        if (tabStatIsOn) {
            TableStatistics.addOpCnt(tableName, (short)3, cnt);
        }
    }

    public static synchronized void addDeleteOp(String tableName, long cnt) {
        if (tabStatIsOn) {
            TableStatistics.addOpCnt(tableName, (short)4, cnt);
        }
    }

    public static synchronized void dump() {
        if (tabStatIsOn) {
            Collection statData = tabStat.values();
            Iterator statIter = statData.iterator();
            while (statIter.hasNext()) {
                StatItem stat = (StatItem)statIter.next();
                stat.dumpOpCnt();
            }
        }
    }

    private static void addOpCnt(String tableName, short opType, long cnt) {
        if (tabStat.containsKey(tableName)) {
            StatItem stat = (StatItem)tabStat.get(tableName);
            stat.addOpCnt(opType, cnt);
            tabStat.put(tableName, stat);
        } else if (level < limit) {
            StatItem stat = new StatItem(tableName);
            stat.addOpCnt(opType, cnt);
            tabStat.put(tableName, stat);
            ++level;
        }
    }
}

