/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.BufferRecordProcessor;
import com.sap.sql.catalog.Column;
import com.sap.sql.tablebuffer.BufferHostVars;
import com.sap.sql.tablebuffer.BufferStatementInfo;
import com.sap.sql.tablebuffer.SearchConditionEvaluator;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectSublist;
import java.sql.SQLException;
import java.util.HashMap;

public class TableBufferRecordProcessor
implements BufferRecordProcessor {
    protected QuerySpecification qs = null;
    protected SearchConditionEvaluator searchConditionValue = null;
    protected BufferStatementInfo bufferStatementInfo;
    protected SearchCondition whereClause;
    protected int[] selectListColumnPosition;
    protected HashMap selectListColumnPositionByName;

    public TableBufferRecordProcessor() {
    }

    public TableBufferRecordProcessor(QuerySpecification qs, BufferHostVars hostVars, BufferStatementInfo buffStatementInfo) {
        if (null != qs) {
            this.bufferStatementInfo = buffStatementInfo;
            this.qs = qs;
            this.whereClause = qs.getWhereClause();
            if (null != this.whereClause) {
                this.searchConditionValue = new SearchConditionEvaluator(this.whereClause, hostVars);
            }
            this.setSelectListColumnPosition(qs);
        }
    }

    public boolean verifySearchCondition(BufferRecord bufferRecord) throws SQLException {
        return null == this.searchConditionValue ? true : this.searchConditionValue.verify(bufferRecord);
    }

    public int[] selectSublistOrder() {
        return this.selectListColumnPosition;
    }

    public int getColumnPosition(String columnName) {
        if (null == columnName || null == this.selectListColumnPositionByName) {
            return -1;
        }
        Integer columnIndex = (Integer)this.selectListColumnPositionByName.get(columnName);
        return null == columnIndex ? -1 : columnIndex;
    }

    public int getColumnPosition(int getPosition) {
        if (null == this.selectListColumnPosition) {
            return getPosition;
        }
        if (getPosition > this.selectListColumnPosition.length || getPosition < 1) {
            return -1;
        }
        return this.selectListColumnPosition[getPosition - 1];
    }

    private void setSelectListColumnPosition(QuerySpecification querySpecification) {
        SelectSublist[] selectList = querySpecification.getSelectList();
        if (selectList != null) {
            this.selectListColumnPositionByName = new HashMap(2 * selectList.length + 1);
            this.selectListColumnPosition = new int[selectList.length];
            int i = 0;
            while (i < selectList.length) {
                ColumnReference cr = (ColumnReference)selectList[i].getValue();
                Column col = cr.getColumnDescriptor();
                this.selectListColumnPosition[i] = col.getPosition();
                this.selectListColumnPositionByName.put(cr.getColumnName(), new Integer(this.selectListColumnPosition[i]));
                ++i;
            }
        }
    }
}

