/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferException;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.tablebuffer.BufferHostVars;
import com.sap.sql.tablebuffer.TableBufferException;
import com.sap.sql.tablebuffer.TableBufferGetObjectException;
import com.sap.sql.tablebuffer.TableBufferRTIllegalArgumentException;
import com.sap.sql.tablebuffer.TableBufferRTIndexOutOfBoundsException;
import com.sap.sql.tablebuffer.TypeConverter;
import com.sap.sql.tree.BigDecimalLiteral;
import com.sap.sql.tree.DefaultValue;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.FloatLiteral;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.IntegerLiteral;
import com.sap.sql.tree.Literal;
import com.sap.sql.tree.NullValue;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.UpdateStatement;
import com.sap.sql.types.CommonTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

class BufferStatementInfo {
    static final int STMT_SELECT = 0;
    static final int STMT_DELETE = 1;
    static final int STMT_INSERT = 2;
    static final int STMT_UPDATE = 3;
    static final DefaultValue DEFAULT_VALUE = new DefaultValue();
    private static final int INVALID_POSITION = -1;
    private final SQLStatement tree;
    private final int keyCnt;
    private int colCnt;
    private int stmtType;
    private ValueInfo[] values;
    private int[] keyIndex;
    private boolean bufferModify;

    private BufferStatementInfo(Table table, SQLStatement tree, int stmtType) {
        this.stmtType = stmtType;
        this.tree = tree;
        this.keyCnt = table.getPrimaryKeyCnt();
        this.bufferModify = false;
    }

    static BufferStatementInfo newInstance(SelectStatement selectStatement) {
        Table table = BufferStatementInfo.getTable(selectStatement);
        if (null == table) {
            return null;
        }
        BufferStatementInfo bsi = new BufferStatementInfo(table, selectStatement, 0);
        if (null == bsi) {
            return null;
        }
        bsi.initSelect();
        return bsi;
    }

    static BufferStatementInfo newInstance(DeleteStatement deleteStatement) {
        Table table = BufferStatementInfo.getTable(deleteStatement);
        if (null == table) {
            return null;
        }
        BufferStatementInfo bsi = new BufferStatementInfo(table, deleteStatement, 1);
        if (null == bsi) {
            return null;
        }
        bsi.initDelete();
        return bsi;
    }

    static BufferStatementInfo newInstance(InsertStatement insertStatement) {
        Table table = BufferStatementInfo.getTable(insertStatement);
        if (null == table) {
            return null;
        }
        BufferStatementInfo bsi = new BufferStatementInfo(table, insertStatement, 2);
        if (null == bsi) {
            return null;
        }
        bsi.initInsert();
        return bsi;
    }

    static BufferStatementInfo newInstance(UpdateStatement updateStatement) {
        Table table = BufferStatementInfo.getTable(updateStatement);
        BufferStatementInfo bsi = new BufferStatementInfo(table, updateStatement, 3);
        if (null == bsi) {
            return null;
        }
        bsi.initUpdate();
        return bsi;
    }

    private void initSelect() {
        this.values = new ValueInfo[this.keyCnt];
    }

    private void initDelete() {
        this.values = new ValueInfo[this.keyCnt];
    }

    private void initInsert() {
        this.colCnt = this.getTable().getColumnCnt();
        this.values = new ValueInfo[this.colCnt];
        this.keyIndex = new int[this.keyCnt];
    }

    private void initUpdate() {
        int setCnt = ((UpdateStatement)this.tree).getSetClauseList().length;
        this.colCnt = this.keyCnt + setCnt;
        this.values = new ValueInfo[this.colCnt];
    }

    void setBufferModify(boolean modify) {
        this.bufferModify = modify;
    }

    boolean getBufferModify() {
        return this.bufferModify;
    }

    public Table getTable() {
        switch (this.stmtType) {
            case 0: {
                return BufferStatementInfo.getTable((SelectStatement)this.tree);
            }
            case 1: {
                return BufferStatementInfo.getTable((DeleteStatement)this.tree);
            }
            case 2: {
                return BufferStatementInfo.getTable((InsertStatement)this.tree);
            }
            case 3: {
                return BufferStatementInfo.getTable((UpdateStatement)this.tree);
            }
        }
        return null;
    }

    public QuerySpecification getQuerySpecification() {
        switch (this.stmtType) {
            case 0: {
                return BufferStatementInfo.getQuerySpecification((SelectStatement)this.tree);
            }
        }
        return null;
    }

    int getKeyCnt() {
        return this.keyCnt;
    }

    int getStatementType() {
        return this.stmtType;
    }

    boolean addKeyValue(Column column, RowValueElement value) {
        ValueInfo info = this.newValue(column, value);
        if (null == info) {
            return false;
        }
        this.values[info.keyPos - 1] = info;
        return true;
    }

    boolean addSetValue(Column column, RowValueElement value, int index) {
        ValueInfo info = this.newValue(column, value);
        if (null == info) {
            return false;
        }
        this.values[this.keyCnt + index - 1] = info;
        return true;
    }

    boolean addValue(Column column, RowValueElement value) {
        ValueInfo info = this.newValue(column, value);
        int colPos = column.getPosition();
        int keyPos = column.getPrimaryKeyPosition();
        this.values[colPos - 1] = info;
        if (keyPos > 0) {
            this.keyIndex[keyPos - 1] = colPos;
        }
        return null != info;
    }

    boolean isGenericKeyComplete(int bufferKeyCnt) {
        int i = 0;
        while (i < this.keyCnt && this.values[i] != null) {
            ++i;
        }
        return i >= bufferKeyCnt;
    }

    boolean isPrimaryKeyComplete() {
        int i = 0;
        while (i < this.keyCnt && this.values[i] != null) {
            ++i;
        }
        return i == this.keyCnt;
    }

    BufferRecord getBufferKey(BufferAccess access, BufferHostVars hostValues) throws TableBufferException, BufferException {
        BufferRecord bufferKey = null;
        switch (this.stmtType) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < this.values.length && this.values[i] != null) {
                    ++i;
                }
                int bufKeyCount = i;
                if (bufKeyCount <= 0) break;
                bufferKey = access.getBufferKey(bufKeyCount);
                i = 0;
                while (i < bufKeyCount) {
                    this.setValue(bufferKey, i + 1, this.getVal(i, hostValues));
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.keyIndex.length && this.keyIndex[i] != 0) {
                    ++i;
                }
                int bufKeyCount = i;
                if (bufKeyCount <= 0) break;
                bufferKey = access.getBufferKey(bufKeyCount);
                i = 0;
                while (i < bufKeyCount) {
                    this.setValue(bufferKey, i + 1, this.getVal(this.keyIndex[i] - 1, hostValues));
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.keyCnt && this.values[i] != null) {
                    ++i;
                }
                int bufKeyCount = i;
                if (bufKeyCount <= 0) break;
                bufferKey = access.getBufferKey(bufKeyCount);
                i = 0;
                while (i < bufKeyCount) {
                    this.setValue(bufferKey, i + 1, this.getVal(i, hostValues));
                    ++i;
                }
                break;
            }
        }
        return bufferKey;
    }

    void fillBufferRecord(BufferRecord bufferRecord, BufferHostVars hostValues) throws TableBufferException, BufferException {
        int i = 0;
        while (i < this.values.length) {
            if (this.values != null) {
                this.setValue(bufferRecord, this.values[i].dbPos, this.getVal(i, hostValues));
            }
            ++i;
        }
    }

    String getName(int index) {
        return this.values[index - 1].name;
    }

    Object getValue(int index, BufferHostVars hostValues) throws TableBufferException {
        if (index < 1 || index > this.values.length) {
            throw TableBufferRTIndexOutOfBoundsException.getAndLog(this.getClass(), "index", index, 1, this.values.length);
        }
        return this.getVal(index - 1, hostValues);
    }

    boolean setDefault() {
        if (2 != this.stmtType) {
            return false;
        }
        Table table = this.getTable();
        int pos = 0;
        while (pos < this.values.length) {
            if (null == this.values[pos]) {
                this.values[pos] = this.newValue(table.getColumn(pos + 1), DEFAULT_VALUE);
            }
            ++pos;
        }
        return true;
    }

    private ValueInfo newValue(Column column, RowValueElement value) {
        ValueInfo info = new ValueInfo();
        info.rowValueElement = value;
        info.dbPos = column.getPosition();
        info.keyPos = column.getPrimaryKeyPosition();
        info.jdbcType = column.getJdbcType();
        info.name = column.getName().toUpperCase();
        if (value instanceof Literal) {
            if (value instanceof StringLiteral) {
                info.value = ((StringLiteral)value).getValue();
            } else if (value instanceof IntegerLiteral) {
                info.value = ((IntegerLiteral)value).getValue();
            } else if (value instanceof FloatLiteral) {
                info.value = new Float(((FloatLiteral)value).getValue());
            } else if (value instanceof BigDecimalLiteral) {
                info.value = ((BigDecimalLiteral)value).getValue();
            }
        } else if (value instanceof HostVariable) {
            info.hostVariablePos = ((HostVariable)value).getPosition();
        } else if (value instanceof NullValue) {
            info.value = null;
        } else if (value instanceof DefaultValue) {
            info.value = column.getDefault();
        } else {
            return null;
        }
        return info;
    }

    private Object getVal(int index, BufferHostVars hostValues) throws TableBufferException {
        ValueInfo info = this.values[index];
        if (null == info) {
            throw TableBufferGetObjectException.getAndLog(this.getClass(), "com.sap.sql.tablebuffer_1202", new Object[]{new Integer(index)});
        }
        return info.getValue(hostValues);
    }

    SQLStatement getSQLStatement() {
        return this.tree;
    }

    int getHostVariableCount() {
        ResultDescriptor[] hostVariables = this.tree.getHostVariablesList();
        return null == hostVariables ? 0 : hostVariables.length;
    }

    static QuerySpecification getQuerySpecification(SelectStatement selectStatement) {
        Query query = selectStatement.getQuery();
        if (!(query instanceof QuerySpecification)) {
            return null;
        }
        return (QuerySpecification)query;
    }

    static Table getTable(SelectStatement selectStatement) {
        QuerySpecification qSpec = BufferStatementInfo.getQuerySpecification(selectStatement);
        if (null == qSpec) {
            return null;
        }
        Query[] fromClause = qSpec.getFromClause();
        if (fromClause.length != 1) {
            return null;
        }
        if (!(fromClause[0] instanceof TableReference)) {
            return null;
        }
        return ((TableReference)fromClause[0]).getTableDescriptor();
    }

    static Table getTable(DeleteStatement deleteStatement) {
        return deleteStatement.getTable().getTableDescriptor();
    }

    static Table getTable(InsertStatement insertStatement) {
        return insertStatement.getTable().getTableDescriptor();
    }

    static Table getTable(UpdateStatement updateStatement) {
        return updateStatement.getTable().getTableDescriptor();
    }

    void setValue(BufferRecord bufferRecord, int index, Object value) throws TableBufferException, BufferException {
        if (value == null) {
            bufferRecord.setNull(index);
        } else if (value instanceof String) {
            bufferRecord.setString(index, (String)value);
        } else if (value instanceof Integer) {
            bufferRecord.setInteger(index, (Integer)value);
        } else if (value instanceof Short) {
            bufferRecord.setShort(index, (Short)value);
        } else if (value instanceof Long) {
            bufferRecord.setLong(index, (Long)value);
        } else if (value instanceof BigDecimal) {
            bufferRecord.setBigDecimal(index, (BigDecimal)value);
        } else if (value instanceof Double) {
            bufferRecord.setDouble(index, (Double)value);
        } else if (value instanceof Float) {
            bufferRecord.setFloat(index, (Float)value);
        } else if (value instanceof BigInteger) {
            bufferRecord.setBigInteger(index, (BigInteger)value);
        } else if (value instanceof Boolean) {
            bufferRecord.setBoolean(index, (Boolean)value);
        } else if (value instanceof Byte) {
            bufferRecord.setByte(index, (Byte)value);
        } else if (value instanceof char[]) {
            bufferRecord.setCharArray(index, (char[])value);
        } else if (value instanceof Character) {
            bufferRecord.setCharacter(index, (Character)value);
        } else if (value instanceof byte[]) {
            bufferRecord.setByteArray(index, (byte[])value);
        } else if (value instanceof Date) {
            bufferRecord.setDate(index, (Date)value);
        } else if (value instanceof Time) {
            bufferRecord.setTime(index, (Time)value);
        } else if (value instanceof Timestamp) {
            bufferRecord.setTimestamp(index, (Timestamp)value);
        } else {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "value", String.valueOf(value.getClass()));
        }
    }

    private class ValueInfo {
        RowValueElement rowValueElement;
        int dbPos;
        int keyPos;
        int hostVariablePos = -1;
        int jdbcType;
        String name;
        Object value;
        static /* synthetic */ Class array$C;
        static /* synthetic */ Class array$B;

        private ValueInfo() {
        }

        private final Class defaultMapping() {
            return CommonTypes.defaultMapping(this.jdbcType);
        }

        private final Object getValue(BufferHostVars hostValues) throws TableBufferException {
            Object val;
            Object object = val = this.hostVariablePos == -1 ? this.value : hostValues.get(this.hostVariablePos);
            if (2005 == this.jdbcType) {
                return TypeConverter.convert(val, array$C == null ? (array$C = ValueInfo.class$("[C")) : array$C);
            }
            if (2004 == this.jdbcType) {
                return TypeConverter.convert(val, array$B == null ? (array$B = ValueInfo.class$("[B")) : array$B);
            }
            return TypeConverter.convert(val, this.defaultMapping());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

