/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.Buffer;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.tablebuffer.BufferConnectionContext;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.tablebuffer.BufferSynchronizer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class BufferManagerFactory {
    private static final String BUFFER_SYNC_PREFIX = "TABLEBUFFER?";
    private static Hashtable buffers = new Hashtable();

    private BufferManagerFactory() {
    }

    public static synchronized BufferManager createBufferManager(BufferConnectionContext connectionContext) throws BufferNotAvailableException {
        String connectionID = connectionContext.getConnectionID();
        Properties props = connectionContext.getProperties();
        boolean active = Boolean.valueOf(props.getProperty("com.sap.sql.tablebuffer.manager.active"));
        Buffer buffer = null;
        if (active) {
            BufferInfo bufferInfo = (BufferInfo)buffers.get(connectionID);
            if (bufferInfo == null) {
                buffer = new TBJBuffer(connectionID);
                buffer.open(props);
                SyncManager.getInstance().registerSender(connectionContext.getBufferSyncID());
                SyncManager.getInstance().registerReceiver(connectionContext.getBufferSyncID(), new BufferSynchronizer(buffer.getBufferAccess()));
                bufferInfo = new BufferInfo(buffer);
                buffers.put(connectionID, bufferInfo);
            } else {
                buffer = bufferInfo.buffer;
            }
            bufferInfo.referenceCount++;
        }
        return new BufferManager(buffer, connectionContext);
    }

    public static synchronized void releaseBufferManager(BufferConnectionContext connectionContext) {
        String connectionID = connectionContext.getConnectionID();
        BufferManager bufferManager = connectionContext.getBufferManager();
        bufferManager.close();
        BufferInfo bufferInfo = (BufferInfo)buffers.get(connectionID);
        if (bufferInfo != null && --bufferInfo.referenceCount == 0) {
            SyncManager.getInstance().deregisterSender(connectionContext.getBufferSyncID());
            SyncManager.getInstance().deregisterReceiver(connectionContext.getBufferSyncID());
            bufferInfo.buffer.close();
            buffers.remove(connectionID);
        }
    }

    public static String getBufferSyncID(String connectionID) {
        return BUFFER_SYNC_PREFIX + connectionID;
    }

    public static synchronized Buffer[] getBuffers() {
        Buffer[] bufs = new Buffer[buffers.size()];
        int i = 0;
        Iterator iter = buffers.values().iterator();
        while (iter.hasNext()) {
            bufs[i] = ((BufferInfo)iter.next()).buffer;
            ++i;
        }
        return bufs;
    }

    static synchronized Buffer getBuffer(String connectionID) {
        BufferInfo bufferInfo = (BufferInfo)buffers.get(connectionID);
        if (bufferInfo == null) {
            return null;
        }
        return bufferInfo.buffer;
    }

    private static class BufferInfo {
        private Buffer buffer;
        private int referenceCount;

        private BufferInfo(Buffer buffer) {
            this.buffer = buffer;
            this.referenceCount = 0;
        }
    }
}

