/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sync;

import com.sap.sql.jdbc.VMContext;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.core.CoreServices;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncReader;
import com.sap.sql.sync.SyncRecordInputStream;
import com.sap.sql.sync.Synchronizer;
import com.sap.tc.logging.Location;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DbTableSyncReader
implements SyncReader {
    private static final String defaultLogTableName = "\"BC_SYNCLOG\"";
    private static final int myVMId = VMContext.getVMID();
    private long lastSyncTimeStamp;
    private SyncManager syncMan;
    private String logTableName = "\"BC_SYNCLOG\"";
    private DataSource ds;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$sync$DbTableSyncReader == null ? (class$com$sap$sql$sync$DbTableSyncReader = DbTableSyncReader.class$("com.sap.sql.sync.DbTableSyncReader")) : class$com$sap$sql$sync$DbTableSyncReader));
    private boolean testMode = false;
    static /* synthetic */ Class class$com$sap$sql$sync$DbTableSyncReader;

    public DbTableSyncReader(String logTableName) {
        TRACE.entering("DbTableSyncReader()");
        this.syncMan = SyncManager.getInstance();
        if (logTableName != null) {
            this.logTableName = "\"" + logTableName + "\"";
        }
        TRACE.debugT("DbTableSyncReader", "SyncReader created");
        TRACE.exiting();
    }

    public void start(DataSource ds) {
        TRACE.entering("start()");
        this.ds = ds;
        try {
            this.lastSyncTimeStamp = this.initTimestamp();
        }
        catch (SQLException e) {
            Syslog.logSQLException(this, e);
            this.lastSyncTimeStamp = -1L;
        }
        TRACE.debugT("DbTableSyncReader", "SyncReader started with timestamp " + this.lastSyncTimeStamp);
        TRACE.exiting();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performSynchronisation() {
        block23: {
            block19: {
                block17: {
                    block18: {
                        oneHour = 3600000L;
                        conn = null;
                        DbTableSyncReader.TRACE.entering("performSynchronisation()");
                        try {
                            try {
                                if (this.lastSyncTimeStamp == -1L) {
                                    var7_3 = null;
                                    if (conn == null) break block17;
                                    break block18;
                                }
                                conn = this.ds.getConnection();
                                natConn = CoreServices.getNativeConnection(conn);
                                this.readLog(natConn);
                                this.deleteLog(natConn, this.lastSyncTimeStamp - 3600000L);
                                break block19;
                            }
                            catch (SQLException e) {
                                Syslog.logSQLException(this, e, null, "DataSource.getConnection()");
                                var7_5 = null;
                                if (conn != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (SQLException e) {
                                        Syslog.logSQLException(this, e, null, "Connection.close()");
                                    }
                                }
                                DbTableSyncReader.TRACE.exiting();
                                return;
                            }
                            catch (Throwable t) {
                                block21: {
                                    Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1022", null, t);
                                    var7_6 = null;
                                    if (conn != null) {
                                        ** try [egrp 2[TRYBLOCK] [3 : 122->131)] { 
lbl40:
                                        // 1 sources

                                        conn.close();
                                        break block21;
lbl42:
                                        // 1 sources

                                        catch (SQLException e) {
                                            Syslog.logSQLException(this, e, null, "Connection.close()");
                                        }
                                    }
                                }
                                DbTableSyncReader.TRACE.exiting();
                                return;
                            }
                        }
                        catch (Throwable var6_16) {
                            block22: {
                                var7_7 = null;
                                if (conn != null) {
                                    ** try [egrp 2[TRYBLOCK] [3 : 122->131)] { 
lbl54:
                                    // 1 sources

                                    conn.close();
                                    break block22;
lbl56:
                                    // 1 sources

                                    catch (SQLException e) {
                                        Syslog.logSQLException(this, e, null, "Connection.close()");
                                    }
                                }
                            }
                            DbTableSyncReader.TRACE.exiting();
                            throw var6_16;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [3 : 122->131)] { 
lbl65:
                    // 1 sources

                    conn.close();
                    break block17;
lbl67:
                    // 1 sources

                    catch (SQLException e) {
                        Syslog.logSQLException(this, e, null, "Connection.close()");
                    }
                }
                DbTableSyncReader.TRACE.exiting();
                return;
            }
            var7_4 = null;
            if (conn != null) {
                ** try [egrp 2[TRYBLOCK] [3 : 122->131)] { 
lbl78:
                // 1 sources

                conn.close();
                break block23;
lbl80:
                // 1 sources

                catch (SQLException e) {
                    Syslog.logSQLException(this, e, null, "Connection.close()");
                }
            }
        }
        DbTableSyncReader.TRACE.exiting();
    }

    public void setTestMode() {
        this.testMode = true;
    }

    private void readLog(Connection conn) {
        String stmt = "select \"TIMESTMP\", \"VMID\", \"NOTEBOOK\" from " + this.logTableName + " where \"TIMESTMP\" > ? order by \"TIMESTMP\" ASC";
        try {
            PreparedStatement ps = conn.prepareStatement(stmt);
            ps.setLong(1, this.lastSyncTimeStamp);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.lastSyncTimeStamp = rs.getLong(1);
                int vmId = rs.getInt(2);
                if (vmId == myVMId && !this.testMode) continue;
                Blob logBook = rs.getBlob(3);
                int rowLength = (int)logBook.length();
                TRACE.debugT("DbTableSyncReader", "logbook length: " + rowLength);
                this.decodeLogBook(rowLength, logBook);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            Syslog.logSQLException(this, e, null, stmt);
        }
    }

    private long initTimestamp() throws SQLException {
        long l;
        String stmt = "select MAX(\"TIMESTMP\") from " + this.logTableName;
        Connection conn = null;
        long timestamp = 0L;
        try {
            conn = this.ds.getConnection();
            Connection natConn = CoreServices.getNativeConnection(conn);
            PreparedStatement ps = natConn.prepareStatement(stmt);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                timestamp = rs.getLong(1);
            }
            rs.close();
            ps.close();
            l = timestamp;
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return l;
    }

    private void deleteLog(Connection conn, long timestamp) {
        String sql = "delete from " + this.logTableName + " where \"TIMESTMP\" < ?";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setLong(1, timestamp);
            int i = ps.executeUpdate();
            TRACE.debugT("DbTableSyncReader", i + " rows deleted");
            ps.close();
        }
        catch (SQLException e) {
            Syslog.logSQLException(this, e, null, sql);
        }
    }

    private void decodeLogBook(int rowLength, Blob logBook) {
        try {
            int logLength = rowLength;
            DataInputStream dis = new DataInputStream(logBook.getBinaryStream());
            while (logLength > 0) {
                String bufferHandlerId = dis.readUTF();
                TRACE.debugT("DbTableSyncReader", "bufferHandlerId: " + bufferHandlerId);
                logLength -= bufferHandlerId.length() + 2;
                int syncRecLn = dis.readInt();
                TRACE.debugT("DbTableSyncReader", "syncRecLn: " + syncRecLn);
                logLength -= 4;
                byte[] syncOrder = new byte[syncRecLn];
                dis.readFully(syncOrder);
                TRACE.debugT("syncRequest: " + new String(syncOrder));
                logLength -= syncRecLn;
                this.performInvalidation(bufferHandlerId, syncOrder);
            }
            if (logLength != 0) {
                Syslog.logError(this, "com.sap.sql.sync_1021", new Object[]{new Integer(logLength)});
            }
        }
        catch (SQLException e) {
            Syslog.logSQLException(this.getClass(), e, null);
        }
        catch (IOException e) {
            Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1023", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    private void performInvalidation(String bufferHandlerId, byte[] syncOrder) {
        SyncRecordInputStream sris = new SyncRecordInputStream(syncOrder);
        Synchronizer bufferHandler = this.syncMan.getBufferHandler(bufferHandlerId);
        if (bufferHandler != null) {
            bufferHandler.synchronize(sris);
        } else {
            Syslog.logError(this.getClass(), "com.sap.sql.sync_1031", new Object[]{bufferHandlerId});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

