/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import antlr.LLkParser;
import antlr.MismatchedCharException;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.Parser;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.impl.BitSet;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.sqlparser.SQLLexerException;
import com.sap.sql.sqlparser.SQLParserTokenTypes;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BigDecimalLiteral;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.CommitStatement;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.CreateViewStatement;
import com.sap.sql.tree.DefaultValue;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.DerivedTable;
import com.sap.sql.tree.DummySearchCondition;
import com.sap.sql.tree.DummyValueExpression;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.FloatLiteral;
import com.sap.sql.tree.Hint;
import com.sap.sql.tree.HintDb2;
import com.sap.sql.tree.HintDb4;
import com.sap.sql.tree.HintDb6;
import com.sap.sql.tree.HintMss;
import com.sap.sql.tree.HintOracle;
import com.sap.sql.tree.HintSap;
import com.sap.sql.tree.HintSapdb;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.IntegerLiteral;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NonJoinQuery;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.NullValue;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.RollbackStatement;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.SortSpecification;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.UpdateStatement;
import com.sap.sql.tree.ValueExpression;
import com.sap.tc.logging.Location;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class SQLParser
extends LLkParser
implements SQLParserTokenTypes {
    static int TYP_BOOL = 1;
    static int TYP_QUERY = 2;
    static int TYP_TREF = 4;
    static int TYP_LIST = 8;
    static int TYP_STR = 16;
    static int TYP_NUM = 32;
    static int TYP_DATE = 64;
    static int TYP_INTV = 128;
    static int TYP_VAL = TYP_STR | TYP_NUM | TYP_DATE | TYP_INTV;
    static int TYP_NULL = 256;
    static int TYP_ROW = TYP_VAL | TYP_LIST;
    static int SPECIAL_MASK = -512;
    static int SPECIAL_qast = -1 * SPECIAL_MASK;
    static int SPECIAL_values = -2 * SPECIAL_MASK;
    static int SPECIAL_select = -3 * SPECIAL_MASK;
    static int SPECIAL_colref = -4 * SPECIAL_MASK;
    static int SPECIAL_id = -5 * SPECIAL_MASK;
    static int SPECIAL_vspec = -6 * SPECIAL_MASK;
    static int SPECIAL_literal = -7 * SPECIAL_MASK;
    static int SPECIAL_ndlist = -8 * SPECIAL_MASK;
    private Vector errorLog = null;
    private int hostVarCount;
    private Stack syntaxStack;
    private static final HintSap hintNoBuffer = new HintSap("BYPASSING BUFFER");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlparser$SQLParser == null ? (class$com$sap$sql$sqlparser$SQLParser = SQLParser.class$("com.sap.sql.sqlparser.SQLParser")) : class$com$sap$sql$sqlparser$SQLParser));
    private boolean bufferable;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "<4>", "<5>", "<6>", "<7>", "<8>", "<9>", "<10>", "<11>", "<12>", "<13>", "<14>", "<15>", "<16>", "<17>", "<18>", "<19>", "<20>", "<21>", "<22>", "<23>", "<24>", "<25>", "<26>", "<27>", "<28>", "<29>", "<30>", "<31>", "<32>", "<33>", "<34>", "<35>", "<36>", "<37>", "<38>", "<39>", "<40>", "<41>", "<42>", "<43>", "<44>", "<45>", "<46>", "<47>", "<48>", "<49>", "<50>", "<51>", "<52>", "<53>", "<54>", "<55>", "<56>", "<57>", "<58>", "<59>", "<60>", "<61>", "<62>", "<63>", "<64>", "<65>", "<66>", "<67>", "<68>", "<69>", "<70>", "<71>", "<72>", "<73>", "<74>", "<75>", "<76>", "<77>", "<78>", "<79>", "<80>", "<81>", "<82>", "<83>", "<84>", "<85>", "<86>", "<87>", "<88>", "<89>", "<90>", "<91>", "<92>", "<93>", "<94>", "<95>", "<96>", "<97>", "<98>", "<99>", "PSEUDO_NONKEYWORD", "AMPERSAND", "APPROX_NUM", "ASTERISK", "BIT_STRING", "CHAR_STRING", "COLON", "COMMA", "CONCAT", "DELIMITED_ID", "DOT", "EQ", "EXACT_NUM", "EXPONENT", "GE", "GT", "HEX_STRING", "ID", "INT", "LBRACK", "LE", "LPAREN", "LT", "MINUS", "NOTEQ", "PERCENT", "PLUS", "QUESTION", "RANGE", "RBRACK", "REGULAR_ID", "RPAREN", "SEMICOLON", "SEPARATOR", "SLASH", "WS", "HINTSTART", "HINTEND", "<138>", "<139>", "<140>", "<141>", "<142>", "<143>", "<144>", "<145>", "<146>", "<147>", "<148>", "<149>", "<150>", "<151>", "<152>", "<153>", "<154>", "<155>", "<156>", "<157>", "<158>", "<159>", "<160>", "<161>", "<162>", "<163>", "<164>", "<165>", "<166>", "<167>", "<168>", "<169>", "<170>", "<171>", "<172>", "<173>", "<174>", "<175>", "<176>", "<177>", "<178>", "<179>", "<180>", "<181>", "<182>", "<183>", "<184>", "<185>", "<186>", "<187>", "<188>", "<189>", "<190>", "<191>", "<192>", "<193>", "<194>", "<195>", "<196>", "<197>", "<198>", "<199>", "PSEUDO_USEDKEYWORD", "\"all\"", "\"alter\"", "\"and\"", "\"any\"", "\"as\"", "\"asc\"", "\"assertion\"", "\"at\"", "\"avg\"", "\"between\"", "\"bit_length\"", "\"both\"", "\"by\"", "\"cascaded\"", "\"case\"", "\"cast\"", "\"char_length\"", "\"character\"", "\"character_length\"", "\"coalesce\"", "\"collate\"", "\"collation\"", "\"commit\"", "\"connect\"", "\"convert\"", "\"corresponding\"", "\"count\"", "\"check\"", "\"create\"", "\"cross\"", "\"current_date\"", "\"current_time\"", "\"current_timestamp\"", "\"current_user\"", "\"date\"", "\"day\"", "\"declare\"", "\"default\"", "\"delete\"", "\"desc\"", "\"disconnect\"", "\"distinct\"", "\"domain\"", "\"drop\"", "\"else\"", "\"end\"", "\"escape\"", "\"except\"", "\"exists\"", "\"extract\"", "\"false\"", "\"for\"", "\"from\"", "\"full\"", "\"global\"", "\"grant\"", "\"group\"", "\"having\"", "\"hour\"", "\"in\"", "\"indicator\"", "\"inner\"", "\"insert\"", "\"intersect\"", "\"interval\"", "\"into\"", "\"is\"", "\"join\"", "\"leading\"", "\"left\"", "\"like\"", "\"local\"", "\"lower\"", "\"match\"", "\"max\"", "\"min\"", "\"minute\"", "\"module\"", "\"month\"", "\"natural\"", "\"not\"", "\"null\"", "\"nullif\"", "\"octet_length\"", "\"of\"", "\"on\"", "\"option\"", "\"or\"", "\"order\"", "\"outer\"", "\"overlaps\"", "\"partial\"", "\"position\"", "\"revoke\"", "\"right\"", "\"rollback\"", "\"schema\"", "\"second\"", "\"select\"", "\"session_user\"", "\"set\"", "\"some\"", "\"substring\"", "\"sum\"", "\"system_user\"", "\"table\"", "\"temporary\"", "\"then\"", "\"time\"", "\"timestamp\"", "\"timezone_hour\"", "\"timezone_minute\"", "\"to\"", "\"trailing\"", "\"translate\"", "\"translation\"", "\"trim\"", "\"true\"", "\"union\"", "\"unique\"", "\"unknown\"", "\"update\"", "\"upper\"", "\"user\"", "\"using\"", "\"value\"", "\"values\"", "\"view\"", "\"with\"", "\"when\"", "\"where\"", "\"work\"", "\"year\"", "\"zone\"", "PSEUDO_UNUSEDKEYWORD", "\"absolute\"", "\"action\"", "\"actor\"", "\"add\"", "\"after\"", "\"alias\"", "\"allocate\"", "\"are\"", "\"async\"", "\"attributes\"", "\"authorization\"", "\"before\"", "\"begin\"", "\"bit\"", "\"boolean\"", "\"breadth\"", "\"cascade\"", "\"catalog\"", "\"char\"", "\"class\"", "\"close\"", "\"column\"", "\"completion\"", "\"connection\"", "\"constraint\"", "\"constraints\"", "\"constructor\"", "\"continue\"", "\"current\"", "\"current_path\"", "\"cursor\"", "\"cycle\"", "\"data\"", "\"deallocate\"", "\"dec\"", "\"decimal\"", "\"deferrable\"", "\"deferred\"", "\"depth\"", "\"describe\"", "\"descriptor\"", "\"designator\"", "\"destroy\"", "\"destructor\"", "\"diagnostics\"", "\"dictionary\"", "\"double\"", "\"each\"", "\"element\"", "\"end-exec\"", "\"equals\"", "\"exception\"", "\"exec\"", "\"execute\"", "\"external\"", "\"factor\"", "\"fetch\"", "\"first\"", "\"float\"", "\"foreign\"", "\"found\"", "\"function\"", "\"general\"", "\"get\"", "\"go\"", "\"goto\"", "\"identity\"", "\"ignore\"", "\"immediate\"", "\"initially\"", "\"inout\"", "\"input\"", "\"insensitive\"", "\"instead\"", "\"int\"", "\"integer\"", "\"isolation\"", "\"key\"", "\"language\"", "\"last\"", "\"less\"", "\"level\"", "\"limit\"", "\"list\"", "\"modify\"", "\"move\"", "\"multiset\"", "\"names\"", "\"national\"", "\"nchar\"", "\"new\"", "\"new_table\"", "\"next\"", "\"no\"", "\"none\"", "\"numeric\"", "\"off\"", "\"oid\"", "\"old\"", "\"old_table\"", "\"only\"", "\"open\"", "\"operation\"", "\"operator\"", "\"operators\"", "\"out\"", "\"output\"", "\"pad\"", "\"parameters\"", "\"path\"", "\"pendant\"", "\"postfix\"", "\"precision\"", "\"prefix\"", "\"preorder\"", "\"prepare\"", "\"preserve\"", "\"primary\"", "\"prior\"", "\"private\"", "\"privileges\"", "\"procedure\"", "\"protected\"", "\"public\"", "\"read\"", "\"real\"", "\"recursive\"", "\"references\"", "\"referencing\"", "\"relative\"", "\"representation\"", "\"restrict\"", "\"role\"", "\"routine\"", "\"row\"", "\"rows\"", "\"savepoint\"", "\"scroll\"", "\"search\"", "\"section\"", "\"sensitive\"", "\"sequence\"", "\"session\"", "\"similar\"", "\"size\"", "\"smallint\"", "\"space\"", "\"specific\"", "\"sql\"", "\"sqlcode\"", "\"sqlerror\"", "\"sqlexception\"", "\"sqlstate\"", "\"sqlwarning\"", "\"start\"", "\"state\"", "\"structure\"", "\"symbol\"", "\"template\"", "\"term\"", "\"test\"", "\"than\"", "\"there\"", "\"transaction\"", "\"trigger\"", "\"type\"", "\"under\"", "\"usage\"", "\"varchar\"", "\"variable\"", "\"variant\"", "\"varying\"", "\"virtual\"", "\"visible\"", "\"wait\"", "\"whenever\"", "\"without\"", "\"write\"", "<514>", "<515>", "<516>", "<517>", "<518>", "<519>", "<520>", "<521>", "<522>", "<523>", "<524>", "<525>", "<526>", "<527>", "<528>", "<529>", "<530>", "<531>", "<532>", "<533>", "<534>", "<535>", "<536>", "<537>", "<538>", "<539>", "<540>", "<541>", "<542>", "<543>", "<544>", "<545>", "<546>", "<547>", "<548>", "<549>", "<550>", "<551>", "<552>", "<553>", "<554>", "<555>", "<556>", "<557>", "<558>", "<559>", "<560>", "<561>", "<562>", "<563>", "<564>", "<565>", "<566>", "<567>", "<568>", "<569>", "<570>", "<571>", "<572>", "<573>", "<574>", "<575>", "<576>", "<577>", "<578>", "<579>", "<580>", "<581>", "<582>", "<583>", "<584>", "<585>", "<586>", "<587>", "<588>", "<589>", "<590>", "<591>", "<592>", "<593>", "<594>", "<595>", "<596>", "<597>", "<598>", "<599>", "<600>", "<601>", "<602>", "<603>", "<604>", "<605>", "<606>", "<607>", "<608>", "<609>", "<610>", "<611>", "<612>", "<613>", "<614>", "<615>", "<616>", "<617>", "<618>", "<619>", "<620>", "<621>", "<622>", "<623>", "<624>", "<625>", "<626>", "<627>", "<628>", "<629>", "<630>", "<631>", "<632>", "<633>", "<634>", "<635>", "<636>", "<637>", "<638>", "<639>", "<640>", "<641>", "<642>", "<643>", "<644>", "<645>", "<646>", "<647>", "<648>", "<649>", "<650>", "<651>", "<652>", "<653>", "<654>", "<655>", "<656>", "<657>", "<658>", "<659>", "<660>", "<661>", "<662>", "<663>", "<664>", "<665>", "<666>", "<667>", "<668>", "<669>", "<670>", "<671>", "<672>", "<673>", "<674>", "<675>", "<676>", "<677>", "<678>", "<679>", "<680>", "<681>", "<682>", "<683>", "<684>", "<685>", "<686>", "<687>", "<688>", "<689>", "<690>", "<691>", "<692>", "<693>", "<694>", "<695>", "<696>", "<697>", "<698>", "<699>", "<700>", "<701>", "<702>", "<703>", "<704>", "<705>", "<706>", "<707>", "<708>", "<709>", "<710>", "<711>", "<712>", "<713>", "<714>", "<715>", "<716>", "<717>", "<718>", "<719>", "<720>", "<721>", "<722>", "<723>", "<724>", "<725>", "<726>", "<727>", "<728>", "<729>", "<730>", "<731>", "<732>", "<733>", "<734>", "<735>", "<736>", "<737>", "<738>", "<739>", "<740>", "<741>", "<742>", "<743>", "<744>", "<745>", "<746>", "<747>", "<748>", "<749>", "<750>", "<751>", "<752>", "<753>", "<754>", "<755>", "<756>", "<757>", "<758>", "<759>", "<760>", "<761>", "<762>", "<763>", "<764>", "<765>", "<766>", "<767>", "<768>", "<769>", "<770>", "<771>", "<772>", "<773>", "<774>", "<775>", "<776>", "<777>", "<778>", "<779>", "<780>", "<781>", "<782>", "<783>", "<784>", "<785>", "<786>", "<787>", "<788>", "<789>", "<790>", "<791>", "<792>", "<793>", "<794>", "<795>", "<796>", "<797>", "<798>", "<799>", "<800>", "<801>", "<802>", "<803>", "<804>", "<805>", "<806>", "<807>", "<808>", "<809>", "<810>", "<811>", "<812>", "<813>", "<814>", "<815>", "<816>", "<817>", "<818>", "<819>", "<820>", "<821>", "<822>", "<823>", "<824>", "<825>", "<826>", "<827>", "<828>", "<829>", "<830>", "<831>", "<832>", "<833>", "<834>", "<835>", "<836>", "<837>", "<838>", "<839>", "<840>", "<841>", "<842>", "<843>", "<844>", "<845>", "<846>", "<847>", "<848>", "<849>", "<850>", "<851>", "<852>", "<853>", "<854>", "<855>", "<856>", "<857>", "<858>", "<859>", "<860>", "<861>", "<862>", "<863>", "<864>", "<865>", "<866>", "<867>", "<868>", "<869>", "<870>", "<871>", "<872>", "<873>", "<874>", "<875>", "<876>", "<877>", "<878>", "<879>", "<880>", "<881>", "<882>", "<883>", "<884>", "<885>", "<886>", "<887>", "<888>", "<889>", "<890>", "<891>", "<892>", "<893>", "<894>", "<895>", "<896>", "<897>", "<898>", "<899>", "<900>", "<901>", "<902>", "<903>", "<904>", "<905>", "<906>", "<907>", "<908>", "<909>", "<910>", "<911>", "<912>", "<913>", "<914>", "<915>", "<916>", "<917>", "<918>", "<919>", "<920>", "<921>", "<922>", "<923>", "<924>", "<925>", "<926>", "<927>", "<928>", "<929>", "<930>", "<931>", "<932>", "<933>", "<934>", "<935>", "<936>", "<937>", "<938>", "<939>", "<940>", "<941>", "<942>", "<943>", "<944>", "<945>", "<946>", "<947>", "<948>", "<949>", "<950>", "<951>", "<952>", "<953>", "<954>", "<955>", "<956>", "<957>", "<958>", "<959>", "<960>", "<961>", "<962>", "<963>", "<964>", "<965>", "<966>", "<967>", "<968>", "<969>", "<970>", "<971>", "<972>", "<973>", "<974>", "<975>", "<976>", "<977>", "<978>", "<979>", "<980>", "<981>", "<982>", "<983>", "<984>", "<985>", "<986>", "<987>", "<988>", "<989>", "<990>", "<991>", "<992>", "<993>", "<994>", "<995>", "<996>", "<997>", "<998>", "<999>", "PSEUDO_HINT_KEYWORD", "HINT_KEYWORD_sap", "HINT_KEYWORD_oracle", "HINT_KEYWORD_sapdb", "HINT_KEYWORD_sqlserver", "HINT_KEYWORD_db2_os390", "HINT_KEYWORD_db2_as400", "HINT_KEYWORD_db2_udb", "HINT_KEYWORD_bypassing", "HINT_KEYWORD_buffer"};
    private static final long[] _tokenSet_0_data_ = new long[]{-16L, -1L, -17L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, 0x3FFFFFFFFFFFFL, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);
    private static final long[] _tokenSet_1_data_ = new long[]{0L, 0L, 0L, -9221120235900207104L, 1156301403350695936L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_1 = new BitSet(_tokenSet_1_data_);
    private static final long[] _tokenSet_2_data_ = new long[]{0L, 0L, 0L, 0x10000000000400L, 0x4000000001L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_2 = new BitSet(_tokenSet_2_data_);
    private static final long[] _tokenSet_3_data_ = new long[]{0L, -3859295434220503040L, 0L, 432362650069499904L, 2911462947833905664L, 217L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_3 = new BitSet(_tokenSet_3_data_);
    private static final long[] _tokenSet_4_data_ = new long[]{2L, -2342479011529097216L, 336L, 5117320398786996736L, -6311904102536258728L, 9433L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_4 = new BitSet(_tokenSet_4_data_);
    private static final long[] _tokenSet_5_data_ = new long[]{0L, -3859295434220503040L, 0L, 432362667249369088L, 2911462947833905664L, 217L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_5 = new BitSet(_tokenSet_5_data_);
    private static final long[] _tokenSet_6_data_ = new long[]{0L, -3859295434220503040L, 0L, 432362650069499904L, 2910328251834040832L, 89L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_6 = new BitSet(_tokenSet_6_data_);
    private static final long[] _tokenSet_7_data_ = new long[]{0L, -3859295434220503040L, 0L, 288317830737821696L, 2910328251800486400L, 88L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_7 = new BitSet(_tokenSet_7_data_);
    private static final long[] _tokenSet_8_data_ = new long[]{2L, 0x80000000000L, 24L, 0x1100000000000000L, -9223372028264840960L, 512L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_8 = new BitSet(_tokenSet_8_data_);
    private static final long[] _tokenSet_9_data_ = new long[]{2L, -2342540584180252672L, 88L, 8637991901203474944L, -6307404891302143146L, 3837L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_9 = new BitSet(_tokenSet_9_data_);
    private static final long[] _tokenSet_10_data_ = new long[]{2L, 0x20080000000000L, 24L, 5836665391950080000L, -9218867873496149690L, 2592L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_10 = new BitSet(_tokenSet_10_data_);
    private static final long[] _tokenSet_11_data_ = new long[]{2L, 0x20080000000000L, 24L, 5836665391950080000L, -9218867873496147642L, 2592L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_11 = new BitSet(_tokenSet_11_data_);
    private static final long[] _tokenSet_12_data_ = new long[]{2L, -2342540584180252672L, 88L, 9214452653506898432L, -1695718855694886058L, 3839L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_12 = new BitSet(_tokenSet_12_data_);
    private static final long[] _tokenSet_13_data_ = new long[]{2L, 6713908820025802752L, 88L, 8205558796484159488L, -9218867839102559914L, 3616L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_13 = new BitSet(_tokenSet_13_data_);
    static /* synthetic */ Class class$com$sap$sql$sqlparser$SQLParser;

    private void checkSql(boolean test, String key) {
        if (!test) {
            this.generalCheck("SQL", key);
        }
    }

    private void checkISql(boolean test, String key) {
        if (!test) {
            this.generalCheck("Intermediate-SQL", key);
        }
    }

    private void checkESql(boolean test, String key) {
        if (!test) {
            this.generalCheck("Entry-SQL", key);
        }
    }

    private void checkSapSql(boolean test, String key) {
        if (!test) {
            this.generalCheck("Open SQL", key);
        }
    }

    private void checkSql(boolean test, String key, String p1) {
        if (!test) {
            this.generalCheck("SQL", key, p1);
        }
    }

    private void checkISql(boolean test, String key, String p1) {
        if (!test) {
            this.generalCheck("Intermediate-SQL", key, p1);
        }
    }

    private void checkESql(boolean test, String key, String p1) {
        if (!test) {
            this.generalCheck("Entry-SQL", key, p1);
        }
    }

    private void checkSapSql(boolean test, String key, String p1) {
        if (!test) {
            this.generalCheck("Open SQL", key, p1);
        }
    }

    private void checkSql(boolean test, String key, String p1, String p2) {
        if (!test) {
            this.generalCheck("SQL", key, p1, p2);
        }
    }

    private void checkISql(boolean test, String key, String p1, String p2) {
        if (!test) {
            this.generalCheck("Intermediate-SQL", key, p1, p2);
        }
    }

    private void checkESql(boolean test, String key, String p1, String p2) {
        if (!test) {
            this.generalCheck("Entry-SQL", key, p1, p2);
        }
    }

    private void checkSapSql(boolean test, String key, String p1, String p2) {
        if (!test) {
            this.generalCheck("Open SQL", key, p1, p2);
        }
    }

    private void checkSql(boolean test, String key, String p1, String p2, String p3) {
        if (!test) {
            this.generalCheck("SQL", key, p1, p2);
        }
    }

    private void checkISql(boolean test, String key, String p1, String p2, String p3) {
        if (!test) {
            this.generalCheck("Intermediate-SQL", key, p1, p2);
        }
    }

    private void checkESql(boolean test, String key, String p1, String p2, String p3) {
        if (!test) {
            this.generalCheck("Entry-SQL", key, p1, p2);
        }
    }

    private void checkSapSql(boolean test, String key, String p1, String p2, String p3) {
        if (!test) {
            this.generalCheck("Open SQL", key, p1, p2);
        }
    }

    private void generalCheck(String level, String key) {
        this.logError(CommonSQLParserErrors.msg("syntaxError", level, CommonSQLParserErrors.msg(key)));
    }

    private void generalCheck(String level, String key, String p1) {
        this.logError(CommonSQLParserErrors.msg("syntaxError", level, CommonSQLParserErrors.msg(key, p1)));
    }

    private void generalCheck(String level, String key, String p1, String p2) {
        this.logError(CommonSQLParserErrors.msg("syntaxError", level, CommonSQLParserErrors.msg(key, p1, p2)));
    }

    private void generalCheck(String level, String key, String p1, String p2, String p3) {
        this.logError(CommonSQLParserErrors.msg("syntaxError", level, CommonSQLParserErrors.msg(key, p1, p2, p3)));
    }

    private void logError(String text) {
        int line = 0;
        int column = 0;
        try {
            line = this.LT(1).getLine();
            column = this.LT(1).getColumn();
        }
        catch (TokenStreamException e) {
            LOCATION.catching((Throwable)e);
        }
        this.logError(text, line, column);
    }

    private void logError(String text, int line, int column) {
        if (this.errorLog == null) {
            this.errorLog = new Vector();
        }
        this.errorLog.add(new LogEntry(text, line, column));
    }

    public void clearErrorLog() {
        this.errorLog = null;
    }

    public Vector getErrorLog() {
        return this.errorLog;
    }

    public int getHostVarCount() {
        return this.hostVarCount;
    }

    private void dumpSyntaxStack() {
        if (null == this.syntaxStack) {
            System.out.println("Stack is null");
            return;
        }
        if (this.syntaxStack.empty()) {
            System.out.println("Stack is empty");
            return;
        }
        System.out.print("Stack top: ");
        Stack copy = new Stack();
        while (!this.syntaxStack.empty()) {
            Object obj = this.syntaxStack.pop();
            copy.push(obj);
            if (null == obj) {
                System.out.println("(null)");
                continue;
            }
            System.out.println(obj.getClass().getName());
        }
        while (!copy.empty()) {
            this.syntaxStack.push(copy.pop());
        }
    }

    private ValueExpression popValueExpression() {
        ValueExpression val;
        if (this.syntaxStack.peek().getClass().isArray()) {
            String[] quad = (String[])this.syntaxStack.pop();
            String colName = quad[0];
            String tabName = quad[1];
            String qualifier = quad[2];
            this.checkSapSql(null == qualifier, "noQualifiedSchemata", qualifier, tabName, colName);
            qualifier = quad[3];
            this.checkSapSql(null == qualifier, "noQualifiedCatalogs", qualifier);
            return new ColumnReference(tabName, colName);
        }
        try {
            val = (ValueExpression)this.syntaxStack.pop();
        }
        catch (ClassCastException cex) {
            val = new IntegerLiteral("42");
        }
        return val;
    }

    private RowValue popRowValue() {
        if (this.syntaxStack.peek().getClass().isArray()) {
            return this.popValueExpression();
        }
        return (RowValue)this.syntaxStack.pop();
    }

    private TableReference popTableReference(String alias) {
        String[] quad = (String[])this.syntaxStack.pop();
        String tabName = quad[0];
        String schName = quad[1];
        String qualifier = quad[2];
        this.checkSapSql(null == qualifier, "noCatalogAllowed", qualifier, schName, tabName);
        qualifier = quad[3];
        this.checkSql(null == qualifier, "noColumnNameExpected", qualifier);
        return new TableReference(schName, tabName, alias);
    }

    private Query popQuery(String alias, boolean autoAlias) {
        Object obj = this.syntaxStack.peek();
        if (obj.getClass().isArray()) {
            if (null == alias && autoAlias) {
                alias = ((String[])obj)[0];
            }
            return this.popTableReference(alias);
        }
        if (obj instanceof Query) {
            Query query = (Query)this.syntaxStack.pop();
            if (alias != null) {
                return new DerivedTable(query, alias);
            }
            return query;
        }
        this.syntaxStack.pop();
        if (null == this.errorLog) {
            this.checkSql(false, "noQuerySpecified");
        }
        return new TableReference("ERROR", "ERROR");
    }

    public int LA(int i) throws TokenStreamException {
        int ttyp = super.LA(i);
        if (ttyp > 335 && ttyp < 1000) {
            throw new TokenStreamRecognitionException((RecognitionException)new NoViableAltException(this.LT(i), this.getFilename()));
        }
        return ttyp;
    }

    private void handleRecognitionException(RecognitionException ex) {
        if (ex instanceof NoViableAltException) {
            this.handleUnexpectedToken(((NoViableAltException)ex).token);
        } else if (ex instanceof MismatchedTokenException) {
            this.handleUnexpectedToken(((MismatchedTokenException)ex).token);
            this.logError(ex.getMessage(), ex.getLine(), ex.getColumn());
        } else if (ex instanceof MismatchedCharException) {
            this.handleMismatchedChar((MismatchedCharException)ex);
        } else {
            this.logError(ex.toString(), ex.getLine(), ex.getColumn());
        }
    }

    private void handleMismatchedChar(MismatchedCharException ex) {
        int EOFCHAR = 65535;
        if (ex.foundChar == '\uffff' && ex.expecting == 39) {
            this.generalCheck("SQL", "runAwayStringLiteral");
        } else if (ex.foundChar == '\uffff' && ex.expecting == 34) {
            this.generalCheck("SQL", "runAwayQuotedIdentifier");
        } else {
            this.logError(ex.getMessage(), ex.getLine(), ex.getColumn());
        }
    }

    private void handleUnexpectedToken(Token token) {
        String tokenText = token.getText();
        int tokenType = token.getType();
        String errorKey = tokenType > 335 ? "unusedKeywordFound" : (tokenType > 200 ? "unexpectedKeywordFound" : (tokenType == 1 ? "unexpectedEndOfFile" : "unexpectedTokenFound"));
        int line = token.getLine();
        int column = token.getColumn();
        String errorText = CommonSQLParserErrors.msg("syntaxError", "SQL", CommonSQLParserErrors.msg(errorKey, tokenText));
        this.logError(errorText, line, column);
    }

    protected SQLParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        ((Parser)this).tokenNames = _tokenNames;
    }

    public SQLParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected SQLParser(TokenStream lexer, int k) {
        super(lexer, k);
        ((Parser)this).tokenNames = _tokenNames;
    }

    public SQLParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public SQLParser(ParserSharedInputState state) {
        super(state, 2);
        ((Parser)this).tokenNames = _tokenNames;
    }

    public final SQLStatement directly_executable_statement() throws RecognitionException, TokenStreamException {
        SQLStatement statement = null;
        try {
            this.hostVarCount = 0;
            this.bufferable = true;
            this.syntaxStack = new Stack();
            switch (this.LA(1)) {
                case 224: 
                case 237: 
                case 241: 
                case 301: {
                    this.sql_not_supported_statement();
                    break;
                }
                case 102: 
                case 104: 
                case 105: 
                case 106: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 121: 
                case 123: 
                case 126: 
                case 127: 
                case 202: 
                case 209: 
                case 211: 
                case 215: 
                case 216: 
                case 217: 
                case 219: 
                case 220: 
                case 223: 
                case 225: 
                case 227: 
                case 229: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 239: 
                case 244: 
                case 249: 
                case 250: 
                case 256: 
                case 263: 
                case 265: 
                case 273: 
                case 275: 
                case 276: 
                case 278: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 293: 
                case 294: 
                case 296: 
                case 299: 
                case 300: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 309: 
                case 310: 
                case 315: 
                case 317: 
                case 320: 
                case 322: 
                case 323: 
                case 324: 
                case 326: 
                case 327: {
                    switch (this.LA(1)) {
                        case 102: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 112: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 121: 
                        case 123: 
                        case 126: 
                        case 127: 
                        case 209: 
                        case 211: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 219: 
                        case 220: 
                        case 225: 
                        case 227: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 249: 
                        case 250: 
                        case 265: 
                        case 273: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 293: 
                        case 299: 
                        case 300: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 309: 
                        case 310: 
                        case 315: 
                        case 317: 
                        case 320: 
                        case 323: 
                        case 324: 
                        case 326: 
                        case 327: {
                            this.direct_select_statement_multiple_rows();
                            break;
                        }
                        case 239: 
                        case 263: 
                        case 322: {
                            this.direct_dml_statement();
                            break;
                        }
                        case 223: 
                        case 296: {
                            this.transaction_management_statement();
                            break;
                        }
                        case 202: 
                        case 229: 
                        case 244: 
                        case 256: 
                        case 294: {
                            this.sql_schema_statement();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    if (this.syntaxStack.size() == 1) {
                        statement = (SQLStatement)this.syntaxStack.pop();
                        statement.setBufferable(this.bufferable);
                        break;
                    }
                    StringBuffer msg = new StringBuffer("illegal stack size: ");
                    msg.append(Integer.toString(this.syntaxStack.size()));
                    msg.append("\ncontents:");
                    while (this.syntaxStack.size() > 0) {
                        msg.append("\n");
                        msg.append(this.syntaxStack.pop().getClass().getName());
                    }
                    throw new IllegalStateException(msg.toString());
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 1: {
                    this.match(1);
                    break;
                }
                case 132: {
                    this.match(132);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.handleRecognitionException(ex);
        }
        catch (TokenStreamRecognitionException tokEx) {
            RecognitionException ex = tokEx.recog;
            this.handleRecognitionException(ex);
        }
        catch (SQLLexerException lexEx) {
            String errorText = CommonSQLParserErrors.msg(lexEx.getKey(), lexEx.getTokenText());
            errorText = CommonSQLParserErrors.msg("syntaxError", "SQL", errorText);
            this.logError(errorText, lexEx.getLine(), lexEx.getColumn());
        }
        return statement;
    }

    private final void sql_not_supported_statement() throws RecognitionException, TokenStreamException {
        this.checkSapSql(false, "statementNotSupported", this.LT(1).getText());
        switch (this.LA(1)) {
            case 237: {
                this.match(237);
                break;
            }
            case 301: {
                this.match(301);
                break;
            }
            case 224: {
                this.match(224);
                break;
            }
            case 241: {
                this.match(241);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (_tokenSet_0.member(this.LA(1))) {
            this.matchNot(132);
        }
    }

    private final void direct_select_statement_multiple_rows() throws RecognitionException, TokenStreamException {
        ArrayList tempList = null;
        SortSpecification[] sortSpecification = null;
        ColumnReference[] forUpdateList = null;
        this.checkESql(299 == this.LA(1) || 121 == this.LA(1) && 299 == this.LA(2), "noSelectFound");
        int etype = this.general_t_expression();
        this.checkSql((etype & TYP_QUERY) != 0, "noQuerySpecified");
        this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesOnlyInInsert");
        switch (this.LA(1)) {
            case 1: 
            case 132: 
            case 289: {
                switch (this.LA(1)) {
                    case 289: {
                        this.match(289);
                        this.match(213);
                        this.sort_specification();
                        tempList = new ArrayList();
                        tempList.add(this.syntaxStack.pop());
                        while (this.LA(1) == 107) {
                            this.match(107);
                            this.sort_specification();
                            tempList.add(this.syntaxStack.pop());
                        }
                        sortSpecification = tempList.toArray(new SortSpecification[0]);
                        break;
                    }
                    case 1: 
                    case 132: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                Query query = this.popQuery(null, true);
                SelectStatement stmt = new SelectStatement(query, sortSpecification);
                this.syntaxStack.push(stmt);
                break;
            }
            case 252: {
                this.match(252);
                this.match(322);
                switch (this.LA(1)) {
                    case 285: {
                        this.match(285);
                        etype = this.column_reference_or_table_name();
                        this.checkSql((etype & TYP_VAL) != 0, "argumentOfForUpdateNotColref");
                        tempList = new ArrayList();
                        tempList.add(this.popValueExpression());
                        while (this.LA(1) == 107) {
                            this.match(107);
                            etype = this.column_reference_or_table_name();
                            this.checkSql((etype & TYP_VAL) != 0, "argumentOfForUpdateNotColref");
                            tempList.add(this.popValueExpression());
                        }
                        forUpdateList = tempList.toArray(new ColumnReference[0]);
                        break;
                    }
                    case 1: 
                    case 132: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                Query query = this.popQuery(null, true);
                QuerySpecification querySpecification = null;
                try {
                    querySpecification = (QuerySpecification)query;
                    Query[] fromClause = querySpecification.getFromClause();
                    this.checkSql(1 == fromClause.length, "selectForUpdateSimpleTableQueryNeeded");
                    this.checkSql(!querySpecification.isDistinct(), "selectForUpdateDistinctNotAllowed");
                    this.checkSql(null == querySpecification.getGroupByList(), "selectForUpdateGroupByNotAllowed");
                    this.checkSql(null == querySpecification.getHavingClause(), "selectForUpdateHavingNotAllowed");
                    this.checkSql(null != querySpecification.getWhereClause(), "selectForUpdateWhereClauseNeeded");
                    TableReference table = (TableReference)fromClause[0];
                    this.syntaxStack.push(new SelectForUpdateStatement(querySpecification.getSelectList(), table, querySpecification.getWhereClause(), forUpdateList));
                }
                catch (ClassCastException ex) {
                    LOCATION.catching((Throwable)ex);
                    this.checkSql(false, "selectForUpdateSimpleTableQueryNeeded");
                    this.syntaxStack.push(new SelectForUpdateStatement(null, null, null, null));
                }
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void direct_dml_statement() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 263: {
                this.insert_statement();
                break;
            }
            case 322: {
                this.update_statement_searched();
                break;
            }
            case 239: {
                this.delete_statement_searched();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void transaction_management_statement() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 223: {
                this.match(223);
                this.syntaxStack.push(new CommitStatement());
                break;
            }
            case 296: {
                this.match(296);
                this.syntaxStack.push(new RollbackStatement());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 332: {
                this.match(332);
                break;
            }
            case 1: 
            case 132: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void sql_schema_statement() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 229 && this.LA(2) == 328) {
            this.create_view_statement();
        } else if (this.LA(1) == 229 && _tokenSet_1.member(this.LA(2))) {
            this.create_not_supported_statement();
        } else if (_tokenSet_2.member(this.LA(1))) {
            this.checkSapSql(false, "statementNotSupported", this.LT(1).getText());
            switch (this.LA(1)) {
                case 256: {
                    this.match(256);
                    break;
                }
                case 244: {
                    this.match(244);
                    break;
                }
                case 202: {
                    this.match(202);
                    break;
                }
                case 294: {
                    this.match(294);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (_tokenSet_0.member(this.LA(1))) {
                this.matchNot(132);
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    private final void insert_statement() throws RecognitionException, TokenStreamException {
        int etype;
        Token col = null;
        Token morecol = null;
        ArrayList<ColumnReference> tempList = null;
        ColumnReference[] columnList = null;
        Query source = null;
        Hint[] hints = null;
        this.match(263);
        switch (this.LA(1)) {
            case 136: {
                this.hintlist();
                hints = (Hint[])this.syntaxStack.pop();
                break;
            }
            case 266: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(266);
        this.table_name();
        if (this.LA(1) == 238 && this.LA(1) == 238) {
            this.match(238);
            this.match(327);
            this.checkESql(false, "notAllowed", "DEFAULT VALUES");
            etype = SPECIAL_values;
        } else if (this.LA(1) == 121 && this.LA(2) == 117 && this.LA(2) == 117 && (this.LA(3) == 107 || this.LA(3) == 131 && this.LA(4) != 132 && this.LA(4) != 1)) {
            this.match(121);
            col = this.LT(1);
            this.match(117);
            tempList = new ArrayList<ColumnReference>();
            tempList.add(new ColumnReference(col.getText()));
            while (this.LA(1) == 107) {
                this.match(107);
                morecol = this.LT(1);
                this.match(117);
                tempList.add(new ColumnReference(morecol.getText()));
            }
            columnList = tempList.toArray(new ColumnReference[0]);
            this.match(131);
            etype = this.general_t_expression();
            source = this.popQuery(null, true);
        } else if (_tokenSet_3.member(this.LA(1)) && _tokenSet_4.member(this.LA(2))) {
            etype = this.general_t_expression();
            source = this.popQuery(null, true);
            this.checkSapSql(false, "insertColumnListMissing");
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.checkSql((etype & TYP_QUERY) != 0 || (etype & SPECIAL_MASK) == SPECIAL_values, "insertValuesMustBeQuery");
        this.checkESql((etype & SPECIAL_MASK) == SPECIAL_values || (etype & SPECIAL_MASK) == SPECIAL_select, "insertValuesMustBeValuesOrQuery");
        TableReference toTable = this.popTableReference(null);
        InsertStatement stmt = new InsertStatement(toTable, columnList, source);
        if (hints != null && hints.length > 0) {
            stmt.setHints(hints);
        }
        this.syntaxStack.push(stmt);
    }

    private final void update_statement_searched() throws RecognitionException, TokenStreamException {
        ArrayList tempList = null;
        SearchCondition whereClause = null;
        Hint[] hints = null;
        this.match(322);
        switch (this.LA(1)) {
            case 136: {
                this.hintlist();
                hints = (Hint[])this.syntaxStack.pop();
                break;
            }
            case 117: 
            case 278: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.table_name();
        this.match(301);
        this.set_clause();
        tempList = new ArrayList();
        tempList.add(this.syntaxStack.pop());
        while (this.LA(1) == 107) {
            this.match(107);
            this.set_clause();
            tempList.add(this.syntaxStack.pop());
        }
        switch (this.LA(1)) {
            case 331: {
                this.match(331);
                this.search_condition("argumentWhereBooleanNeeded");
                whereClause = (SearchCondition)this.syntaxStack.pop();
                break;
            }
            case 1: 
            case 132: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        SetClause[] setClause = tempList.toArray(new SetClause[0]);
        TableReference table = this.popTableReference(null);
        UpdateStatement stmt = new UpdateStatement(table, setClause, whereClause);
        if (hints != null && hints.length > 0) {
            stmt.setHints(hints);
        }
        this.syntaxStack.push(stmt);
    }

    private final void delete_statement_searched() throws RecognitionException, TokenStreamException {
        SearchCondition whereClause = null;
        Hint[] hints = null;
        this.match(239);
        switch (this.LA(1)) {
            case 136: {
                this.hintlist();
                hints = (Hint[])this.syntaxStack.pop();
                break;
            }
            case 253: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(253);
        this.table_name();
        switch (this.LA(1)) {
            case 331: {
                this.match(331);
                this.search_condition("argumentWhereBooleanNeeded");
                whereClause = (SearchCondition)this.syntaxStack.pop();
                break;
            }
            case 1: 
            case 132: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        TableReference table = this.popTableReference(null);
        DeleteStatement stmt = new DeleteStatement(table, whereClause);
        if (hints != null && hints.length > 0) {
            stmt.setHints(hints);
        }
        this.syntaxStack.push(stmt);
    }

    private final void create_view_statement() throws RecognitionException, TokenStreamException {
        Token col = null;
        Token morecol = null;
        ArrayList<String> tempList = null;
        String[] viewColumnList = null;
        boolean withCheckOption = false;
        this.syntaxStack = new Stack();
        CreateViewStatement statement = null;
        this.match(229);
        this.match(328);
        this.table_name();
        switch (this.LA(1)) {
            case 121: {
                this.match(121);
                col = this.LT(1);
                this.match(117);
                tempList = new ArrayList<String>();
                tempList.add(col.getText());
                while (this.LA(1) == 107) {
                    this.match(107);
                    morecol = this.LT(1);
                    this.match(117);
                    tempList.add(morecol.getText());
                }
                viewColumnList = tempList.toArray(new String[tempList.size()]);
                this.match(131);
                break;
            }
            case 205: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(205);
        int etype = this.general_t_expression();
        this.checkSql((etype & TYP_QUERY) != 0, "noQuerySpecified");
        this.checkESql((etype & SPECIAL_MASK) == SPECIAL_select, "createViewQueryMustBeQuerySpec");
        switch (this.LA(1)) {
            case 329: {
                this.match(329);
                block8 : switch (this.LA(1)) {
                    case 214: 
                    case 272: {
                        this.checkISql(false, "noLevelsClause");
                        switch (this.LA(1)) {
                            case 214: {
                                this.match(214);
                                break block8;
                            }
                            case 272: {
                                this.match(272);
                                break block8;
                            }
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    case 228: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(228);
                this.match(287);
                withCheckOption = true;
                break;
            }
            case 1: 
            case 132: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        QuerySpecification query = (QuerySpecification)this.popQuery(null, false);
        this.checkSapSql(query.getSelectList() != null, "noExplicitSelectList");
        TableReference viewName = this.popTableReference(null);
        statement = new CreateViewStatement(viewName.getTableName(), viewColumnList, query, withCheckOption);
        this.syntaxStack.push(statement);
    }

    private final void create_not_supported_statement() throws RecognitionException, TokenStreamException {
        this.match(229);
        block0 : switch (this.LA(1)) {
            case 207: 
            case 218: 
            case 222: 
            case 243: 
            case 297: 
            case 316: {
                this.checkSapSql(false, "statementNotSupported", this.LT(1).getText());
                switch (this.LA(1)) {
                    case 297: {
                        this.match(297);
                        break block0;
                    }
                    case 243: {
                        this.match(243);
                        break block0;
                    }
                    case 207: {
                        this.match(207);
                        break block0;
                    }
                    case 218: {
                        this.match(218);
                        this.match(301);
                        break block0;
                    }
                    case 222: {
                        this.match(222);
                        break block0;
                    }
                    case 316: {
                        this.match(316);
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 255: 
            case 272: 
            case 306: 
            case 307: {
                this.checkSapSql(false, "createTableNotSupported", this.LT(1).getText());
                switch (this.LA(1)) {
                    case 255: 
                    case 272: 
                    case 307: {
                        switch (this.LA(1)) {
                            case 255: {
                                this.match(255);
                                break;
                            }
                            case 272: {
                                this.match(272);
                                break;
                            }
                            case 307: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        this.match(307);
                        break;
                    }
                    case 306: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(306);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (_tokenSet_0.member(this.LA(1))) {
            this.matchNot(132);
        }
    }

    private final int general_t_expression() throws RecognitionException, TokenStreamException {
        int setOperator = 0;
        Query lhs = null;
        int etype = this.general_t_term();
        while (this.LA(1) == 248 || this.LA(1) == 319) {
            this.checkSql((etype & TYP_QUERY) != 0, "leftArgumentNotTable", "UNION/EXCEPT");
            this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesNotDirectlyInInsert");
            lhs = this.popQuery(null, true);
            if (this.LA(1) == 319 && _tokenSet_5.member(this.LA(2))) {
                this.match(319);
                setOperator = 1;
            } else if (this.LA(1) == 319 && this.LA(2) == 201) {
                this.match(319);
                this.match(201);
                setOperator = 2;
            } else if (this.LA(1) == 248 && _tokenSet_5.member(this.LA(2))) {
                this.match(248);
                setOperator = 5;
                this.checkESql(false, "notAllowed", "EXCEPT");
            } else if (this.LA(1) == 248 && this.LA(2) == 201) {
                this.match(248);
                this.match(201);
                setOperator = 6;
                this.checkESql(false, "notAllowed", "EXCEPT ALL");
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            switch (this.LA(1)) {
                case 226: {
                    this.corresponding_spec();
                    break;
                }
                case 102: 
                case 104: 
                case 105: 
                case 106: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 121: 
                case 123: 
                case 126: 
                case 127: 
                case 209: 
                case 211: 
                case 215: 
                case 216: 
                case 217: 
                case 219: 
                case 220: 
                case 225: 
                case 227: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 249: 
                case 250: 
                case 265: 
                case 273: 
                case 275: 
                case 276: 
                case 278: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 293: 
                case 299: 
                case 300: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 309: 
                case 310: 
                case 315: 
                case 317: 
                case 320: 
                case 323: 
                case 324: 
                case 326: 
                case 327: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            etype = this.general_t_term();
            this.checkSql((etype & TYP_QUERY) != 0, "rightArgumentNotTable", "UNION/EXCEPT");
            this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesNotDirectlyInInsert");
            etype = TYP_QUERY;
            Query rhs = this.popQuery(null, true);
            this.syntaxStack.push(new NonJoinQuery(lhs, setOperator, rhs));
        }
        return etype;
    }

    private final void sort_specification() throws RecognitionException, TokenStreamException {
        Token number = null;
        String columnName = null;
        boolean isDescending = false;
        switch (this.LA(1)) {
            case 117: 
            case 278: {
                int etype = this.column_reference_or_table_name();
                String[] quad = (String[])this.syntaxStack.pop();
                columnName = quad[0];
                int i = 1;
                while (i < 4) {
                    this.checkSql(null == quad[i], "noQualifiedSortKeys", quad[i], columnName);
                    ++i;
                }
                this.checkSql((etype & SPECIAL_MASK) == SPECIAL_id, "illegalSortKey");
                break;
            }
            case 118: {
                number = this.LT(1);
                this.match(118);
                this.checkSapSql(false, "sortByColNo");
                columnName = number.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 221: {
                this.collate_clause();
                break;
            }
            case 1: 
            case 107: 
            case 132: 
            case 206: 
            case 240: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 206: {
                this.match(206);
                break;
            }
            case 240: {
                this.match(240);
                isDescending = true;
                break;
            }
            case 1: 
            case 107: 
            case 132: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.syntaxStack.push(new SortSpecification(columnName, isDescending));
    }

    private final int column_reference_or_table_name() throws RecognitionException, TokenStreamException {
        Token part1 = null;
        Token part2 = null;
        Token part3 = null;
        Token asterisk3 = null;
        Token part4 = null;
        int etype = 0;
        block0 : switch (this.LA(1)) {
            case 117: {
                part1 = this.LT(1);
                this.match(117);
                switch (this.LA(1)) {
                    case 1: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 225: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 238: 
                    case 240: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 258: 
                    case 260: 
                    case 262: 
                    case 264: 
                    case 265: 
                    case 267: 
                    case 268: 
                    case 270: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 291: 
                    case 293: 
                    case 295: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 329: 
                    case 330: 
                    case 331: {
                        etype = TYP_VAL | SPECIAL_id | TYP_TREF;
                        this.syntaxStack.push(new String[]{part1.getText(), null, null, null});
                        break block0;
                    }
                    case 110: {
                        this.match(110);
                        switch (this.LA(1)) {
                            case 103: {
                                this.match(103);
                                etype = SPECIAL_qast;
                                this.syntaxStack.push(new String[]{"*", part1.getText(), null, null});
                                break block0;
                            }
                            case 117: {
                                part2 = this.LT(1);
                                this.match(117);
                                switch (this.LA(1)) {
                                    case 1: 
                                    case 102: 
                                    case 103: 
                                    case 104: 
                                    case 105: 
                                    case 106: 
                                    case 107: 
                                    case 108: 
                                    case 111: 
                                    case 112: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 123: 
                                    case 124: 
                                    case 126: 
                                    case 127: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 203: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 209: 
                                    case 210: 
                                    case 211: 
                                    case 215: 
                                    case 216: 
                                    case 217: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 225: 
                                    case 227: 
                                    case 230: 
                                    case 231: 
                                    case 232: 
                                    case 233: 
                                    case 234: 
                                    case 235: 
                                    case 238: 
                                    case 240: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 249: 
                                    case 250: 
                                    case 252: 
                                    case 253: 
                                    case 254: 
                                    case 257: 
                                    case 258: 
                                    case 260: 
                                    case 262: 
                                    case 264: 
                                    case 265: 
                                    case 267: 
                                    case 268: 
                                    case 270: 
                                    case 271: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 278: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 284: 
                                    case 286: 
                                    case 288: 
                                    case 289: 
                                    case 291: 
                                    case 293: 
                                    case 295: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 315: 
                                    case 317: 
                                    case 319: 
                                    case 320: 
                                    case 323: 
                                    case 324: 
                                    case 325: 
                                    case 326: 
                                    case 327: 
                                    case 329: 
                                    case 330: 
                                    case 331: {
                                        etype = TYP_VAL | SPECIAL_colref | TYP_TREF;
                                        this.syntaxStack.push(new String[]{part2.getText(), part1.getText(), null, null});
                                        break block0;
                                    }
                                    case 110: {
                                        this.match(110);
                                        switch (this.LA(1)) {
                                            case 103: {
                                                this.match(103);
                                                etype = SPECIAL_qast;
                                                this.syntaxStack.push(new String[]{"*", part2.getText(), part1.getText(), null});
                                                break block0;
                                            }
                                            case 117: {
                                                part3 = this.LT(1);
                                                this.match(117);
                                                switch (this.LA(1)) {
                                                    case 1: 
                                                    case 102: 
                                                    case 103: 
                                                    case 104: 
                                                    case 105: 
                                                    case 106: 
                                                    case 107: 
                                                    case 108: 
                                                    case 111: 
                                                    case 112: 
                                                    case 114: 
                                                    case 115: 
                                                    case 116: 
                                                    case 117: 
                                                    case 118: 
                                                    case 120: 
                                                    case 121: 
                                                    case 122: 
                                                    case 123: 
                                                    case 124: 
                                                    case 126: 
                                                    case 127: 
                                                    case 131: 
                                                    case 132: 
                                                    case 134: 
                                                    case 203: 
                                                    case 205: 
                                                    case 206: 
                                                    case 208: 
                                                    case 209: 
                                                    case 210: 
                                                    case 211: 
                                                    case 215: 
                                                    case 216: 
                                                    case 217: 
                                                    case 219: 
                                                    case 220: 
                                                    case 221: 
                                                    case 225: 
                                                    case 227: 
                                                    case 230: 
                                                    case 231: 
                                                    case 232: 
                                                    case 233: 
                                                    case 234: 
                                                    case 235: 
                                                    case 238: 
                                                    case 240: 
                                                    case 245: 
                                                    case 246: 
                                                    case 247: 
                                                    case 248: 
                                                    case 249: 
                                                    case 250: 
                                                    case 252: 
                                                    case 253: 
                                                    case 254: 
                                                    case 257: 
                                                    case 258: 
                                                    case 260: 
                                                    case 262: 
                                                    case 264: 
                                                    case 265: 
                                                    case 267: 
                                                    case 268: 
                                                    case 270: 
                                                    case 271: 
                                                    case 273: 
                                                    case 274: 
                                                    case 275: 
                                                    case 276: 
                                                    case 278: 
                                                    case 280: 
                                                    case 281: 
                                                    case 282: 
                                                    case 283: 
                                                    case 284: 
                                                    case 286: 
                                                    case 288: 
                                                    case 289: 
                                                    case 291: 
                                                    case 293: 
                                                    case 295: 
                                                    case 299: 
                                                    case 300: 
                                                    case 301: 
                                                    case 303: 
                                                    case 304: 
                                                    case 305: 
                                                    case 306: 
                                                    case 308: 
                                                    case 309: 
                                                    case 310: 
                                                    case 315: 
                                                    case 317: 
                                                    case 319: 
                                                    case 320: 
                                                    case 323: 
                                                    case 324: 
                                                    case 325: 
                                                    case 326: 
                                                    case 327: 
                                                    case 329: 
                                                    case 330: 
                                                    case 331: {
                                                        etype = TYP_VAL | SPECIAL_colref | TYP_TREF;
                                                        this.syntaxStack.push(new String[]{part3.getText(), part2.getText(), part1.getText(), null});
                                                        break block0;
                                                    }
                                                    case 110: {
                                                        this.match(110);
                                                        switch (this.LA(1)) {
                                                            case 103: {
                                                                asterisk3 = this.LT(1);
                                                                this.match(103);
                                                                etype = SPECIAL_qast;
                                                                this.syntaxStack.push(new String[]{"*", part3.getText(), part2.getText(), part1.getText()});
                                                                break block0;
                                                            }
                                                            case 117: {
                                                                part4 = this.LT(1);
                                                                this.match(117);
                                                                etype = TYP_VAL | SPECIAL_colref;
                                                                this.syntaxStack.push(new String[]{part4.getText(), part3.getText(), part2.getText(), part1.getText()});
                                                                break block0;
                                                            }
                                                        }
                                                        throw new NoViableAltException(this.LT(1), this.getFilename());
                                                    }
                                                }
                                                throw new NoViableAltException(this.LT(1), this.getFilename());
                                            }
                                        }
                                        throw new NoViableAltException(this.LT(1), this.getFilename());
                                    }
                                }
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 278: {
                this.checkSapSql(false, "noQualifiedLocalTables");
                this.syntaxStack.push(new String[]{"module", null, null, null});
                this.match(278);
                this.match(110);
                this.match(117);
                switch (this.LA(1)) {
                    case 1: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 225: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 238: 
                    case 240: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 258: 
                    case 260: 
                    case 262: 
                    case 264: 
                    case 265: 
                    case 267: 
                    case 268: 
                    case 270: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 291: 
                    case 293: 
                    case 295: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 329: 
                    case 330: 
                    case 331: {
                        etype = TYP_TREF;
                        break block0;
                    }
                    case 110: {
                        this.match(110);
                        switch (this.LA(1)) {
                            case 103: {
                                this.match(103);
                                etype = SPECIAL_qast;
                                break block0;
                            }
                            case 117: {
                                this.match(117);
                                etype = TYP_VAL | SPECIAL_colref;
                                break block0;
                            }
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final void collate_clause() throws RecognitionException, TokenStreamException {
        this.checkISql(false, "collateNotAllowed");
        this.match(221);
        this.qualified_name();
        this.syntaxStack.pop();
    }

    private final void hintlist() throws RecognitionException, TokenStreamException {
        HashSet hints = new HashSet();
        this.match(136);
        this.hint();
        hints.add(this.syntaxStack.pop());
        while (this.LA(1) == 107) {
            this.match(107);
            this.hint();
            hints.add(this.syntaxStack.pop());
        }
        this.match(137);
        if (hints.contains(hintNoBuffer)) {
            this.bufferable = false;
            hints.remove(hintNoBuffer);
        }
        Hint[] hintList = new Hint[hints.size()];
        ((AbstractCollection)hints).toArray(hintList);
        this.syntaxStack.push(hintList);
    }

    private final void table_name() throws RecognitionException, TokenStreamException {
        int etype = this.column_reference_or_table_name();
        this.checkSql((etype & TYP_TREF) != 0, "argumentMustBeTable");
    }

    private final void set_clause() throws RecognitionException, TokenStreamException {
        Token id = null;
        id = this.LT(1);
        this.match(117);
        this.match(111);
        switch (this.LA(1)) {
            case 238: {
                this.checkESql(false, "noDefaultSpec");
                this.syntaxStack.push(new DefaultValue());
                this.match(238);
                break;
            }
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                this.value_expression_or_null();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        ColumnReference colRef = new ColumnReference(id.getText());
        RowValueElement value = (RowValueElement)this.popRowValue();
        this.syntaxStack.push(new SetClause(colRef, value));
    }

    private final void search_condition(String errorKey) throws RecognitionException, TokenStreamException {
        int etype = this.general_b_expression();
        Object obj = this.syntaxStack.peek();
        if (!(obj instanceof SearchCondition)) {
            this.checkSql(false, errorKey);
            this.syntaxStack.pop();
            this.syntaxStack.push(new DummySearchCondition());
        }
    }

    private final void value_expression_or_null() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_expression();
        this.checkSql((etype & (TYP_VAL | TYP_NULL)) != 0, "argumentMustBeValueOrNull");
    }

    private final int general_sub_expression() throws RecognitionException, TokenStreamException {
        ArrayList<RowValue> tempList = null;
        this.match(121);
        int etype = this.row_value_constructor_t(true);
        switch (this.LA(1)) {
            case 131: {
                this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesNotDirectlyInInsert");
                if ((etype & TYP_QUERY) != 0 && (etype & SPECIAL_MASK) == SPECIAL_select) {
                    etype |= TYP_ROW;
                }
                this.checkSql((etype &= TYP_BOOL | TYP_QUERY | TYP_TREF | TYP_VAL | TYP_NULL) != 0, "parentheses not allowed");
                if ((etype &= TYP_BOOL | TYP_QUERY | TYP_TREF | TYP_VAL) == 0) {
                    etype = SPECIAL_ndlist;
                    break;
                }
                if ((etype & TYP_VAL) == 0) break;
                etype |= TYP_LIST;
                break;
            }
            case 107: {
                this.checkSql((etype & (TYP_VAL | TYP_NULL)) != 0, "wrongListElements");
                boolean containsNullOrDefault = (etype & TYP_VAL) == 0;
                tempList = new ArrayList<RowValue>();
                tempList.add(this.popRowValue());
                int _cnt56 = 0;
                while (true) {
                    if (this.LA(1) != 107) {
                        if (_cnt56 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(107);
                    etype = this.row_value_constructor_t(false);
                    containsNullOrDefault = containsNullOrDefault || (etype & TYP_VAL) == 0;
                    tempList.add(this.popRowValue());
                    ++_cnt56;
                }
                etype = containsNullOrDefault ? SPECIAL_ndlist : TYP_LIST;
                RowValueElement[] valueList = tempList.toArray(new RowValueElement[0]);
                this.syntaxStack.push(new RowValueElementList(valueList));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(131);
        return etype;
    }

    private final int row_value_constructor_t(boolean noCheck) throws RecognitionException, TokenStreamException {
        int etype = 0;
        switch (this.LA(1)) {
            case 238: {
                this.checkESql(false, "noDefaultSpec");
                this.match(238);
                etype = TYP_NULL;
                this.syntaxStack.push(new DefaultValue());
                break;
            }
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 249: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 299: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 320: 
            case 323: 
            case 324: 
            case 326: 
            case 327: {
                etype = this.general_t_expression();
                this.checkSql(noCheck || (etype & (TYP_VAL | TYP_NULL)) != 0, "wrongListElements");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int row_value_constructor_for_table_value() throws RecognitionException, TokenStreamException {
        int etype = 0;
        switch (this.LA(1)) {
            case 238: {
                this.checkESql(false, "noDefaultSpec");
                this.match(238);
                etype = TYP_NULL;
                this.syntaxStack.push(new DefaultValue());
                break;
            }
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                etype = this.general_v_expression();
                this.checkISql((etype & TYP_LIST) != 0 || etype == SPECIAL_ndlist, "illegalValuesClause");
                this.checkSql((etype & (TYP_ROW | TYP_NULL)) != 0 || etype == SPECIAL_ndlist, "illegalRowValue");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int general_v_expression() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_term();
        block5: while (true) {
            switch (this.LA(1)) {
                case 126: {
                    int etype1 = etype & (TYP_NUM | TYP_INTV | TYP_DATE);
                    this.checkSql(etype1 != 0, "illegalFirstArgumentPlusMinus", "+");
                    this.match(126);
                    int etype2 = this.general_v_term();
                    etype &= etype2 & (TYP_NUM | TYP_INTV);
                    if ((etype1 & TYP_INTV) != 0 && (etype2 & TYP_DATE) != 0 || (etype1 & TYP_DATE) != 0 && (etype2 & TYP_INTV) != 0) {
                        etype |= TYP_DATE;
                    }
                    this.checkSql(etype != 0, "illegalPlusMinusArgument", "+");
                    ValueExpression rhs = this.popValueExpression();
                    ValueExpression lhs = this.popValueExpression();
                    this.syntaxStack.push(new ArithmeticExpression(lhs, 1, rhs));
                    continue block5;
                }
                case 123: {
                    int etype1 = etype & (TYP_NUM | TYP_INTV | TYP_DATE);
                    this.checkSql(etype1 != 0, "illegalFirstArgumentPlusMinus", "-");
                    this.match(123);
                    int etype2 = this.general_v_term();
                    etype &= etype2 & (TYP_NUM | TYP_INTV);
                    if ((etype1 & TYP_DATE) != 0 && (etype2 & TYP_INTV) != 0) {
                        etype |= TYP_DATE;
                    }
                    if ((etype1 & TYP_DATE) != 0 && (etype2 & TYP_DATE) != 0) {
                        etype |= TYP_INTV;
                    }
                    this.checkSql(etype != 0, "illegalPlusMinusArgument", "-");
                    ValueExpression rhs = this.popValueExpression();
                    ValueExpression lhs = this.popValueExpression();
                    this.syntaxStack.push(new ArithmeticExpression(lhs, 2, rhs));
                    continue block5;
                }
                case 108: {
                    this.checkESql(false, "notAllowed", "||");
                    int etype1 = etype & TYP_STR;
                    this.checkSql(etype1 != 0, "firstConcatArgument");
                    this.match(108);
                    int etype2 = this.general_v_term();
                    etype = etype1 & etype2;
                    this.checkSql(etype != 0, "secondConcatArgument");
                    ValueExpression[] operands = new ValueExpression[2];
                    operands[1] = this.popValueExpression();
                    operands[0] = this.popValueExpression();
                    this.syntaxStack.push(new ConcatenationExpression(operands));
                    continue block5;
                }
            }
            break;
        }
        return etype;
    }

    private final int general_t_term() throws RecognitionException, TokenStreamException {
        int setOperator = 0;
        Query lhs = null;
        int etype = this.general_t_factor();
        while (this.LA(1) == 264) {
            this.checkESql(false, "notAllowed", "INTERSECT");
            this.checkSql((etype & TYP_QUERY) != 0, "leftArgumentNotTable", "INTERSECT");
            this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesOnlyInInsert");
            lhs = this.popQuery(null, true);
            this.match(264);
            switch (this.LA(1)) {
                case 102: 
                case 104: 
                case 105: 
                case 106: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 121: 
                case 123: 
                case 126: 
                case 127: 
                case 209: 
                case 211: 
                case 215: 
                case 216: 
                case 217: 
                case 219: 
                case 220: 
                case 225: 
                case 226: 
                case 227: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 249: 
                case 250: 
                case 265: 
                case 273: 
                case 275: 
                case 276: 
                case 278: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 293: 
                case 299: 
                case 300: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 309: 
                case 310: 
                case 315: 
                case 317: 
                case 320: 
                case 323: 
                case 324: 
                case 326: 
                case 327: {
                    setOperator = 3;
                    break;
                }
                case 201: {
                    this.match(201);
                    setOperator = 4;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 226: {
                    this.corresponding_spec();
                    break;
                }
                case 102: 
                case 104: 
                case 105: 
                case 106: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 121: 
                case 123: 
                case 126: 
                case 127: 
                case 209: 
                case 211: 
                case 215: 
                case 216: 
                case 217: 
                case 219: 
                case 220: 
                case 225: 
                case 227: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 249: 
                case 250: 
                case 265: 
                case 273: 
                case 275: 
                case 276: 
                case 278: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 293: 
                case 299: 
                case 300: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 309: 
                case 310: 
                case 315: 
                case 317: 
                case 320: 
                case 323: 
                case 324: 
                case 326: 
                case 327: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            etype = this.general_t_factor();
            this.checkSql((etype & TYP_QUERY) != 0, "rightArgumentNotTable", "INTERSECT");
            this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesOnlyInInsert");
            etype = TYP_QUERY;
            Query rhs = this.popQuery(null, true);
            this.syntaxStack.push(new NonJoinQuery(lhs, setOperator, rhs));
        }
        return etype;
    }

    private final void corresponding_spec() throws RecognitionException, TokenStreamException {
        this.checkESql(false, "notAllowed", "CORRESPONDING BY");
        this.match(226);
        this.match(213);
        this.match(121);
        this.match(117);
        while (this.LA(1) == 107) {
            this.match(107);
            this.match(117);
        }
        this.match(131);
    }

    private final int general_t_factor() throws RecognitionException, TokenStreamException {
        int etype = 0;
        switch (this.LA(1)) {
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 249: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 320: 
            case 323: 
            case 324: 
            case 326: {
                etype = this.general_t_join();
                break;
            }
            case 299: {
                etype = this.query_specification();
                break;
            }
            case 327: {
                etype = this.table_value_constructor();
                break;
            }
            case 306: {
                this.checkISql(false, "noExplicitTable");
                this.match(306);
                this.table_name();
                etype = TYP_QUERY;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int general_t_join() throws RecognitionException, TokenStreamException {
        int etype = this.general_t_primary();
        block41: while (true) {
            switch (this.LA(1)) {
                case 230: {
                    this.checkISql(false, "notAllowed", "CROSS JOIN");
                    this.match(230);
                    etype = this.join_cont(etype, false, 1);
                    continue block41;
                }
                case 280: {
                    this.checkESql(false, "notAllowed", "NATURAL JOIN");
                    this.match(280);
                    switch (this.LA(1)) {
                        case 262: {
                            this.match(262);
                            etype = this.join_cont(etype, false, 4);
                            continue block41;
                        }
                        case 270: {
                            this.match(270);
                            switch (this.LA(1)) {
                                case 290: {
                                    this.match(290);
                                    break;
                                }
                                case 268: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            etype = this.join_cont(etype, false, 6);
                            continue block41;
                        }
                        case 295: {
                            this.match(295);
                            switch (this.LA(1)) {
                                case 290: {
                                    this.match(290);
                                    break;
                                }
                                case 268: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            etype = this.join_cont(etype, false, 8);
                            continue block41;
                        }
                        case 254: {
                            this.match(254);
                            switch (this.LA(1)) {
                                case 290: {
                                    this.match(290);
                                    break;
                                }
                                case 268: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            etype = this.join_cont(etype, false, 10);
                            continue block41;
                        }
                        case 319: {
                            this.match(319);
                            this.checkSql(false, "notAllowed", "NATURAL UNION JOIN");
                            etype = this.join_cont(etype, false, 2);
                            continue block41;
                        }
                        case 268: {
                            etype = this.join_cont(etype, false, 4);
                            continue block41;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 262: {
                    this.match(262);
                    etype = this.join_cont(etype, true, 3);
                    continue block41;
                }
                case 270: {
                    this.match(270);
                    switch (this.LA(1)) {
                        case 290: {
                            this.match(290);
                            break;
                        }
                        case 268: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    etype = this.join_cont(etype, true, 5);
                    continue block41;
                }
                case 295: {
                    this.checkESql(false, "notAllowed", "RIGHT OUTER JOIN");
                    this.match(295);
                    switch (this.LA(1)) {
                        case 290: {
                            this.match(290);
                            break;
                        }
                        case 268: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    etype = this.join_cont(etype, true, 7);
                    continue block41;
                }
                case 254: {
                    this.checkESql(false, "notAllowed", "FULL OUTER JOIN");
                    this.match(254);
                    switch (this.LA(1)) {
                        case 290: {
                            this.match(290);
                            break;
                        }
                        case 268: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    etype = this.join_cont(etype, true, 9);
                    continue block41;
                }
                case 268: {
                    etype = this.join_cont(etype, true, 3);
                    continue block41;
                }
            }
            if (this.LA(1) != 319 || this.LA(2) != 268 || this.LA(2) != 268) break;
            this.checkISql(false, "notAllowed", "UNION JOIN");
            this.match(319);
            etype = this.join_cont(etype, false, 2);
        }
        return etype;
    }

    private final int query_specification() throws RecognitionException, TokenStreamException {
        boolean isDistinct = false;
        SelectSublist[] selectSublist = null;
        Query[] fromClause = null;
        SearchCondition whereClause = null;
        ColumnReference[] groupByList = null;
        SearchCondition havingClause = null;
        ArrayList tempList = null;
        Hint[] hints = null;
        this.match(299);
        switch (this.LA(1)) {
            case 136: {
                this.hintlist();
                hints = (Hint[])this.syntaxStack.pop();
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 201: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 242: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 242: {
                this.match(242);
                isDistinct = true;
                break;
            }
            case 201: {
                this.match(201);
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 103: {
                this.match(103);
                break;
            }
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                this.select_sublist();
                tempList = new ArrayList();
                tempList.add(this.syntaxStack.pop());
                while (this.LA(1) == 107) {
                    this.match(107);
                    this.select_sublist();
                    tempList.add(this.syntaxStack.pop());
                }
                selectSublist = tempList.toArray(new SelectSublist[0]);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(253);
        int etype = this.general_t_join();
        this.checkSql((etype & TYP_TREF) != 0, "fromArgumentMustBeTabref");
        tempList = new ArrayList();
        tempList.add(this.popQuery(null, true));
        while (this.LA(1) == 107 && _tokenSet_6.member(this.LA(2))) {
            this.match(107);
            etype = this.general_t_join();
            this.checkSql((etype & TYP_TREF) != 0, "fromArgumentMustBeTabref");
            tempList.add(this.popQuery(null, true));
        }
        fromClause = tempList.toArray(new Query[0]);
        switch (this.LA(1)) {
            case 331: {
                this.match(331);
                this.search_condition("argumentWhereBooleanNeeded");
                whereClause = (SearchCondition)this.syntaxStack.pop();
                break;
            }
            case 1: 
            case 107: 
            case 131: 
            case 132: 
            case 248: 
            case 252: 
            case 257: 
            case 258: 
            case 264: 
            case 289: 
            case 319: 
            case 329: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 257: {
                this.match(257);
                this.match(213);
                this.grouping_column_reference();
                tempList = new ArrayList();
                tempList.add(this.syntaxStack.pop());
                while (this.LA(1) == 107 && (this.LA(2) == 117 || this.LA(2) == 118 || this.LA(2) == 278)) {
                    this.match(107);
                    this.grouping_column_reference();
                    tempList.add(this.syntaxStack.pop());
                }
                groupByList = tempList.toArray(new ColumnReference[0]);
                break;
            }
            case 1: 
            case 107: 
            case 131: 
            case 132: 
            case 248: 
            case 252: 
            case 258: 
            case 264: 
            case 289: 
            case 319: 
            case 329: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 258: {
                this.match(258);
                this.search_condition("argumentHavingBooleanNeeded");
                havingClause = (SearchCondition)this.syntaxStack.pop();
                break;
            }
            case 1: 
            case 107: 
            case 131: 
            case 132: 
            case 248: 
            case 252: 
            case 264: 
            case 289: 
            case 319: 
            case 329: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        etype = TYP_QUERY | SPECIAL_select;
        QuerySpecification querySpec = new QuerySpecification(isDistinct, selectSublist, fromClause, whereClause, groupByList, havingClause);
        if (hints != null && hints.length > 0) {
            querySpec.setHints(hints);
        }
        this.syntaxStack.push(querySpec);
        return etype;
    }

    private final int table_value_constructor() throws RecognitionException, TokenStreamException {
        int etype;
        ArrayList<RowValue> tempList;
        block6: {
            tempList = null;
            this.match(327);
            etype = this.row_value_constructor_for_table_value();
            tempList = new ArrayList<RowValue>();
            tempList.add(this.popRowValue());
            if (this.LA(1) == 107 && _tokenSet_7.member(this.LA(2)) && this.LA(1) == 107) {
                this.checkISql(false, "tooManyRowValueConstructors");
                int _cnt115 = 0;
                while (true) {
                    if (this.LA(1) != 107 || !_tokenSet_7.member(this.LA(2))) {
                        if (_cnt115 < 1) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        break block6;
                    }
                    this.match(107);
                    int etype2 = this.row_value_constructor_for_table_value();
                    if ((etype2 & TYP_ROW) == 0) {
                        etype = 0;
                    }
                    tempList.add(this.popRowValue());
                    ++_cnt115;
                }
            }
            if (!_tokenSet_8.member(this.LA(1)) || !_tokenSet_9.member(this.LA(2))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        etype = (etype & TYP_ROW) == 0 ? SPECIAL_values : TYP_QUERY | SPECIAL_values;
        RowValue[] rowList = tempList.toArray(new RowValue[0]);
        this.syntaxStack.push(new TableValue(rowList));
        return etype;
    }

    private final int general_t_primary() throws RecognitionException, TokenStreamException {
        Token alias = null;
        int etype = this.general_b_expression();
        block0 : switch (this.LA(1)) {
            case 117: 
            case 205: {
                this.checkSql((etype & TYP_TREF) != 0, "notATableReference");
                this.checkISql((etype & TYP_QUERY) == 0, "notATableName");
                switch (this.LA(1)) {
                    case 205: {
                        this.match(205);
                        break;
                    }
                    case 117: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                alias = this.LT(1);
                this.match(117);
                this.syntaxStack.push(this.popQuery(alias.getText(), false));
                switch (this.LA(1)) {
                    case 121: {
                        this.checkESql(false, "derivedColumnListNotAllowed");
                        this.match(121);
                        this.match(117);
                        while (this.LA(1) == 107) {
                            this.match(107);
                            this.match(117);
                        }
                        this.match(131);
                        break block0;
                    }
                    case 1: 
                    case 107: 
                    case 131: 
                    case 132: 
                    case 230: 
                    case 248: 
                    case 252: 
                    case 254: 
                    case 257: 
                    case 258: 
                    case 262: 
                    case 264: 
                    case 268: 
                    case 270: 
                    case 280: 
                    case 286: 
                    case 289: 
                    case 295: 
                    case 319: 
                    case 325: 
                    case 329: 
                    case 331: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 1: 
            case 107: 
            case 131: 
            case 132: 
            case 230: 
            case 248: 
            case 252: 
            case 254: 
            case 257: 
            case 258: 
            case 262: 
            case 264: 
            case 268: 
            case 270: 
            case 280: 
            case 286: 
            case 289: 
            case 295: 
            case 319: 
            case 325: 
            case 329: 
            case 331: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int join_cont(int etype1, boolean joinSpec, int joinType) throws RecognitionException, TokenStreamException {
        Token id = null;
        Token more_id = null;
        SearchCondition onClause = null;
        String[] usingClause = null;
        ArrayList<String> tempList = null;
        this.checkSql((etype1 & TYP_TREF) != 0, "joinLeftArgument");
        this.match(268);
        int etype = this.general_t_primary();
        this.checkSql((etype & TYP_TREF) != 0, "joinRightArgument");
        switch (this.LA(1)) {
            case 286: {
                this.checkSql(joinSpec, "onNotAllowed");
                this.match(286);
                this.search_condition("argumentOnBooleanNeeded");
                onClause = (SearchCondition)this.syntaxStack.pop();
                break;
            }
            case 325: {
                this.checkSql(false, "usingNotAllowed");
                this.match(325);
                this.match(121);
                id = this.LT(1);
                this.match(117);
                tempList = new ArrayList<String>();
                tempList.add(id.getText());
                while (this.LA(1) == 107) {
                    this.match(107);
                    more_id = this.LT(1);
                    this.match(117);
                    tempList.add(more_id.getText());
                }
                this.match(131);
                usingClause = tempList.toArray(new String[0]);
                break;
            }
            case 1: 
            case 107: 
            case 131: 
            case 132: 
            case 230: 
            case 248: 
            case 252: 
            case 254: 
            case 257: 
            case 258: 
            case 262: 
            case 264: 
            case 268: 
            case 270: 
            case 280: 
            case 289: 
            case 295: 
            case 319: 
            case 329: 
            case 331: {
                this.checkSql(!joinSpec, "onEmpty");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        etype = TYP_TREF | TYP_QUERY;
        Query rhs = this.popQuery(null, true);
        Query lhs = this.popQuery(null, true);
        if (null != usingClause) {
            this.syntaxStack.push(new JoinedTable(lhs, joinType, rhs, usingClause));
        } else {
            this.syntaxStack.push(new JoinedTable(lhs, joinType, rhs, onClause));
        }
        return etype;
    }

    private final int general_b_expression() throws RecognitionException, TokenStreamException {
        ArrayList operands = null;
        boolean wasError = false;
        int etype = this.general_b_term();
        switch (this.LA(1)) {
            case 288: {
                if ((etype & TYP_BOOL) == 0) {
                    this.checkSql(false, "illegalLeftArgument", "OR", "Boolean");
                    wasError = true;
                }
                operands = new ArrayList();
                operands.add(this.syntaxStack.pop());
                int _cnt119 = 0;
                while (true) {
                    if (this.LA(1) == 288) {
                        this.match(288);
                        etype = this.general_b_term();
                        if ((etype & TYP_BOOL) == 0) {
                            this.checkSql(false, "illegalRightArgument", "OR", "Boolean");
                            wasError = true;
                        }
                    } else {
                        if (_cnt119 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    operands.add(this.syntaxStack.pop());
                    ++_cnt119;
                }
                if (wasError) {
                    this.syntaxStack.push(new DummySearchCondition());
                } else {
                    SearchCondition[] operandList = operands.toArray(new SearchCondition[0]);
                    this.syntaxStack.push(new BooleanOr(operandList));
                }
                etype = TYP_BOOL;
                break;
            }
            case 1: 
            case 107: 
            case 117: 
            case 131: 
            case 132: 
            case 205: 
            case 230: 
            case 248: 
            case 252: 
            case 254: 
            case 257: 
            case 258: 
            case 262: 
            case 264: 
            case 268: 
            case 270: 
            case 280: 
            case 286: 
            case 289: 
            case 295: 
            case 308: 
            case 319: 
            case 325: 
            case 329: 
            case 331: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final void select_sublist() throws RecognitionException, TokenStreamException {
        Token alias = null;
        String aliasName = null;
        int etype = this.general_v_expression();
        switch (this.LA(1)) {
            case 117: 
            case 205: {
                this.checkSql((etype & TYP_VAL) != 0, "aliasedColumnMustBeValue");
                switch (this.LA(1)) {
                    case 205: {
                        this.match(205);
                        break;
                    }
                    case 117: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                alias = this.LT(1);
                this.match(117);
                aliasName = alias.getText();
                break;
            }
            case 107: 
            case 253: {
                this.checkSql((etype & TYP_VAL) != 0 || etype == SPECIAL_qast, "derivedColumnMustBeValue");
                this.checkESql(etype != SPECIAL_qast, "noDotAsterisk");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        ValueExpression value = this.popValueExpression();
        if (null == aliasName && value instanceof ColumnReference) {
            aliasName = ((ColumnReference)value).getColumnName();
        }
        this.syntaxStack.push(new SelectSublist(value, aliasName));
    }

    private final void grouping_column_reference() throws RecognitionException, TokenStreamException {
        Token number = null;
        switch (this.LA(1)) {
            case 117: 
            case 278: {
                int etype = this.column_reference_or_table_name();
                this.checkSql((etype & TYP_VAL) != 0, "argumentOfGroupByNotColref");
                this.syntaxStack.push(this.popValueExpression());
                break;
            }
            case 118: {
                number = this.LT(1);
                this.match(118);
                this.checkSql(false, "illegalGroupByNumber");
                this.syntaxStack.push(new ColumnReference(number.getText()));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 221: {
                this.collate_clause();
                break;
            }
            case 1: 
            case 107: 
            case 131: 
            case 132: 
            case 248: 
            case 252: 
            case 258: 
            case 264: 
            case 289: 
            case 319: 
            case 329: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final int general_b_term() throws RecognitionException, TokenStreamException {
        ArrayList operands = null;
        boolean wasError = false;
        int etype = this.general_b_factor();
        switch (this.LA(1)) {
            case 203: {
                if ((etype & TYP_BOOL) == 0) {
                    this.checkSql(false, "illegalLeftArgument", "AND", "Boolean");
                    wasError = true;
                }
                operands = new ArrayList();
                operands.add(this.syntaxStack.pop());
                int _cnt123 = 0;
                while (true) {
                    if (this.LA(1) == 203) {
                        this.match(203);
                        etype = this.general_b_factor();
                        if ((etype & TYP_BOOL) == 0) {
                            this.checkSql(false, "illegalRightArgument", "AND", "Boolean");
                            wasError = true;
                        }
                    } else {
                        if (_cnt123 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    operands.add(this.syntaxStack.pop());
                    ++_cnt123;
                }
                if (wasError) {
                    this.syntaxStack.push(new DummySearchCondition());
                } else {
                    SearchCondition[] operandList = operands.toArray(new SearchCondition[0]);
                    this.syntaxStack.push(new BooleanAnd(operandList));
                }
                etype = TYP_BOOL;
                break;
            }
            case 1: 
            case 107: 
            case 117: 
            case 131: 
            case 132: 
            case 205: 
            case 230: 
            case 248: 
            case 252: 
            case 254: 
            case 257: 
            case 258: 
            case 262: 
            case 264: 
            case 268: 
            case 270: 
            case 280: 
            case 286: 
            case 288: 
            case 289: 
            case 295: 
            case 308: 
            case 319: 
            case 325: 
            case 329: 
            case 331: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int general_b_factor() throws RecognitionException, TokenStreamException {
        String text;
        int etype;
        switch (this.LA(1)) {
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 249: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 320: 
            case 323: 
            case 324: 
            case 326: {
                etype = this.general_b_primary();
                break;
            }
            case 281: {
                this.match(281);
                etype = this.general_b_primary();
                SearchCondition negation = (SearchCondition)this.syntaxStack.pop();
                if ((etype & TYP_BOOL) == 0) {
                    this.checkSql(false, "illegalArgument", "NOT", "Boolean");
                    this.syntaxStack.push(new DummySearchCondition());
                } else {
                    this.syntaxStack.push(new BooleanNot(negation));
                }
                etype = TYP_BOOL;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.LA(1) == 267 && (this.LA(2) == 251 || this.LA(2) == 318 || this.LA(2) == 321)) {
            text = this.LT(1).getText() + " " + this.LT(2).getText();
            this.checkISql(false, "booleanTestsNotAllowed", text);
            this.checkSql((etype & TYP_BOOL) != 0, "illegalISAregument");
            etype = TYP_BOOL;
            this.match(267);
            switch (this.LA(1)) {
                case 318: {
                    this.match(318);
                    break;
                }
                case 251: {
                    this.match(251);
                    break;
                }
                case 321: {
                    this.match(321);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        } else if (this.LA(1) == 267 && this.LA(2) == 281) {
            text = this.LT(1).getText() + " " + this.LT(2).getText() + " " + this.LT(3).getText();
            this.checkISql(false, "booleanTestsNotAllowed", text);
            this.checkSql((etype & TYP_BOOL) != 0, "illegalISAregument");
            etype = TYP_BOOL;
            this.match(267);
            this.match(281);
            switch (this.LA(1)) {
                case 318: {
                    this.match(318);
                    break;
                }
                case 251: {
                    this.match(251);
                    break;
                }
                case 321: {
                    this.match(321);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        } else if (!_tokenSet_10.member(this.LA(1))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return etype;
    }

    private final int general_b_primary() throws RecognitionException, TokenStreamException {
        int etype;
        boolean isNotNull = false;
        block0 : switch (this.LA(1)) {
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                etype = this.general_v_expression();
                switch (this.LA(1)) {
                    case 111: 
                    case 114: 
                    case 115: 
                    case 120: 
                    case 122: 
                    case 124: {
                        this.comparison_predicate_cont(etype);
                        etype = TYP_BOOL;
                        break block0;
                    }
                    case 210: {
                        this.between_predicate_cont(etype, false);
                        etype = TYP_BOOL;
                        break block0;
                    }
                    case 260: {
                        this.in_predicate_cont(etype, false);
                        etype = TYP_BOOL;
                        break block0;
                    }
                    case 271: {
                        this.like_predicate_cont(etype, false);
                        etype = TYP_BOOL;
                        break block0;
                    }
                    case 274: {
                        this.match_predicate_cont(etype);
                        etype = TYP_BOOL;
                        break block0;
                    }
                    case 291: {
                        this.overlaps_predicate_cont(etype);
                        etype = TYP_BOOL;
                        break block0;
                    }
                    case 281: {
                        this.match(281);
                        switch (this.LA(1)) {
                            case 210: {
                                this.between_predicate_cont(etype, true);
                                break;
                            }
                            case 260: {
                                this.in_predicate_cont(etype, true);
                                break;
                            }
                            case 271: {
                                this.like_predicate_cont(etype, true);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        etype = TYP_BOOL;
                        break block0;
                    }
                }
                if (this.LA(1) == 267 && (this.LA(2) == 281 || this.LA(2) == 282) && (this.LA(2) == 282 || this.LA(2) == 281 && this.LA(3) == 282)) {
                    this.checkISql((etype & TYP_VAL) != 0, "nullArgumentNotValue");
                    this.checkSql((etype & TYP_ROW) != 0, "nullArgumentNotRowValue");
                    this.checkESql((etype & SPECIAL_MASK) == SPECIAL_colref || (etype & SPECIAL_MASK) == SPECIAL_id, "nullArgumentNotColRef");
                    this.match(267);
                    switch (this.LA(1)) {
                        case 281: {
                            this.match(281);
                            isNotNull = true;
                            break;
                        }
                        case 282: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(282);
                    etype = TYP_BOOL;
                    ValueExpression value = this.popValueExpression();
                    this.syntaxStack.push(new NullPredicate(value, isNotNull));
                    break;
                }
                if (_tokenSet_11.member(this.LA(1)) && _tokenSet_12.member(this.LA(2))) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 249: {
                this.match(249);
                etype = this.general_sub_expression();
                this.checkSql((etype & TYP_QUERY) != 0, "existsArgumentNotSubquery");
                this.checkESql((etype & TYP_ROW) != 0, "existsArgumentNotSelect");
                etype = TYP_BOOL;
                Query subQuery = this.popQuery(null, false);
                this.syntaxStack.push(new ExistsPredicate(subQuery));
                break;
            }
            case 320: {
                this.checkESql(false, "predicateNotAllowed", "UNIQUE");
                this.match(320);
                etype = this.general_sub_expression();
                this.checkSql((etype & TYP_QUERY) != 0, "uniqueArgumentNotSubquery");
                etype = TYP_BOOL;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final void comparison_predicate_cont(int etype) throws RecognitionException, TokenStreamException {
        int operator = 0;
        int quantifier = 0;
        this.checkISql((etype & TYP_VAL) != 0, "leftCompArgumentNotValue");
        this.checkSql((etype & TYP_ROW) != 0, "leftCompArgumentNotRowValue");
        switch (this.LA(1)) {
            case 111: {
                this.match(111);
                operator = 1;
                break;
            }
            case 124: {
                this.match(124);
                operator = 2;
                break;
            }
            case 122: {
                this.match(122);
                operator = 3;
                break;
            }
            case 120: {
                this.match(120);
                operator = 4;
                break;
            }
            case 115: {
                this.match(115);
                operator = 5;
                break;
            }
            case 114: {
                this.match(114);
                operator = 6;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                etype = this.general_v_expression();
                this.checkISql((etype & TYP_VAL) != 0, "rightCompArgumentNotValue");
                this.checkSql((etype & TYP_ROW) != 0, "rightCompArgumentNotRowValue");
                RowValue rhs = this.popRowValue();
                RowValue lhs = this.popRowValue();
                this.syntaxStack.push(new ComparisonPredicate(lhs, operator, rhs));
                break;
            }
            case 201: 
            case 204: 
            case 302: {
                switch (this.LA(1)) {
                    case 201: {
                        this.match(201);
                        quantifier = 1;
                        break;
                    }
                    case 204: {
                        this.match(204);
                        quantifier = 2;
                        break;
                    }
                    case 302: {
                        this.match(302);
                        quantifier = 3;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                etype = this.general_sub_expression();
                this.checkSql((etype & TYP_QUERY) != 0, "quantifiedComparisonSubquery");
                this.checkESql((etype & TYP_ROW) != 0, "quantifiedComparisonSelect");
                Query subQuery = this.popQuery(null, false);
                RowValue lhs = this.popRowValue();
                this.syntaxStack.push(new QuantifiedComparisonPredicate(lhs, operator, quantifier, subQuery));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void between_predicate_cont(int etype, boolean notBetween) throws RecognitionException, TokenStreamException {
        this.checkISql((etype & TYP_VAL) != 0, "firstBetweenArgumentValue");
        this.checkSql((etype & TYP_ROW) != 0, "firstBetweenArgumentRowValue");
        this.match(210);
        etype = this.general_v_expression();
        this.checkISql((etype & TYP_VAL) != 0, "secondBetweenArgumentValue");
        this.checkSql((etype & TYP_ROW) != 0, "secondBetweenArgumentRowValue");
        this.match(203);
        etype = this.general_v_expression();
        this.checkISql((etype & TYP_VAL) != 0, "thirdBetweenArgumentValue");
        this.checkSql((etype & TYP_ROW) != 0, "thirdBetweenArgumentRowValue");
        RowValue high = this.popRowValue();
        RowValue low = this.popRowValue();
        RowValue value = this.popRowValue();
        this.syntaxStack.push(new BetweenPredicate(value, low, high, notBetween));
    }

    private final void in_predicate_cont(int etype, boolean notIn) throws RecognitionException, TokenStreamException {
        ArrayList<ValueExpression> tempList = null;
        this.checkISql((etype & TYP_VAL) != 0, "firstInArgumentValue");
        this.checkSql((etype & TYP_ROW) != 0, "firstInArgumentRowValue");
        this.match(260);
        this.match(121);
        etype = this.general_t_expression();
        switch (this.LA(1)) {
            case 131: {
                this.checkESql((etype & SPECIAL_MASK) == SPECIAL_select || (etype & TYP_VAL) != 0, "secondInArgumentSelectOrList");
                this.checkSql((etype & (TYP_QUERY | TYP_VAL)) != 0, "secondInArgumentSelectOrList");
                this.checkISql((etype & SPECIAL_MASK) != SPECIAL_values, "valuesOnlyInInsert");
                if ((etype & TYP_QUERY) != 0) {
                    Query subQuery = this.popQuery(null, false);
                    RowValue value = this.popRowValue();
                    this.syntaxStack.push(new InSubqueryPredicate(value, subQuery, notIn));
                    break;
                }
                ValueExpression[] inValueList = new ValueExpression[]{this.popValueExpression()};
                ValueExpression value = this.popValueExpression();
                this.syntaxStack.push(new InListPredicate(value, inValueList, notIn));
                break;
            }
            case 107: {
                this.checkISql((etype & SPECIAL_MASK) == SPECIAL_vspec || (etype & SPECIAL_MASK) == SPECIAL_literal, "illegalListElement");
                this.checkSql((etype & TYP_VAL) != 0, "listElementNotValue");
                tempList = new ArrayList<ValueExpression>();
                tempList.add(this.popValueExpression());
                int _cnt142 = 0;
                while (true) {
                    if (this.LA(1) != 107) {
                        if (_cnt142 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(107);
                    etype = this.general_t_expression();
                    this.checkISql((etype & SPECIAL_MASK) == SPECIAL_vspec || (etype & SPECIAL_MASK) == SPECIAL_literal, "illegalListElement");
                    this.checkSql((etype & TYP_VAL) != 0, "listElementNotValue");
                    tempList.add(this.popValueExpression());
                    ++_cnt142;
                }
                ValueExpression value = this.popValueExpression();
                ValueExpression[] inValueList = tempList.toArray(new ValueExpression[0]);
                this.syntaxStack.push(new InListPredicate(value, inValueList, notIn));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(131);
    }

    private final void like_predicate_cont(int etype, boolean notLike) throws RecognitionException, TokenStreamException {
        ValueExpression escape = null;
        this.checkSql((etype & TYP_STR) != 0, "firstLikeArgumentNotString");
        this.checkESql((etype & SPECIAL_MASK) == SPECIAL_colref || (etype & SPECIAL_MASK) == SPECIAL_id, "firstLikeArgumentNotColRef");
        this.match(271);
        etype = this.general_v_expression();
        this.checkSql((etype & TYP_STR) != 0, "likePatternNotString");
        this.checkESql((etype & SPECIAL_MASK) == SPECIAL_vspec || (etype & SPECIAL_MASK) == SPECIAL_literal, "likePatternNotLiteral");
        switch (this.LA(1)) {
            case 247: {
                this.match(247);
                etype = this.general_v_expression();
                this.checkSql((etype & TYP_STR) != 0, "escapeCharNotChar");
                this.checkESql((etype & SPECIAL_MASK) == SPECIAL_vspec || (etype & SPECIAL_MASK) == SPECIAL_literal, "escapeCharNotLiteral");
                escape = this.popValueExpression();
                break;
            }
            case 1: 
            case 107: 
            case 117: 
            case 131: 
            case 132: 
            case 203: 
            case 205: 
            case 230: 
            case 248: 
            case 252: 
            case 254: 
            case 257: 
            case 258: 
            case 262: 
            case 264: 
            case 267: 
            case 268: 
            case 270: 
            case 280: 
            case 286: 
            case 288: 
            case 289: 
            case 295: 
            case 308: 
            case 319: 
            case 325: 
            case 329: 
            case 331: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        ValueExpression pattern = this.popValueExpression();
        ValueExpression match = this.popValueExpression();
        this.syntaxStack.push(new LikePredicate(match, pattern, escape, notLike));
    }

    private final void match_predicate_cont(int etype) throws RecognitionException, TokenStreamException {
        this.checkISql(false, "predicateNotAllowed", "MATCH");
        this.checkSql((etype & TYP_ROW) != 0, "firstArgumentOfMatchNotRowValue");
        this.popRowValue();
        this.match(274);
        switch (this.LA(1)) {
            case 320: {
                this.match(320);
                break;
            }
            case 121: 
            case 254: 
            case 292: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 292: {
                this.match(292);
                break;
            }
            case 254: {
                this.match(254);
                break;
            }
            case 121: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        etype = this.general_sub_expression();
        this.checkSql((etype & TYP_QUERY) != 0, "secondArgumentOfMatchNotTable");
        this.popQuery(null, true);
        this.syntaxStack.push(new DummySearchCondition());
    }

    private final void overlaps_predicate_cont(int etype) throws RecognitionException, TokenStreamException {
        this.checkESql(false, "predicateNotAllowed", "OVERLAPS");
        this.checkSql((etype & TYP_LIST) != 0, "illegalOverlapsArgument");
        this.popRowValue();
        this.match(291);
        etype = this.general_v_expression();
        this.checkSql((etype & TYP_LIST) != 0, "illegalOverlapsArgument");
        this.popRowValue();
        this.syntaxStack.push(new DummySearchCondition());
    }

    private final int general_v_term() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_factor();
        block4: while (true) {
            switch (this.LA(1)) {
                case 103: {
                    int etype1 = etype & (TYP_NUM | TYP_INTV);
                    this.checkSql(etype1 != 0, "firstMultDivArgument", "*");
                    this.match(103);
                    int etype2 = this.general_v_factor();
                    etype &= etype2 & TYP_NUM;
                    if ((etype1 & TYP_INTV) != 0 && (etype2 & TYP_NUM) != 0 || (etype1 & TYP_NUM) != 0 && (etype2 & TYP_INTV) != 0) {
                        etype |= TYP_INTV;
                    }
                    this.checkSql(etype != 0, "illegalMultArguments");
                    ValueExpression rhs = this.popValueExpression();
                    ValueExpression lhs = this.popValueExpression();
                    this.syntaxStack.push(new ArithmeticExpression(lhs, 3, rhs));
                    continue block4;
                }
                case 134: {
                    this.checkSql((etype &= TYP_NUM | TYP_INTV) != 0, "firstMultDivArgument", "/");
                    this.match(134);
                    int etype2 = this.general_v_factor();
                    this.checkSql((etype & TYP_NUM) != 0, "illegalDivArgument");
                    ValueExpression rhs = this.popValueExpression();
                    ValueExpression lhs = this.popValueExpression();
                    this.syntaxStack.push(new ArithmeticExpression(lhs, 4, rhs));
                    continue block4;
                }
            }
            break;
        }
        return etype;
    }

    private final int general_v_factor() throws RecognitionException, TokenStreamException {
        int etype;
        switch (this.LA(1)) {
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 127: 
            case 209: 
            case 211: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 225: 
            case 227: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 250: 
            case 265: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 300: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 315: 
            case 317: 
            case 323: 
            case 324: 
            case 326: {
                etype = this.general_v_primary();
                break;
            }
            case 123: 
            case 126: {
                int operator;
                switch (this.LA(1)) {
                    case 126: {
                        this.match(126);
                        operator = 1;
                        break;
                    }
                    case 123: {
                        this.match(123);
                        operator = 2;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                etype = this.general_v_primary();
                etype = (etype & SPECIAL_MASK) == SPECIAL_literal ? (etype &= TYP_NUM | TYP_INTV | SPECIAL_literal) : (etype &= TYP_NUM | TYP_INTV);
                this.checkSql((etype & (TYP_NUM | TYP_INTV)) != 0, "illegalSignedArgument");
                this.syntaxStack.push(new ArithmeticExpression(operator, this.popValueExpression()));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block8 : switch (this.LA(1)) {
            case 221: {
                this.checkSql((etype &= TYP_STR) != 0, "illegalCollateType");
                this.collate_clause();
                etype = TYP_STR;
                break;
            }
            case 208: {
                this.checkESql(false, "noDateTimeAllowed");
                this.checkSql((etype &= TYP_DATE) != 0, "illegalTimezoneType");
                this.match(208);
                switch (this.LA(1)) {
                    case 272: {
                        this.match(272);
                        break block8;
                    }
                    case 309: {
                        this.match(309);
                        this.match(334);
                        int tztype = this.general_v_primary();
                        this.checkSql((tztype & TYP_INTV) != 0, "timezoneArgumentNotInterval");
                        this.syntaxStack.pop();
                        break block8;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 1: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 114: 
            case 115: 
            case 117: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 132: 
            case 134: 
            case 203: 
            case 205: 
            case 210: 
            case 230: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 267: 
            case 268: 
            case 270: 
            case 271: 
            case 274: 
            case 280: 
            case 281: 
            case 286: 
            case 288: 
            case 289: 
            case 291: 
            case 295: 
            case 308: 
            case 319: 
            case 325: 
            case 329: 
            case 330: 
            case 331: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int general_v_primary() throws RecognitionException, TokenStreamException {
        int etype;
        switch (this.LA(1)) {
            case 121: {
                etype = this.general_sub_expression();
                break;
            }
            case 102: 
            case 104: 
            case 105: 
            case 112: 
            case 116: 
            case 118: 
            case 235: 
            case 309: 
            case 310: {
                etype = this.unsigned_literal();
                etype |= SPECIAL_literal;
                break;
            }
            case 265: {
                this.interval_literal();
                etype = TYP_INTV | SPECIAL_literal;
                this.syntaxStack.push(new DummyValueExpression());
                break;
            }
            case 106: 
            case 127: 
            case 234: 
            case 300: 
            case 305: 
            case 324: 
            case 326: {
                etype = this.general_value_specification();
                if ((etype & (TYP_STR | TYP_NUM | TYP_DATE)) == 0) break;
                etype |= SPECIAL_vspec;
                break;
            }
            case 117: 
            case 278: {
                etype = this.column_reference_or_table_name();
                break;
            }
            case 209: 
            case 227: 
            case 275: 
            case 276: 
            case 304: {
                etype = this.set_function_specification();
                break;
            }
            case 215: 
            case 220: 
            case 283: {
                this.case_expression();
                etype = TYP_VAL;
                this.syntaxStack.push(new DummyValueExpression());
                break;
            }
            case 216: {
                this.cast_specification();
                etype = TYP_VAL;
                this.syntaxStack.push(new DummyValueExpression());
                break;
            }
            case 211: 
            case 217: 
            case 219: 
            case 250: 
            case 284: 
            case 293: {
                this.numeric_value_function();
                etype = TYP_NUM;
                this.syntaxStack.push(new DummyValueExpression());
                break;
            }
            case 225: 
            case 273: 
            case 303: 
            case 315: 
            case 317: 
            case 323: {
                etype = this.string_value_function();
                break;
            }
            case 231: 
            case 232: 
            case 233: {
                this.datetime_value_function();
                etype = TYP_DATE;
                this.syntaxStack.push(new DummyValueExpression());
                break;
            }
            case 282: {
                this.match(282);
                etype = TYP_NULL;
                this.syntaxStack.push(new NullValue());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int unsigned_literal() throws RecognitionException, TokenStreamException {
        Token litInt = null;
        Token litExact = null;
        Token litApprox = null;
        Token litChar = null;
        Token litBit = null;
        Token litHex = null;
        Token litDate = null;
        Token litTime = null;
        Token litTimestamp = null;
        int etype = 0;
        switch (this.LA(1)) {
            case 118: {
                litInt = this.LT(1);
                this.match(118);
                etype = TYP_NUM;
                this.syntaxStack.push(new IntegerLiteral(litInt.getText()));
                break;
            }
            case 112: {
                litExact = this.LT(1);
                this.match(112);
                etype = TYP_NUM;
                BigDecimal value = new BigDecimal(litExact.getText());
                this.syntaxStack.push(new BigDecimalLiteral(value));
                break;
            }
            case 102: {
                litApprox = this.LT(1);
                this.match(102);
                etype = TYP_NUM;
                float value = Float.parseFloat(litApprox.getText());
                this.syntaxStack.push(new FloatLiteral(value));
                break;
            }
            case 105: {
                litChar = this.LT(1);
                this.match(105);
                etype = TYP_STR;
                this.syntaxStack.push(new StringLiteral(litChar.getText()));
                break;
            }
            case 104: 
            case 116: 
            case 235: 
            case 309: 
            case 310: {
                block7 : switch (this.LA(1)) {
                    case 104: {
                        litBit = this.LT(1);
                        this.match(104);
                        etype = TYP_STR;
                        this.checkISql(false, "literalBitstringNotAllowed", litBit.getText());
                        break;
                    }
                    case 116: {
                        litHex = this.LT(1);
                        this.match(116);
                        etype = TYP_STR;
                        this.checkISql(false, "literalHexstringNotAllowed", litHex.getText());
                        break;
                    }
                    default: {
                        if ((this.LA(1) == 235 || this.LA(1) == 309 || this.LA(1) == 310) && this.LA(2) == 105) {
                            switch (this.LA(1)) {
                                case 235: {
                                    this.match(235);
                                    litDate = this.LT(1);
                                    this.match(105);
                                    this.checkESql(false, "literalDateNotAllowed", "DATE", litDate.getText());
                                    etype = TYP_DATE;
                                    break block7;
                                }
                                case 309: {
                                    this.match(309);
                                    litTime = this.LT(1);
                                    this.match(105);
                                    this.checkESql(false, "literalTimeNotAllowed", "TIME", litTime.getText());
                                    etype = TYP_DATE;
                                    break block7;
                                }
                                case 310: {
                                    this.match(310);
                                    litTimestamp = this.LT(1);
                                    this.match(105);
                                    this.checkESql(false, "literalTimestampNotAllowed", "TIMESTAMP", litTimestamp.getText());
                                    etype = TYP_DATE;
                                    break block7;
                                }
                            }
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.syntaxStack.push(new DummyValueExpression());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final void interval_literal() throws RecognitionException, TokenStreamException {
        this.checkESql(false, "literalNotAllowed", "Interval");
        this.match(265);
        switch (this.LA(1)) {
            case 126: {
                this.match(126);
                break;
            }
            case 123: {
                this.match(123);
                break;
            }
            case 105: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(105);
        this.interval_qualifier();
    }

    private final int general_value_specification() throws RecognitionException, TokenStreamException {
        int etype = 0;
        block0 : switch (this.LA(1)) {
            case 127: {
                this.match(127);
                this.syntaxStack.push(new HostVariable(++this.hostVarCount));
                switch (this.LA(1)) {
                    case 1: 
                    case 103: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 203: 
                    case 205: 
                    case 208: 
                    case 210: 
                    case 221: 
                    case 230: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 258: 
                    case 260: 
                    case 262: 
                    case 264: 
                    case 267: 
                    case 268: 
                    case 270: 
                    case 271: 
                    case 274: 
                    case 280: 
                    case 281: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 291: 
                    case 295: 
                    case 308: 
                    case 319: 
                    case 325: 
                    case 329: 
                    case 330: 
                    case 331: {
                        etype = TYP_VAL;
                        break block0;
                    }
                    case 236: 
                    case 259: 
                    case 277: 
                    case 279: 
                    case 298: 
                    case 333: {
                        this.interval_qualifier();
                        etype = TYP_INTV;
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 106: 
            case 234: 
            case 300: 
            case 305: 
            case 324: 
            case 326: {
                this.syntaxStack.push(new DummyValueExpression());
                switch (this.LA(1)) {
                    case 106: {
                        this.checkSapSql(false, "noParameters");
                        this.match(106);
                        this.match(117);
                        switch (this.LA(1)) {
                            case 261: {
                                this.match(261);
                                this.match(106);
                                this.match(117);
                                break;
                            }
                            case 106: {
                                this.match(106);
                                this.match(117);
                                break;
                            }
                            case 1: 
                            case 103: 
                            case 107: 
                            case 108: 
                            case 111: 
                            case 114: 
                            case 115: 
                            case 117: 
                            case 120: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 126: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 203: 
                            case 205: 
                            case 208: 
                            case 210: 
                            case 221: 
                            case 230: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 257: 
                            case 258: 
                            case 260: 
                            case 262: 
                            case 264: 
                            case 267: 
                            case 268: 
                            case 270: 
                            case 271: 
                            case 274: 
                            case 280: 
                            case 281: 
                            case 286: 
                            case 288: 
                            case 289: 
                            case 291: 
                            case 295: 
                            case 308: 
                            case 319: 
                            case 325: 
                            case 329: 
                            case 330: 
                            case 331: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        etype = TYP_VAL;
                        break block0;
                    }
                    case 324: {
                        this.checkSapSql(false, "userNotAllowed");
                        this.match(324);
                        etype = TYP_STR;
                        break block0;
                    }
                    case 234: {
                        this.checkESql(false, "notAllowed", "CURRENT_USER");
                        this.match(234);
                        etype = TYP_STR;
                        break block0;
                    }
                    case 300: {
                        this.checkESql(false, "notAllowed", "SESSION_USER");
                        this.match(300);
                        etype = TYP_STR;
                        break block0;
                    }
                    case 305: {
                        this.checkESql(false, "notAllowed", "SYSTEM_USER");
                        this.match(305);
                        etype = TYP_STR;
                        break block0;
                    }
                    case 326: {
                        this.checkESql(false, "notAllowed", "VALUE");
                        this.match(326);
                        etype = TYP_VAL;
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return etype;
    }

    private final int set_function_specification() throws RecognitionException, TokenStreamException {
        boolean isDistinct = false;
        boolean isCountAll = false;
        int functionType = 0;
        int etype = 0;
        switch (this.LA(1)) {
            case 227: {
                this.match(227);
                this.match(121);
                switch (this.LA(1)) {
                    case 103: {
                        this.match(103);
                        isCountAll = true;
                        break;
                    }
                    case 102: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 121: 
                    case 123: 
                    case 126: 
                    case 127: 
                    case 201: 
                    case 209: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 225: 
                    case 227: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 242: 
                    case 250: 
                    case 265: 
                    case 273: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 293: 
                    case 300: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 323: 
                    case 324: 
                    case 326: {
                        switch (this.LA(1)) {
                            case 242: {
                                this.match(242);
                                isDistinct = true;
                                break;
                            }
                            case 201: {
                                this.match(201);
                                break;
                            }
                            case 102: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 112: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 121: 
                            case 123: 
                            case 126: 
                            case 127: 
                            case 209: 
                            case 211: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 219: 
                            case 220: 
                            case 225: 
                            case 227: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 235: 
                            case 250: 
                            case 265: 
                            case 273: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 282: 
                            case 283: 
                            case 284: 
                            case 293: 
                            case 300: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 309: 
                            case 310: 
                            case 315: 
                            case 317: 
                            case 323: 
                            case 324: 
                            case 326: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        this.checkESql(isDistinct, "onlyCountAllowed");
                        etype = this.value_expression_no_query();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(131);
                etype = etype & SPECIAL_MASK | TYP_NUM;
                functionType = 5;
                break;
            }
            case 275: 
            case 276: {
                switch (this.LA(1)) {
                    case 275: {
                        this.match(275);
                        functionType = 3;
                        break;
                    }
                    case 276: {
                        this.match(276);
                        functionType = 2;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(121);
                switch (this.LA(1)) {
                    case 242: {
                        this.match(242);
                        isDistinct = true;
                        break;
                    }
                    case 201: {
                        this.match(201);
                        break;
                    }
                    case 102: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 121: 
                    case 123: 
                    case 126: 
                    case 127: 
                    case 209: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 225: 
                    case 227: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 250: 
                    case 265: 
                    case 273: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 293: 
                    case 300: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 323: 
                    case 324: 
                    case 326: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                etype = this.value_expression_no_query();
                this.match(131);
                break;
            }
            case 209: 
            case 304: {
                switch (this.LA(1)) {
                    case 209: {
                        this.match(209);
                        functionType = 1;
                        break;
                    }
                    case 304: {
                        this.match(304);
                        functionType = 4;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(121);
                switch (this.LA(1)) {
                    case 242: {
                        this.match(242);
                        isDistinct = true;
                        break;
                    }
                    case 201: {
                        this.match(201);
                        break;
                    }
                    case 102: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 121: 
                    case 123: 
                    case 126: 
                    case 127: 
                    case 209: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 225: 
                    case 227: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 250: 
                    case 265: 
                    case 273: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 293: 
                    case 300: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 323: 
                    case 324: 
                    case 326: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                etype = this.value_expression_no_query();
                this.match(131);
                this.checkSql((etype & (TYP_NUM | TYP_INTV)) != 0, "argumentMustBeNumeric");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.checkISql(!isDistinct || (etype & SPECIAL_MASK) == SPECIAL_colref || (etype & SPECIAL_MASK) == SPECIAL_id, "argumentColRefDistinct");
        etype &= TYP_VAL;
        if (isCountAll) {
            this.syntaxStack.push(new CountAll());
        } else {
            ValueExpression argument = this.popValueExpression();
            this.syntaxStack.push(new SetFunction(functionType, isDistinct, argument));
        }
        return etype;
    }

    private final void case_expression() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 283: {
                this.checkESql(false, "notAllowed", "NULLIF");
                this.match(283);
                this.match(121);
                this.value_expression();
                this.match(107);
                this.value_expression();
                this.match(131);
                break;
            }
            case 220: {
                this.checkESql(false, "notAllowed", "COALESCE");
                this.match(220);
                this.match(121);
                this.value_expression();
                int _cnt195 = 0;
                while (true) {
                    if (this.LA(1) != 107) {
                        if (_cnt195 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(107);
                    this.value_expression();
                    ++_cnt195;
                }
                this.match(131);
                break;
            }
            case 215: {
                this.checkESql(false, "notAllowed", "CASE");
                this.match(215);
                block5 : switch (this.LA(1)) {
                    case 102: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 121: 
                    case 123: 
                    case 126: 
                    case 127: 
                    case 209: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 225: 
                    case 227: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 250: 
                    case 265: 
                    case 273: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 293: 
                    case 300: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 323: 
                    case 324: 
                    case 326: {
                        this.value_expression();
                        int _cnt198 = 0;
                        while (true) {
                            if (this.LA(1) != 330) {
                                if (_cnt198 >= 1) break;
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            this.match(330);
                            this.value_expression();
                            this.match(308);
                            this.value_expression_or_null();
                            ++_cnt198;
                        }
                        switch (this.LA(1)) {
                            case 245: {
                                this.match(245);
                                this.value_expression_or_null();
                                break block5;
                            }
                            case 246: {
                                break block5;
                            }
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    case 330: {
                        int _cnt201 = 0;
                        while (true) {
                            if (this.LA(1) != 330) {
                                if (_cnt201 >= 1) break;
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            this.match(330);
                            this.search_condition("argumentWhenBooleanNeeded");
                            this.match(308);
                            this.value_expression_or_null();
                            ++_cnt201;
                        }
                        switch (this.LA(1)) {
                            case 245: {
                                this.match(245);
                                this.value_expression_or_null();
                                break block5;
                            }
                            case 246: {
                                break block5;
                            }
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(246);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void cast_specification() throws RecognitionException, TokenStreamException {
        this.checkESql(false, "functionNotAllowed", "CAST");
        this.match(216);
        this.match(121);
        this.value_expression_or_null();
        this.match(205);
        this.qualified_name();
        this.match(131);
    }

    private final void numeric_value_function() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 293: {
                this.checkISql(false, "functionNotAllowed", "POSITION");
                this.match(293);
                this.match(121);
                this.string_value_expression();
                this.match(260);
                this.string_value_expression();
                this.match(131);
                break;
            }
            case 250: {
                this.checkESql(false, "functionNotAllowed", "EXTRACT");
                this.match(250);
                this.match(121);
                switch (this.LA(1)) {
                    case 333: {
                        this.match(333);
                        break;
                    }
                    case 279: {
                        this.match(279);
                        break;
                    }
                    case 236: {
                        this.match(236);
                        break;
                    }
                    case 259: {
                        this.match(259);
                        break;
                    }
                    case 277: {
                        this.match(277);
                        break;
                    }
                    case 298: {
                        this.match(298);
                        break;
                    }
                    case 311: {
                        this.match(311);
                        break;
                    }
                    case 312: {
                        this.match(312);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(253);
                int etype = this.general_v_expression();
                this.match(131);
                this.checkSql((etype & (TYP_DATE | TYP_INTV)) != 0, "extractSourceNotDateOrInterval");
                break;
            }
            case 217: 
            case 219: 
            case 284: {
                this.checkESql(false, "functionNotAllowed", "LENGTH");
                switch (this.LA(1)) {
                    case 217: {
                        this.match(217);
                        break;
                    }
                    case 219: {
                        this.match(219);
                        break;
                    }
                    case 284: {
                        this.match(284);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(121);
                this.string_value_expression();
                this.match(131);
                break;
            }
            case 211: {
                this.checkISql(false, "functionNotAllowed", "BIT_LENGTH");
                this.match(211);
                this.match(121);
                this.string_value_expression();
                this.match(131);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final int string_value_function() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 303: {
                this.checkESql(false, "functionNotAllowed", "SUBSTRING");
                this.match(303);
                this.match(121);
                this.string_value_expression();
                this.popValueExpression();
                this.match(253);
                this.numeric_value_expression();
                this.popValueExpression();
                switch (this.LA(1)) {
                    case 252: {
                        this.match(252);
                        this.numeric_value_expression();
                        this.popValueExpression();
                        break;
                    }
                    case 131: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(131);
                break;
            }
            case 273: 
            case 323: {
                this.checkISql(false, "functionsNotAllowed", "UPPER", "LOWER");
                switch (this.LA(1)) {
                    case 323: {
                        this.match(323);
                        break;
                    }
                    case 273: {
                        this.match(273);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(121);
                this.string_value_expression();
                this.popValueExpression();
                this.match(131);
                break;
            }
            case 225: 
            case 315: {
                this.checkISql(false, "functionsNotAllowed", "CONVERT", "TRANSLATE");
                switch (this.LA(1)) {
                    case 225: {
                        this.match(225);
                        break;
                    }
                    case 315: {
                        this.match(315);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(121);
                this.string_value_expression();
                this.popValueExpression();
                this.match(325);
                this.qualified_name();
                this.popValueExpression();
                this.match(131);
                break;
            }
            case 317: {
                this.checkESql(false, "functionNotAllowed", "TRIM");
                this.match(317);
                this.match(121);
                block18 : switch (this.LA(1)) {
                    case 212: 
                    case 269: 
                    case 314: {
                        switch (this.LA(1)) {
                            case 269: {
                                this.match(269);
                                break;
                            }
                            case 314: {
                                this.match(314);
                                break;
                            }
                            case 212: {
                                this.match(212);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        switch (this.LA(1)) {
                            case 102: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 112: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 121: 
                            case 123: 
                            case 126: 
                            case 127: 
                            case 209: 
                            case 211: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 219: 
                            case 220: 
                            case 225: 
                            case 227: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 235: 
                            case 250: 
                            case 265: 
                            case 273: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 282: 
                            case 283: 
                            case 284: 
                            case 293: 
                            case 300: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 309: 
                            case 310: 
                            case 315: 
                            case 317: 
                            case 323: 
                            case 324: 
                            case 326: {
                                this.string_value_expression();
                                this.popValueExpression();
                                break;
                            }
                            case 253: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        this.match(253);
                        this.string_value_expression();
                        this.popValueExpression();
                        break;
                    }
                    case 102: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 121: 
                    case 123: 
                    case 126: 
                    case 127: 
                    case 209: 
                    case 211: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 220: 
                    case 225: 
                    case 227: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 250: 
                    case 265: 
                    case 273: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 293: 
                    case 300: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 309: 
                    case 310: 
                    case 315: 
                    case 317: 
                    case 323: 
                    case 324: 
                    case 326: {
                        this.string_value_expression();
                        this.popValueExpression();
                        switch (this.LA(1)) {
                            case 253: {
                                this.match(253);
                                this.string_value_expression();
                                this.popValueExpression();
                                break block18;
                            }
                            case 131: {
                                break block18;
                            }
                        }
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(131);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        int etype = TYP_STR;
        this.syntaxStack.push(new DummyValueExpression());
        return etype;
    }

    private final void datetime_value_function() throws RecognitionException, TokenStreamException {
        block0 : switch (this.LA(1)) {
            case 231: {
                this.checkESql(false, "functionNotAllowed", "CURRENT_DATE");
                this.match(231);
                break;
            }
            case 232: {
                this.checkESql(false, "functionNotAllowed", "CURRENT_TIME");
                this.match(232);
                switch (this.LA(1)) {
                    case 121: {
                        this.checkISql(false, "noPrecisionAllowed", "CURRENT_TIME");
                        this.match(121);
                        this.match(118);
                        this.match(131);
                        break block0;
                    }
                    case 1: 
                    case 103: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 203: 
                    case 205: 
                    case 208: 
                    case 210: 
                    case 221: 
                    case 230: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 258: 
                    case 260: 
                    case 262: 
                    case 264: 
                    case 267: 
                    case 268: 
                    case 270: 
                    case 271: 
                    case 274: 
                    case 280: 
                    case 281: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 291: 
                    case 295: 
                    case 308: 
                    case 319: 
                    case 325: 
                    case 329: 
                    case 330: 
                    case 331: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 233: {
                this.checkESql(false, "functionNotAllowed", "CURRENT_TIMESTAMP");
                this.match(233);
                switch (this.LA(1)) {
                    case 121: {
                        this.checkISql(false, "noPrecisionAllowed", "CURRENT_TIMESTAMP");
                        this.match(121);
                        this.match(118);
                        this.match(131);
                        break block0;
                    }
                    case 1: 
                    case 103: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 203: 
                    case 205: 
                    case 208: 
                    case 210: 
                    case 221: 
                    case 230: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 258: 
                    case 260: 
                    case 262: 
                    case 264: 
                    case 267: 
                    case 268: 
                    case 270: 
                    case 271: 
                    case 274: 
                    case 280: 
                    case 281: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 291: 
                    case 295: 
                    case 308: 
                    case 319: 
                    case 325: 
                    case 329: 
                    case 330: 
                    case 331: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void interval_qualifier() throws RecognitionException, TokenStreamException {
        this.checkESql(false, "noIntervalExpressions");
        boolean withSecond = this.general_datetime_field(true);
        if (this.LA(1) == 313 && !withSecond) {
            this.match(313);
            withSecond = this.general_datetime_field(false);
        } else if (!_tokenSet_13.member(this.LA(1))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    private final boolean general_datetime_field(boolean twoAllowed) throws RecognitionException, TokenStreamException {
        boolean withSecond = false;
        switch (this.LA(1)) {
            case 333: {
                this.match(333);
                break;
            }
            case 279: {
                this.match(279);
                break;
            }
            case 236: {
                this.match(236);
                break;
            }
            case 259: {
                this.match(259);
                break;
            }
            case 277: {
                this.match(277);
                break;
            }
            case 298: {
                this.match(298);
                withSecond = true;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 121: {
                this.match(121);
                this.match(118);
                if (this.LA(1) == 107 && withSecond && twoAllowed) {
                    this.match(107);
                    this.match(118);
                } else if (this.LA(1) != 131) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(131);
                break;
            }
            case 1: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 114: 
            case 115: 
            case 117: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 132: 
            case 134: 
            case 203: 
            case 205: 
            case 208: 
            case 210: 
            case 221: 
            case 230: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 267: 
            case 268: 
            case 270: 
            case 271: 
            case 274: 
            case 280: 
            case 281: 
            case 286: 
            case 288: 
            case 289: 
            case 291: 
            case 295: 
            case 308: 
            case 313: 
            case 319: 
            case 325: 
            case 329: 
            case 330: 
            case 331: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return withSecond;
    }

    private final int value_expression_no_query() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_expression();
        this.checkSql((etype & TYP_VAL) != 0, "argumentMustBeValue");
        this.checkSql((etype & TYP_QUERY) == 0, "argumentMustNotBeQuery");
        return etype;
    }

    private final void value_expression() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_expression();
        this.checkSql((etype & TYP_VAL) != 0, "argumentMustBeValue");
    }

    private final void qualified_name() throws RecognitionException, TokenStreamException {
        int etype = this.column_reference_or_table_name();
        this.checkSql(etype != SPECIAL_qast, "noAsteriskAllowed");
        this.checkSql((etype & TYP_TREF) != 0, "noThreeDotsAllowed");
    }

    private final void string_value_expression() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_expression();
        this.checkSql((etype & TYP_STR) != 0, "argumentMustBeString");
    }

    private final void numeric_value_expression() throws RecognitionException, TokenStreamException {
        int etype = this.general_v_expression();
        this.checkSql((etype & TYP_NUM) != 0, "argumentMustBeNumber");
    }

    private final void hint() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 1001: {
                this.match(1001);
                this.sap_hint();
                break;
            }
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: {
                this.vendor();
                this.match(105);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    private final void sap_hint() throws RecognitionException, TokenStreamException {
        this.match(1008);
        this.match(1009);
        this.syntaxStack.push(hintNoBuffer);
    }

    private final void vendor() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 1002: {
                this.match(1002);
                this.syntaxStack.push(new HintOracle(this.LT(1).getText()));
                break;
            }
            case 1003: {
                this.match(1003);
                this.syntaxStack.push(new HintSapdb(this.LT(1).getText()));
                break;
            }
            case 1004: {
                this.match(1004);
                this.syntaxStack.push(new HintMss(this.LT(1).getText()));
                break;
            }
            case 1005: {
                this.match(1005);
                this.syntaxStack.push(new HintDb2(this.LT(1).getText()));
                break;
            }
            case 1006: {
                this.match(1006);
                this.syntaxStack.push(new HintDb4(this.LT(1).getText()));
                break;
            }
            case 1007: {
                this.match(1007);
                this.syntaxStack.push(new HintDb6(this.LT(1).getText()));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

