/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.UpdateStatement;
import java.util.Vector;

public class ClientVisitor
extends SQLVisitor {
    private Vector errorLog = null;
    private String client = null;
    private QuerySpecification currentQuery = null;

    public ClientVisitor(Vector aErrorlog, String aClient) {
        this.client = aClient;
        this.errorLog = aErrorlog;
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        this.currentQuery = x;
        Query[] fromClause = x.getFromClause();
        int i = 0;
        while (i < fromClause.length) {
            SearchCondition newSearchCon;
            if (fromClause[i] instanceof TableReference && (newSearchCon = this.extendSearchCondition((TableReference)fromClause[i], x.getWhereClause())) != null) {
                x.setWhereClause(newSearchCon);
            }
            ++i;
        }
    }

    public void visitJoinedTable(JoinedTable x) {
        TableReference rightTab;
        TableReference leftTab;
        SearchCondition newSearchCon;
        if (x.getLeftOperand() instanceof TableReference && (newSearchCon = this.extendSearchCondition(leftTab = (TableReference)x.getLeftOperand(), this.currentQuery.getWhereClause())) != null) {
            this.currentQuery.setWhereClause(newSearchCon);
        }
        if ((newSearchCon = this.extendSearchCondition(rightTab = (TableReference)x.getRightOperand(), x.getJoinCondition())) != null) {
            x.setJoinCondition(newSearchCon);
        }
    }

    public void visitInsertStatementBefore(InsertStatement x) {
        TableReference insertTab = x.getTable();
        Table insertTabDescriptor = insertTab.getTableDescriptor();
        if (insertTabDescriptor != null) {
            ColumnReference[] colRefs;
            SelectSublist[] selList;
            Query insertSource = x.getInsertSource();
            if (insertSource instanceof TableValue) {
                if (((TableValue)insertSource).getRowValues()[0] instanceof RowValueElementList) {
                    RowValue[] rowVal = ((TableValue)insertSource).getRowValues();
                    int i = 0;
                    while (i < rowVal.length) {
                        if (rowVal[i] instanceof RowValueElementList) {
                            RowValueElementList rvel = (RowValueElementList)rowVal[i];
                            RowValueElement[] rve = rvel.getValueList();
                            RowValueElement[] newRve = new RowValueElement[rve.length + 1];
                            newRve[0] = new StringLiteral(this.client);
                            int j = 0;
                            while (j < rve.length) {
                                newRve[j + 1] = rve[j];
                                ++j;
                            }
                            rvel.setValueList(newRve);
                        }
                        ++i;
                    }
                } else {
                    RowValueElement[] newRve = new RowValueElement[]{new StringLiteral(this.client), (RowValueElement)((TableValue)insertSource).getRowValues()[0]};
                    RowValueElementList rvel = new RowValueElementList(newRve);
                    ((TableValue)insertSource).setRowValues(rvel);
                }
            }
            if (insertSource instanceof QuerySpecification && (selList = ((QuerySpecification)insertSource).getSelectList()) != null) {
                SelectSublist[] newSelList = new SelectSublist[selList.length + 1];
                newSelList[0] = new SelectSublist(new StringLiteral(this.client));
                int i = 0;
                while (i < selList.length) {
                    newSelList[i + 1] = selList[i];
                    ++i;
                }
                ((QuerySpecification)insertSource).setSelectList(newSelList);
            }
            if ((colRefs = x.getColumnList()) != null) {
                Column clientColDescriptor = insertTabDescriptor.getColumn(1);
                ColumnReference clientCol = new ColumnReference(clientColDescriptor.getName());
                ColumnReference[] newColRefs = new ColumnReference[colRefs.length + 1];
                newColRefs[0] = clientCol;
                int i = 0;
                while (i < colRefs.length) {
                    newColRefs[i + 1] = colRefs[i];
                    ++i;
                }
                x.setColumnList(newColRefs);
            }
        }
    }

    public void visitUpdateStatementBefore(UpdateStatement x) {
        Table updateTabDescriptor;
        TableReference updateTab = x.getTable();
        SearchCondition newSearchCon = this.extendSearchCondition(updateTab, x.getWhereClause());
        if (newSearchCon != null) {
            x.setWhereClause(newSearchCon);
        }
        if ((updateTabDescriptor = updateTab.getTableDescriptor()) != null) {
            Column clientColDescriptor = updateTabDescriptor.getColumn(1);
            String clientCol = clientColDescriptor.getName();
            SetClause[] setClauseList = x.getSetClauseList();
            int i = 0;
            while (i < setClauseList.length) {
                ColumnReference setCol = setClauseList[i].getColumnReference();
                if (clientCol.compareTo(setCol.getColumnName()) == 0) {
                    LogEntry le = new LogEntry(CommonSQLParserErrors.msg("noSetOnClient", clientCol));
                    this.errorLog.add(le);
                }
                ++i;
            }
        }
    }

    public void visitDeleteStatementBefore(DeleteStatement x) {
        SearchCondition newSearchCon = this.extendSearchCondition(x.getTable(), x.getWhereClause());
        if (newSearchCon != null) {
            x.setWhereClause(newSearchCon);
        }
    }

    private SearchCondition extendSearchCondition(TableReference tabRef, SearchCondition SearchCon) {
        SearchCondition newSearchCon = null;
        Table TabDescriptor = tabRef.getTableDescriptor();
        if (TabDescriptor != null) {
            Column clientColDescriptor = TabDescriptor.getColumn(1);
            ColumnReference clientCol = new ColumnReference(tabRef.getAliasName(), clientColDescriptor.getName());
            ComparisonPredicate eqClient = new ComparisonPredicate(clientCol, 1, new StringLiteral(this.client));
            newSearchCon = SearchCon == null ? eqClient : new BooleanAnd(new SearchCondition[]{SearchCon, eqClient});
        }
        return newSearchCon;
    }
}

