/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SetFunction;
import java.util.Vector;

public class CheckSetFunctionVisitor
extends CheckVisitor {
    private boolean checked = false;
    private boolean inSetFunction = false;

    public CheckSetFunctionVisitor(Vector errorLog) {
        super(errorLog);
    }

    private void logError(String key) {
        String txt = CommonSQLParserErrors.msg(key);
        this.errorLog.add(new LogEntry(txt, 0, 0));
    }

    public void visitQuerySpecification(QuerySpecification aQuery) {
        this.checked = true;
        if (this.inSetFunction) {
            this.logError("subqueryInSetFunction");
        }
    }

    public void visitSetFunctionBefore(SetFunction aSetFunction) {
        if (this.inSetFunction) {
            this.logError("setFunctionInSetFunction");
        }
        this.inSetFunction = true;
    }

    public void visitSetFunction(SetFunction aSetFunction) {
        this.inSetFunction = false;
    }

    public void visitCountAll(CountAll notUsed) {
        if (this.inSetFunction) {
            this.logError("countAllInSetFunction");
        }
    }
}

