/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.TableReference;
import java.util.ArrayList;
import java.util.Vector;

public class CheckSelForUpdVisitor
extends CheckVisitor {
    TableReference tableForUpd = null;
    ArrayList eqCols = null;
    char stmtKind = (char)63;

    public CheckSelForUpdVisitor(Vector errorLog) throws CommonSQLParserException {
        super(errorLog);
    }

    public void visitSelectForUpdateBefore(SelectForUpdateStatement x) {
        this.stmtKind = (char)102;
        this.tableForUpd = x.getFromClause();
        if (x.getWhereClause() != null) {
            SearchCondition sc = x.getWhereClause();
            eqColFinder ecf = new eqColFinder();
            sc.accept(ecf);
            this.eqCols = ecf.getEqCols();
            Object var3_3 = null;
        }
    }

    public void dumpLists() {
        if (this.eqCols != null) {
            int j = 0;
            while (j < this.eqCols.size()) {
                System.out.println(((ColumnReference)this.eqCols.get(j)).getColumnName());
                ++j;
            }
        }
        if (this.tableForUpd != null) {
            System.out.println(this.tableForUpd.getTableName());
        }
    }

    public void performChecks() {
        if (this.stmtKind == 'f') {
            this.checkPrimaryKey();
        }
    }

    private void checkPrimaryKey() {
        Table tab = this.tableForUpd.getTableDescriptor();
        if (tab != null) {
            int keyCnt = tab.getPrimaryKeyCnt();
            if (keyCnt > 0) {
                if (this.eqCols != null) {
                    int i = 1;
                    while (i <= keyCnt) {
                        boolean found = false;
                        Column keyCol = tab.getPrimaryKeyColumn(i);
                        int j = 0;
                        while (j < this.eqCols.size()) {
                            ColumnReference eqCol = (ColumnReference)this.eqCols.get(j);
                            if (keyCol.getName().compareTo(eqCol.getColumnName()) == 0) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            this.println("notPrimaryKey", null, 1);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.println("notPrimaryKey", null, 1);
                }
            } else {
                this.println("tabWithoutKey", null, 1);
            }
        }
    }

    private void println(String line, int mode) {
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                LogEntry le = new LogEntry(line);
                this.errorLog.add(le);
                break;
            }
            case 2: {
                break;
            }
            default: {
                System.out.println("Unknown PrintMode");
            }
        }
    }

    private void println(String key, String f0, int mode) {
        if (f0 != null) {
            this.println(CommonSQLParserErrors.msg(key, f0), mode);
        } else {
            this.println(CommonSQLParserErrors.msg(key), mode);
        }
    }

    class eqColFinder
    extends SQLVisitor {
        private int inSubQ = 0;
        private boolean inEq = false;
        private boolean foundOr = false;
        private boolean foundNot = false;
        private ArrayList eqCols = new ArrayList();

        eqColFinder() {
        }

        public void visitQuerySpecificationBefore(QuerySpecification x) {
            ++this.inSubQ;
        }

        public void visitQuerySpecification(QuerySpecification x) {
            --this.inSubQ;
        }

        public void visitColumnReferenceBefore(ColumnReference x) {
            if (this.inEq && this.inSubQ == 0) {
                this.eqCols.add(x);
            }
        }

        public void visitComparisonPredicateBefore(ComparisonPredicate x) {
            if (x.getOperator() == 1) {
                this.inEq = true;
            }
        }

        public void visitComparisonPredicate(ComparisonPredicate x) {
            if (x.getOperator() == 1) {
                this.inEq = false;
            }
        }

        public void visitBooleanOrBefore(BooleanOr x) {
            if (this.inSubQ == 0) {
                this.foundOr = true;
            }
        }

        public void visitBooleanNotBefore(BooleanNot x) {
            if (this.inSubQ == 0) {
                this.foundNot = true;
            }
        }

        public ArrayList getEqCols() {
            if (this.foundOr || this.foundNot) {
                return null;
            }
            return this.eqCols;
        }
    }
}

