/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import java.util.Stack;
import java.util.Vector;

public class CheckHostVariableVisitor
extends CheckVisitor {
    private Stack stack = new Stack();
    int hostVarCount = 0;

    public CheckHostVariableVisitor(Vector errorLog) {
        super(errorLog);
    }

    private void logError(String key) {
        String txt = CommonSQLParserErrors.msg(key);
        this.errorLog.add(new LogEntry(txt, 0, 0));
    }

    private final void pushCount() {
        this.stack.push(new Integer(this.hostVarCount));
        this.hostVarCount = 0;
    }

    private final void popCount() {
        this.hostVarCount = (Integer)this.stack.pop();
    }

    public void visitArithmeticExpressionBefore(ArithmeticExpression x) {
        this.pushCount();
    }

    public void visitArithmeticExpression(ArithmeticExpression x) {
        if (this.hostVarCount > 0) {
            this.logError("hostVarArithmeticNotAllowed");
        }
        this.popCount();
    }

    public void visitBetweenPredicate(BetweenPredicate x) {
        if (this.hostVarCount > 0) {
            if (x.getValue() instanceof HostVariable) {
                this.logError("hostVarBetweenNotAllowed");
            }
            this.hostVarCount = 0;
        }
    }

    public void visitComparisonPredicate(ComparisonPredicate x) {
        if (this.hostVarCount > 0) {
            if (x.getLeftOperand() instanceof HostVariable) {
                this.logError("hostVarComparisonLeftNotAllowed");
            }
            this.hostVarCount = 0;
        }
    }

    public void visitConcatenationExpression(ConcatenationExpression x) {
        if (this.hostVarCount > 0) {
            this.logError("hostVarConcatNotAllowed");
            this.hostVarCount = 0;
        }
    }

    public void visitHostVariable(HostVariable x) {
        ++this.hostVarCount;
    }

    public void visitInListPredicate(InListPredicate x) {
        if (this.hostVarCount > 0) {
            if (x.getValue() instanceof HostVariable) {
                this.logError("hostVarInNotAllowed");
            }
            this.hostVarCount = 0;
        }
    }

    public void visitInSubqueryPredicate(InSubqueryPredicate x) {
        if (this.hostVarCount > 0) {
            if (x.getValue() instanceof HostVariable) {
                this.logError("hostVarInNotAllowed");
            }
            this.hostVarCount = 0;
        }
    }

    public void visitLikePredicate(LikePredicate x) {
        if (this.hostVarCount > 0) {
            if (x.getMatchValue() instanceof HostVariable) {
                this.logError("hostVarLikeNotAllowed");
            }
            this.hostVarCount = 0;
        }
    }

    public void visitNullPredicate(NullPredicate x) {
        if (this.hostVarCount > 0) {
            this.logError("hostVarIsNullNotAllowed");
            this.hostVarCount = 0;
        }
    }

    public void visitQuantifiedComparisonPredicate(QuantifiedComparisonPredicate x) {
        if (this.hostVarCount > 0) {
            if (x.getValue() instanceof HostVariable) {
                this.logError("hostVarComparisonLeftNotAllowed");
            }
            this.hostVarCount = 0;
        }
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        this.pushCount();
    }

    public void visitQuerySpecification(QuerySpecification x) {
        if (this.hostVarCount > 0) {
            this.logError("unknownHostVarLocation");
            this.hostVarCount = 0;
        }
        this.popCount();
    }

    public void visitSelectSublist(SelectSublist x) {
        if (this.hostVarCount > 0) {
            this.logError("hostVarSelectListNotAllowed");
            this.hostVarCount = 0;
        }
    }

    public void visitSetClause(SetClause x) {
        this.hostVarCount = 0;
    }

    public void visitSetFunction(SetFunction x) {
        if (this.hostVarCount > 0) {
            this.logError("hostVarSetFunctionNotAllowed");
            this.hostVarCount = 0;
        }
    }
}

