/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.CreateViewStatement;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.UpdateStatement;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class CheckColAndTabVisitor
extends CheckVisitor {
    private CreateViewStatement createViewStatement = null;
    private static final Location trace = Location.getLocation((Class)(class$com$sap$sql$sqlparser$CheckColAndTabVisitor == null ? (class$com$sap$sql$sqlparser$CheckColAndTabVisitor = CheckColAndTabVisitor.class$("com.sap.sql.sqlparser.CheckColAndTabVisitor")) : class$com$sap$sql$sqlparser$CheckColAndTabVisitor));
    private ArrayList querys = new ArrayList();
    private ArrayList setCols = new ArrayList();
    private String dmlTabName = null;
    private int subQuery = 0;
    private boolean selectAsterisk = false;
    private boolean debug = false;
    private CatalogReader reader = null;
    private ColumnReference[] forUpdCols = null;
    static /* synthetic */ Class class$com$sap$sql$sqlparser$CheckColAndTabVisitor;

    public CheckColAndTabVisitor(Vector errorLog, CatalogReader aReader) {
        super(errorLog);
        this.reader = aReader;
        if (this.reader == null) {
            throw new IllegalArgumentException("No CatalogReader specified");
        }
        this.debug = trace.beDebug();
        if (this.debug) {
            trace.debugT("using reader:" + this.reader.toString());
        }
        this.querys.add(this.subQuery, new QuDes(null));
    }

    public void visitColumnReference(ColumnReference x) {
        ((QuDes)this.querys.get((int)this.subQuery)).collist.add(x);
    }

    public void visitTableReference(TableReference x) {
        ((QuDes)this.querys.get((int)this.subQuery)).tablist.add(x);
    }

    public void visitSelectForUpdateBefore(SelectForUpdateStatement x) {
        this.forUpdCols = x.getUpdateFieldList();
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        QuDes pa = (QuDes)this.querys.get(this.subQuery);
        ++this.subQuery;
        this.querys.add(this.subQuery, new QuDes(pa));
        if (this.subQuery == 1 && x.getSelectList() == null) {
            this.selectAsterisk = true;
        }
        if (this.forUpdCols != null) {
            int i = 0;
            while (i < this.forUpdCols.length) {
                ((QuDes)this.querys.get((int)this.subQuery)).collist.add(this.forUpdCols[i]);
                ++i;
            }
            this.forUpdCols = null;
        }
    }

    public void visitQuerySpecification(QuerySpecification x) {
        --this.subQuery;
    }

    public void visitInsertStatement(InsertStatement x) {
        this.dmlTabName = x.getTable().getTableName();
    }

    public void visitUpdateStatement(UpdateStatement x) {
        this.dmlTabName = x.getTable().getTableName();
    }

    public void visitDeleteStatement(DeleteStatement x) {
        this.dmlTabName = x.getTable().getTableName();
    }

    public void visitSetClause(SetClause x) {
        this.setCols.add(x.getColumnReference());
    }

    public void visitCreateViewStatement(CreateViewStatement x) {
        this.createViewStatement = x;
    }

    private void checkCreateView() throws SQLException {
        if (this.createViewStatement != null) {
            String viewName;
            this.dmlTabName = viewName = this.createViewStatement.getName();
            if (this.reader.existsTable(viewName)) {
                this.println("tabExists", viewName, 1);
            }
        }
    }

    public void performCatalogChecks() throws SQLException {
        int i = 0;
        while (i < this.querys.size()) {
            if (!this.checkTabs(i)) break;
            this.checkCols(i);
            ++i;
        }
        if (i == this.querys.size()) {
            this.checkDmlScope();
        }
        this.checkCreateView();
    }

    private void println(String line, int mode) {
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                LogEntry le = new LogEntry(line);
                this.errorLog.add(le);
                break;
            }
            case 2: {
                System.out.println("INFO : " + line);
                break;
            }
            default: {
                System.out.println("Unknown PrintMode");
            }
        }
    }

    private void println(String key, String f0, int mode) {
        if (f0 != null) {
            this.println(CommonSQLParserErrors.msg(key, f0), mode);
        } else {
            this.println(CommonSQLParserErrors.msg(key), mode);
        }
    }

    private boolean checkTabs(int quNu) throws SQLException {
        trace.entering("checkTabs");
        QuDes quDes = (QuDes)this.querys.get(quNu);
        ArrayList tabList = quDes.tablist;
        int i = 0;
        while (i < tabList.size()) {
            String ali = ((TableReference)tabList.get(i)).getAliasName();
            String tab = ((TableReference)tabList.get(i)).getTableName();
            if (this.debug) {
                trace.debugT("table:" + tab + ":alias:" + ali + ":scope:" + quNu);
            }
            if (quDes.aliaslookup.containsKey(ali)) {
                this.println("tabNotUni", ali, 1);
            } else if (quNu == 0 && this.getStatementType() != 2) {
                quDes.aliaslookup.put(tab, tab);
            } else {
                quDes.aliaslookup.put(ali, tab);
            }
            Table cattab = null;
            try {
                cattab = this.reader.getTable(tab);
            }
            catch (SQLException ex) {
                if (this.debug) {
                    trace.debugT(this.reader.toString() + ":thrown:" + ex.getMessage() + ":table:" + tab);
                }
                trace.exiting();
                throw ex;
            }
            if (cattab == null) {
                this.println("tabNotInDB", tab, 1);
                trace.exiting();
                return false;
            }
            quDes.cattablist.add(cattab);
            ((TableReference)tabList.get(i)).setTableDescriptor(cattab);
            ++i;
        }
        if (this.dmlTabName != null) {
            switch (this.getStatementType()) {
                case 4: 
                case 8: 
                case 16: {
                    Set set;
                    if (this.isUpdateable(this.dmlTabName)) {
                        set = this.getLeafUnderlyingTableNames(this.dmlTabName);
                        String underlyingDmlTabName = (String)set.iterator().next();
                        int i2 = 0;
                        while (i2 < tabList.size()) {
                            String tab = ((TableReference)tabList.get(i2)).getTableName();
                            if (this.debug) {
                                trace.debugT("table:" + tab + ":scope:" + quNu);
                            }
                            if (quDes.parent != null && (set = this.getLeafUnderlyingTableNames(tab)).contains(underlyingDmlTabName)) {
                                this.println("corrTab", tab, 1);
                            }
                            ++i2;
                        }
                        break;
                    }
                    this.println("dmlReadOnly", this.dmlTabName, 1);
                    break;
                }
                case 256: {
                    Set set;
                    int i3 = 0;
                    while (i3 < tabList.size()) {
                        String tab = ((TableReference)tabList.get(i3)).getTableName();
                        if (this.debug) {
                            trace.debugT("table:" + tab + ":scope:" + quNu);
                        }
                        if ((set = this.getLeafUnderlyingTableNames(tab)).contains(this.dmlTabName)) {
                            this.println("corrView", tab, 1);
                        }
                        ++i3;
                    }
                    break;
                }
            }
        }
        trace.exiting();
        return true;
    }

    private int checkCols(int quNu) {
        trace.entering("checkCols");
        if (quNu == 0 && (this.getStatementType() == 2 || this.getStatementType() == 32)) {
            trace.exiting();
            return 1;
        }
        ArrayList colList = ((QuDes)this.querys.get((int)quNu)).collist;
        int i = 0;
        while (i < colList.size()) {
            ColumnReference colRef = (ColumnReference)colList.get(i);
            QuDes scope = (QuDes)this.querys.get(quNu);
            String quali = colRef.getTableName();
            if (quali != null) {
                this.checkQualiCol(scope, colRef);
            } else {
                this.checkNonQualiCol(scope, colRef);
            }
            ++i;
        }
        trace.exiting();
        return 0;
    }

    private void checkQualiCol(QuDes scope, ColumnReference colRef) {
        trace.entering("checkQualiCol");
        int colFoundCount = 0;
        String colName = colRef.getColumnName();
        String quali = colRef.getTableName();
        while (scope != null) {
            String tableName = (String)scope.aliaslookup.get(quali);
            if (tableName == null) {
                scope = scope.parent;
            } else {
                int j = 0;
                while (j < scope.cattablist.size()) {
                    Column colu;
                    Table cattab = (Table)scope.cattablist.get(j);
                    if (tableName.compareTo(cattab.getName()) == 0 && (colu = cattab.getColumn(colName)) != null) {
                        ++colFoundCount;
                        colRef.setColumnDescriptor(colu);
                        if (this.debug) {
                            trace.debugT("found col " + colName + " in " + tableName);
                        }
                        scope = null;
                        break;
                    }
                    ++j;
                }
                if (colFoundCount == 0) {
                    scope = scope.parent;
                    if (this.debug) {
                        trace.debugT(colName + " not in " + tableName);
                    }
                }
            }
            if (scope != null || colFoundCount != 0) continue;
            this.println("colNotInAny", quali + "." + colName, 1);
        }
        trace.exiting();
    }

    private void checkNonQualiCol(QuDes scope, ColumnReference colRef) {
        trace.entering("checkNonQualiCol");
        int colFoundCount = 0;
        String colName = colRef.getColumnName();
        while (scope != null) {
            int j = 0;
            while (j < scope.cattablist.size()) {
                Table cattab = null;
                cattab = (Table)scope.cattablist.get(j);
                Column colu = cattab.getColumn(colName);
                if (colu != null) {
                    ++colFoundCount;
                    colRef.setColumnDescriptor(colu);
                    if (this.debug) {
                        trace.debugT("found col " + colName + " in " + cattab.getName());
                    }
                } else if (this.debug) {
                    trace.debugT(colName + " not in " + cattab.getName());
                }
                ++j;
            }
            if (colFoundCount == 0) {
                scope = scope.parent;
                continue;
            }
            if (colFoundCount == 1) {
                scope = null;
                continue;
            }
            if (colFoundCount <= true) continue;
            this.println("colNotUni", colName, 1);
            scope = null;
        }
        if (colFoundCount == 0) {
            this.println("colNotInAny", colName, 1);
        }
        trace.exiting();
    }

    private void checkDmlScope() {
        trace.entering("checkDmlScope");
        if (this.dmlTabName != null) {
            switch (this.getStatementType()) {
                case 4: {
                    ArrayList colList = ((QuDes)this.querys.get((int)0)).collist;
                    HashSet<String> hSet = new HashSet<String>();
                    int i = 0;
                    while (i < colList.size()) {
                        String colName = ((ColumnReference)colList.get(i)).getColumnName();
                        if (!hSet.add(colName)) {
                            this.println("colNotUni", colName, 1);
                        }
                        ++i;
                    }
                    break;
                }
                case 8: {
                    HashSet<String> hSet = new HashSet<String>();
                    int i = 0;
                    while (i < this.setCols.size()) {
                        String colName = ((ColumnReference)this.setCols.get(i)).getColumnName();
                        if (!hSet.add(colName)) {
                            this.println("colNotUni", colName, 1);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        trace.exiting();
    }

    public boolean isSelectAsterisk() {
        return this.selectAsterisk;
    }

    private boolean isUpdateable(String tableName) {
        return true;
    }

    private Set getLeafUnderlyingTableNames(String tableName) {
        HashSet<String> set = new HashSet<String>();
        set.add(tableName);
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class QuDes {
        QuDes parent;
        ArrayList collist = new ArrayList();
        ArrayList tablist = new ArrayList();
        ArrayList cattablist = new ArrayList();
        HashMap aliaslookup = new HashMap();

        QuDes(QuDes pa) {
            this.parent = pa;
        }
    }
}

