/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.util;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.ClassNameResolverWrapper;
import com.sap.sql.sqlj.util.NestedClassResolver;
import java.util.Vector;

public class BlockClassResolver
extends ClassNameResolverWrapper {
    private BlockInfo m_info;
    private Snapshot m_snapshot = null;
    private Vector m_classes = new Vector();

    public ClassNameResolver getSnapshot() {
        if (this.m_snapshot == null) {
            this.m_snapshot = new Snapshot(this.m_classes.size());
        }
        return this.m_snapshot;
    }

    ClassNameResolver getWindow() {
        this.m_snapshot = null;
        return new Window(this.m_classes.size());
    }

    public static BlockClassResolver newInstance(ClassNameResolver base) {
        if (base instanceof BlockClassResolver) {
            return new BlockClassResolver((BlockClassResolver)base);
        }
        if (base instanceof NestedClassResolver) {
            return new BlockClassResolver((NestedClassResolver)base);
        }
        throw new IllegalArgumentException("unknown resolver type " + base);
    }

    public BlockClassResolver(BlockClassResolver base) {
        super(base.getSnapshot());
        this.m_info = base.m_info;
    }

    public BlockClassResolver(NestedClassResolver base) {
        super(base);
        this.m_info = new BlockInfo(base);
    }

    private BaseJSClass lookupClass(String name, int maxClasses) {
        int i = 0;
        while (i < maxClasses) {
            BaseJSClass cls = (BaseJSClass)this.m_classes.elementAt(i);
            if (cls.getName().equals(name)) {
                return cls;
            }
            ++i;
        }
        return null;
    }

    private int addClass(BaseJSClass cls, int curClassCount) {
        if (curClassCount != this.m_classes.size()) {
            throw new IllegalArgumentException("illegal call to addClass");
        }
        if (!cls.getName().startsWith(this.m_info.m_enclosingClass)) {
            throw new IllegalArgumentException("illegal class name");
        }
        this.m_classes.addElement(cls);
        return curClassCount + 1;
    }

    class Window
    extends Snapshot {
        Window(int classNum) {
            super(classNum);
        }

        public void addClass(BaseJSClass cls) {
            if (this.isLoadedClass(cls.getName())) {
                throw new ClassCircularityError(cls.getName());
            }
            this.m_classNum = BlockClassResolver.this.addClass(cls, this.m_classNum);
        }
    }

    private class Snapshot
    extends ClassNameResolverWrapper {
        int m_classNum;

        public Snapshot(int classNum) {
            super(BlockClassResolver.this.m_base);
            this.m_classNum = classNum;
        }

        public BaseJSClass getClass(String name) throws ClassNotFoundException {
            BaseJSClass result = this.getArray(name);
            if (result != null) {
                return result;
            }
            result = BlockClassResolver.this.lookupClass(name, this.m_classNum);
            if (result != null) {
                return result;
            }
            result = BlockClassResolver.this.lookupClass(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClass + name.replace('.', '$'), this.m_classNum);
            if (result != null) {
                return result;
            }
            return this.m_base.getClass(name);
        }

        public BaseJSClass getQualifiedClass(String name) {
            BaseJSClass result = BlockClassResolver.this.lookupClass(name, this.m_classNum);
            if (result != null) {
                return result;
            }
            return this.m_base.getQualifiedClass(name);
        }

        public String getShortName(BaseJSClass cls) {
            if (cls.getName().startsWith(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClass)) {
                return cls.getName().substring(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClassLen);
            }
            return this.m_base.getShortName(cls);
        }

        public StringBuffer getClassQualification() {
            return new StringBuffer(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClass);
        }

        public boolean isLoadedClass(String className) {
            return BlockClassResolver.this.lookupClass(className, this.m_classNum) != null || this.m_base.isLoadedClass(className);
        }

        public void addClass(BaseJSClass cls) {
            throw new IllegalArgumentException("can't add classes to snapshot");
        }
    }

    private static class BlockInfo {
        String m_enclosingClass;
        int m_enclosingClassLen;

        BlockInfo(NestedClassResolver base) {
            this.m_enclosingClass = base.getClassQualification().append(base.newBlockCount()).append("$").toString();
            this.m_enclosingClassLen = this.m_enclosingClass.length();
        }
    }
}

