/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.tools;

import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.OptionGroup;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.framework.options.PropertyListImpl;
import com.sap.sql.sqlj.mesg.OptionDesc;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.runtime.profile.util.CustomizerHarness;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.tools.ClassMapper;
import com.sap.sql.sqlj.tools.LogMapper;
import com.sap.sql.sqlj.tools.SqljOptions;
import com.sap.sql.sqlj.translator.Main;
import com.sap.sql.sqlj.util.Disposable;
import com.sap.sql.sqlj.util.ParseException;
import com.sap.sql.sqlj.util.io.ErrorLogger;
import com.sap.sql.sqlj.util.io.SapOutputStreamWriter;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Sqlj {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$tools$Sqlj == null ? (class$com$sap$sql$sqlj$tools$Sqlj = Sqlj.class$("com.sap.sql.sqlj.tools.Sqlj")) : class$com$sap$sql$sqlj$tools$Sqlj));
    private static final String[] booleanOptions = new String[]{"help", "version", "compile", "profile", "status", "linemap", "compiler-encoding-flag", "compiler-pipe-output-flag", "force"};
    private static final String[] otherOptions = new String[]{"props", "encoding", "d", "default-customizer", "compiler-executable", "compiler-output-file"};
    private ErrorLogger log;
    private Main theMain;
    private OptionGroup options;
    private PrintWriter errorStream;
    private PrintWriter statusStream;
    private SqljOptions frontEndOptions;
    private String passfile = null;
    private boolean isPass1 = false;
    private boolean isPass2 = false;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_TRANSLATE_ERROR = 1;
    public static final int STATUS_COMPILE_ERROR = 2;
    public static final int STATUS_CUSTOMIZE_ERROR = 3;
    public static final int STATUS_INSTRUMENT_ERROR = 4;
    public static final int STATUS_CALL_JAVA_COMPILE = 90;
    public static final int STATUS_CALL_SER2CLASS_COMPILE = 91;
    private boolean translationSuccessful = false;
    private boolean compilationSuccessful = false;
    private boolean customizationSuccessful = false;
    private boolean instrumentationSuccessful = false;
    private Boolean m_compile_files = null;
    private Boolean m_profile_files = null;
    private Boolean m_sqlj_files = null;
    private Vector files = new Vector();
    private boolean m_wantsHelp = false;
    private boolean m_wantsShortcutHelp = false;
    private boolean m_wantsLongHelp = false;
    private boolean m_wantsVersion = false;
    private boolean m_wantsProfileHelp = false;
    private boolean m_wantsCompileHelp = false;
    private PropertyListImpl compileOptions;
    private PropertyListImpl profileOptions;
    private static final boolean FORCE_FILE_FOUND = true;
    private final String COMMAND_LINE = OptionDesc.command_line();
    private static final String PROPERTY_FILE = "sqlj.properties";
    private static final String SQLJ_PROP_PREFIX = "sqlj.";
    private static final String COMPILE_PROP_PREFIX = "compile.";
    private static final String PROFILE_PROP_PREFIX = "profile.";
    private String[] prefixes = new String[]{"sqlj.", "compile.", "profile."};
    private int[] prefixes_len = new int[]{"sqlj.".length(), "compile.".length(), "profile.".length()};
    private Boolean noValue = new Boolean(false);
    static /* synthetic */ Class class$com$sap$sql$sqlj$tools$Sqlj;

    public static void main(String[] args) {
        boolean noexit = false;
        ArrayList<String> newArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].compareTo("-noexit") == 0) {
                noexit = true;
            } else {
                newArgs.add(args[i]);
            }
            ++i;
        }
        if (noexit) {
            String[] ref = new String[args.length - 1];
            newArgs.toArray(ref);
            new Sqlj().statusMain(ref);
        } else {
            System.exit(new Sqlj().statusMain(args));
        }
    }

    public int statusMain(String[] args) {
        if (args.length >= 1 && (args[0].startsWith("-pass1=") || args[0].startsWith("-pass2=") || args[0].startsWith("-fail2="))) {
            this.passfile = args[0].substring(7);
            if (args[0].startsWith("-pass1=")) {
                this.isPass1 = true;
                String[] tmp = new String[args.length - 1];
                int i = 1;
                while (i < args.length) {
                    tmp[i - 1] = args[i];
                    ++i;
                }
                args = tmp;
            } else {
                this.isPass2 = true;
                this.translationSuccessful = true;
                this.compilationSuccessful = args[0].startsWith("-pass2=");
                args = this.restoreState(this.passfile);
            }
        }
        this.initializeErrors();
        SemanticAnalyzerFactory.captureInterestingOptions();
        try {
            Object var6_16;
            try {
                try {
                    this.processOptions(args);
                    if (!this.isPass2) {
                        if (!this.hasProfileFiles()) {
                            if (!this.wantsInfo()) {
                                if (this.hasSqljFiles()) {
                                    if (this.frontEndOptions.getBoolean("status")) {
                                        this.statusStream.println(TranslatorErrors.translatingFiles(this.files.size()));
                                    }
                                    this.theMain.runTranslation(this.files);
                                } else {
                                    int i = 0;
                                    while (i < this.files.size()) {
                                        String file = (String)this.files.elementAt(i);
                                        if (!file.endsWith(".java")) {
                                            this.log.addEntry(new JSError(TranslatorErrors.illegal_input_extension(file)));
                                        }
                                        ++i;
                                    }
                                }
                            }
                        } else if (this.hasCompileFiles()) {
                            this.log.addEntry(new JSError(TranslatorErrors.eitherSourceOrSer()));
                        }
                    }
                }
                catch (InvalidOptionException e) {
                    LOCATION.catching((Throwable)e);
                }
                catch (ParseException e) {
                    LOCATION.catching((Throwable)e);
                }
                catch (IOException e) {
                    LOCATION.catching((Throwable)e);
                }
                var6_16 = null;
                this.finishTranslation();
            }
            catch (Throwable e) {
                LOCATION.catching(e);
                this.errorStream.println(TranslatorErrors.unexpected_error());
                this.log.addEntry(new JSError(TranslatorErrors.exceptionCaught(e.toString())));
                var6_16 = null;
                this.finishTranslation();
            }
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            this.finishTranslation();
            throw throwable;
        }
        try {
            if (this.isPass2) {
                this.runPostCompilation();
            } else if (this.m_wantsCompileHelp) {
                this.runCompilation(new String[]{"-help"}, args);
            } else if (this.translationSuccessful && this.frontEndOptions.getBoolean("compile") && this.hasCompileFiles() && !this.wantsInfo()) {
                this.runCompilation(this.sqlj2java(this.files), args);
            }
            if (this.isPass1 && this.frontEndOptions.getBoolean("compile") && this.hasCompileFiles()) {
                if (this.translationSuccessful) {
                    return 90;
                }
                File runline = new File(this.passfile + ".run");
                try {
                    runline.delete();
                }
                catch (SecurityException exn) {
                    LOCATION.catching((Throwable)exn);
                }
                return 1;
            }
            if (this.m_wantsProfileHelp) {
                this.customizationSuccessful = this.runProfileCustomization(new String[]{"-help"});
            } else if (this.hasProfileFiles()) {
                Object[] pfiles = new String[this.files.size()];
                this.files.copyInto(pfiles);
                this.customizationSuccessful = this.runProfileCustomization((String[])pfiles);
            } else {
                this.customizationSuccessful = this.frontEndOptions.getBoolean("profile") && this.hasCompileFiles() ? this.runProfileCustomization(null) : true;
            }
            if (this.frontEndOptions.getBoolean("linemap") && this.hasCompileFiles() && (!this.frontEndOptions.getBoolean("compile") || this.compilationSuccessful)) {
                if (!this.frontEndOptions.getBoolean("compile")) {
                    Main.classFilesTable = new Hashtable();
                    Enumeration e = this.files.elements();
                    while (e.hasMoreElements()) {
                        String f = (String)e.nextElement();
                        if (!f.endsWith(".java") && !f.endsWith(".sqlj")) continue;
                        f = f.substring(0, f.length() - 5);
                        Main.classFilesTable.put(f + ".java", f + ".class");
                    }
                }
                this.instrumentationSuccessful = this.runClassInstrumentation();
            } else {
                this.instrumentationSuccessful = true;
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "", (Throwable)e);
        }
        if (this.hasCompileFiles()) {
            if (!this.translationSuccessful) {
                return 1;
            }
            if (!this.compilationSuccessful && this.frontEndOptions.getBoolean("compile")) {
                return 2;
            }
        }
        if (!this.customizationSuccessful) {
            return 3;
        }
        if (!this.instrumentationSuccessful) {
            return 4;
        }
        if (this.m_wantsHelp && this.files.size() == 0) {
            return 1;
        }
        return 0;
    }

    private void initializeErrors() {
        this.log = new ErrorLogger();
        this.errorStream = null;
        this.statusStream = null;
        try {
            this.statusStream = this.errorStream = new PrintWriter((Writer)new SapOutputStreamWriter(System.out), true);
        }
        catch (UnsupportedEncodingException exn) {
            LOCATION.catching((Throwable)exn);
            this.log.addEntry(new JSError(TranslatorErrors.unsupported_file_encoding(System.getProperty("file.encoding", "null"))));
            this.errorStream = new PrintWriter(System.out, true);
            this.statusStream = new PrintWriter(System.err, true);
        }
        catch (Exception exn) {
            LOCATION.catching((Throwable)exn);
            this.errorStream = new PrintWriter(System.out, true);
            this.statusStream = new PrintWriter(System.out, true);
        }
    }

    private void processOptions(String[] args) throws InvalidOptionException {
        this.options = new OptionGroup();
        String[] opts = new String[booleanOptions.length + otherOptions.length];
        int i = 0;
        while (i < booleanOptions.length) {
            opts[i] = booleanOptions[i];
            ++i;
        }
        int j = 0;
        int i2 = booleanOptions.length;
        while (j < otherOptions.length) {
            opts[i2] = otherOptions[j];
            ++j;
            ++i2;
        }
        this.frontEndOptions = new SqljOptions(opts, this.log);
        this.options.addElement(this.frontEndOptions);
        this.theMain = new Main();
        this.theMain.prepareTranslation(this.options, this.log);
        this.procOptions(args);
        if (this.frontEndOptions.getBoolean("status")) {
            Main.immediateStream = this.errorStream;
        }
        if (this.m_wantsVersion) {
            this.printVersion(this.errorStream);
        }
        if (this.m_wantsHelp) {
            this.printHelp(this.errorStream);
        }
        if (this.m_wantsShortcutHelp) {
            this.printShortcutHelp(this.errorStream);
        }
        if (this.m_wantsLongHelp) {
            this.printLongHelp(this.errorStream);
        }
    }

    private void finishTranslation() {
        Disposable.disposer.disposeTrash();
        this.log.printLog(this.errorStream);
        this.errorStream.flush();
        block0 : switch (this.log.errorCount()) {
            case 0: {
                this.translationSuccessful = true;
                switch (this.log.warningCount()) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.errorStream.println(TranslatorErrors.noErrorOneWarning());
                        break block0;
                    }
                }
                this.errorStream.println(TranslatorErrors.noErrorNWarnings(this.log.warningCount()));
                break;
            }
            case 1: {
                switch (this.log.warningCount()) {
                    case 0: {
                        this.errorStream.println(TranslatorErrors.oneErrorNoWarning());
                        break block0;
                    }
                    case 1: {
                        this.errorStream.println(TranslatorErrors.oneErrorOneWarning());
                        break block0;
                    }
                }
                this.errorStream.println(TranslatorErrors.oneErrorNWarnings(this.log.warningCount()));
                break;
            }
            default: {
                switch (this.log.warningCount()) {
                    case 0: {
                        this.errorStream.println(TranslatorErrors.nErrorsNoWarning(this.log.errorCount()));
                        break block0;
                    }
                    case 1: {
                        this.errorStream.println(TranslatorErrors.nErrorsOneWarning(this.log.errorCount()));
                        break block0;
                    }
                }
                this.errorStream.println(TranslatorErrors.nErrorsNWarnings(this.log.errorCount(), this.log.warningCount()));
            }
        }
    }

    private void runCompilation(String[] javaFiles, String[] args) {
        String dir;
        String enc;
        StringBuffer v = new StringBuffer();
        v.append(this.frontEndOptions.getOption("compiler-executable"));
        v.append(" ");
        if (this.frontEndOptions.getBoolean("compiler-pipe-output-flag")) {
            v.append("-J-Djavac.pipe.output=true ");
        }
        if ((enc = this.frontEndOptions.getOption("encoding")) != null && !enc.equals("") && this.frontEndOptions.getBoolean("compiler-encoding-flag")) {
            v.append("-encoding ");
            v.append(enc);
            v.append(" ");
        }
        if ((dir = this.frontEndOptions.getOption("d")) != null && !dir.equals("")) {
            v.append("-d ");
            v.append(dir);
            v.append(" ");
        }
        String[] cOpts = this.optionsToStrings(this.compileOptions);
        int i = 0;
        while (i < cOpts.length) {
            if (cOpts[i].startsWith("-classpath=")) {
                v.append("-classpath ");
                v.append(cOpts[i].substring(11));
            } else {
                v.append(cOpts[i]);
            }
            v.append(" ");
            ++i;
        }
        int i2 = 0;
        while (i2 < javaFiles.length - 1) {
            v.append(javaFiles[i2]);
            v.append(" ");
            ++i2;
        }
        if (javaFiles.length > 0) {
            v.append(javaFiles[javaFiles.length - 1]);
        }
        if (this.frontEndOptions.getBoolean("status")) {
            this.statusStream.println(TranslatorErrors.compilingFiles(javaFiles.length));
        }
        this.compilationSuccessful = false;
        if (this.isPass1) {
            this.writeState(this.passfile, args);
            this.writeJavaCRunline(this.passfile, v.toString());
        } else {
            String msg;
            Process proc = null;
            try {
                proc = Runtime.getRuntime().exec(v.toString());
                proc.waitFor();
            }
            catch (IOException exn) {
                msg = TranslatorErrors.errorInCompilation(exn.getMessage());
                LOCATION.traceThrowableT(500, msg, (Throwable)exn);
                this.errorStream.println(msg);
            }
            catch (InterruptedException exn) {
                String msg2 = TranslatorErrors.errorInCompilation(exn.getMessage());
                LOCATION.traceThrowableT(500, msg2, (Throwable)exn);
                this.errorStream.println(msg2);
            }
            try {
                if (proc != null) {
                    InputStream fis;
                    int exitVal = proc.exitValue();
                    String TMP_FILE = this.frontEndOptions.getOption("compiler-output-file");
                    File tmpfile = null;
                    if (TMP_FILE != null && !TMP_FILE.equals("")) {
                        tmpfile = new File(TMP_FILE);
                        fis = new FileInputStream(tmpfile);
                    } else {
                        fis = proc.getInputStream();
                    }
                    this.compilationSuccessful = LogMapper.main(fis, System.out);
                    if (exitVal != 0) {
                        this.compilationSuccessful = false;
                    }
                    fis.close();
                    if (tmpfile != null) {
                        tmpfile.delete();
                    }
                }
            }
            catch (IOException exn) {
                msg = TranslatorErrors.errorInCompilation(exn.getMessage());
                LOCATION.traceThrowableT(500, msg, (Throwable)exn);
                this.errorStream.println(msg);
            }
        }
    }

    private void runPostCompilation() {
        try {
            File tmpfile = new File(this.passfile + ".log");
            FileInputStream fis = new FileInputStream(tmpfile);
            LogMapper.main(fis, System.out);
            ((InputStream)fis).close();
            tmpfile.delete();
        }
        catch (IOException exn) {
            String msg = TranslatorErrors.errorInCompilation(exn.getMessage());
            LOCATION.traceThrowableT(500, msg, (Throwable)exn);
            this.errorStream.println(msg);
        }
        catch (SecurityException exn) {
            String msg = TranslatorErrors.errorInCompilation(exn.getMessage());
            LOCATION.traceThrowableT(500, msg, (Throwable)exn);
            this.errorStream.println(msg);
        }
    }

    private String[] getSerFiles() {
        if (Main.serFilesVector != null) {
            String[] files = new String[Main.serFilesVector.size()];
            int i = 0;
            while (i < files.length) {
                File f = (File)Main.serFilesVector.elementAt(i);
                files[i] = f.toString();
                ++i;
            }
            return files;
        }
        return new String[0];
    }

    private boolean runProfileCustomization(String[] serFiles) {
        String defaultCustomizer;
        if (serFiles == null) {
            serFiles = this.getSerFiles();
        }
        if (serFiles.length == 0) {
            return true;
        }
        String[] pOpts = this.optionsToStrings(this.profileOptions);
        if (serFiles.length == 1 && serFiles[0].equals("-help")) {
            serFiles = new String[pOpts.length + 1];
            int i = 0;
            while (i < pOpts.length) {
                serFiles[i] = pOpts[i];
                ++i;
            }
            serFiles[pOpts.length] = "-help";
            pOpts = serFiles;
            serFiles = new String[]{};
        }
        boolean haveDefaultCustomizer = (defaultCustomizer = this.frontEndOptions.getOption("default-customizer")) != null && !defaultCustomizer.equals("");
        Hashtable h = SemanticAnalyzerFactory.getInterestingOptions();
        int oocount = h == null ? 0 : h.size();
        String[] args = new String[oocount + pOpts.length + serFiles.length + (haveDefaultCustomizer ? 1 : 0)];
        int argIndex = 0;
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)h.get(key);
            args[argIndex] = "-" + key + (value == null || value.equals("") ? "" : "=" + value);
            ++argIndex;
        }
        boolean runCustomizer = false;
        if (haveDefaultCustomizer) {
            args[argIndex] = "-customizer=" + defaultCustomizer;
            ++argIndex;
            runCustomizer = true;
        }
        int i = 0;
        while (i < pOpts.length) {
            if (pOpts[i].equals("-print")) {
                pOpts[i] = "-customizer=com.sap.sql.sqlj.runtime.profile.util.ProfilePrinter";
                runCustomizer = true;
            } else if (pOpts[i].equals("-debug")) {
                pOpts[i] = "-customizer=com.sap.sql.sqlj.runtime.profile.util.AuditorInstaller";
                runCustomizer = true;
            } else if (pOpts[i].equals("-help") || pOpts[i].startsWith("-customizer=")) {
                runCustomizer = true;
            }
            args[i + argIndex] = pOpts[i];
            ++i;
        }
        if (runCustomizer) {
            if (this.frontEndOptions.getBoolean("status")) {
                this.statusStream.println(TranslatorErrors.customizingProfiles(serFiles.length));
            }
            int i2 = 0;
            while (i2 < serFiles.length) {
                args[pOpts.length + i2 + argIndex] = serFiles[i2];
                ++i2;
            }
            int i3 = CustomizerHarness.mainStatus(args);
            return i3 == 0;
        }
        return true;
    }

    private boolean runClassInstrumentation() {
        boolean status = true;
        if (Main.classFilesTable.size() == 0) {
            return true;
        }
        if (this.frontEndOptions.getBoolean("status")) {
            this.statusStream.println(TranslatorErrors.instrumentingClassfiles(Main.classFilesTable.size()));
        }
        Enumeration e = Main.classFilesTable.keys();
        while (e.hasMoreElements()) {
            int i;
            String javaFile = (String)e.nextElement();
            String classFile = (String)Main.classFilesTable.get(javaFile);
            if (this.frontEndOptions.getBoolean("status")) {
                this.statusStream.println(TranslatorErrors.instrumentingClassfile(classFile, javaFile));
            }
            if ((i = ClassMapper.mainStatus(classFile, javaFile)) == 0) continue;
            status = false;
        }
        return status;
    }

    private String[] sqlj2java(Vector f) {
        String[] res = new String[f.size()];
        int i = 0;
        while (i < res.length) {
            String file = (String)f.elementAt(i);
            res[i] = file.endsWith(".sqlj") ? (String)Main.javaFilesTable.get(file) : file;
            ++i;
        }
        return res;
    }

    private void hasXXXFiles() {
        boolean profile = false;
        boolean compile = false;
        boolean sqlj = false;
        int i = 0;
        while (i < this.files.size()) {
            String file = (String)this.files.elementAt(i);
            if (file.endsWith(".sqlj")) {
                compile = true;
                sqlj = true;
            } else if (!compile && file.endsWith(".java")) {
                compile = true;
            } else if (!profile && (file.endsWith(".ser") || file.endsWith(".jar"))) {
                profile = true;
            }
            ++i;
        }
        this.m_compile_files = new Boolean(compile);
        this.m_profile_files = new Boolean(profile);
        this.m_sqlj_files = new Boolean(sqlj);
    }

    private boolean hasCompileFiles() {
        if (this.m_compile_files == null) {
            this.hasXXXFiles();
        }
        return this.m_compile_files;
    }

    private boolean hasProfileFiles() {
        if (this.m_profile_files == null) {
            this.hasXXXFiles();
        }
        return this.m_profile_files;
    }

    private boolean hasSqljFiles() {
        if (this.m_sqlj_files == null) {
            this.hasXXXFiles();
        }
        return this.m_sqlj_files;
    }

    private boolean wantsInfo() {
        return this.m_wantsHelp || this.m_wantsShortcutHelp || this.m_wantsLongHelp || this.m_wantsVersion || this.m_wantsProfileHelp || this.m_wantsCompileHelp;
    }

    private String[] optionsToStrings(PropertyListImpl prop) {
        if (prop == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        Enumeration keys = prop.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = prop.getProperty(key);
            v.addElement("-" + key + (value == null || value.equals("") ? "" : "=" + value));
        }
        Object[] sa = new String[v.size()];
        v.copyInto(sa);
        return sa;
    }

    private void procOptions(String[] args) throws InvalidOptionException {
        PropertyListImpl[] props = new PropertyListImpl[]{new PropertyListImpl(), new PropertyListImpl(), new PropertyListImpl()};
        props = this.importProps("java.home", props);
        props = this.importProps("user.home", props);
        props = this.importProps("user.dir", props);
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-P-help")) {
                this.m_wantsProfileHelp = true;
            } else if (args[i].equals("-C-help")) {
                this.m_wantsCompileHelp = true;
            } else {
                props = this.procOption(args[i], props);
            }
            ++i;
        }
        this.options.setOptions(props[0], this.log);
        this.handleUnusedOptions(props[0]);
        this.compileOptions = props[1];
        this.profileOptions = props[2];
        boolean invalidBooleans = false;
        int i2 = 0;
        while (i2 < booleanOptions.length) {
            try {
                this.frontEndOptions.getBooleanOption(booleanOptions[i2]);
            }
            catch (InvalidOptionException exn) {
                LOCATION.catching((Throwable)exn);
                this.log.addEntry(new JSError(SemanticErrors.illegalBooleanOptionEntry(booleanOptions[i2], exn.getMessage())));
                invalidBooleans = true;
            }
            ++i2;
        }
        if (invalidBooleans) {
            throw new InvalidOptionException();
        }
        if (!this.wantsInfo() && this.files.size() == 0) {
            this.m_wantsHelp = true;
        }
    }

    private void handleUnusedOptions(PropertyList props) throws InvalidOptionException {
        boolean foundError = false;
        Enumeration keys = props.propertyNames(false);
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String location = props.getPropertyLocation(key);
            this.log.addEntry(new JSError(TranslatorErrors.unknown_option(key, location)));
            foundError = true;
        }
        if (foundError) {
            throw new InvalidOptionException();
        }
    }

    private PropertyListImpl[] importProps(String propDir, PropertyListImpl[] props) throws InvalidOptionException {
        String dir = System.getProperty(propDir);
        if (dir != null) {
            props = this.procProps(new File(dir, PROPERTY_FILE), false, props);
        }
        return props;
    }

    private PropertyListImpl[] procProps(File propFile, boolean forceFileFound, PropertyListImpl[] curProps) throws InvalidOptionException {
        Properties props = new Properties();
        boolean ioError = false;
        try {
            if (propFile.isFile()) {
                FileInputStream is = new FileInputStream(propFile);
                props.load(is);
                is.close();
                int i = 0;
                while (i < 3) {
                    curProps[i] = new PropertyListImpl(curProps[i]);
                    ++i;
                }
                this.loadProps(props, propFile.getPath(), curProps);
            } else {
                ioError = forceFileFound;
            }
        }
        catch (FileNotFoundException e) {
            LOCATION.catching((Throwable)e);
            ioError = forceFileFound;
        }
        catch (IOException e) {
            LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
            ioError = true;
        }
        if (ioError) {
            this.log.addEntry(new JSError(TranslatorErrors.bad_property_file(propFile.getPath())));
            throw new InvalidOptionException();
        }
        return curProps;
    }

    private void loadProps(Properties fromProps, String optionLocation, PropertyListImpl[] toProps) {
        Enumeration<?> keys = fromProps.propertyNames();
        block0: while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            int i = 0;
            while (i < this.prefixes.length) {
                if (key.startsWith(this.prefixes[i])) {
                    toProps[i].addProperty(key.substring(this.prefixes_len[i]), fromProps.getProperty(key), optionLocation);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private PropertyListImpl[] procOption(String option, PropertyListImpl[] props) throws InvalidOptionException {
        if (option.startsWith("-C-")) {
            option = option.substring(3);
            props[1].addProperty(option, this.COMMAND_LINE);
        } else if (option.startsWith("-P-")) {
            option = option.substring(3);
            props[2].addProperty(option, this.COMMAND_LINE);
        } else if (option.startsWith("-")) {
            if (this.isFlagOption(option = option.substring(1), "help")) {
                this.m_wantsHelp = true;
            } else if (this.isFlagOption(option, "help-alias")) {
                this.m_wantsShortcutHelp = true;
            } else if (this.isFlagOption(option, "help-long")) {
                this.m_wantsLongHelp = true;
            } else if (this.isFlagOption(option, "version")) {
                this.m_wantsVersion = true;
            } else if (this.isValueOption(option, "props")) {
                String filename = this.getOptionValue(option, "props");
                props = this.procProps(new File(filename), true, props);
            } else {
                props[0].addProperty(option, this.COMMAND_LINE);
            }
        } else {
            this.files.addElement(option);
        }
        return props;
    }

    private boolean isFlagOption(String option, String key) {
        return option.equals(key);
    }

    private boolean isValueOption(String option, String key) {
        if (option.startsWith(key)) {
            int keyLen = key.length();
            return option.length() == keyLen || option.charAt(keyLen) == '=';
        }
        return false;
    }

    private String getOptionValue(String option, String key) {
        int keyLen = key.length();
        return option.length() > keyLen ? option.substring(keyLen + 1) : "";
    }

    private void writeState(String filename, String[] args) {
        try {
            File f = new File(filename + ".ser");
            ObjectOutputStream dos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            dos.writeObject("SAP SQLJ Translator (Based on the SQLJ Reference Implementation)");
            dos.writeObject(args);
            dos.writeObject(Main.serFilesVector);
            dos.writeObject(Main.javaFilesTable);
            dos.writeObject(Main.classFilesTable);
            dos.close();
        }
        catch (IOException exn) {
            LOCATION.traceThrowableT(500, "Unable to write translation state to " + filename + ".ser", (Throwable)exn);
        }
    }

    private void writeJavaCRunline(String filename, String command) {
        try {
            File f = new File(filename + ".run");
            PrintWriter pw = new PrintWriter(new FileOutputStream(f));
            pw.println(command);
            pw.close();
        }
        catch (IOException exn) {
            LOCATION.traceThrowableT(500, "Unable to write Java compiler command line to " + filename + ".run", (Throwable)exn);
        }
    }

    private String[] restoreState(String filename) {
        String[] args = null;
        try {
            File f = new File(filename + ".ser");
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
            String version = "UNKNOWN";
            try {
                version = (String)dis.readObject();
            }
            catch (Exception exn) {
                LOCATION.catching((Throwable)exn);
            }
            if (version == null || !version.equals("SAP SQLJ Translator (Based on the SQLJ Reference Implementation)")) {
                throw new IOException("File or version mismatch in reading SQLJ translation state.");
            }
            args = (String[])dis.readObject();
            Main.serFilesVector = (Vector)dis.readObject();
            Main.javaFilesTable = (Hashtable)dis.readObject();
            Main.classFilesTable = (Hashtable)dis.readObject();
            dis.close();
            f.delete();
            f = new File(filename + ".run");
            f.delete();
            return args;
        }
        catch (IOException exn) {
            LOCATION.traceThrowableT(500, "Unable to write read translation state from " + filename + ".ser", (Throwable)exn);
            return args;
        }
        catch (ClassNotFoundException exn) {
            LOCATION.traceThrowableT(500, "Unable to write read translation state from " + filename + ".ser", (Throwable)exn);
            return args;
        }
        catch (SecurityException exn) {
            LOCATION.traceThrowableT(500, "Unable to remove file " + filename + ".ser or " + filename + ".run", (Throwable)exn);
            return args;
        }
    }

    private void printHelp(PrintWriter out) {
        out.println(TranslatorErrors.sqljHelpMessage());
    }

    private void printLongHelp(PrintWriter out) {
        out.println(TranslatorErrors.synopsis("sqlj"));
        out.println(TranslatorErrors.options());
        out.println();
        this.printParams(out, this.options.getOptionInfo());
    }

    private void printShortcutHelp(PrintWriter out) {
        out.println(TranslatorErrors.sqljShortcutMessage());
    }

    private void printParams(PrintWriter out, String[][] params) {
        String[] cols = new String[]{TranslatorErrors.name(), TranslatorErrors.type(), TranslatorErrors.value(), TranslatorErrors.description(), TranslatorErrors.setFrom()};
        int colWidth = 0;
        int i = 0;
        while (i < cols.length) {
            if (colWidth < cols[i].length()) {
                colWidth = cols[i].length();
            }
            ++i;
        }
        ++colWidth;
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2] = (cols[i2] + "                                   ").substring(0, colWidth);
            ++i2;
        }
        int i3 = 0;
        while (i3 < params.length) {
            out.println(cols[0] + params[i3][0]);
            if (params[i3][1] != null) {
                out.println(cols[1] + params[i3][1]);
            }
            if (params[i3][2] != null) {
                out.println(cols[2] + params[i3][2]);
            }
            if (params[i3][3] != null) {
                out.println(cols[3] + params[i3][3]);
            }
            if (params[i3][4] != null) {
                out.println(cols[4] + params[i3][4]);
            }
            out.println();
            ++i3;
        }
    }

    public void printVersion(PrintWriter out) {
        out.println("SAP SQLJ Translator (Based on the SQLJ Reference Implementation)");
    }

    private ErrorLogger getErrorLogger() {
        return this.log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

