/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.tools;

import com.sap.tc.logging.Location;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class SourceMapper
extends FilterWriter {
    private Reader m_isr = null;
    private StringWriter m_sw = null;
    private static final int SRC = 0;
    private static final int TGT = 1;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$tools$SourceMapper == null ? (class$com$sap$sql$sqlj$tools$SourceMapper = SourceMapper.class$("com.sap.sql.sqlj.tools.SourceMapper")) : class$com$sap$sql$sqlj$tools$SourceMapper));
    private int size = 0;
    private int MAX_SIZE = 20;
    private int[][] sline = new int[2][this.MAX_SIZE];
    private int[][] scol = new int[2][this.MAX_SIZE];
    private int[][] eline = new int[2][this.MAX_SIZE];
    private int[][] ecol = new int[2][this.MAX_SIZE];
    private boolean ready = false;
    private boolean CR_SEEN = false;
    private int line_count = 1;
    private int col_count = 0;
    private int prev_col_count = 0;
    private static final int OTHER = 1;
    private static final int USER_CODE = 2;
    private static final int GENERATED_CODE = 3;
    private static final int LINEINFO = 4;
    private int startTokenColumn = 0;
    private int startTokenLine = 0;
    private int startTokenColOnPrevLine = 0;
    private int endTokenColumn = 0;
    private int endTokenLine = 0;
    private int info_line = 0;
    private int info_column = 0;
    private int line_at_info = 0;
    private int column_at_info = 0;
    static String USER_CODE_TAG = "user-code";
    static String GENERATED_CODE_TAG = "generated-code";
    private static String AT_LINEINFO_TAG = "@lineinfo:";
    private Integer m_sline = null;
    private Integer m_scol = null;
    private Integer m_eline = null;
    private Integer m_ecol = null;
    private int line_start;
    private int col_start;
    private int line_end;
    private int col_end;
    static /* synthetic */ Class class$com$sap$sql$sqlj$tools$SourceMapper;

    public SourceMapper(String s) {
        super(new StringWriter());
        this.size = 0;
        try {
            this.m_sw = null;
            FileInputStream fis = new FileInputStream(s);
            this.m_isr = new InputStreamReader(fis);
            this.readAll();
            this.m_isr.close();
            fis.close();
            this.ready = true;
        }
        catch (EOFException ex) {
        }
        catch (IOException exn) {
            LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)exn);
        }
    }

    public SourceMapper(Reader r) {
        super(new StringWriter());
        try {
            this.m_sw = null;
            this.m_isr = r;
            this.readAll();
            this.m_isr.close();
            this.ready = true;
        }
        catch (EOFException ex) {
        }
        catch (IOException exn) {
            LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)exn);
        }
    }

    public int size() {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: request for mapping with map construction pending");
        }
        return this.size;
    }

    public SourceMapper(Writer w) {
        super(w);
        this.m_isr = null;
        this.m_sw = new StringWriter();
    }

    private void allocate() {
        int new_size = this.MAX_SIZE * 2;
        int[][] tmp_sl = new int[2][new_size];
        int[][] tmp_sc = new int[2][new_size];
        int[][] tmp_el = new int[2][new_size];
        int[][] tmp_ec = new int[2][new_size];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < this.MAX_SIZE) {
                tmp_sl[i][j] = this.sline[i][j];
                tmp_sc[i][j] = this.scol[i][j];
                tmp_el[i][j] = this.eline[i][j];
                tmp_ec[i][j] = this.ecol[i][j];
                ++j;
            }
            ++i;
        }
        this.sline = tmp_sl;
        this.scol = tmp_sc;
        this.eline = tmp_el;
        this.ecol = tmp_ec;
        this.MAX_SIZE = new_size;
    }

    private void readAll() {
        try {
            int result = 1;
            int first_srcline = 1;
            int first_srccol = 1;
            int first_tgtline = 1;
            int first_tgtcol = 1;
            while (true) {
                if (result != 3) {
                    result = this.readToken();
                    continue;
                }
                if (this.readToken() == 4) {
                    first_srcline = this.info_line;
                    first_srccol = this.info_column;
                    first_tgtline = this.endTokenLine;
                    first_tgtcol = this.endTokenColumn;
                }
                while (result != 2) {
                    result = this.readToken();
                }
                this.readToken();
                if (this.size == this.MAX_SIZE) {
                    this.allocate();
                }
                this.sline[1][this.size] = first_tgtline;
                this.scol[1][this.size] = first_tgtcol;
                this.eline[1][this.size] = this.line_count;
                this.ecol[1][this.size] = this.col_count;
                this.sline[0][this.size] = first_srcline;
                this.scol[0][this.size] = first_srccol;
                this.eline[0][this.size] = this.info_line;
                this.ecol[0][this.size] = this.info_column - 1;
                ++this.size;
            }
        }
        catch (EOFException ex) {
        }
        catch (IOException exn) {
            LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)exn);
        }
    }

    private char nextChar() throws IOException {
        int ci = this.m_isr.read();
        if (ci < 0) {
            throw new EOFException();
        }
        char ch = (char)ci;
        ++this.col_count;
        if (ch == '\r') {
            this.CR_SEEN = true;
            ++this.line_count;
            this.prev_col_count = this.col_count;
            this.col_count = 0;
        } else if (ch == '\n') {
            if (!this.CR_SEEN) {
                this.prev_col_count = this.col_count;
                ++this.line_count;
            } else {
                this.CR_SEEN = false;
            }
            this.col_count = 0;
        } else {
            this.CR_SEEN = false;
        }
        return ch;
    }

    private int readToken() throws IOException {
        char ch;
        this.startTokenLine = this.line_count;
        this.startTokenColumn = this.col_count;
        if (this.startTokenColumn == 1) {
            this.startTokenColOnPrevLine = this.prev_col_count + 1;
        }
        if ((ch = this.nextChar()) == '\"') {
            this.readEnclosing(34);
            return this.setOtherTokenEnd();
        }
        if (ch == '\'') {
            this.readEnclosing(39);
            return this.setOtherTokenEnd();
        }
        if (ch == '/') {
            ch = this.nextChar();
            if (ch == '/') {
                ch = this.nextChar();
                while (ch != '\n' && ch != '\r') {
                    ch = this.nextChar();
                }
                return this.setOtherTokenEnd();
            }
            if (ch == '*') {
                ch = this.nextChar();
                if (ch == '@' && this.readAtLineinfo(ch)) {
                    ch = this.nextChar();
                    if ('0' <= ch && ch <= '9') {
                        if (this.readLineInfo(ch)) {
                            this.line_at_info = this.line_count;
                            this.column_at_info = this.col_count;
                            return 4;
                        }
                        return this.setOtherTokenEnd();
                    }
                    if (ch == 'u') {
                        if (this.readUserCode(ch)) {
                            return 2;
                        }
                        return this.setOtherTokenEnd();
                    }
                    if (ch == 'g') {
                        if (this.readGeneratedCode(ch)) {
                            return 3;
                        }
                        return this.setOtherTokenEnd();
                    }
                    this.readComment(ch);
                    return this.setOtherTokenEnd();
                }
                this.readComment(ch);
                return this.setOtherTokenEnd();
            }
        } else if (ch == '\\') {
            ch = this.nextChar();
            if (ch == 'u') {
                this.readUnicode();
            }
            return this.setOtherTokenEnd();
        }
        return this.setOtherTokenEnd();
    }

    private int setOtherTokenEnd() {
        this.endTokenLine = this.line_count;
        this.endTokenColumn = this.col_count;
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readLineInfo(char ch) throws IOException {
        this.info_line = 0;
        this.info_column = 0;
        while ('0' <= ch && ch <= '9') {
            this.info_line *= 10;
            this.info_line += ch - 48;
            ch = this.nextChar();
        }
        if (ch != '^') {
            this.readComment(ch);
            return false;
        }
        ch = this.nextChar();
        if (ch >= '0' && '9' >= ch) ** GOTO lbl18
        this.readComment(ch);
        return false;
lbl-1000:
        // 1 sources

        {
            this.info_column *= 10;
            this.info_column += ch - 48;
            ch = this.nextChar();
lbl18:
            // 2 sources

            ** while ('0' <= ch && ch <= '9')
        }
lbl19:
        // 1 sources

        return this.readEndComment(ch);
    }

    private boolean readUserCode(char ch) throws IOException {
        int i = 0;
        while (i < USER_CODE_TAG.length()) {
            if (USER_CODE_TAG.charAt(i) != ch) {
                this.readComment(ch);
                return false;
            }
            ch = this.nextChar();
            ++i;
        }
        return this.readEndComment(ch);
    }

    private boolean readGeneratedCode(char ch) throws IOException {
        int i = 0;
        while (i < GENERATED_CODE_TAG.length()) {
            if (GENERATED_CODE_TAG.charAt(i) != ch) {
                this.readComment(ch);
                return false;
            }
            ch = this.nextChar();
            ++i;
        }
        return this.readEndComment(ch);
    }

    private boolean readAtLineinfo(char ch) throws IOException {
        int i = 0;
        while (i < AT_LINEINFO_TAG.length()) {
            if (AT_LINEINFO_TAG.charAt(i) != ch) {
                this.readComment(ch);
                return false;
            }
            if (i < AT_LINEINFO_TAG.length() - 1) {
                ch = this.nextChar();
            }
            ++i;
        }
        return true;
    }

    private void readEnclosing(int ch) throws IOException {
        boolean SEEN_BACKSLASH = false;
        char c = this.nextChar();
        while (true) {
            if (SEEN_BACKSLASH && c == 'u') {
                this.readUnicode();
                SEEN_BACKSLASH = false;
            } else if (SEEN_BACKSLASH) {
                SEEN_BACKSLASH = false;
            } else if (c == ch) {
                return;
            }
            c = this.nextChar();
        }
    }

    private void readUnicode() throws IOException {
        this.nextChar();
        this.nextChar();
        this.nextChar();
        this.nextChar();
    }

    private void readComment(char ch) throws IOException {
        boolean SEEN_STAR = ch == '*';
        ch = this.nextChar();
        while (!SEEN_STAR || ch != '/') {
            SEEN_STAR = ch == '*';
            ch = this.nextChar();
        }
        return;
    }

    private boolean readEndComment(char ch) throws IOException {
        if (ch == '*' && (ch = this.nextChar()) == '/') {
            return true;
        }
        this.readComment(ch);
        return false;
    }

    public void write(char[] ch, int off, int len) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(ch, off, len);
        super.write(ch, off, len);
    }

    public void write(int ch) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(ch);
        super.write(ch);
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(s, off, len);
        super.write(s, off, len);
    }

    public void flush() throws IOException {
        if (this.ready) {
            throw new IOException("flush not permitted on this SourceMapper");
        }
        this.m_sw.flush();
        super.flush();
    }

    public void close() throws IOException {
        if (this.ready) {
            throw new IOException("close not permitted on this SourceMapper");
        }
        this.m_sw.close();
        this.m_isr = new StringReader(this.m_sw.toString());
        this.readAll();
        this.m_isr.close();
        this.ready = true;
        this.m_sw = null;
        this.m_isr = null;
    }

    public int startLine() {
        if (this.m_sline != null) {
            return this.m_sline;
        }
        throw new IllegalArgumentException("startLine(): no line/col info available");
    }

    public int startCol() {
        if (this.m_scol != null) {
            return this.m_scol;
        }
        throw new IllegalArgumentException("startCol(): no line/col info available");
    }

    public int endLine() {
        if (this.m_eline != null) {
            return this.m_eline;
        }
        throw new IllegalArgumentException("endLine(): no line/col info available");
    }

    public int endCol() {
        if (this.m_ecol != null) {
            return this.m_ecol;
        }
        throw new IllegalArgumentException("endCol(): no line/col info available");
    }

    public void srcLineToTgt(int line, int col) {
        this.lineRange(0, line, col, line, col, 1);
    }

    public void srcLineToTgt(int line1, int col1, int line2, int col2) {
        this.lineRange(0, line1, col1, line2, col2, 1);
    }

    public void tgtLineToSrc(int line, int col) {
        this.lineRange(1, line, col, line, col, 0);
    }

    public void tgtLineToSrc(int line1, int col1, int line2, int col2) {
        this.lineRange(1, line1, col1, line2, col2, 0);
    }

    private void lineRange(int in, int line1, int col1, int line2, int col2, int out) {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: request for mapping with map construction pending");
        }
        if (line2 < line1 || line1 == line2 && col2 < col1) {
            throw new IllegalArgumentException("end line/col < start line/col");
        }
        this.lookupLineCol(in, line1, col1, out);
        if (line1 == line2 && col1 == col2) {
            this.m_sline = new Integer(this.line_start);
            this.m_scol = new Integer(this.col_start);
            this.m_eline = new Integer(this.line_end);
            this.m_ecol = new Integer(this.col_end);
            return;
        }
        int sline1 = this.line_start;
        int scol1 = this.col_start;
        int eline1 = this.line_end;
        int ecol1 = this.col_end;
        this.lookupLineCol(in, line2, col2, out);
        this.m_sline = new Integer(sline1);
        this.m_scol = new Integer(scol1);
        if (eline1 > this.line_end || eline1 == this.line_end && ecol1 > this.col_end) {
            this.m_eline = new Integer(eline1);
            this.m_ecol = new Integer(ecol1);
        } else {
            this.m_eline = new Integer(this.line_end);
            this.m_ecol = new Integer(this.col_end);
        }
    }

    private void lookupLineCol(int in, int line, int col, int out) {
        if (this.size == 0 || line < this.sline[in][0] || line == this.sline[in][0] && col < this.scol[in][0]) {
            this.line_end = this.line_start = line;
            this.col_end = this.col_start = col;
            return;
        }
        if (line > this.eline[in][this.size - 1]) {
            this.line_start = line - this.eline[in][this.size - 1] + this.eline[out][this.size - 1];
            this.col_start = col;
            this.line_end = this.line_start;
            this.col_end = this.col_start;
            return;
        }
        if (line == this.eline[in][this.size - 1] && col > this.ecol[in][this.size - 1]) {
            this.line_start = this.eline[out][this.size - 1];
            this.col_start = col - this.ecol[in][this.size - 1] + this.ecol[out][this.size - 1];
            this.line_end = this.line_start;
            this.col_end = this.col_start;
            return;
        }
        int idx = this.searchLineCol(in, line, col);
        if (idx < 0 || idx >= this.size) {
            throw new IllegalArgumentException("Internal error: line/col not found:" + line + "/" + col);
        }
        if (line < this.eline[in][idx] || line == this.eline[in][idx] && col <= this.ecol[in][idx]) {
            this.line_start = this.sline[out][idx];
            this.col_start = this.scol[out][idx];
            this.line_end = this.eline[out][idx];
            this.col_end = this.ecol[out][idx];
            return;
        }
        if (this.eline[in][idx] < line) {
            this.line_end = this.line_start = line - this.eline[in][idx] + this.eline[out][idx];
            this.col_end = this.col_start = col;
            return;
        }
        this.line_end = this.line_start = this.eline[out][idx];
        this.col_end = this.col_start = col - this.ecol[in][idx] + this.ecol[out][idx];
    }

    private int searchLineCol(int array, int line, int col) {
        int first = 0;
        int last = this.size - 1;
        while (true) {
            if (first > last) {
                if (this.size > 0 && (this.eline[array][this.size - 1] < line || this.eline[array][this.size - 1] == line && this.ecol[array][this.size - 1] < col)) {
                    return this.size;
                }
                return -1;
            }
            int index = (first + last) / 2;
            int cline = this.sline[array][index];
            int ccol = this.scol[array][index];
            if ((cline < line || cline == line && ccol <= col) && (index == this.size - 1 || line < this.sline[array][index + 1] || line == this.sline[array][index + 1] && col < this.scol[array][index + 1])) {
                return index;
            }
            if (cline > line || cline == line && ccol > col) {
                last = index - 1;
                continue;
            }
            first = index + 1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

