/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.syntax;

import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.javac.ExpressionNode;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.syntax.SQLUnit;
import com.sap.sql.sqlj.util.Parselet;
import java.util.Enumeration;
import java.util.Vector;

public class ExecElem
extends Elem {
    Vector contextList;
    Parselet resultExpr;
    SQLUnit sqlUnit;

    ExecElem(ErrorLog e, Vector v, Parselet p, SQLUnit s) {
        super(e);
        if (v == null) {
            v = new Vector();
        }
        if (s == null) {
            throw new NullPointerException("Missing SQLUnit");
        }
        this.contextList = v;
        this.resultExpr = p;
        this.sqlUnit = s;
    }

    ExecElem(ErrorLog e, Vector v, SQLUnit s) {
        this(e, v, null, s);
    }

    public Enumeration getContextExprList() {
        return this.contextList.elements();
    }

    public Parselet getResultExpr() {
        return this.resultExpr;
    }

    public SQLUnit getSQL() {
        return this.sqlUnit;
    }

    public void setScope(Parselet p) {
        super.setScope(p);
        Enumeration e = this.getContextExprList();
        while (e.hasMoreElements()) {
            ((Parselet)e.nextElement()).setScope(p);
        }
        if (this.resultExpr != null) {
            this.resultExpr.setScope(p);
        }
        this.sqlUnit.setScope(p);
    }

    void getTextTo(StringBuffer b) {
        b.append("#sql ");
        if (this.contextList != null && !this.contextList.isEmpty()) {
            b.append("[");
            Enumeration e = this.getContextExprList();
            while (true) {
                ((ExpressionNode)e.nextElement()).getTextTo(b);
                if (!e.hasMoreElements()) break;
                b.append(",");
            }
            b.append("] ");
        }
        if (this.resultExpr != null) {
            ((ExpressionNode)this.resultExpr).getTextTo(b);
            b.append(" = ");
        }
        b.append("{ ");
        this.sqlUnit.getTextTo(b);
        b.append(" };");
    }
}

