/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import antlr.Token;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.checker.HostItem;
import com.sap.sql.sqlj.framework.checker.SQLOperation;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.error.Warning;
import com.sap.sql.sqlj.javac.ErrorDescriptor;
import com.sap.sql.sqlj.javac.SimpleNameNode;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.SQLTokenizer;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.syntax.BindExpr;
import com.sap.sql.sqlj.syntax.DirectBindExpr;
import com.sap.sql.sqlj.syntax.IntoBindExpr;
import com.sap.sql.sqlj.syntax.ReturnBindExpr;
import com.sap.sql.sqlj.syntax.SQLUnit;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SQLOperationImpl
implements SQLOperation {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$semantics$SQLOperationImpl == null ? (class$com$sap$sql$sqlj$semantics$SQLOperationImpl = SQLOperationImpl.class$("com.sap.sql.sqlj.semantics.SQLOperationImpl")) : class$com$sap$sql$sqlj$semantics$SQLOperationImpl));
    private SQLUnit m_sql_unit;
    private ErrorLog m_error_log;
    private int m_host_item_count;
    private Vector m_host_items;
    private JSClass m_result_type;
    private int m_result_index;
    private boolean m_hasIntoBindExpr;
    static /* synthetic */ Class class$com$sap$sql$sqlj$semantics$SQLOperationImpl;

    SQLOperationImpl(ErrorLog el, SQLUnit su, JSClass result_type, SemanticAnalyzerFactory saf) {
        block26: {
            this.m_result_index = 0;
            this.m_hasIntoBindExpr = false;
            this.m_sql_unit = su;
            this.m_error_log = el;
            this.m_result_type = result_type;
            this.setOperationCode(this.getOperationCode());
            this.m_host_item_count = 0;
            this.m_host_items = new Vector();
            Enumeration e = this.m_sql_unit.getBindExprs();
            IntoBindExpr ibe = null;
            while (e.hasMoreElements()) {
                BindExpr bexp = (BindExpr)e.nextElement();
                if (bexp instanceof IntoBindExpr) {
                    if (ibe != null) {
                        el.addEntry(new JSError(SemanticErrors.severalIntos()));
                        continue;
                    }
                    ibe = (IntoBindExpr)bexp;
                    continue;
                }
                if (bexp instanceof ReturnBindExpr) {
                    el.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-1")));
                    continue;
                }
                if (bexp instanceof DirectBindExpr) {
                    ++this.m_host_item_count;
                    this.m_host_items.addElement(new HostItemImpl((DirectBindExpr)bexp, this.m_host_item_count));
                    continue;
                }
                el.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-2")));
            }
            if (ibe != null) {
                if (this.m_result_type != null) {
                    el.addEntry(new JSError(SemanticErrors.intoAndValue()));
                } else {
                    try {
                        Enumeration ebe = ibe.getParselets();
                        int count = 0;
                        boolean wasError = false;
                        while (ebe.hasMoreElements()) {
                            ++count;
                            ExpressionDescriptor ed = (ExpressionDescriptor)((Parselet)ebe.nextElement()).getDescriptor();
                            if (!ed.isAssignable()) {
                                el.addEntry(new JSError(SemanticErrors.intoListItemMustBeLvalue(count)));
                            }
                            if (ed instanceof ErrorDescriptor) {
                                wasError = true;
                                el.addEntry(new JSError(SemanticErrors.invalidJavaTypeForINTOItem(count, ed.getName())));
                            }
                            if (wasError) {
                                this.m_result_type = JSClass.ResultSetIterator_TYPE;
                                continue;
                            }
                            this.m_result_type = saf.m_pf.newIteratorClass(ibe);
                            this.m_hasIntoBindExpr = true;
                        }
                    }
                    catch (ClassNotFoundException exn) {
                        boolean isFetch;
                        LOCATION.catching((Throwable)exn);
                        this.m_result_type = JSClass.ResultSetIterator_TYPE;
                        Token startToken = (Token)this.tokens().nextElement();
                        boolean bl = isFetch = startToken.getType() == 127;
                        if (isFetch) break block26;
                        el.addEntry(new JSError(SemanticErrors.illegalIntoList(exn.getMessage())));
                    }
                }
            }
        }
        if (this.m_host_item_count != this.m_sql_unit.getNumActualBindExprs()) {
            el.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-3")));
        }
        int item_index = 0;
        Enumeration ts = this.tokens();
        int tokenCount = 0;
        boolean startsWithSet = false;
        while (ts.hasMoreElements()) {
            Token t = (Token)ts.nextElement();
            int tokenType = t.getType();
            if (0 <= tokenCount) {
                if (++tokenCount == 1) {
                    if (t.getType() == 301) {
                        startsWithSet = true;
                    } else {
                        tokenCount = -99999;
                    }
                } else if (tokenCount == 2) {
                    HostItemImpl hi;
                    if (t.getType() == 127 && (hi = (HostItemImpl)this.m_host_items.elementAt(item_index)).getHostItemMode() != 4) {
                        if (hi.getHostItemMode() != 0) {
                            el.addEntry(new Warning(SemanticErrors.setModeChangedToOut()));
                        }
                        hi.setHostItemMode(4);
                    }
                    tokenCount = -99999;
                }
            }
            if (tokenType != 127) continue;
            if (++item_index > this.m_host_item_count) {
                el.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-4")));
                continue;
            }
            ((HostItemImpl)this.m_host_items.elementAt(item_index - 1)).setPos(t.getLine());
        }
        if (item_index < this.m_host_item_count) {
            el.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-5")));
        }
    }

    public String getSQLString() {
        if (this.m_sql_unit.getSQL() == null) {
            throw new IllegalArgumentException("SQLUnit.getSQL() returns null");
        }
        return this.m_sql_unit.getSQL();
    }

    public void setSQLString(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("SQLOperation.setSQLString(null)");
        }
        this.m_sql_unit.setSQL(sql);
    }

    public Enumeration tokens() {
        return new SQLTokenizer(this.m_error_log, this.getSQLString());
    }

    public int getOperationCode() {
        return this.m_sql_unit.getOperationType();
    }

    public void setOperationCode(int i) {
        if (i != 9 && i != 4 && i != 11 && i != 8 && i != 6 && i != 2 && i != 7 && i != 12 && i != 3 && i != 17 && i != 1023 && i != 5 && i != 1022 && i != 19 && i != 18 && i < 1024) {
            throw new IllegalArgumentException("com.sap.sql.sqlj.semantics.SQLOperationImpl.setOperationCode(int): illegal operation code " + i);
        }
        this.m_sql_unit.setOperationType(i);
    }

    public void setDescriptor(Serializable descriptor) {
        this.m_sql_unit.setDescriptor(descriptor);
    }

    public Serializable getDescriptor() {
        return this.m_sql_unit.getDescriptor();
    }

    public int hostItemCount() {
        return this.m_host_item_count;
    }

    public HostItem hostItem(int i) {
        if (--i < 0 || i >= this.m_host_item_count) {
            return null;
        }
        return (HostItem)this.m_host_items.elementAt(i);
    }

    public JSClass getResultType() {
        return this.m_result_type;
    }

    public void setResultType(JSClass resultType) {
        this.m_result_type = resultType;
    }

    public void setResultParamIndex(int index) {
        if (index < 0 || index > this.hostItemCount() + 1) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.m_result_index == 0) {
            if (index != 0) {
                this.m_sql_unit.insertBindExprAt(ReturnBindExpr.COLUMN_RETURN, index);
            }
        } else {
            throw new IllegalArgumentException("can only set result param once");
        }
        this.m_result_index = index;
    }

    public int getResultParamIndex() {
        return this.m_result_index;
    }

    public boolean hasIntoBindExpr() {
        return this.m_hasIntoBindExpr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class HostItemImpl
    implements HostItem {
        private DirectBindExpr m_dbe;
        private int m_pos;
        private int m_nth;
        private JSClass m_type;
        private String m_name;
        private boolean m_lvalue;

        HostItemImpl(DirectBindExpr dbe, int numExpr) {
            this.m_dbe = dbe;
            this.m_nth = numExpr;
            Parselet parselet = this.m_dbe.getParselet();
            if (parselet == null) {
                String msg = SemanticErrors.internalError("SQLOperationImpl-6:") + "(Internal error: DirectBindExpression has a NULL parselet!)";
                LOCATION.errorT(msg);
                SQLOperationImpl.this.m_error_log.addEntry(new JSError(msg));
            }
            TypeDescriptor td = null;
            td = parselet.getDescriptor();
            if (td == null) {
                if (parselet instanceof SimpleNameNode) {
                    SimpleNameNode simpleNameNode = (SimpleNameNode)parselet;
                    this.m_name = simpleNameNode.getText();
                }
                this.m_type = null;
                this.m_name = null;
                this.m_lvalue = false;
            } else {
                try {
                    if (td instanceof ClassDescriptor) {
                        this.m_type = ((ClassDescriptor)td).getReflection();
                        this.m_name = null;
                        this.m_lvalue = false;
                    } else if (td instanceof ExpressionDescriptor) {
                        ExpressionDescriptor ed = (ExpressionDescriptor)td;
                        this.m_type = ed.getReflection();
                        this.m_name = ed.getName();
                        this.m_lvalue = ed.isAssignable();
                        int mode = this.getHostItemMode();
                        if (!(this.m_lvalue || mode != 4 && mode != 2)) {
                            SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.hostItemMustBeLvalue(this.m_nth)));
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    LOCATION.catching((Throwable)e);
                    this.m_type = null;
                    this.m_name = null;
                    this.m_lvalue = false;
                }
            }
        }

        void setPos(int pos) {
            this.m_pos = pos;
        }

        public int getHostItemPosition() {
            return this.m_pos;
        }

        public JSClass getHostItemType() {
            return this.m_type;
        }

        public String getHostItemName() {
            return this.m_name;
        }

        public int getHostItemMode() {
            return this.m_dbe.getModality();
        }

        public void setHostItemMode(int mode) {
            if (mode == 1 || mode == 4 || mode == 2 || mode == 0) {
                this.m_dbe.setModality(mode);
                if (!(this.m_lvalue || mode != 4 && mode != 2)) {
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.hostItemMustBeLvalue(this.m_nth)));
                }
            } else {
                throw new IllegalArgumentException("HostItem.setHostItemMode(" + mode + ") - illegal mode value.");
            }
        }
    }
}

