/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import antlr.Token;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.JSMethod;
import com.sap.sql.sqlj.framework.checker.HostItem;
import com.sap.sql.sqlj.framework.checker.SQLChecker;
import com.sap.sql.sqlj.framework.checker.SQLOperation;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.javac.SimpleNameNode;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.BaseAnalysis;
import com.sap.sql.sqlj.semantics.SQLOperationImpl;
import com.sap.sql.sqlj.semantics.SemanticAnalyzer;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.semantics.TypeProperties;
import com.sap.sql.sqlj.syntax.ExecElem;
import com.sap.sql.sqlj.syntax.IntoBindExpr;
import com.sap.sql.sqlj.syntax.ReturnBindExpr;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.LValueDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;

class ExecAnalysis
extends BaseAnalysis
implements SemanticAnalyzer {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$semantics$ExecAnalysis == null ? (class$com$sap$sql$sqlj$semantics$ExecAnalysis = ExecAnalysis.class$("com.sap.sql.sqlj.semantics.ExecAnalysis")) : class$com$sap$sql$sqlj$semantics$ExecAnalysis));
    private SQLOperation m_so;
    private ErrorLog m_el;
    private ExecElem exec_elem;
    private static Token EOF = new Token(1);
    static /* synthetic */ Class class$com$sap$sql$sqlj$semantics$ExecAnalysis;

    ExecAnalysis(ExecElem elem, SemanticAnalyzerFactory saf) {
        super(elem, saf);
        this.exec_elem = elem;
        this.m_el = this.exec_elem.getErrorLog();
        this.m_so = null;
    }

    private void checkHostItemType(JSClass type, int mode, int pos, String name, boolean intoList) {
        if (type == null) {
            return;
        }
        if (intoList) {
            if (!TypeProperties.isCursorColumnType(type)) {
                if (type.isPrimitive()) {
                    this.logError(SemanticErrors.invalidJavaTypeForINTOItem(pos, TypeProperties.printJavaType(type)));
                } else {
                    this.logError(SemanticErrors.unsupportedJavaTypeForINTOItem(pos, TypeProperties.printJavaType(type)));
                }
            } else if (this.saf.getPortable() && !TypeProperties.isCursorColumnType(type)) {
                this.logWarning(SemanticErrors.notJdbcHostItem(TypeProperties.printJavaType(type), pos, null));
            }
        } else {
            boolean in_legal = TypeProperties.isHostItemInType(type);
            boolean out_legal = TypeProperties.isHostItemOutType(type);
            if (mode == 1 && !in_legal || mode == 4 && !out_legal || (mode == 2 || mode == 0) && (!out_legal || !in_legal)) {
                if (type.isPrimitive()) {
                    this.logError(SemanticErrors.invalidJavaTypeForHostItem(pos, TypeProperties.printJavaType(type), name));
                } else {
                    String message = SemanticErrors.unsupportedJavaTypeForHostItem(pos, TypeProperties.printJavaType(type), name);
                    if (in_legal && !out_legal) {
                        message = message + " " + SemanticErrors.notLegalAsOut();
                    } else if (!in_legal && out_legal) {
                        message = message + " " + SemanticErrors.notLegalAsIn();
                    }
                    this.logError(message);
                }
            } else if (this.saf.getPortable()) {
                in_legal = TypeProperties.isHostItemInType(type);
                out_legal = TypeProperties.isHostItemOutType(type);
                if (mode == 1 && !in_legal || mode == 4 && !out_legal || (mode == 2 || mode == 0) && (!out_legal || !in_legal)) {
                    String message = SemanticErrors.notJdbcHostItem(TypeProperties.printJavaType(type), pos, name);
                    if (in_legal && !out_legal) {
                        message = message + " " + SemanticErrors.notLegalAsOut();
                    } else if (!in_legal && out_legal) {
                        message = message + " " + SemanticErrors.notLegalAsIn();
                    }
                    this.logWarning(message);
                }
            }
        }
    }

    public boolean prepare() throws ConfigurationException {
        super.prepare();
        String context = "";
        Enumeration ce = this.exec_elem.getContextExprList();
        Parselet context_parselet = null;
        Parselet executor_parselet = null;
        if (ce.hasMoreElements()) {
            context_parselet = (Parselet)ce.nextElement();
            if (ce.hasMoreElements()) {
                executor_parselet = (Parselet)ce.nextElement();
                if (ce.hasMoreElements()) {
                    this.logError(SemanticErrors.tooManyContexts());
                }
            }
        }
        if (context_parselet != null && executor_parselet == null) {
            try {
                JSClass aClass = ((ExpressionDescriptor)context_parselet.getDescriptor()).getReflection();
                if (aClass != JSClass.null_TYPE && JSClass.ExecutionContext_TYPE.isAssignableFrom(aClass)) {
                    executor_parselet = context_parselet;
                    context_parselet = null;
                }
            }
            catch (ClassNotFoundException exn) {
                LOCATION.catching((Throwable)exn);
            }
        }
        if (context_parselet != null) {
            try {
                JSClass ctx = ((ExpressionDescriptor)context_parselet.getDescriptor()).getReflection();
                context = ctx.getName();
                if (JSClass.ConnectionContext_TYPE.isAssignableFrom(ctx) && ctx != JSClass.null_TYPE) {
                    if (ctx == JSClass.ConnectionContext_TYPE) {
                        this.logError(SemanticErrors.notContextSubtype(context));
                    }
                } else {
                    this.logError(SemanticErrors.notContextType(context));
                }
            }
            catch (ClassNotFoundException exn) {
                LOCATION.catching((Throwable)exn);
                if (context_parselet instanceof SimpleNameNode) {
                    this.logError(SemanticErrors.message("contextNoType", ((SimpleNameNode)context_parselet).getText()));
                }
                this.logError(SemanticErrors.notContextType());
            }
        }
        if (executor_parselet != null) {
            ExpressionDescriptor descriptor = (ExpressionDescriptor)executor_parselet.getDescriptor();
            try {
                JSClass ctx = descriptor.getReflection();
                if (!JSClass.ExecutionContext_TYPE.isAssignableFrom(ctx) || ctx == JSClass.null_TYPE) {
                    this.logError(SemanticErrors.notExecutorType(ctx.getName()));
                }
            }
            catch (ClassNotFoundException exn) {
                exn.printStackTrace();
                LOCATION.catching((Throwable)exn);
                this.logError(SemanticErrors.notExecutorName(descriptor.getName()));
            }
        }
        JSClass result_type = null;
        if (this.m_so == null && this.exec_elem.getResultExpr() != null) {
            try {
                ExpressionDescriptor ed = (ExpressionDescriptor)this.exec_elem.getResultExpr().getDescriptor();
                result_type = ed.getReflection();
                if (!(ed instanceof LValueDescriptor)) {
                    this.logError(SemanticErrors.resultMustBeLvalue());
                }
            }
            catch (ClassNotFoundException exn) {
                LOCATION.catching((Throwable)exn);
                this.logError(SemanticErrors.lhsNotJavaType());
                result_type = TypeProperties.Invalid_TYPE;
            }
        }
        if (this.m_so == null) {
            this.m_so = new SQLOperationImpl(this.m_el, this.exec_elem.getSQL(), result_type, this.saf);
        }
        boolean invalid_sql_operation = false;
        int i = 1;
        while (i <= this.m_so.hostItemCount()) {
            HostItem hi = this.m_so.hostItem(i);
            JSClass type = hi.getHostItemType();
            if (type == null) {
                this.logError(SemanticErrors.invalidJavaTypeForHostItem(i, hi.getHostItemName()));
                invalid_sql_operation = true;
            }
            ++i;
        }
        Enumeration te = this.m_so.tokens();
        Token startToken = this.nextToken(te);
        if (startToken.getType() == 392) {
            this.m_so.setOperationCode(1022);
            startToken = this.nextToken(te);
            if (startToken.getType() == 1) {
                this.logError(SemanticErrors.expectCursorHostItem());
            } else if (startToken.getType() != 127) {
                this.logError(SemanticErrors.expectCursorHostItem(startToken.getText()));
            } else {
                startToken = this.nextToken(te);
                if (startToken.getType() != 1) {
                    this.logError(SemanticErrors.expectEndOfFetch(startToken.getText()));
                } else if (this.m_so.hostItemCount() != 1) {
                    this.logError(SemanticErrors.internalError("ExecAnalysis-1"));
                } else {
                    JSClass curtype = this.m_so.hostItem(1).getHostItemType();
                    this.m_so.hostItem(1).setHostItemMode(1);
                    if (curtype == null) {
                        this.logError(SemanticErrors.invalidFetchCursor());
                    } else if (JSClass.PositionedIterator_TYPE.isAssignableFrom(curtype)) {
                        Enumeration e;
                        JSClass[] columnTypes = null;
                        int maxindex = 0;
                        JSMethod[] methods = curtype.getDeclaredMethods();
                        columnTypes = new JSClass[methods.length];
                        int i2 = 0;
                        while (i2 < methods.length) {
                            String name = methods[i2].getName();
                            int num_params = methods[i2].getParameterTypes().length;
                            JSClass javaType = methods[i2].getReturnType();
                            if (num_params > 0 || !name.startsWith("getCol")) break;
                            Integer pos = Integer.valueOf(name.substring(6));
                            int j = 0;
                            if (pos != null) {
                                j = pos;
                            }
                            if (j < 1 || j > methods.length) {
                                this.logError(SemanticErrors.internalError("ExecAnalysis-2"));
                            }
                            if (j > maxindex) {
                                maxindex = j;
                            }
                            columnTypes[j - 1] = javaType;
                            ++i2;
                        }
                        if ((e = this.exec_elem.getSQL().getBindExprs()).hasMoreElements()) {
                            e.nextElement();
                        } else {
                            this.logError(SemanticErrors.noIntoAfterFetch());
                        }
                        int intoCount = 0;
                        try {
                            IntoBindExpr ibe = (IntoBindExpr)e.nextElement();
                            e = ibe.getParselets();
                            TypeProperties tp = new TypeProperties();
                            while (e.hasMoreElements()) {
                                ++intoCount;
                                JSClass t = null;
                                TypeDescriptor td = ((Parselet)e.nextElement()).getDescriptor();
                                if (td != null && td instanceof ExpressionDescriptor) {
                                    t = ((ExpressionDescriptor)td).getReflection();
                                }
                                if (columnTypes != null && intoCount > maxindex) {
                                    this.logError(SemanticErrors.tooManyINTOItems(intoCount, maxindex));
                                }
                                if (t == null) {
                                    this.logError(SemanticErrors.invalidJavaTypeForINTOItem(intoCount));
                                } else if (!JSClass.ResultSet_TYPE.hasAccessTo(t)) {
                                    this.logError(SemanticErrors.inaccessibleJavaTypeForINTOItem(intoCount, TypeProperties.printJavaType(t)));
                                }
                                if (columnTypes == null || intoCount > maxindex || t == null || columnTypes[intoCount - 1] == t) continue;
                                this.logError(SemanticErrors.intoTypeMismatch(intoCount, columnTypes[intoCount - 1].getName(), t.getName()));
                            }
                        }
                        catch (Exception exn) {
                            LOCATION.catching((Throwable)exn);
                            this.logError(SemanticErrors.expectINTOBindExpression());
                        }
                        if (columnTypes != null && maxindex > intoCount) {
                            StringBuffer signature = new StringBuffer();
                            int i3 = intoCount;
                            while (i3 < maxindex) {
                                signature.append(columnTypes[i3].getName());
                                if (i3 < maxindex - 1) {
                                    signature.append(", ");
                                }
                                ++i3;
                            }
                            if (maxindex - intoCount == 1) {
                                this.logError(SemanticErrors.missingIntoElements(signature.toString()));
                            } else {
                                this.logError(SemanticErrors.missingIntoElements(maxindex - intoCount, signature.toString()));
                            }
                        }
                    } else {
                        this.logError(SemanticErrors.invalidFetchCursor(curtype.getName()));
                    }
                    if (context != null && !context.equals("")) {
                        this.logWarning(SemanticErrors.contextIgnored(context));
                    }
                }
            }
        } else if (startToken.getType() == 216) {
            this.m_so.setOperationCode(18);
            startToken = this.nextToken(te);
            if (startToken.getType() == 1) {
                this.logError(SemanticErrors.expectCastResultSet(null));
            } else if (startToken.getType() != 127) {
                this.logError(SemanticErrors.expectCastResultSet(startToken.getText()));
            } else {
                this.m_so.hostItem(1).setHostItemMode(1);
                JSClass casttype = this.m_so.hostItem(1).getHostItemType();
                if (casttype == null) {
                    this.logError(SemanticErrors.invalidCastType(null));
                } else if (!JSClass.ResultSet_TYPE.isAssignableFrom(casttype)) {
                    this.logError(SemanticErrors.invalidCastType(casttype.getName()));
                }
                startToken = this.nextToken(te);
                if (startToken.getType() != 1) {
                    this.logError(SemanticErrors.expectEndOfCast(startToken.getText()));
                }
            }
            JSClass lhs = this.m_so.getResultType();
            if (lhs == null) {
                this.logError(SemanticErrors.expectCastAssignmentToIterator(null));
            } else if (lhs != TypeProperties.Invalid_TYPE && !TypeProperties.isCursorType(lhs)) {
                this.logError(SemanticErrors.expectCastAssignmentToIterator(lhs.getName()));
            }
            this.exec_elem.getSQL().insertBindExprAt(ReturnBindExpr.QUERY_RETURN, 1);
        } else if (!invalid_sql_operation) {
            SQLChecker checker = this.saf.m_cm.getSQLChecker(context, this.m_el);
            if (checker != null) {
                checker.describeSQLOperation(this.m_el, this.m_so);
                this.performWork(result_type, checker);
                if (this.m_so.getOperationCode() != 9 && (context == null || context.equals(""))) {
                    this.logError(SemanticErrors.message("usesDefaultContext"));
                }
            } else {
                this.unpreparable = true;
            }
        }
        if (this.m_el.errorCount() > 0) {
            this.unpreparable = true;
        }
        return !this.unpreparable;
    }

    private Token nextToken(Enumeration te) {
        if (te.hasMoreElements()) {
            return (Token)te.nextElement();
        }
        return EOF;
    }

    private void performWork(JSClass result_type, SQLChecker checker) {
        String name;
        int i;
        if (result_type != null && this.m_so.getOperationCode() == 2 && JSClass.ForUpdate_TYPE.isAssignableFrom(result_type)) {
            this.m_so.setOperationCode(7);
        }
        if (this.m_so.getOperationCode() == 2 && result_type != null && this.m_so.getResultType() == JSClass.ResultSetIterator_TYPE) {
            this.m_so.setOperationCode(19);
        }
        if (result_type == null && this.m_so.getResultType() != null) {
            int oper = this.m_so.getOperationCode();
            if (oper == 2) {
                this.m_so.setOperationCode(8);
            } else if (oper < 1024 && oper != 1022 && oper != 1023) {
                this.m_el.addEntry(new JSError(SemanticErrors.intoListRestriction()));
            }
        }
        int statement_type = this.m_so.getOperationCode();
        if (!this.unpreparable && this.m_el.errorCount() == 0) {
            boolean result_present;
            if (statement_type != 1023) {
                i = 1;
                while (i <= this.m_so.hostItemCount()) {
                    if (this.m_so.hostItem(i).getHostItemMode() == 0) {
                        if (statement_type != 4 && statement_type != 5 && statement_type != 9) {
                            this.logWarning(SemanticErrors.unassignedAssumeInMode(i, this.m_so.hostItem(i).getHostItemName()));
                            this.m_so.hostItem(i).setHostItemMode(1);
                        } else {
                            this.logError(SemanticErrors.unassignedMode(i, this.m_so.hostItem(i).getHostItemName()));
                        }
                    }
                    ++i;
                }
            }
            boolean bl = result_present = this.exec_elem.getResultExpr() != null;
            if (statement_type == 2 || statement_type == 7 || statement_type == 19 || statement_type == 5) {
                if (!result_present) {
                    if (statement_type == 2 || statement_type == 7 || statement_type == 19) {
                        this.logWarning(SemanticErrors.unassignedQueryValue());
                    } else {
                        this.logWarning(SemanticErrors.unassignedFunctionValue());
                    }
                } else {
                    if (statement_type == 2 || statement_type == 7 || statement_type == 19) {
                        this.exec_elem.getSQL().insertBindExprAt(ReturnBindExpr.QUERY_RETURN, 1);
                    } else {
                        this.exec_elem.getSQL().insertBindExprAt(ReturnBindExpr.COLUMN_RETURN, 1);
                    }
                    if (statement_type == 2 || statement_type == 19 || statement_type == 7) {
                        JSClass inhClass = this.m_so.getResultType();
                        if (inhClass == null) {
                            String msg = SemanticErrors.internalError("ExecAnalysis-4") + "Internal Error: return Type present, but not installed in SQLOperation";
                            this.logError(msg);
                            LOCATION.errorT(msg);
                        } else if (inhClass != TypeProperties.Invalid_TYPE) {
                            if (TypeProperties.isCursorType(inhClass)) {
                                JSClass enclosing;
                                try {
                                    enclosing = ((ClassDescriptor)this.exec_elem.getScope().getEnclosingClass().getDescriptor()).getReflection();
                                }
                                catch (ClassNotFoundException e) {
                                    LOCATION.catching((Throwable)e);
                                    enclosing = null;
                                }
                                if (enclosing != null && !enclosing.hasAccessTo(inhClass)) {
                                    this.logError(SemanticErrors.returnTypeNotVisible(TypeProperties.printJavaType(inhClass)));
                                }
                            } else {
                                this.logError(SemanticErrors.returnTypeNotACursor(TypeProperties.printJavaType(inhClass)));
                            }
                        }
                    }
                }
            } else if (result_present && statement_type != 1023 && statement_type != 18 && statement_type != 4 && statement_type < 1024) {
                this.logError(SemanticErrors.noReturn());
            }
        } else {
            this.unpreparable = true;
        }
        if (this.m_so.getOperationCode() != 1022) {
            i = 1;
            while (i <= this.m_so.hostItemCount()) {
                this.checkSQLJPrefix(this.m_so.hostItem(i).getHostItemName());
                JSClass type = this.m_so.hostItem(i).getHostItemType();
                if (type == null) break;
                int mode = this.m_so.hostItem(i).getHostItemMode();
                if (mode != 1 && !JSClass.ResultSet_TYPE.hasAccessTo(type)) {
                    this.logError(SemanticErrors.inaccessibleJavaTypeForHostItem(i, TypeProperties.printJavaType(type), this.m_so.hostItem(i).getHostItemName()));
                }
                if (this.m_so.getOperationCode() < 1024 && this.m_so.getOperationCode() != 18) {
                    this.checkHostItemType(type, mode, i, this.m_so.hostItem(i).getHostItemName(), false);
                }
                ++i;
            }
        }
        if (this.saf.getPortable() && this.m_so.getOperationCode() == 9) {
            Hashtable<String, Integer> namesIn = new Hashtable<String, Integer>();
            Hashtable<String, Integer> namesOut = new Hashtable<String, Integer>();
            int i2 = 1;
            while (i2 <= this.m_so.hostItemCount()) {
                name = this.m_so.hostItem(i2).getHostItemName();
                if (name != null) {
                    int first_pos = -1;
                    int mode = this.m_so.hostItem(i2).getHostItemMode();
                    if (mode == 1) {
                        if (namesOut.get(name) != null) {
                            first_pos = (Integer)namesOut.get(name);
                        }
                        namesIn.put(name, new Integer(i2));
                    } else if (mode == 4 || mode == 2) {
                        if (namesOut.get(name) != null) {
                            first_pos = (Integer)namesOut.get(name);
                        } else if (namesIn.get(name) != null) {
                            first_pos = (Integer)namesIn.get(name);
                        }
                        namesOut.put(name, new Integer(i2));
                    }
                    if (first_pos >= 0) {
                        this.logWarning(SemanticErrors.repeatedHostItem(name, first_pos, i2));
                    }
                }
                ++i2;
            }
        }
        if (this.m_so.getOperationCode() == 8) {
            JSClass intoList = this.m_so.getResultType();
            JSMethod[] methods = intoList.getDeclaredMethods();
            int i3 = 0;
            while (i3 < methods.length) {
                name = methods[i3].getName();
                int num_params = methods[i3].getParameterTypes().length;
                if (num_params > 0) break;
                int j = 0;
                if (!name.startsWith("getCol")) break;
                try {
                    j = Integer.parseInt(name.substring(6));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                JSClass javaType = methods[i3].getReturnType();
                if (j > 0) {
                    this.checkHostItemType(javaType, 4, j, null, true);
                }
                ++i3;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

