/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.ClassAnalysis;
import com.sap.sql.sqlj.semantics.SemanticAnalyzer;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.semantics.TypeProperties;
import com.sap.sql.sqlj.syntax.CursorElem;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.syntax.Type;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;

class CursorAnalysis
extends ClassAnalysis
implements SemanticAnalyzer {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$semantics$CursorAnalysis == null ? (class$com$sap$sql$sqlj$semantics$CursorAnalysis = CursorAnalysis.class$("com.sap.sql.sqlj.semantics.CursorAnalysis")) : class$com$sap$sql$sqlj$semantics$CursorAnalysis));
    private CursorElem cursor_elem;
    private static final String[] reservedMethods = new String[]{"next", "getResultSet", "isClosed", "close", "endFetch"};
    private static String SRRSI = "sqlj.runtime.ResultSetIterator";
    private static String SRRSIPref = SRRSI + ".";
    private static String RSI = "ResultSetIterator";
    private static String RSIPref = RSI + ".";
    private static String SENSITIVE = "SENSITIVE";
    private static String ASENSITIVE = "ASENSITIVE";
    private static String INSENSITIVE = "INSENSITIVE";
    static /* synthetic */ Class class$com$sap$sql$sqlj$semantics$CursorAnalysis;

    CursorAnalysis(Elem elem, SemanticAnalyzerFactory saf) {
        super(elem, saf);
        if (!(elem instanceof CursorElem)) {
            throw new IllegalArgumentException("CursorAnalysis(elem): not a CursorElem");
        }
        this.cursor_elem = (CursorElem)elem;
    }

    private boolean checkReservedMethods(String name) {
        int i = 0;
        while (i < reservedMethods.length) {
            if (reservedMethods[i].equals(name)) {
                this.logError(SemanticErrors.badMethod(name));
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkArgType(Type type, String name) {
        JSClass typeClass;
        if (type == null) {
            this.logError(SemanticErrors.internalError("CursorAnalysis-0"));
            return true;
        }
        try {
            typeClass = type.getClass(this.elem.getScope());
        }
        catch (ClassNotFoundException error) {
            LOCATION.catching((Throwable)error);
            this.logError(SemanticErrors.notJavaCursorColumn(name, type.getName()));
            return true;
        }
        catch (IllegalArgumentException error) {
            String msg = SemanticErrors.internalError("CursorAnalysis-1") + "Something else if fishy here, as well!";
            LOCATION.errorT(msg);
            LOCATION.catching((Throwable)error);
            this.logError(msg);
            return true;
        }
        if (!JSClass.ResultSet_TYPE.hasAccessTo(typeClass)) {
            this.logError(SemanticErrors.inaccessibleJavaTypeForColumn(TypeProperties.printJavaType(typeClass), name));
        }
        if (typeClass.isPrimitive() && !TypeProperties.isCursorColumnType(typeClass)) {
            this.logError(SemanticErrors.notValidCursorColumnType(name, TypeProperties.printJavaType(typeClass)));
        } else if (this.saf.getPortable() && !TypeProperties.isCursorColumnType(typeClass)) {
            this.logError(SemanticErrors.notJdbcCursorColumn(name, TypeProperties.printJavaType(typeClass)));
        }
        return false;
    }

    private void checkWithClause() {
        Enumeration fields = this.cursor_elem.getWithKeywords();
        while (fields.hasMoreElements()) {
            String f_name = (String)fields.nextElement();
            Parselet p = this.cursor_elem.getWithValue(f_name);
            ExpressionDescriptor ed = (ExpressionDescriptor)p.getDescriptor();
            JSClass f_type = null;
            try {
                f_type = ed.getReflection();
            }
            catch (ClassNotFoundException exn) {
                LOCATION.errorT("Unexpected ClassNotFoundException caught and ignored.");
                LOCATION.catching((Throwable)exn);
            }
            if (f_name.equals("sensitivity")) {
                int code;
                String value = ed.getName();
                Object theVal = ed.getValue();
                if (theVal != null && theVal instanceof Integer && ((code = ((Integer)theVal).intValue()) == 3 || code == 1 || code == 2) || value != null && (value.equals(SENSITIVE) || value.equals(ASENSITIVE) || value.equals(INSENSITIVE) || value.equals(SRRSIPref + SENSITIVE) || value.equals(SRRSIPref + ASENSITIVE) || value.equals(SRRSIPref + INSENSITIVE))) continue;
                boolean complain = true;
                if (value != null && (value.equals(RSIPref + SENSITIVE) || value.equals(RSIPref + ASENSITIVE) || value.equals(RSIPref + INSENSITIVE))) {
                    try {
                        ClassNameResolver cnr = this.cursor_elem.getScope().getClassResolver();
                        if (cnr.getClass(RSI).getName().equals(SRRSI)) {
                            complain = false;
                        }
                    }
                    catch (ClassNotFoundException exn) {
                        LOCATION.errorT("Unexpected ClassNotFoundException caught and ignored.");
                        LOCATION.catching((Throwable)exn);
                    }
                }
                if (!complain) continue;
                this.logError(SemanticErrors.invalidSensitivitySetting());
                continue;
            }
            if (f_name.equals("holdability") || f_name.equals("returnability")) {
                if (f_type == JSClass.boolean_TYPE) continue;
                this.logError(SemanticErrors.invalidBooleanSetting(f_name));
                continue;
            }
            if (f_name.equals("updateColumns")) {
                if (f_type != JSClass.String_TYPE) {
                    this.logError(SemanticErrors.updateColumnsNotString());
                }
                JSClass curClass = null;
                try {
                    curClass = ((ClassDescriptor)this.cursor_elem.getScope().getDescriptor()).getReflection();
                    if (JSClass.ForUpdate_TYPE.isAssignableFrom(curClass)) continue;
                    this.logError(SemanticErrors.updateColumnsNotForUpdate());
                }
                catch (ClassNotFoundException exn) {
                    String msg = SemanticErrors.internalError("CursorAnalysis-2") + "Internal error - unable to determine type of declared cursor!";
                    LOCATION.catching((Throwable)exn);
                    LOCATION.errorT(msg);
                    this.logError(msg);
                }
                continue;
            }
            if (!this.saf.getPortable()) continue;
            this.logWarning(SemanticErrors.nonStandardAttribute(f_name));
        }
    }

    private void checkNames() {
        Hashtable<String, String> usedArgNames = new Hashtable<String, String>();
        Enumeration enumeration = this.cursor_elem.getColumnNames();
        while (enumeration.hasMoreElements()) {
            String argName = (String)enumeration.nextElement();
            this.checkReservedMethods(argName);
            this.checkSQLJPrefix(argName);
            String ArgName = argName.toUpperCase();
            if (usedArgNames.get(ArgName) != null) {
                String otherName = (String)usedArgNames.get(ArgName);
                if (otherName.equals(argName)) {
                    this.logError(SemanticErrors.dupMethod(argName));
                } else {
                    this.logError(SemanticErrors.dupMethod(otherName, argName));
                }
            } else {
                usedArgNames.put(ArgName, argName);
            }
            this.checkArgType(this.cursor_elem.getColumnType(argName), argName);
        }
    }

    private void checkPositions() {
        Enumeration enumeration = this.cursor_elem.getColumnTypes();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Type argType = (Type)enumeration.nextElement();
            this.checkArgType(argType, String.valueOf(++count));
        }
    }

    public boolean prepare() {
        super.prepare();
        this.checkWithClause();
        if (this.cursor_elem.isByName()) {
            this.checkNames();
        } else {
            this.checkPositions();
        }
        return !this.unpreparable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

