/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.sqlj.common.CommonCheckerFactory;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.checker.SQLChecker;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.Info;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.ide.TranslationOptionsQuery;
import com.sap.sql.sqlj.framework.options.ConnectionFactory;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.framework.options.PropertyListImpl;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionManager {
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$semantics$ConnectionManager == null ? (class$com$sap$sql$sqlj$semantics$ConnectionManager = ConnectionManager.class$("com.sap.sql.sqlj.semantics.ConnectionManager")) : class$com$sap$sql$sqlj$semantics$ConnectionManager));
    private SemanticAnalyzerFactory m_saf = null;
    private TranslationOptionsQuery m_query_password = null;
    private static Integer FAILED = new Integer(0);
    private Map m_readers = null;
    private Map m_sql_checkers = new HashMap();
    static /* synthetic */ Class class$com$sap$sql$sqlj$semantics$ConnectionManager;

    ConnectionManager(SemanticAnalyzerFactory saf, Map presetCatalogReaders) {
        this.m_saf = saf;
        this.m_readers = presetCatalogReaders != null ? presetCatalogReaders : new HashMap();
    }

    public SQLChecker getSQLChecker(String context, ErrorLog el) throws ConfigurationException {
        Object result;
        if (context == null) {
            context = "";
        }
        if ((result = this.m_sql_checkers.get(context)) == null) {
            result = this.doGetSQLChecker(context, el);
            if (result == null && !context.equals("")) {
                result = this.doGetSQLChecker("", el);
            }
            if (result == null) {
                this.m_sql_checkers.put(context, FAILED);
                el.addEntry(new JSError(SemanticErrors.message("connectFailed")));
                return null;
            }
            this.m_sql_checkers.put(context, result);
            return (SQLChecker)result;
        }
        if (result == FAILED) {
            return null;
        }
        return (SQLChecker)result;
    }

    public void registerOptionsQuery(TranslationOptionsQuery qp) {
        if (qp != null) {
            this.m_connFact.setOptionsQuery(qp);
        }
    }

    private SQLChecker doGetSQLChecker(String context, ErrorLog el) throws ConfigurationException {
        CatalogReader reader = this.doGetReader(context, el);
        if (reader == null) {
            return null;
        }
        return this.doGetOnlineSQLChecker(reader, el);
    }

    private SQLChecker doGetOnlineSQLChecker(CatalogReader reader, ErrorLog el) {
        try {
            CommonCheckerFactory checkerFactory = new CommonCheckerFactory();
            SQLChecker checker = checkerFactory.getOnlineChecker(reader);
            if (checker != null) {
                checker.setOptions(this.getCheckerPropertyList(), el);
            }
            return checker;
        }
        catch (InvalidOptionException exn) {
            String msg = "Internal error: InvalidOptionException in doGetOnlineSQLChecker() should not occur: " + exn.getMessage();
            LOCATION.traceThrowableT(500, msg, (Throwable)exn);
            throw new IllegalStateException(msg);
        }
    }

    private PropertyList getCheckerPropertyList() {
        PropertyListImpl props = new PropertyListImpl();
        int count = 3;
        if (this.m_saf.getVerbose()) {
            ++count;
        }
        if (this.m_saf.getNulls()) {
            ++count;
        }
        if (this.m_saf.getPrecision()) {
            ++count;
        }
        if (this.m_saf.getPortable()) {
            ++count;
        }
        if (this.m_saf.getStrict()) {
            ++count;
        }
        String[] keys = new String[count];
        keys[0] = "default-procedure-mode=" + String.valueOf(this.m_saf.getDefaultProcedureMode());
        keys[1] = "default-function-mode=" + String.valueOf(this.m_saf.getDefaultFunctionMode());
        keys[2] = "default-block-mode=" + String.valueOf(this.m_saf.getDefaultBlockMode());
        int i = 3;
        if (this.m_saf.getVerbose()) {
            keys[i] = "verbose";
            ++i;
        }
        if (this.m_saf.getNulls()) {
            keys[i] = "null";
            ++i;
        }
        if (this.m_saf.getPrecision()) {
            keys[i] = "precision";
            ++i;
        }
        if (this.m_saf.getPortable()) {
            keys[i] = "portable";
            ++i;
        }
        if (this.m_saf.getStrict()) {
            keys[i] = "strict";
            ++i;
        }
        props.addProperty(keys, "Internal");
        return props;
    }

    /*
     * Unable to fully structure code
     */
    private CatalogReader doGetReader(String context, ErrorLog el) throws ConfigurationException {
        obj = this.m_readers.get(context);
        if (obj == ConnectionManager.FAILED) {
            return null;
        }
        if (obj != null) {
            return (CatalogReader)obj;
        }
        catalogReaderString = this.m_saf.getCatalogReader(context);
        user = this.m_saf.getUser(context);
        password = this.m_saf.getPassword(context);
        if (catalogReaderString == null) {
            this.m_readers.put(context, ConnectionManager.FAILED);
            return null;
        }
        this.m_connFact.setCatalogReader(catalogReaderString);
        this.m_connFact.setUser(user);
        this.m_connFact.setPassword(password);
        this.m_connFact.setDrivers(this.m_saf.getDrivers());
        user_reader = this.m_connFact.toString();
        try {
            reader = this.m_connFact.getCatalogReader(el);
            this.m_readers.put(context, reader);
            if (this.m_saf.getVerbose()) {
                el.addEntry(new Info(SemanticErrors.message("connectedSuccessfully", context, catalogReaderString)));
            }
            return reader;
        }
        catch (SQLException exn) {
            ** while (exn != null)
        }
lbl-1000:
        // 1 sources

        {
            ConnectionManager.LOCATION.catching((Throwable)exn);
            msg = exn.getMessage();
            txt = SemanticErrors.message("unableToAnalyzeConnection", catalogReaderString, msg);
            ConnectionManager.LOCATION.errorT(txt);
            el.addEntry(new JSError(txt));
            ConnectionManager.LOCATION.catching((Throwable)exn);
            exn = exn.getNextException();
            if (exn == null) continue;
            ConnectionManager.LOCATION.errorT("next SQLException:");
            continue;
        }
lbl41:
        // 1 sources

        this.m_readers.put(context, ConnectionManager.FAILED);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

