/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.ref;

import com.sap.sql.sqlj.runtime.ref.RuntimeRefErrors;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;

public class ProfileGroup {
    Hashtable m_profileKeys = new Hashtable();
    Vector m_profiles = new Vector();
    Vector m_connGroups = new Vector();

    public synchronized Object getProfileKey(Loader loader, String profileName) throws SQLException {
        Integer key = (Integer)this.m_profileKeys.get(profileName);
        if (key == null) {
            Profile profile = null;
            try {
                profile = Profile.instantiate(loader, profileName);
            }
            catch (ClassNotFoundException e) {
                RuntimeRefErrors.raise_PROFILE_NOT_FOUND(profileName, e);
            }
            catch (IOException e) {
                RuntimeRefErrors.raise_PROFILE_NOT_FOUND(profileName, e);
            }
            key = new Integer(this.m_profiles.size());
            this.m_profileKeys.put(profileName, key);
            this.m_profiles.addElement(profile);
            Enumeration enumeration = this.m_connGroups.elements();
            while (enumeration.hasMoreElements()) {
                ((ConnectedGroup)enumeration.nextElement()).addProfile();
            }
        }
        return key;
    }

    public Profile getProfile(Object key) {
        if (key == null || !(key instanceof Integer)) {
            throw new IllegalArgumentException(key + "");
        }
        return (Profile)this.m_profiles.elementAt((Integer)key);
    }

    public synchronized ConnectedGroup addConnection(Connection conn) {
        ConnectedGroup connGroup = new ConnectedGroup(conn);
        this.m_connGroups.addElement(connGroup);
        return connGroup;
    }

    private synchronized void removeConnection(ConnectedGroup group) {
        this.m_connGroups.removeElement(group);
    }

    class ConnectedGroup {
        private Connection m_conn;
        private Vector m_connProfiles = new Vector();

        ConnectedGroup(Connection conn) {
            this.m_conn = conn;
            int i = ProfileGroup.this.m_profiles.size();
            while (i > 0) {
                this.addProfile();
                --i;
            }
        }

        public void addProfile() {
            this.m_connProfiles.addElement(null);
        }

        public ConnectedProfile getProfile(Object key) throws SQLException {
            if (key == null || !(key instanceof Integer)) {
                throw new IllegalArgumentException(key + "");
            }
            int ndx = (Integer)key;
            ConnectedProfile connProfile = (ConnectedProfile)this.m_connProfiles.elementAt(ndx);
            if (connProfile == null) {
                Profile profile = (Profile)ProfileGroup.this.m_profiles.elementAt(ndx);
                connProfile = profile.getConnectedProfile(this.m_conn);
                this.m_connProfiles.setElementAt(connProfile, ndx);
            }
            return connProfile;
        }

        public void close() throws SQLException {
            ProfileGroup.this.removeConnection(this);
            Enumeration enumeration = this.m_connProfiles.elements();
            while (enumeration.hasMoreElements()) {
                ConnectedProfile profile = (ConnectedProfile)enumeration.nextElement();
                if (profile == null) continue;
                profile.close();
            }
        }
    }
}

