/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.util;

import com.sap.sql.sqlj.runtime.profile.util.Auditor;
import java.io.PrintWriter;
import java.util.Hashtable;

public class PrintWriterAuditor
implements Auditor {
    private String m_prefix;
    private Hashtable m_objectHashes = new Hashtable();
    private static final Counter m_objCount = new Counter();
    private PrintWriter m_ps;

    public PrintWriterAuditor(PrintWriter ps) {
        this(ps, "");
    }

    public PrintWriterAuditor(PrintWriter ps, String prefix) {
        this.m_ps = ps;
        this.m_prefix = prefix;
    }

    private void printValue(Object obj) {
        String objStr = obj + "";
        int ndx = this.getAddressIndex(objStr, obj);
        if (ndx != -1) {
            String hashName = (String)this.m_objectHashes.get(objStr);
            if (hashName == null) {
                hashName = objStr.substring(0, ndx + 1) + m_objCount.getNewCount();
                this.m_objectHashes.put(objStr, hashName);
            }
            objStr = hashName;
        }
        this.m_ps.print(objStr);
    }

    private int getAddressIndex(String objStr, Object obj) {
        int ndx = objStr.indexOf(64);
        if (ndx != -1 && objStr.equals(obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode()))) {
            return ndx;
        }
        return -1;
    }

    public void registerCall(Object obj, String methodName, Object[] args) {
        this.m_ps.print(this.m_prefix);
        this.printValue(obj);
        this.m_ps.print(" . " + methodName + " ( ");
        int i = 0;
        while (i < args.length) {
            this.printValue(args[i]);
            if (++i >= args.length) break;
            this.m_ps.print(" , ");
        }
        this.m_ps.println(" )");
    }

    public void registerReturn(Object obj, String methodName, Object returnVal) {
        this.m_ps.print(this.m_prefix);
        this.printValue(obj);
        this.m_ps.print(" . " + methodName + " returned ");
        if (returnVal != Auditor.VOID_RETURN) {
            this.printValue(returnVal);
        }
        this.m_ps.println();
    }

    public void registerException(Object obj, String methodName, Exception e) {
        this.m_ps.print(this.m_prefix);
        this.printValue(obj);
        this.m_ps.print(" . " + methodName + " threw exception ");
        this.printValue(e);
        this.m_ps.println();
    }

    private static class Counter {
        private int m_numObjs = 0;

        private Counter() {
        }

        public synchronized int getNewCount() {
            return ++this.m_numObjs;
        }
    }
}

