/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.util;

import com.sap.sql.sqlj.runtime.profile.ref.EntryInfoImpl;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileDataImpl;
import com.sap.sql.sqlj.runtime.profile.ref.TypeInfoImpl;
import java.io.FileInputStream;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.TypeInfo;

public class DataCustomizer {
    public static final int RESULT = 1;
    public static final int PARAM = 2;

    public ProfileData customizeData(ProfileData data) {
        boolean changed = false;
        int size = data.size();
        EntryInfo[] entries = new EntryInfo[size];
        int i = 0;
        while (i < size) {
            EntryInfo oldEntry = data.getEntryInfo(i);
            entries[i] = this.customizeEntry(data, oldEntry, i);
            if (oldEntry != entries[i]) {
                changed = true;
            }
            ++i;
        }
        String sourceFile = this.customizeSourceFile(data);
        if (!this.equal(sourceFile, data.getSourceFile())) {
            changed = true;
        }
        if (changed) {
            return this.newProfileData(data, entries, data.getProfile(), sourceFile);
        }
        return data;
    }

    public String customizeSourceFile(ProfileData data) {
        return data.getSourceFile();
    }

    public ProfileData newProfileData(ProfileData origData, EntryInfo[] entries, Profile profile, String sourceFile) {
        return new ProfileDataImpl(entries, profile, sourceFile);
    }

    public EntryInfo customizeEntry(ProfileData data, EntryInfo entry, int entryNum) {
        String resultSetName;
        Object desc;
        int resultSetType;
        int role;
        int execType;
        int stmtType;
        boolean changed = false;
        String sqlString = this.customizeSQLString(data, entry, entryNum);
        if (!sqlString.equals(entry.getSQLString())) {
            changed = true;
        }
        if ((stmtType = this.customizeStatementType(data, entry, entryNum)) != entry.getStatementType()) {
            changed = true;
        }
        if ((execType = this.customizeExecType(data, entry, entryNum)) != entry.getExecuteType()) {
            changed = true;
        }
        if ((role = this.customizeRole(data, entry, entryNum)) != entry.getRole()) {
            changed = true;
        }
        if ((resultSetType = this.customizeResultSetType(data, entry, entryNum)) != entry.getResultSetType()) {
            changed = true;
        }
        if ((desc = this.customizeDescriptor(data, entry, entryNum)) != entry.getDescriptor()) {
            changed = true;
        }
        int numResults = entry.getResultSetCount();
        TypeInfo[] results = new TypeInfo[numResults];
        int i = 1;
        while (i <= numResults) {
            TypeInfo oldType = entry.getResultSetInfo(i);
            results[i - 1] = this.customizeType(data, entry, entryNum, oldType, i, 1);
            if (oldType != results[i - 1]) {
                changed = true;
            }
            ++i;
        }
        int numParams = entry.getParamCount();
        TypeInfo[] params = new TypeInfo[numParams];
        int i2 = 1;
        while (i2 <= numParams) {
            TypeInfo oldType = entry.getParamInfo(i2);
            params[i2 - 1] = this.customizeType(data, entry, entryNum, oldType, i2, 2);
            if (oldType != params[i2 - 1]) {
                changed = true;
            }
            ++i2;
        }
        int lineNumber = this.customizeLineNumber(data, entry, entryNum);
        if (lineNumber != entry.getLineNumber()) {
            changed = true;
        }
        if (!this.equal(resultSetName = this.customizeResultSetName(data, entry, entryNum), entry.getResultSetName())) {
            changed = true;
        }
        if (changed) {
            return this.newEntryInfo(data, entry, entryNum, sqlString, stmtType, execType, role, resultSetType, desc, params, results, lineNumber, resultSetName);
        }
        return entry;
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public EntryInfo newEntryInfo(ProfileData origData, EntryInfo origEntry, int entryNum, String sqlString, int stmtType, int execType, int role, int resultSetType, Object desc, TypeInfo[] params, TypeInfo[] results, int lineNumber, String resultSetName) {
        return new EntryInfoImpl(sqlString, stmtType, execType, role, resultSetType, desc, params, results, lineNumber, resultSetName);
    }

    public String customizeSQLString(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getSQLString();
    }

    public String customizeResultSetName(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getResultSetName();
    }

    public int customizeStatementType(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getStatementType();
    }

    public int customizeExecType(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getExecuteType();
    }

    public int customizeRole(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getRole();
    }

    public int customizeResultSetType(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getResultSetType();
    }

    public Object customizeDescriptor(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getDescriptor();
    }

    public int customizeLineNumber(ProfileData data, EntryInfo entry, int entryNum) {
        return entry.getLineNumber();
    }

    public TypeInfo customizeType(ProfileData data, EntryInfo entry, int entryNum, TypeInfo type, int typeNum, int typeRole) {
        int markerIndex;
        int mode;
        String name;
        String javaType;
        boolean changed = false;
        int sqlType = this.customizeSQLType(data, entry, entryNum, type, typeNum, typeRole);
        if (sqlType != type.getSQLType()) {
            changed = true;
        }
        if (!(javaType = this.customizeJavaTypeName(data, entry, entryNum, type, typeNum, typeRole)).equals(type.getJavaTypeName())) {
            changed = true;
        }
        if ((name = this.customizeName(data, entry, entryNum, type, typeNum, typeRole)) != type.getName() && !name.equals(type.getName())) {
            changed = true;
        }
        if ((mode = this.customizeMode(data, entry, entryNum, type, typeNum, typeRole)) != type.getMode()) {
            changed = true;
        }
        if ((markerIndex = this.customizeMarkerIndex(data, entry, entryNum, type, typeNum, typeRole)) != type.getMarkerIndex()) {
            changed = true;
        }
        if (changed) {
            return this.newTypeInfo(data, entry, entryNum, type, typeNum, typeRole, javaType, sqlType, name, mode, markerIndex);
        }
        return type;
    }

    public TypeInfo newTypeInfo(ProfileData origData, EntryInfo origEntry, int entryNum, TypeInfo origType, int typeNum, int typeRole, String javaType, int sqlType, String name, int mode, int markerIndex) {
        return new TypeInfoImpl(javaType, sqlType, name, mode, markerIndex);
    }

    public int customizeSQLType(ProfileData data, EntryInfo entry, int entryNum, TypeInfo type, int typeNum, int typeRole) {
        return type.getSQLType();
    }

    public String customizeJavaTypeName(ProfileData data, EntryInfo entry, int entryNum, TypeInfo type, int typeNum, int typeRole) {
        return type.getJavaTypeName();
    }

    public String customizeName(ProfileData data, EntryInfo entry, int entryNum, TypeInfo type, int typeNum, int typeRole) {
        return type.getName();
    }

    public int customizeMode(ProfileData data, EntryInfo entry, int entryNum, TypeInfo type, int typeNum, int typeRole) {
        return type.getMode();
    }

    public int customizeMarkerIndex(ProfileData data, EntryInfo entry, int entryNum, TypeInfo type, int typeNum, int typeRole) {
        return type.getMarkerIndex();
    }

    public static void main(String[] args) throws Exception {
        DataCustomizer c;
        if (args.length != 1) {
            System.out.println("usage: DataCustomizer profileName.ser");
            return;
        }
        Profile p = Profile.instantiate(null, new FileInputStream(args[0]));
        ProfileData data = p.getProfileData();
        if (data != (c = new DataCustomizer()).customizeData(data)) {
            System.out.println("failed");
        } else {
            System.out.println("success");
        }
    }
}

