/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.javac;

import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.javac.CopyOut;
import com.sap.sql.sqlj.javac.JavaParserImplTokenManager;
import com.sap.sql.sqlj.javac.JavaParserSub;
import com.sap.sql.sqlj.javac.LinefeedFilter;
import com.sap.sql.sqlj.javac.PrefixFilter;
import com.sap.sql.sqlj.javac.Token;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.DefaultParselet;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.ParseContext;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import com.sap.sql.sqlj.util.io.CharStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

class JavaParserSubTokenManager
extends JavaParserImplTokenManager {
    JavaParserSub parser;
    private Copying m_copy = new Copying();
    private ParseContext m_ctx;

    JavaParserSubTokenManager(CharStream cs, JavaParserSub j) {
        super(cs);
        this.parser = j;
    }

    public void ReInit(CharStream stream) {
        super.ReInit(stream);
        this.m_copy = new Copying();
    }

    public CopyOut getCopyOut() {
        return this.m_copy;
    }

    void setParseContext(ParseContext ctx) {
        this.m_ctx = ctx;
    }

    public Token getNextToken() {
        Token t = super.getNextToken();
        if (t.kind != 132) {
            if (t.specialToken != null) {
                t.specialToken.image = t.specialToken.image.intern();
            }
            t.image = t.image.intern();
            this.m_copy.addToken(t);
        }
        return t;
    }

    private void Error(String s, Token t) {
        this.parser.Error(s, t);
    }

    class TokenManagerParselet
    extends DefaultParselet {
        private Vector m_children = new Vector();

        TokenManagerParselet(Vector v) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Parselet p = (Parselet)e.nextElement();
                this.m_children.addElement(p);
            }
        }

        public boolean generate(OutputContext octx) throws IOException, ConfigurationException {
            boolean success = true;
            int i = 0;
            while (i < this.m_children.size()) {
                Parselet p = (Parselet)this.m_children.elementAt(i);
                success = p.generate(octx) && success;
                ++i;
            }
            return success;
        }
    }

    class StringParselet
    extends DefaultParselet {
        private Vector m_string;
        private int m_startline;
        private int m_startcol;
        private int m_endline;
        private int m_endcol;

        StringParselet(Vector s, int startline, int startcol, int endline, int endcol) {
            this.m_string = s;
            this.m_startline = startline;
            this.m_startcol = startcol;
            this.m_endline = endline;
            this.m_endcol = endcol;
        }

        public boolean generate(OutputContext ctx) throws IOException {
            boolean protocol;
            LinefeedFilter w = new LinefeedFilter(ctx.getWriter());
            boolean bl = protocol = this.m_startline >= 0 && (this.m_startline != this.m_endline || this.m_startcol != this.m_endcol);
            if (protocol) {
                w.write("/*@lineinfo:user-code*/");
                w.write("/*@lineinfo:" + this.m_startline + "^" + this.m_startcol + "*/");
            }
            Enumeration e = this.m_string.elements();
            while (e.hasMoreElements()) {
                w.write(e.nextElement().toString());
            }
            if (protocol) {
                w.write("/*@lineinfo:generated-code*/");
            }
            return true;
        }
    }

    class PositionedParselet
    implements Parselet {
        private Parselet m_p;
        private String m_prefix;

        PositionedParselet(Parselet p, int line, int col) {
            this.m_p = p;
            this.m_prefix = "/*@lineinfo:" + line + "^" + col + "*/";
        }

        public boolean generate(OutputContext ctx) throws IOException, ConfigurationException {
            return this.m_p.generate(new ModifiedContext(ctx));
        }

        public void setScope(Parselet scope) {
            this.m_p.setScope(scope);
        }

        public Parselet getScope() {
            return this.m_p.getScope();
        }

        public Parselet getEnclosingClass() {
            return this.m_p.getEnclosingClass();
        }

        public Parselet getDefiningUnit() {
            return this.m_p.getDefiningUnit();
        }

        public void setInfo(Object o) {
            this.m_p.setInfo(o);
        }

        public Object getInfo() {
            return this.m_p.getInfo();
        }

        public TypeDescriptor getDescriptor() {
            return this.m_p.getDescriptor();
        }

        public ClassNameResolver getClassResolver() {
            return this.m_p.getClassResolver();
        }

        class ModifiedContext
        implements OutputContext {
            OutputContext m_ctx;
            Writer m_w;

            ModifiedContext(OutputContext ctx) {
                this.m_ctx = ctx;
                this.m_w = new PrefixFilter(ctx.getWriter(), PositionedParselet.this.m_prefix);
            }

            public Writer getWriter() {
                return this.m_w;
            }

            public OutputStream createOutputStream(String filename) throws IOException {
                return this.m_ctx.createOutputStream(filename);
            }
        }
    }

    class Copying
    implements CopyOut {
        private Vector m_parselets;
        private Vector m_tokenbuff = new Vector();
        private boolean m_copying = true;
        private int m_startline = 1;
        private int m_startcol = 1;
        private boolean seenSQL = false;

        Copying() {
            this.m_parselets = new Vector();
        }

        public void addParselet(Parselet p, int line, int col) {
            this.m_parselets.addElement(new PositionedParselet(p, line, col));
        }

        public void startCopying() {
            this.m_copying = true;
            this.m_startline = JavaParserSubTokenManager.this.m_ctx.getCharStream().getEndLine();
            this.m_startcol = JavaParserSubTokenManager.this.m_ctx.getCharStream().getEndColumn();
        }

        public void endCopying() {
            this.m_copying = false;
            this.m_parselets.addElement(new StringParselet(this.m_tokenbuff, this.m_startline, this.m_startcol, JavaParserSubTokenManager.this.m_ctx.getCharStream().getBeginLine(), JavaParserSubTokenManager.this.m_ctx.getCharStream().getBeginColumn()));
            this.m_tokenbuff = new Vector();
        }

        void addToken(Token t) {
            Token tmp_t = t.specialToken;
            if (tmp_t != null) {
                while (tmp_t.specialToken != null) {
                    tmp_t = tmp_t.specialToken;
                }
            }
            while (tmp_t != null) {
                if (t.kind != 0) {
                    this.m_tokenbuff.addElement(tmp_t.image);
                }
                tmp_t = tmp_t.next;
            }
            if (!t.image.equals("#sql")) {
                if (!this.seenSQL || !t.image.equals(";")) {
                    this.m_tokenbuff.addElement(t.image);
                }
                this.seenSQL = false;
            } else {
                this.seenSQL = true;
            }
        }

        public Parselet getParselet() {
            if (this.m_copying) {
                this.endCopying();
            }
            return new TokenManagerParselet(this.m_parselets);
        }
    }
}

