/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework.options;

import com.sap.sql.sqlj.framework.options.PropertyList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PropertyListImpl
implements PropertyList {
    private Hashtable m_props = new Hashtable();
    private PropertyListImpl m_defaults;

    public PropertyListImpl() {
        this(null);
    }

    public PropertyListImpl(PropertyListImpl defaults) {
        this.m_defaults = defaults;
    }

    public void addProperty(String key, String value, String location) {
        this.m_props.put(key, new Entry(value, location));
    }

    public void addProperty(Properties props, String location) {
        Enumeration keys = ((Hashtable)props).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.addProperty(key, props.getProperty(key), location);
        }
    }

    public void addProperty(String[] props, String location) {
        int i = 0;
        while (i < props.length) {
            this.addProperty(props[i], location);
            ++i;
        }
    }

    public void addProperty(String prop, String location) {
        String value;
        String key;
        int ndx = prop.indexOf(61);
        if (ndx == -1) {
            key = prop;
            value = "";
        } else {
            key = prop.substring(0, ndx);
            value = prop.substring(ndx + 1);
        }
        this.addProperty(key, value, location);
    }

    public String getProperty(String key) {
        Entry e = this.getEntry(key);
        return e == null ? null : e.value();
    }

    public String getPropertyLocation(String key) {
        Entry e = this.getEntry(key);
        return e == null ? null : e.location();
    }

    public boolean propertyWasRead(String key) {
        Entry e = this.getEntry(key);
        return e == null ? false : e.wasRead();
    }

    public Enumeration propertyNames() {
        Hashtable h = new Hashtable();
        this.enumerateKeys(h);
        return h.keys();
    }

    public Enumeration propertyNames(boolean wasRead) {
        return new StatusEnumeration(wasRead);
    }

    private Entry getEntry(String key) {
        Entry e = (Entry)this.m_props.get(key);
        if (e == null && this.m_defaults != null) {
            e = this.m_defaults.getEntry(key);
        }
        return e;
    }

    private void enumerateKeys(Hashtable h) {
        if (this.m_defaults != null) {
            this.m_defaults.enumerateKeys(h);
        }
        Enumeration e = this.m_props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            h.put(key, key);
        }
    }

    private static class Entry {
        private String m_value;
        private String m_location;
        private boolean m_wasRead;

        public Entry(String value, String location) {
            this.m_value = value;
            this.m_wasRead = false;
            this.m_location = location;
        }

        public Entry(Entry other) {
            this.m_value = other.m_value;
            this.m_wasRead = false;
            this.m_location = other.m_location;
        }

        public String value() {
            this.m_wasRead = true;
            return this.m_value;
        }

        public boolean wasRead() {
            return this.m_wasRead;
        }

        public String location() {
            return this.m_location;
        }
    }

    private class StatusEnumeration
    implements Enumeration {
        private boolean m_wasRead;
        private Enumeration m_keys;
        private String m_key;

        public StatusEnumeration(boolean wasRead) {
            this.m_keys = PropertyListImpl.this.propertyNames();
            this.m_key = null;
            this.m_wasRead = wasRead;
        }

        public boolean hasMoreElements() {
            while (this.m_keys.hasMoreElements()) {
                this.m_key = (String)this.m_keys.nextElement();
                if (PropertyListImpl.this.getEntry(this.m_key).wasRead() != this.m_wasRead) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            return this.m_key;
        }
    }
}

