/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework.ide;

import com.sap.sql.catalog.CatalogReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class Options {
    public static final int WARN_VERBOSE = 1;
    public static final int WARN_PRECISION = 2;
    public static final int WARN_NULLS = 4;
    public static final int WARN_PORTABLE = 8;
    public static final int WARN_STRICT = 16;
    public static final int WARN_NONE = 0;
    public static final int WARN_ALL = 31;
    private Properties m_props = new Properties();
    private Map m_catalogReaders;

    public void setWarn(int warn_flags) throws IllegalArgumentException {
        String key = "warn";
        String warn = "none,";
        warn = warn + ((warn_flags & 1) == 1 ? "verbose," : "noverbose,");
        warn = warn + ((warn_flags & 2) == 1 ? "precision," : "noprecision,");
        warn = warn + ((warn_flags & 4) == 1 ? "nulls," : "nonulls,");
        warn = warn + ((warn_flags & 8) == 1 ? "portable," : "noportable,");
        warn = warn + ((warn_flags & 0x10) == 1 ? "strict" : "nostrict");
        ((Hashtable)this.m_props).put(key, warn);
    }

    public void setDriver(String driver) throws IllegalArgumentException {
        ((Hashtable)this.m_props).put("driver", driver);
    }

    public void setEncoding(String enc) throws IllegalArgumentException {
        ((Hashtable)this.m_props).put("encoding", enc);
    }

    public void setUser(String user, String context) throws IllegalArgumentException {
        this.setKey("user", user, context);
    }

    public void setPassword(String pwd, String context) throws IllegalArgumentException {
        this.setKey("password", pwd, context);
    }

    public void setClasspath(String path) throws IllegalArgumentException {
        ((Hashtable)this.m_props).put("classpath", path);
    }

    public void setSource(String path) throws IllegalArgumentException {
        ((Hashtable)this.m_props).put("sourcepath", path);
    }

    public void setOffline(String offline, String context) throws IllegalArgumentException {
        this.setKey("offline", offline, context);
    }

    public void setOnline(String online, String context) throws IllegalArgumentException {
        this.setKey("online", online, context);
    }

    public void setCatalogReader(String name, String context) throws IllegalArgumentException {
        this.setKey("catalogReader", name, context);
    }

    public void addCatalogReader(CatalogReader catalogReader, String context) throws IllegalArgumentException {
        if (context == null) {
            context = "";
        }
        if (this.m_catalogReaders == null) {
            this.m_catalogReaders = new HashMap();
        }
        this.m_catalogReaders.put(context, catalogReader);
    }

    public void setForce(String force, String context) throws IllegalArgumentException {
        this.setKey("force", force, context);
    }

    public void setSapMode(boolean sapMode) {
        ((Hashtable)this.m_props).put("sapMode", sapMode ? "true" : "false");
    }

    public Properties getProps() {
        return this.m_props;
    }

    private void setKey(String key, String value, String context) throws IllegalArgumentException {
        if (context != null) {
            key = key + "@" + context;
        }
        ((Hashtable)this.m_props).put(key, value);
    }

    Map getCatalogReaders() {
        return this.m_catalogReaders;
    }
}

