/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework.error;

public class Position {
    private int m_startLine;
    private int m_endLine;
    private int m_startCol;
    private int m_endCol;

    public Position() {
        this(-1, -1, -1, -1);
    }

    public Position(int line, int col) {
        this(line, col, line, col);
    }

    public Position(int sline, int scol, int eline, int ecol) {
        this.m_startLine = sline;
        this.m_startCol = scol;
        this.m_endLine = eline;
        this.m_endCol = ecol;
    }

    boolean less(Position p) {
        if (p == null) {
            return false;
        }
        return this.m_startLine < p.startLine() || this.m_startLine == p.startLine() && this.m_endCol < p.endCol();
    }

    public int startLine() {
        return this.m_startLine;
    }

    public int endLine() {
        return this.m_endLine;
    }

    public int startCol() {
        return this.m_startCol;
    }

    public int endCol() {
        return this.m_endCol;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_startLine);
        if (this.m_startCol > 0) {
            sb.append(".");
            sb.append(this.m_startCol);
        }
        if (this.m_startLine != this.m_endLine || this.m_startCol != this.m_endCol) {
            sb.append("-");
            sb.append(this.m_endLine);
            if (this.m_endCol > 0) {
                sb.append(".");
                sb.append(this.m_endCol);
            }
        }
        return sb.toString();
    }
}

