/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.common.runtime;

import com.sap.sql.jdbc.common.CommonConnection;
import com.sap.sql.sqlj.runtime.profile.ref.IterConvertProfile;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileRefErrors;
import com.sap.sql.sqlj.runtime.profile.ref.RTStatementJDBCPrepared;
import com.sap.sql.sqlj.runtime.profile.ref.TransactionControlProfile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTStatement;

public class CommonConnectedProfile
implements ConnectedProfile {
    private Connection m_connection;
    private String m_source;
    private ProfileData m_data;
    private long m_timestamp;

    public CommonConnectedProfile(Connection conn, ProfileData profileData, long timestamp) {
        this.m_connection = conn;
        this.m_data = profileData;
        this.m_source = this.m_data.getSourceFile();
        this.m_timestamp = timestamp;
    }

    public ProfileData getProfileData() {
        return this.m_data;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public RTStatement getStatement(int ndx, BatchContext batch, Map typeMap) throws SQLException {
        RTStatement stmt;
        EntryInfo entry = this.m_data.getEntryInfo(ndx);
        switch (entry.getRole()) {
            case 18: {
                if (entry.getStatementType() != 2) {
                    ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entry.getSQLString());
                }
                if (entry.getExecuteType() != 16) {
                    ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entry.getSQLString());
                }
                stmt = IterConvertProfile.newIterConvertStatement(this, entry);
            }
            case 11: 
            case 12: {
                stmt = new TransactionControlProfile(this).getStatement(ndx, batch, typeMap);
                break;
            }
            default: {
                CommonConnection ccon = (CommonConnection)this.m_connection;
                PreparedStatement prep = ccon.prepareStatement(entry.getSQLString(), this.m_source, entry.getLineNumber(), this.m_timestamp);
                stmt = new RTStatementJDBCPrepared(prep);
            }
        }
        return stmt;
    }

    public RTStatement getStatement(int ndx, Map typeMap) throws SQLException {
        return this.getStatement(ndx, null, typeMap);
    }

    public void close() throws SQLException {
    }
}

