/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen.engine;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentationWriter
extends PrintWriter {
    private IndentationFilter os_;

    public IndentationWriter(Writer os) {
        this(os, 0);
    }

    public IndentationWriter(Writer os, int initialIndentSpaces) {
        this(new IndentationFilter(os, initialIndentSpaces));
    }

    private IndentationWriter(IndentationFilter os) {
        super(os);
        this.os_ = os;
    }

    public void indentation(boolean isOn) {
        this.os_.indentation(isOn);
    }

    public void println() {
        super.println();
        this.os_.lastNew();
    }

    public void println(boolean b) {
        super.println(b);
        this.os_.lastNew();
    }

    public void println(char c) {
        super.println(c);
        this.os_.lastNew();
    }

    public void println(char[] s) {
        super.println(s);
        this.os_.lastNew();
    }

    public void println(double d) {
        super.println(d);
        this.os_.lastNew();
    }

    public void println(float f) {
        super.println(f);
        this.os_.lastNew();
    }

    public void println(int i) {
        super.println(i);
        this.os_.lastNew();
    }

    public void println(long l) {
        super.println(l);
        this.os_.lastNew();
    }

    public void println(Object obj) {
        super.println(obj);
        this.os_.lastNew();
    }

    public void println(String s) {
        super.println(s);
        this.os_.lastNew();
    }

    private static class IndentationFilter
    extends FilterWriter {
        private boolean indent_;
        private boolean lastNew_ = true;
        private int braceDepth_ = 0;
        private int spacesInTab_ = 2;
        private int init_;

        public IndentationFilter(Writer os, int init) {
            super(os);
            this.init_ = init;
            this.indent_ = true;
        }

        public void indentation(boolean isOn) {
            this.indent_ = isOn;
        }

        public void write(int b) throws IOException {
            this.checkInit(b);
            this.out.write(b);
        }

        private void checkInit(int b) throws IOException {
            if (b == 125 && this.braceDepth_ > 0) {
                --this.braceDepth_;
            }
            if (this.lastNew_ && this.indent_) {
                int i = 0;
                while (i < this.spacesInTab_ * this.braceDepth_ + this.init_) {
                    this.out.write(32);
                    ++i;
                }
            }
            if (b == 123) {
                ++this.braceDepth_;
            }
            this.lastNew_ = false;
        }

        private void checkRest(int b) {
            if (b == 125 && this.braceDepth_ > 0) {
                --this.braceDepth_;
            } else if (b == 123) {
                ++this.braceDepth_;
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (len > 0) {
                this.checkInit(cbuf[off]);
            }
            int i = 1;
            while (i < len) {
                this.checkRest(cbuf[i + off]);
                ++i;
            }
            this.out.write(cbuf, off, len);
        }

        public void write(String str, int off, int len) throws IOException {
            if (len > 0) {
                this.checkInit(str.charAt(off));
            }
            int i = 1;
            while (i < len) {
                this.checkRest(str.charAt(i + off));
                ++i;
            }
            this.out.write(str, off, len);
        }

        public void lastNew() {
            this.lastNew_ = true;
        }
    }
}

