/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.HelperClassDecl;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.codegen.ProfileDecl;
import com.sap.sql.sqlj.codegen.ProfileKeysJSClass;
import com.sap.sql.sqlj.codegen.TypedExpression;
import com.sap.sql.sqlj.codegen.Util;
import com.sap.sql.sqlj.codegen.engine.ArrayInit;
import com.sap.sql.sqlj.codegen.engine.AssignmentStatement;
import com.sap.sql.sqlj.codegen.engine.BaseMethodDecl;
import com.sap.sql.sqlj.codegen.engine.ChainedExpression;
import com.sap.sql.sqlj.codegen.engine.Expression;
import com.sap.sql.sqlj.codegen.engine.FieldDecl;
import com.sap.sql.sqlj.codegen.engine.FunctionCall;
import com.sap.sql.sqlj.codegen.engine.IfStatement;
import com.sap.sql.sqlj.codegen.engine.Initializer;
import com.sap.sql.sqlj.codegen.engine.Modifiers;
import com.sap.sql.sqlj.codegen.engine.NewArray;
import com.sap.sql.sqlj.codegen.engine.ObjectExpression;
import com.sap.sql.sqlj.codegen.engine.ReturnStatement;
import com.sap.sql.sqlj.codegen.engine.StatementBlock;
import com.sap.sql.sqlj.codegen.engine.StatementGroup;
import com.sap.sql.sqlj.codegen.engine.SynchronizedBlock;
import com.sap.sql.sqlj.codegen.engine.Type;
import com.sap.sql.sqlj.util.Parselet;

class StatementsDecl
extends HelperClassDecl {
    public static final String STATEMENT_TEXT_ARRAY_NAME = "stmtText";
    public static final String STATEMENTS_CLASS_SUFFIX = Util.newClassName("Statements");
    public static final String GET_SQL_STATEMENT_METHOD_NAME = "getSqlStatement";
    private static final String STMTS = "sqlStatement";
    private static final String LINES = "sourceLine";
    private static final String STMT_NUM = "stmtNum";
    private static final String CONTEXT = "context";
    private static final Expression CONTEXT_EXPR = new ObjectExpression("context");
    private static final String SOURCE = "source";
    private static final Expression SOURCE_EXPR = new ObjectExpression("source");
    private static final String TIMESTAMP = "timestamp";
    private static final Expression TIMESTAMP_EXPR = new ObjectExpression("timestamp");
    private static final Expression NULL_EXPR = new ObjectExpression("null");
    private static final Expression STMT_NUM_EXPR = new ObjectExpression("sqlStatement[stmtNum]");
    private static final String SQL_STATEMENT = "commonSqlStatement";
    private JSClassType.Factory m_typeFactory;
    private NewArray m_keyInit;
    private ArrayInit m_txtArray;
    private ArrayInit m_stmtArray;
    private ArrayInit m_lineArray;
    private StatementGroup m_keyAssign;
    private Type m_classType;
    private String m_baseClassName;
    private String m_classQualifier;
    private int m_keyNum = 0;
    private int m_stmtNum = 0;

    public StatementsDecl(String classQualifier, String baseClassName, Parselet unitParselet, String sourceFile) {
        this.m_typeFactory = new JSClassType.Factory.ElemFactory(unitParselet);
        this.m_baseClassName = baseClassName;
        this.m_classQualifier = classQualifier;
        this.name(baseClassName + STATEMENTS_CLASS_SUFFIX);
        this.setJlinComment_("$JL-TOPLEVEL-CLASSES$");
        ProfileKeysJSClass keysClass = new ProfileKeysJSClass(classQualifier + baseClassName + STATEMENTS_CLASS_SUFFIX, unitParselet);
        this.m_classType = this.m_typeFactory.getType(keysClass);
        FieldDecl txts = new FieldDecl();
        txts.modifiers(Modifiers.STATIC_PRIVATE);
        txts.name(STATEMENT_TEXT_ARRAY_NAME);
        txts.type(JSClassType.StringArr_TYPE);
        this.m_txtArray = new ArrayInit(JSClassType.StringArr_TYPE);
        txts.initializer(new Initializer(this.m_txtArray));
        this.addBodyDecl(txts);
        FieldDecl stmts = new FieldDecl();
        stmts.modifiers(Modifiers.STATIC_PRIVATE);
        stmts.name(STMTS);
        stmts.type(JSClassType.ObjectArr_TYPE);
        this.m_stmtArray = new ArrayInit(JSClassType.ObjectArr_TYPE);
        stmts.initializer(new Initializer(this.m_stmtArray));
        this.addBodyDecl(stmts);
        FieldDecl lines = new FieldDecl();
        lines.modifiers(Modifiers.STATIC_PRIVATE);
        lines.name(LINES);
        lines.type(JSClassType.intArr_TYPE);
        this.m_lineArray = new ArrayInit(JSClassType.intArr_TYPE);
        lines.initializer(new Initializer(this.m_lineArray));
        this.addBodyDecl(lines);
        FieldDecl source = new FieldDecl();
        source.modifiers(Modifiers.STATIC_PUBLIC_FINAL);
        source.name(SOURCE);
        source.type(JSClassType.String_TYPE);
        String stringifiedSourceFile = Util.stringify(sourceFile);
        source.initializer(new Initializer(new ObjectExpression(stringifiedSourceFile)));
        this.addBodyDecl(source);
        FieldDecl timestamp = new FieldDecl();
        timestamp.modifiers(Modifiers.STATIC_PUBLIC_FINAL);
        timestamp.name(TIMESTAMP);
        timestamp.type(JSClassType.long_TYPE);
        timestamp.initializer(new Initializer(new ObjectExpression("" + System.currentTimeMillis() + "l")));
        this.addBodyDecl(timestamp);
        this.addGetSqlStatementMethod();
    }

    private void addGetSqlStatementMethod() {
        BaseMethodDecl getSql = new BaseMethodDecl(false);
        getSql.modifiers(Modifiers.STATIC_PUBLIC);
        getSql.name(GET_SQL_STATEMENT_METHOD_NAME);
        getSql.type(JSClassType.Object_TYPE);
        getSql.addException(JSClassType.SQLException_TYPE.name());
        getSql.addParameter(JSClassType.ConnectionContext_TYPE, CONTEXT);
        getSql.addParameter(JSClassType.int_TYPE, STMT_NUM);
        SynchronizedBlock synchBlock = new SynchronizedBlock(new ObjectExpression(STMTS));
        ObjectExpression ifCondition = new ObjectExpression("sqlStatement[stmtNum] == null");
        StatementBlock ifBody = new StatementBlock();
        ObjectExpression sqlTxt = new ObjectExpression("stmtText[stmtNum]");
        ObjectExpression lines = new ObjectExpression("sourceLine[stmtNum]");
        ChainedExpression preprepareExpr = new ChainedExpression();
        preprepareExpr.addExpression(new ObjectExpression("com.sap.sql.sqlj.common.runtime.StatementAnalyzer"));
        FunctionCall preprepare = new FunctionCall("preprepareStatement");
        preprepare.addParameter(CONTEXT_EXPR);
        preprepare.addParameter(sqlTxt);
        preprepare.addParameter(SOURCE_EXPR);
        preprepare.addParameter(lines);
        preprepare.addParameter(TIMESTAMP_EXPR);
        preprepareExpr.addExpression(preprepare);
        AssignmentStatement assignment = new AssignmentStatement(STMT_NUM_EXPR, preprepareExpr);
        ifBody.addStatement(assignment);
        synchBlock.addStatement(new IfStatement(ifCondition, ifBody));
        getSql.addStatement(synchBlock);
        getSql.addStatement(new ReturnStatement(STMT_NUM_EXPR));
        this.addBodyDecl(getSql);
    }

    public int addSqlText(String txt, int lineNumber) {
        String stringifiedTxt = Util.stringify(txt);
        this.m_txtArray.addInit(new ObjectExpression(stringifiedTxt));
        this.m_stmtArray.addInit(NULL_EXPR);
        this.m_lineArray.addInit(new ObjectExpression(Integer.toString(lineNumber)));
        ++this.m_stmtNum;
        return this.m_stmtNum - 1;
    }

    public Expression getSqlStatementExpression(int textNum, TypedExpression connCtxExpr) {
        FunctionCall getSql = new FunctionCall(GET_SQL_STATEMENT_METHOD_NAME);
        getSql.addParameter(connCtxExpr);
        getSql.addParameter(new ObjectExpression(new Integer(textNum).toString()));
        ChainedExpression utExpr = new ChainedExpression();
        utExpr.addExpression(new ObjectExpression(this.m_classType.name()));
        utExpr.addExpression(getSql);
        TypedExpression tExpr = new TypedExpression(JSClassType.Object_TYPE, utExpr, STMTS);
        return tExpr;
    }

    private static class Entry {
        public ProfileDecl m_decl;
        public Expression m_key;

        public Entry(ProfileDecl decl, Expression key) {
            this.m_decl = decl;
            this.m_key = key;
        }
    }
}

