/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.CursorJSClass;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.JSMethod;
import com.sap.sql.sqlj.mesg.CodegenErrors;
import java.util.Vector;

public class IteratorMetaData {
    private static final int BY_NAME = 1;
    private static final int BY_POSITION = 2;
    private static final int UNKNOWN = 0;
    private static final JSClass[] NO_PARAMS = new JSClass[0];
    private static final JSClass[] CONSTRUCTOR_PARAMS = new JSClass[]{JSClassType.RTResultSet_TYPE.toClass()};
    private int m_iterType = 0;
    private Vector m_columnNames = new Vector();
    private Vector m_columnTypes = new Vector();
    private int m_numCols = 0;

    public IteratorMetaData(JSClass iterator, JSClass caller) throws Exception {
        iterator = this.getBaseIterator(iterator, caller);
        if (JSClass.NamedIterator_TYPE.isAssignableFrom(iterator)) {
            this.initNamedData(iterator);
        } else if (JSClass.PositionedIterator_TYPE.isAssignableFrom(iterator)) {
            this.initPositionedData(iterator);
        }
    }

    private JSClass getBaseIterator(JSClass iter, JSClass caller) throws Exception {
        if (!caller.hasAccessTo(iter) || iter.resolveConstructor(CONSTRUCTOR_PARAMS, caller).length != 1) {
            String mesg = CodegenErrors.cannot_construct_iterator(iter.getName());
            throw new Exception(mesg);
        }
        JSClass nameResult = this.getLastImplementing(iter, JSClass.NamedIterator_TYPE);
        JSClass posResult = this.getLastImplementing(iter, JSClass.PositionedIterator_TYPE);
        if (nameResult != null) {
            if (posResult != null) {
                String mesg = CodegenErrors.ambiguous_iterator(iter.getName());
                throw new Exception(mesg);
            }
            return nameResult;
        }
        if (posResult == null) {
            String mesg = CodegenErrors.incomplete_iterator(iter.getName());
            throw new Exception(mesg);
        }
        return posResult;
    }

    private JSClass getLastImplementing(JSClass cls, JSClass iterType) {
        if (!iterType.isAssignableFrom(cls)) {
            return null;
        }
        JSClass superclass;
        while ((superclass = cls.getSuperclass()) != null && iterType.isAssignableFrom(superclass)) {
            cls = superclass;
        }
        return cls;
    }

    public boolean isByName() {
        return this.m_iterType == 1;
    }

    public boolean isByPosition() {
        return this.m_iterType == 2;
    }

    public int getColumnCount() {
        return this.m_numCols;
    }

    public String getColumnName(int columnNumber) {
        return (String)this.m_columnNames.elementAt(columnNumber - 1);
    }

    public JSClass getColumnType(int columnNumber) {
        return (JSClass)this.m_columnTypes.elementAt(columnNumber - 1);
    }

    private void initNamedData(JSClass namedIter) {
        this.m_iterType = 1;
        JSMethod[] methods = namedIter.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            this.addColumn(methods[i]);
            ++i;
        }
    }

    private void initPositionedData(JSClass posIter) {
        this.m_iterType = 2;
        int i = 1;
        while (true) {
            try {
                String methodName = CursorJSClass.getColumnAccessName(i);
                this.addColumn(posIter.getDeclaredMethod(methodName, NO_PARAMS));
            }
            catch (NoSuchMethodException e) {
                break;
            }
            ++i;
        }
    }

    private void addColumn(JSMethod method) {
        ++this.m_numCols;
        this.m_columnTypes.addElement(method.getReturnType());
        this.m_columnNames.addElement(method.getName());
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }
    }
}

