/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.CodeGenerator;
import com.sap.sql.sqlj.codegen.ContextCodegen;
import com.sap.sql.sqlj.codegen.CursorCodegen;
import com.sap.sql.sqlj.codegen.ExecCodegen;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.options.HasOptions;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.mesg.OptionDesc;
import com.sap.sql.sqlj.syntax.ContextElem;
import com.sap.sql.sqlj.syntax.CursorElem;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.syntax.ExecElem;
import com.sap.sql.sqlj.util.TranslationContext;

public class CodeGeneratorFactory
implements HasOptions {
    private static final String SAP_MODE = "sapMode";
    private boolean sapMode = true;
    private String modeOrigin = OptionDesc.default_origin();

    CodeGeneratorFactory(TranslationContext ctx) {
    }

    public CodeGenerator newCodeGenerator(Elem e) {
        if (e instanceof CursorElem) {
            return this.newCodeGenerator((CursorElem)e);
        }
        if (e instanceof ExecElem) {
            return this.newCodeGenerator((ExecElem)e, this.sapMode);
        }
        if (e instanceof ContextElem) {
            return this.newCodeGenerator((ContextElem)e);
        }
        throw new IllegalArgumentException("unsupported elem type " + e.getClass());
    }

    public CodeGenerator newCodeGenerator(CursorElem e) {
        return new CursorCodegen(e, new JSClassType.Factory.ElemFactory(e));
    }

    public CodeGenerator newCodeGenerator(ExecElem e, boolean sapMode) {
        return new ExecCodegen(e, new JSClassType.Factory.ElemFactory(e), sapMode);
    }

    public CodeGenerator newCodeGenerator(ContextElem e) {
        return new ContextCodegen(e, new JSClassType.Factory.ElemFactory(e));
    }

    public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
        String value = props.getProperty(SAP_MODE);
        if (value != null) {
            if (value.equals("true") || value.equals("on") || value.equals("1")) {
                this.sapMode = true;
                this.modeOrigin = props.getPropertyLocation(SAP_MODE);
            } else if (value.equals("false") || value.equals("off") || value.equals("0")) {
                this.sapMode = false;
                this.modeOrigin = props.getPropertyLocation(SAP_MODE);
            } else {
                throw new InvalidOptionException("The option \"sapMode\" has the illegal value \"" + value + "\"");
            }
        }
    }

    public String[][] getOptionInfo() {
        return new String[][]{{SAP_MODE, "true, false, on, off, 0, 1", this.sapMode ? "true" : "false", "code generation without profile files", this.modeOrigin}};
    }
}

