/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.anttask;

import com.sap.sql.sqlj.framework.ide.TranslationLog;
import com.sap.sql.sqlj.tools.TranslatorApi;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class Sqlj
extends Task {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$anttask$Sqlj == null ? (class$com$sap$sql$sqlj$anttask$Sqlj = Sqlj.class$("com.sap.sql.sqlj.anttask.Sqlj")) : class$com$sap$sql$sqlj$anttask$Sqlj));
    private File outDir = null;
    private File srcfile = null;
    private Vector filesets = new Vector();
    private String force = null;
    private Path catpath = null;
    private Path classpath = null;
    private Path sourcepath = null;
    private boolean detailLog = false;
    private TranslatorApi translator;
    private AntTaskLog log;
    static /* synthetic */ Class class$com$sap$sql$sqlj$anttask$Sqlj;

    public void setSrcfile(File aSrcfile) {
        this.srcfile = aSrcfile;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setOutputdirectory(File aOutputDirectory) {
        this.outDir = aOutputDirectory;
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setSourcepath(Path sp) {
        if (this.sourcepath == null) {
            this.sourcepath = sp;
        } else {
            this.sourcepath.append(sp);
        }
    }

    public Path createSourcepath() {
        if (this.sourcepath == null) {
            this.sourcepath = new Path(((ProjectComponent)this).project);
        }
        return this.sourcepath.createPath();
    }

    public Path getSourcepath() {
        return this.sourcepath;
    }

    public void setForce(String aForce) {
        this.force = aForce;
    }

    public void setDetaillog(boolean aDetail) {
        this.detailLog = aDetail;
    }

    public void setCatalogpath(Path aCatPath) {
        if (this.catpath == null) {
            this.catpath = aCatPath;
        } else {
            this.catpath.append(aCatPath);
        }
    }

    public Path createCatalogpath() {
        if (this.catpath == null) {
            this.catpath = new Path(((ProjectComponent)this).project);
        }
        return this.catpath.createPath();
    }

    public Path getCatalogpath() {
        return this.catpath;
    }

    public void execute() throws BuildException {
        this.buildCommand();
        if (this.srcfile != null && this.filesets.size() == 0) {
            this.validateAttributes(this.srcfile);
            this.log("Using srcfile:" + this.srcfile, 2);
            this.translator.addUnit(this.srcfile);
            this.translator.translate();
        } else if (this.srcfile == null && this.filesets.size() > 0) {
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    this.log("No source found ", 1);
                    return;
                }
                int j = 0;
                while (j < files.length) {
                    File src = null;
                    try {
                        src = new File(fs.getDir(((ProjectComponent)this).project) + File.separator + files[j]);
                        this.validateAttributes(src);
                        this.log("addUnit: " + src.toString(), 3);
                        this.translator.addUnit(src.toString());
                    }
                    catch (Exception e) {
                        LOCATION.catching((Throwable)e);
                        throw new BuildException(e.getMessage() + ": " + src.toString());
                    }
                    ++j;
                }
                this.translator.translate();
                int errCount = this.log.getErrorCount();
                int warningCount = this.log.getWarningCount();
                if (warningCount > 0) {
                    this.log(warningCount + " warning" + (warningCount > 1 ? "s" : ""), 1);
                }
                if (errCount > 0) {
                    this.log(errCount + " error" + (errCount > 1 ? "s" : ""), 0);
                    throw new BuildException("Translation failed.");
                }
                ++i;
            }
        } else {
            throw new BuildException("Please use either srcfile or a fileset");
        }
    }

    private void buildCommand() throws BuildException {
        if (this.catpath == null) {
            throw new BuildException("Please specify a catalogpath");
        }
        this.log("Using catalog:xml/file/" + this.catpath.toString(), 2);
        this.log = new AntTaskLog();
        this.translator = new TranslatorApi("xml/file/" + this.catpath.toString(), (TranslationLog)this.log);
        if (this.outDir != null) {
            if (!this.outDir.isDirectory()) {
                throw new BuildException("Invalid output directory: " + this.outDir);
            }
            this.log("Using outputDirectory:" + this.outDir.toString(), 3);
            this.translator.setOutputDirectory(this.outDir.toString());
        }
        if (this.sourcepath != null) {
            this.log("Using sourcepath:" + this.sourcepath.toString(), 3);
            this.translator.setSourcepath(this.sourcepath.toString());
        }
        if (this.classpath != null) {
            this.log("Using classpath:" + this.classpath.toString(), 3);
            this.translator.setClasspath(this.classpath.toString());
        }
        if (this.force != null) {
            this.log("Using force:" + this.force.toString(), 3);
            this.translator.setForce(this.force);
        }
        if (this.detailLog) {
            this.log("option detailLog deprecated", 1);
        }
    }

    private void validateAttributes(File srcfile) throws BuildException {
        if (srcfile == null || !srcfile.isFile() || !srcfile.getName().endsWith(".sqlj")) {
            throw new BuildException("Invalid srcfile: " + srcfile);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AntTaskLog
    implements TranslationLog {
        int errorCount = 0;
        int warningCount = 0;

        AntTaskLog() {
        }

        private void doLog(int level, String header, String message, int beginLine, int beginCol, int endLine, int endCol) {
            Sqlj.this.log(header + beginLine + "/" + beginCol + "-" + endLine + "/" + endCol + ": " + message, level);
        }

        public void logError(String message, int beginLine, int beginCol, int endLine, int endCol) {
            this.doLog(0, "error: ", message, beginLine, beginCol, endLine, endCol);
            ++this.errorCount;
        }

        public void logWarning(String message, int beginLine, int beginCol, int endLine, int endCol) {
            this.doLog(1, "warning: ", message, beginLine, beginCol, endLine, endCol);
            ++this.warningCount;
        }

        public void logInfo(String message, int beginLine, int beginCol, int endLine, int endCol) {
            this.doLog(3, "info: ", message, beginLine, beginCol, endLine, endCol);
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }
    }
}

