/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.stmtpool;

import com.sap.sql.jdbc.stmtpool.DoubleLinkedList;
import com.sap.sql.jdbc.stmtpool.PooledStatement;
import com.sap.sql.jdbc.stmtpool.StatementEventListener;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class StatementPool {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$stmtpool$StatementPool == null ? (class$com$sap$sql$jdbc$stmtpool$StatementPool = StatementPool.class$("com.sap.sql.jdbc.stmtpool.StatementPool")) : class$com$sap$sql$jdbc$stmtpool$StatementPool));
    private final int capacity;
    private HashIndex hashedPool;
    private DoubleLinkedList lruList = new DoubleLinkedList();
    private DoubleLinkedList usedList = new DoubleLinkedList();
    private long hits = 0L;
    private long misses = 0L;
    static /* synthetic */ Class class$com$sap$sql$jdbc$stmtpool$StatementPool;

    public StatementPool(int capacity) {
        this.capacity = capacity;
        this.hashedPool = new HashIndex(capacity);
    }

    public PreparedStatement lookup(String sql, int resultSetType, int resultSetConcurrency) {
        String method = "lookup(String, int, int, int)";
        PreparedStatement prepStmt = null;
        if (TRACE.bePath()) {
            TRACE.entering("lookup(String, int, int, int)", new Object[]{sql});
        }
        try {
            PooledStatementLink link = this.hashedPool.get(sql, resultSetType, resultSetConcurrency);
            if (link != null) {
                PooledStatement pooledStmt = link.getPooledStatement();
                try {
                    pooledStmt.clear();
                }
                catch (SQLException ex) {
                    Syslog.logSQLException(this, ex);
                    Syslog.logWarning(this, "com.sap.sql.jdbc.stmtpool_1262", new Object[]{pooledStmt.getSql()});
                    link.statementErrorOccured(null, ex);
                    PreparedStatement preparedStatement = null;
                    Object var11_10 = null;
                    if (TRACE.bePath()) {
                        TRACE.exiting((Object)prepStmt);
                    }
                    return preparedStatement;
                }
                link.move(this.usedList);
                prepStmt = pooledStmt.getPreparedStatement();
                ++this.hits;
                link.hits++;
            } else {
                ++this.misses;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (TRACE.bePath()) {
                TRACE.exiting(prepStmt);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)prepStmt);
        }
        return prepStmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(PooledStatement pooledStmt) {
        boolean added;
        block7: {
            boolean bl;
            block6: {
                String method = "add(PooledStatement)";
                added = false;
                if (TRACE.bePath()) {
                    TRACE.entering("add(PooledStatement)", new Object[]{pooledStmt});
                }
                try {
                    PooledStatementLink link;
                    if (this.hashedPool.size() < this.capacity) {
                        link = new PooledStatementLink(pooledStmt);
                    } else {
                        link = (PooledStatementLink)this.lruList.getLast();
                        if (link == null) {
                            Syslog.logWarning(this, "com.sap.sql.jdbc.stmtpool_1263", new Object[]{pooledStmt.getSql()});
                            bl = false;
                            Object var7_6 = null;
                            break block6;
                        }
                        link.remove();
                        link.setPooledStatement(pooledStmt);
                    }
                    pooledStmt.addStatementEventListener(link);
                    this.lruList.addFirst(link);
                    this.hashedPool.add(link);
                    added = true;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting((Object)new Boolean(added));
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return bl;
            TRACE.exiting((Object)new Boolean(added));
            return bl;
        }
        Object var7_7 = null;
        if (!TRACE.bePath()) return true;
        TRACE.exiting((Object)new Boolean(added));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void connectionClosed() {
        PooledStatementLink link;
        if (TRACE.bePath()) {
            TRACE.entering("connectionClosed()");
        }
        while ((link = (PooledStatementLink)this.usedList.getLast()) != null) {
            void var1_1;
            var1_1.move(this.lruList);
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clear() {
        PooledStatementLink link;
        if (TRACE.bePath()) {
            TRACE.entering("clear()");
        }
        while ((link = (PooledStatementLink)this.lruList.getFirst()) != null) {
            void var1_1;
            var1_1.remove();
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getPooledStatementCount() {
        return this.hashedPool.size();
    }

    public Set getPooledStatements() {
        HashSet<PooledStatementInfo> result = new HashSet<PooledStatementInfo>(this.hashedPool.size());
        Iterator iter = this.hashedPool.iterator();
        while (iter.hasNext()) {
            result.add(new PooledStatementInfo((PooledStatementLink)iter.next()));
        }
        return result;
    }

    public int getUsedPooledStatementCount() {
        return this.usedList.size();
    }

    public long getRequests() {
        return this.hits + this.misses;
    }

    public long getHits() {
        return this.hits;
    }

    public int getMaxHashBucketSize() {
        return this.hashedPool.getMaxBucketSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HashIndex {
        private static final int[] primeNumbers = new int[]{101, 211, 307, 503, 1009, 1511, 2003};
        private ArrayList[] hashArea;
        private int size = 0;
        private int maxBucketSize = 0;

        public HashIndex(int capacity) {
            this.hashArea = new ArrayList[this.compHashAreaSize(capacity)];
        }

        public PooledStatementLink get(String sql, int resultSetType, int resultSetConcurrency) {
            ArrayList bucket = this.hashArea[this.hashSql(sql)];
            if (bucket != null) {
                int i = 0;
                while (i < bucket.size()) {
                    PooledStatementLink link = (PooledStatementLink)bucket.get(i);
                    if (!link.isUsed() && link.getPooledStatement().match(sql, resultSetType, resultSetConcurrency)) {
                        return link;
                    }
                    ++i;
                }
            }
            return null;
        }

        public void add(PooledStatementLink link) {
            int hash = this.hashSql(link.getPooledStatement().getSql());
            if (this.hashArea[hash] == null) {
                this.hashArea[hash] = new ArrayList(3);
            }
            this.hashArea[hash].add(link);
            ++this.size;
            link.setHashValue(hash);
            if (this.maxBucketSize < this.hashArea[hash].size()) {
                ++this.maxBucketSize;
            }
        }

        public void remove(PooledStatementLink link) {
            ArrayList bucket = this.hashArea[link.getHashValue()];
            if (bucket != null) {
                ((AbstractCollection)bucket).remove(link);
                --this.size;
                if (this.maxBucketSize > bucket.size()) {
                    --this.maxBucketSize;
                }
            }
        }

        public int size() {
            return this.size;
        }

        public Iterator iterator() {
            return new Iterator(this){
                Object nextElem;
                private int i;
                private int j;
                private final /* synthetic */ HashIndex this$0;
                {
                    this.this$0 = this$0;
                    this.nextElem = null;
                    this.i = 0;
                    this.j = 0;
                }

                public boolean hasNext() {
                    while (this.i < HashIndex.access$300(this.this$0).length) {
                        ArrayList bucket = HashIndex.access$300(this.this$0)[this.i];
                        if (bucket != null && this.j < bucket.size()) {
                            try {
                                this.nextElem = bucket.get(this.j);
                                return true;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        ++this.i;
                        this.j = 0;
                    }
                    return false;
                }

                public Object next() {
                    if (this.nextElem != null || this.hasNext()) {
                        Object result = this.nextElem;
                        ++this.j;
                        this.nextElem = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void clear() {
            int i = 0;
            while (i < this.hashArea.length) {
                if (this.hashArea[i] != null) {
                    this.hashArea[i].clear();
                    this.hashArea[i] = null;
                }
                ++i;
            }
            this.size = 0;
            this.maxBucketSize = 0;
        }

        public int getMaxBucketSize() {
            return this.maxBucketSize;
        }

        private int compHashAreaSize(int capacity) {
            int i = 0;
            while (i < primeNumbers.length) {
                if (capacity <= primeNumbers[i]) {
                    return primeNumbers[i];
                }
                ++i;
            }
            return primeNumbers[primeNumbers.length - 1];
        }

        private int hashSql(String sql) {
            return sql.length() % this.hashArea.length;
        }

        static /* synthetic */ ArrayList[] access$300(HashIndex x0) {
            return x0.hashArea;
        }
    }

    private class PooledStatementLink
    implements DoubleLinkedList.DoubleLinkable,
    StatementEventListener {
        private int hashValue = -1;
        private PooledStatement ps;
        private DoubleLinkedList.DoubleLinkable next = null;
        private DoubleLinkedList.DoubleLinkable previous = null;
        private DoubleLinkedList myList = null;
        private long hits = 0L;
        static /* synthetic */ Class class$com$sap$sql$jdbc$stmtpool$StatementPool;

        public PooledStatementLink(PooledStatement ps) {
            this.ps = ps;
        }

        public void setPrevious(DoubleLinkedList.DoubleLinkable link) {
            this.previous = link;
        }

        public DoubleLinkedList.DoubleLinkable getPrevious() {
            return this.previous;
        }

        public void setNext(DoubleLinkedList.DoubleLinkable link) {
            this.next = link;
        }

        public DoubleLinkedList.DoubleLinkable getNext() {
            return this.next;
        }

        public void statementClosed(Object event) {
            this.myList.remove(this);
            StatementPool.this.lruList.addFirst(this);
        }

        public void statementErrorOccured(Object event, SQLException sqlEx) {
            this.remove();
        }

        public PooledStatement getPooledStatement() {
            return this.ps;
        }

        public void setPooledStatement(PooledStatement ps) {
            this.ps = ps;
        }

        public int getHashValue() {
            return this.hashValue;
        }

        public void setHashValue(int hashValue) {
            this.hashValue = hashValue;
        }

        public long getHits() {
            return this.hits;
        }

        public void setMyList(DoubleLinkedList list) {
            this.myList = list;
        }

        public DoubleLinkedList getMyList() {
            return this.myList;
        }

        public boolean isUsed() {
            return this.myList == StatementPool.this.usedList;
        }

        public void remove() {
            try {
                this.ps.close();
            }
            catch (SQLException ex) {
                Syslog.logSQLException(class$com$sap$sql$jdbc$stmtpool$StatementPool == null ? (class$com$sap$sql$jdbc$stmtpool$StatementPool = PooledStatementLink.class$("com.sap.sql.jdbc.stmtpool.StatementPool")) : class$com$sap$sql$jdbc$stmtpool$StatementPool, ex);
                Syslog.logWarning(class$com$sap$sql$jdbc$stmtpool$StatementPool == null ? (class$com$sap$sql$jdbc$stmtpool$StatementPool = PooledStatementLink.class$("com.sap.sql.jdbc.stmtpool.StatementPool")) : class$com$sap$sql$jdbc$stmtpool$StatementPool, "com.sap.sql.jdbc.stmtpool_1261", new Object[]{this.ps.getSql()});
            }
            this.myList.remove(this);
            StatementPool.this.hashedPool.remove(this);
        }

        public void move(DoubleLinkedList toList) {
            this.myList.remove(this);
            toList.addFirst(this);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class PooledStatementInfo {
        private int hashValue;
        private String sql;
        private boolean isUsed;
        private long hits;

        public PooledStatementInfo(PooledStatementLink psl) {
            this.hashValue = psl.getHashValue();
            this.sql = psl.getPooledStatement().getSql();
            this.isUsed = psl.isUsed();
            this.hits = psl.getHits();
        }

        public int getHashValue() {
            return this.hashValue;
        }

        public String getSQL() {
            return this.sql;
        }

        public boolean isUsed() {
            return this.isUsed;
        }

        public long getHits() {
            return this.hits;
        }
    }
}

