/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.oracle;

import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;

public class OracleSQLExceptionAnalyzer
extends SQLExceptionAnalyzer {
    public OracleSQLExceptionAnalyzer(Connection connection) {
        super(connection);
    }

    public int getCategory(SQLException masterException) {
        SQLException exception = masterException;
        int category = 0;
        boolean categorized = false;
        while (exception != null) {
            String sqlState;
            categorized = false;
            int errorCode = exception.getErrorCode();
            if (errorCode > -1) {
                if (errorCode == 0) {
                    category = Math.max(category, 0);
                    categorized = true;
                } else if (errorCode == 1) {
                    category = Math.max(category, 1);
                    categorized = true;
                } else if (errorCode == 1426 || errorCode == 1455 || errorCode == 1457 || errorCode == 3120 || errorCode == 3132 || errorCode == 7408 || errorCode == 7802 || errorCode == 8463 || errorCode == 17026) {
                    category = Math.max(category, 2);
                    categorized = true;
                } else if (errorCode == 904 || errorCode == 945 || errorCode == 13411 || errorCode == 14030 || errorCode == 23334 || errorCode == 26018) {
                    category = Math.max(category, 3);
                    categorized = true;
                } else if (errorCode == 903 || errorCode == 942 || errorCode == 943 || errorCode == 959 || errorCode == 1129 || errorCode == 1312 || errorCode == 1418 || errorCode == 1432 || errorCode == 1435 || errorCode == 1495 || errorCode == 1917 || errorCode == 1918 || errorCode == 1919 || errorCode == 2149 || errorCode == 2270 || errorCode == 2271 || errorCode == 2289 || errorCode == 2430 || errorCode == 2431 || errorCode == 2432 || errorCode == 2433 || errorCode == 2434 || errorCode == 2435 || errorCode == 2441 || errorCode == 2442 || errorCode == 2443 || errorCode == 2448 || errorCode == 4042 || errorCode == 4043 || errorCode == 4054 || errorCode == 4067 || errorCode == 4080 || errorCode == 6564 || errorCode == 8005 || errorCode == 8006 || errorCode == 8103 || errorCode == 12003 || errorCode == 12418 || errorCode == 13055 || errorCode == 13113 || errorCode == 13114 || errorCode == 13117 || errorCode == 13158 || errorCode == 13409 || errorCode == 14251 || errorCode == 18002 || errorCode == 18009 || errorCode == 21613 || errorCode == 22305 || errorCode == 22311 || errorCode == 22809 || errorCode == 23292 || errorCode == 23306 || errorCode == 23331 || errorCode == 23344 || errorCode == 23362 || errorCode == 23401 || errorCode == 23505 || errorCode == 24147 || errorCode == 24404 || errorCode == 24756 || errorCode == 25129 || errorCode == 26001 || errorCode == 26514 || errorCode == 29304 || errorCode == 29342 || errorCode == 30738 || errorCode == 32835) {
                    category = Math.max(category, 4);
                    categorized = true;
                } else if (errorCode == 955 || errorCode == 1430 || errorCode == 1433 || errorCode == 1543 || errorCode == 2011 || errorCode == 2033 || errorCode == 2261 || errorCode == 2264 || errorCode == 2275 || errorCode == 4081 || errorCode == 4095 || errorCode == 12006 || errorCode == 13159 || errorCode == 14322 || errorCode == 14323 || errorCode == 14620 || errorCode == 14621 || errorCode == 18004 || errorCode == 22306 || errorCode == 22309 || errorCode == 23307 || errorCode == 23309 || errorCode == 23330 || errorCode == 23374 || errorCode == 24398 || errorCode == 24407 || errorCode == 24411 || errorCode == 24784 || errorCode == 25018 || errorCode == 28026 || errorCode == 29349 || errorCode == 29357) {
                    category = Math.max(category, 5);
                    categorized = true;
                } else if (errorCode == 60 || errorCode == 99 || errorCode == 104 || errorCode == 2049 || errorCode == 4020 || errorCode == 12829 || errorCode == 18014 || errorCode == 29665 || errorCode == 31443 || errorCode == 32059) {
                    category = Math.max(category, 6);
                    categorized = true;
                } else if (errorCode == 28 || errorCode == 1029 || errorCode == 2390 || errorCode == 2392 || errorCode == 3113 || errorCode == 3114 || errorCode == 6034 || errorCode == 6136 || errorCode == 6137 || errorCode == 6138 || errorCode == 6413 || errorCode == 17002 || errorCode == 17008 || errorCode == 25403 || errorCode == 25407 || errorCode == 25425 || errorCode == 26507 || errorCode == 26508 || errorCode == 29271) {
                    category = Math.max(category, 9);
                    categorized = true;
                }
            }
            if ((sqlState = exception.getSQLState()) != null) {
                if (sqlState.startsWith("00") || sqlState.startsWith("01")) {
                    category = Math.max(category, 0);
                    categorized = true;
                } else if (sqlState.startsWith("22003")) {
                    category = Math.max(category, 2);
                    categorized = true;
                } else if (sqlState.startsWith("08")) {
                    category = Math.max(category, 9);
                    categorized = true;
                }
            }
            if (!categorized) {
                category = 7;
                categorized = true;
            }
            exception = exception.getNextException();
        }
        return category;
    }
}

