/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.oracle;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import com.sap.sql.jdbc.basic.BasicPreparedStatement;
import com.sap.sql.jdbc.oracle.OracleBatch;
import com.sap.sql.jdbc.oracle.OracleBatchParameter;
import com.sap.sql.jdbc.oracle.OracleBatchStorage;
import com.sap.sql.jdbc.oracle.OracleConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import oracle.jdbc.OracleSavepoint;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OraclePreparedStatement
extends BasicPreparedStatement {
    private OracleBatchStorage oracleBatchStorage = new OracleBatchStorage();
    private OracleBatch oracleBatch = new OracleBatch();
    private ArrayList temporaryBlobs = new ArrayList();
    private ArrayList temporaryClobs = new ArrayList();

    public OraclePreparedStatement(BasicJdbcObjectFactory factory, Connection connection, PreparedStatement preparedStatement, String sql) {
        super(factory, connection, preparedStatement, sql);
    }

    public void addBatch() throws SQLException {
        this.oracleBatchStorage.addBatch(this.oracleBatch.copy());
    }

    public void clearBatch() throws SQLException {
        this.oracleBatchStorage.clear();
        this.cleanupTemporaryLobs();
    }

    public void clearParameters() throws SQLException {
        this.oracleBatch.clear();
        super.clearParameters();
    }

    public void close() throws SQLException {
        try {
            super.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanupTemporaryLobsForClose();
            throw throwable;
        }
        this.cleanupTemporaryLobsForClose();
        this.oracleBatchStorage = null;
        this.oracleBatch = null;
    }

    public boolean execute() throws SQLException {
        if (this.oracleBatchStorage.getBatchCount() > 0) {
            throw new SQLException("error occurred during batching: batch must be either executed or cleared", null, 17081);
        }
        int index = 1;
        while (index <= this.oracleBatch.getParameterCount()) {
            OracleBatchParameter parameter = this.oracleBatch.getParameter(index);
            switch (parameter.getMethod()) {
                case 0: {
                    this.setArray(index, parameter);
                    break;
                }
                case 1: {
                    this.setAsciiStream(index, parameter);
                    break;
                }
                case 2: {
                    this.setBigDecimal(index, parameter);
                    break;
                }
                case 3: {
                    this.setBinaryStream(index, parameter);
                    break;
                }
                case 4: {
                    this.setBlob(index, parameter);
                    break;
                }
                case 5: {
                    this.setBoolean(index, parameter);
                    break;
                }
                case 6: {
                    this.setByte(index, parameter);
                    break;
                }
                case 7: {
                    this.setBytes(index, parameter);
                    break;
                }
                case 8: {
                    this.setCharacterStream(index, parameter);
                    break;
                }
                case 9: {
                    this.setClob(index, parameter);
                    break;
                }
                case 10: {
                    this.setDate(index, parameter);
                    break;
                }
                case 11: {
                    this.setDouble(index, parameter);
                    break;
                }
                case 12: {
                    this.setFloat(index, parameter);
                    break;
                }
                case 13: {
                    this.setInt(index, parameter);
                    break;
                }
                case 14: {
                    this.setLong(index, parameter);
                    break;
                }
                case 15: {
                    this.setNull(index, parameter);
                    break;
                }
                case 16: {
                    this.setObject(index, parameter);
                    break;
                }
                case 17: {
                    this.setRef(index, parameter);
                    break;
                }
                case 18: {
                    this.setShort(index, parameter);
                    break;
                }
                case 19: {
                    this.setString(index, parameter);
                    break;
                }
                case 20: {
                    this.setTime(index, parameter);
                    break;
                }
                case 21: {
                    this.setTimestamp(index, parameter);
                }
            }
            ++index;
        }
        return super.execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] updateCounts = null;
        try {
            boolean autoCommit = this.getConnection().getAutoCommit();
            if (autoCommit) {
                this.getConnection().setAutoCommit(false);
            }
            try {
                boolean rollback = true;
                oracle.jdbc.OracleConnection oracleConnection = ((OracleConnection)this.getConnection()).getWrappedConnection();
                OracleSavepoint oracleSavepoint = oracleConnection.oracleSetSavepoint();
                try {
                    try {
                        int batchCount = this.oracleBatchStorage.getBatchCount();
                        Enumeration batches = this.oracleBatchStorage.getBatches();
                        while (batches.hasMoreElements()) {
                            OracleBatch batch = (OracleBatch)batches.nextElement();
                            int index = 1;
                            while (index <= batch.getParameterCount()) {
                                OracleBatchParameter parameter = batch.getParameter(index);
                                switch (parameter.getMethod()) {
                                    case 0: {
                                        this.setArray(index, parameter);
                                        break;
                                    }
                                    case 1: {
                                        this.setAsciiStream(index, parameter);
                                        break;
                                    }
                                    case 2: {
                                        this.setBigDecimal(index, parameter);
                                        break;
                                    }
                                    case 3: {
                                        this.setBinaryStream(index, parameter);
                                        break;
                                    }
                                    case 4: {
                                        this.setBlob(index, parameter);
                                        break;
                                    }
                                    case 5: {
                                        this.setBoolean(index, parameter);
                                        break;
                                    }
                                    case 6: {
                                        this.setByte(index, parameter);
                                        break;
                                    }
                                    case 7: {
                                        this.setBytes(index, parameter);
                                        break;
                                    }
                                    case 8: {
                                        this.setCharacterStream(index, parameter);
                                        break;
                                    }
                                    case 9: {
                                        this.setClob(index, parameter);
                                        break;
                                    }
                                    case 10: {
                                        this.setDate(index, parameter);
                                        break;
                                    }
                                    case 11: {
                                        this.setDouble(index, parameter);
                                        break;
                                    }
                                    case 12: {
                                        this.setFloat(index, parameter);
                                        break;
                                    }
                                    case 13: {
                                        this.setInt(index, parameter);
                                        break;
                                    }
                                    case 14: {
                                        this.setLong(index, parameter);
                                        break;
                                    }
                                    case 15: {
                                        this.setNull(index, parameter);
                                        break;
                                    }
                                    case 16: {
                                        this.setObject(index, parameter);
                                        break;
                                    }
                                    case 17: {
                                        this.setRef(index, parameter);
                                        break;
                                    }
                                    case 18: {
                                        this.setShort(index, parameter);
                                        break;
                                    }
                                    case 19: {
                                        this.setString(index, parameter);
                                        break;
                                    }
                                    case 20: {
                                        this.setTime(index, parameter);
                                        break;
                                    }
                                    case 21: {
                                        this.setTimestamp(index, parameter);
                                        break;
                                    }
                                }
                                ++index;
                            }
                            super.addBatch();
                        }
                        this.oracleBatchStorage.clear();
                        updateCounts = super.executeBatch();
                        if (updateCounts.length < batchCount) {
                            int[] partialUpdateCounts = updateCounts;
                            updateCounts = new int[batchCount];
                            int i = 0;
                            while (i < batchCount - partialUpdateCounts.length) {
                                updateCounts[i] = -2;
                                ++i;
                            }
                            System.arraycopy(partialUpdateCounts, 0, updateCounts, batchCount - partialUpdateCounts.length, partialUpdateCounts.length);
                        }
                        if (autoCommit) {
                            this.getConnection().commit();
                        }
                        rollback = false;
                        int[] nArray = updateCounts;
                        Object var12_13 = null;
                        if (rollback) {
                            oracleConnection.oracleRollback(oracleSavepoint);
                        }
                        Object var14_15 = null;
                        if (autoCommit) {
                            this.getConnection().setAutoCommit(true);
                        }
                        Object var16_17 = null;
                        this.cleanupTemporaryLobs();
                        return nArray;
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        updateCounts = new int[]{};
                        StringWriter stringWriter = new StringWriter();
                        batchUpdateException.printStackTrace(new PrintWriter(stringWriter));
                        throw new BatchUpdateException("Batch rolled back. Caused by " + stringWriter.toString(), batchUpdateException.getSQLState(), batchUpdateException.getErrorCode(), updateCounts);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (!rollback) throw throwable;
                    oracleConnection.oracleRollback(oracleSavepoint);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (!autoCommit) throw throwable;
                this.getConnection().setAutoCommit(true);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.cleanupTemporaryLobs();
            throw throwable;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.oracleBatchStorage.getBatchCount() > 0) {
            throw new SQLException("error occurred during batching: batch must be either executed or cleared", null, 17081);
        }
        int index = 1;
        while (index <= this.oracleBatch.getParameterCount()) {
            OracleBatchParameter parameter = this.oracleBatch.getParameter(index);
            switch (parameter.getMethod()) {
                case 0: {
                    this.setArray(index, parameter);
                    break;
                }
                case 1: {
                    this.setAsciiStream(index, parameter);
                    break;
                }
                case 2: {
                    this.setBigDecimal(index, parameter);
                    break;
                }
                case 3: {
                    this.setBinaryStream(index, parameter);
                    break;
                }
                case 4: {
                    this.setBlob(index, parameter);
                    break;
                }
                case 5: {
                    this.setBoolean(index, parameter);
                    break;
                }
                case 6: {
                    this.setByte(index, parameter);
                    break;
                }
                case 7: {
                    this.setBytes(index, parameter);
                    break;
                }
                case 8: {
                    this.setCharacterStream(index, parameter);
                    break;
                }
                case 9: {
                    this.setClob(index, parameter);
                    break;
                }
                case 10: {
                    this.setDate(index, parameter);
                    break;
                }
                case 11: {
                    this.setDouble(index, parameter);
                    break;
                }
                case 12: {
                    this.setFloat(index, parameter);
                    break;
                }
                case 13: {
                    this.setInt(index, parameter);
                    break;
                }
                case 14: {
                    this.setLong(index, parameter);
                    break;
                }
                case 15: {
                    this.setNull(index, parameter);
                    break;
                }
                case 16: {
                    this.setObject(index, parameter);
                    break;
                }
                case 17: {
                    this.setRef(index, parameter);
                    break;
                }
                case 18: {
                    this.setShort(index, parameter);
                    break;
                }
                case 19: {
                    this.setString(index, parameter);
                    break;
                }
                case 20: {
                    this.setTime(index, parameter);
                    break;
                }
                case 21: {
                    this.setTimestamp(index, parameter);
                }
            }
            ++index;
        }
        return super.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        if (this.oracleBatchStorage.getBatchCount() > 0) {
            throw new SQLException("error occurred during batching: batch must be either executed or cleared", null, 17081);
        }
        int index = 1;
        while (index <= this.oracleBatch.getParameterCount()) {
            OracleBatchParameter parameter = this.oracleBatch.getParameter(index);
            switch (parameter.getMethod()) {
                case 0: {
                    this.setArray(index, parameter);
                    break;
                }
                case 1: {
                    this.setAsciiStream(index, parameter);
                    break;
                }
                case 2: {
                    this.setBigDecimal(index, parameter);
                    break;
                }
                case 3: {
                    this.setBinaryStream(index, parameter);
                    break;
                }
                case 4: {
                    this.setBlob(index, parameter);
                    break;
                }
                case 5: {
                    this.setBoolean(index, parameter);
                    break;
                }
                case 6: {
                    this.setByte(index, parameter);
                    break;
                }
                case 7: {
                    this.setBytes(index, parameter);
                    break;
                }
                case 8: {
                    this.setCharacterStream(index, parameter);
                    break;
                }
                case 9: {
                    this.setClob(index, parameter);
                    break;
                }
                case 10: {
                    this.setDate(index, parameter);
                    break;
                }
                case 11: {
                    this.setDouble(index, parameter);
                    break;
                }
                case 12: {
                    this.setFloat(index, parameter);
                    break;
                }
                case 13: {
                    this.setInt(index, parameter);
                    break;
                }
                case 14: {
                    this.setLong(index, parameter);
                    break;
                }
                case 15: {
                    this.setNull(index, parameter);
                    break;
                }
                case 16: {
                    this.setObject(index, parameter);
                    break;
                }
                case 17: {
                    this.setRef(index, parameter);
                    break;
                }
                case 18: {
                    this.setShort(index, parameter);
                    break;
                }
                case 19: {
                    this.setString(index, parameter);
                    break;
                }
                case 20: {
                    this.setTime(index, parameter);
                    break;
                }
                case 21: {
                    this.setTimestamp(index, parameter);
                }
            }
            ++index;
        }
        return super.executeUpdate();
    }

    public void setArray(int index, Array array) throws SQLException {
        Object[] parameter = new Object[]{array};
        int method = 0;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setArray(int index, OracleBatchParameter parameter) throws SQLException {
        Array array = (Array)parameter.getParameter(0);
        super.setArray(index, array);
    }

    public void setAsciiStream(int index, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null) {
            Object[] parameter = new Object[]{null};
            int method = 19;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else if (length <= 1333) {
            Object[] parameter = new Object[]{this.convertStreamToString(inputStream, length)};
            int method = 19;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else {
            Object[] parameter = new Object[]{this.convertStreamToClob(inputStream, length)};
            int method = 9;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    private void setAsciiStream(int index, OracleBatchParameter parameter) throws SQLException {
        ((oracle.jdbc.OraclePreparedStatement)this.prepStmt).setFormOfUse(index, (short)2);
        InputStream inputStream = (InputStream)parameter.getParameter(0);
        int length = (Integer)parameter.getParameter(1);
        super.setAsciiStream(index, inputStream, length);
    }

    public void setBigDecimal(int index, BigDecimal bigDecimal) throws SQLException {
        Object[] parameter = new Object[]{bigDecimal};
        int method = 2;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setBigDecimal(int index, OracleBatchParameter parameter) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)parameter.getParameter(0);
        super.setBigDecimal(index, bigDecimal);
    }

    public void setBinaryStream(int index, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null) {
            Object[] parameter = new Object[]{null};
            int method = 7;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else if (length <= 4000) {
            Object[] parameter = new Object[]{this.convertStreamToBytes(inputStream, length)};
            int method = 7;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else {
            Object[] parameter = new Object[]{this.convertStreamToBlob(inputStream, length)};
            int method = 4;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    private void setBinaryStream(int index, OracleBatchParameter parameter) throws SQLException {
        InputStream inputStream = (InputStream)parameter.getParameter(0);
        int length = (Integer)parameter.getParameter(1);
        super.setBinaryStream(index, inputStream, length);
    }

    public void setBlob(int index, Blob blob) throws SQLException {
        Object[] parameter = new Object[]{blob};
        int method = 4;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setBlob(int index, OracleBatchParameter parameter) throws SQLException {
        Blob blob = (Blob)parameter.getParameter(0);
        super.setBlob(index, blob);
    }

    public void setBoolean(int index, boolean b) throws SQLException {
        Object[] parameter = new Object[]{new Boolean(b)};
        int method = 5;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setBoolean(int index, OracleBatchParameter parameter) throws SQLException {
        boolean b = (Boolean)parameter.getParameter(0);
        super.setBoolean(index, b);
    }

    public void setByte(int index, byte b) throws SQLException {
        Object[] parameter = new Object[]{new Byte(b)};
        int method = 6;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setByte(int index, OracleBatchParameter parameter) throws SQLException {
        byte b = (Byte)parameter.getParameter(0);
        super.setByte(index, b);
    }

    public void setBytes(int index, byte[] bytes) throws SQLException {
        if (bytes == null) {
            Object[] parameter = new Object[]{null};
            int method = 7;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else if (bytes.length <= 4000) {
            Object[] parameter = new Object[]{bytes};
            int method = 7;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else {
            Object[] parameter = new Object[]{this.convertBytesToBlob(bytes)};
            int method = 4;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    private void setBytes(int index, OracleBatchParameter parameter) throws SQLException {
        byte[] bytes = (byte[])parameter.getParameter(0);
        super.setBytes(index, bytes);
    }

    public void setCharacterStream(int index, Reader reader, int length) throws SQLException {
        if (reader == null) {
            Object[] parameter = new Object[]{null};
            int method = 19;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else if (length <= 4000) {
            Object[] parameter = new Object[]{this.convertStreamToString(reader, length)};
            int method = 19;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else {
            Object[] parameter = new Object[]{this.convertStreamToClob(reader, length)};
            int method = 9;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    private void setCharacterStream(int index, OracleBatchParameter parameter) throws SQLException {
        ((oracle.jdbc.OraclePreparedStatement)this.prepStmt).setFormOfUse(index, (short)2);
        Reader reader = (Reader)parameter.getParameter(0);
        int length = (Integer)parameter.getParameter(1);
        super.setCharacterStream(index, reader, length);
    }

    public void setClob(int index, Clob clob) throws SQLException {
        Object[] parameter = new Object[]{clob};
        int method = 9;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setClob(int index, OracleBatchParameter parameter) throws SQLException {
        ((oracle.jdbc.OraclePreparedStatement)this.prepStmt).setFormOfUse(index, (short)2);
        Clob clob = (Clob)parameter.getParameter(0);
        super.setClob(index, clob);
    }

    public void setDate(int index, Date date) throws SQLException {
        Object[] parameter = new Object[]{date};
        int method = 10;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    public void setDate(int index, Date date, Calendar calendar) throws SQLException {
        Object[] parameter = new Object[]{date, calendar};
        int method = 10;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setDate(int index, OracleBatchParameter parameter) throws SQLException {
        if (parameter.getParameterCount() == 1) {
            Date date = (Date)parameter.getParameter(0);
            super.setDate(index, date);
        } else {
            Date date = (Date)parameter.getParameter(0);
            Calendar calendar = (Calendar)parameter.getParameter(1);
            super.setDate(index, date, calendar);
        }
    }

    public void setDouble(int index, double d) throws SQLException {
        Object[] parameter = new Object[]{new Double(d)};
        int method = 11;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setDouble(int index, OracleBatchParameter parameter) throws SQLException {
        double d = (Double)parameter.getParameter(0);
        super.setDouble(index, d);
    }

    public void setFloat(int index, float f) throws SQLException {
        Object[] parameter = new Object[]{new Float(f)};
        int method = 12;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setFloat(int index, OracleBatchParameter parameter) throws SQLException {
        float f = ((Float)parameter.getParameter(0)).floatValue();
        super.setFloat(index, f);
    }

    public void setInt(int index, int i) throws SQLException {
        Object[] parameter = new Object[]{new Integer(i)};
        int method = 13;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setInt(int index, OracleBatchParameter parameter) throws SQLException {
        int i = (Integer)parameter.getParameter(0);
        super.setInt(index, i);
    }

    public void setLong(int index, long l) throws SQLException {
        Object[] parameter = new Object[]{new Long(l)};
        int method = 14;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setLong(int index, OracleBatchParameter parameter) throws SQLException {
        long l = (Long)parameter.getParameter(0);
        super.setLong(index, l);
    }

    public void setNull(int index, int sqlType) throws SQLException {
        Object[] parameter = new Object[]{new Integer(sqlType)};
        int method = 15;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    public void setNull(int index, int sqlType, String typeName) throws SQLException {
        Object[] parameter = new Object[]{new Integer(sqlType), typeName};
        int method = 15;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setNull(int index, OracleBatchParameter parameter) throws SQLException {
        ((oracle.jdbc.OraclePreparedStatement)this.prepStmt).setFormOfUse(index, (short)2);
        if (parameter.getParameterCount() == 1) {
            int sqlType = (Integer)parameter.getParameter(0);
            super.setNull(index, sqlType);
        } else {
            int sqlType = (Integer)parameter.getParameter(0);
            String typeName = (String)parameter.getParameter(1);
            super.setNull(index, sqlType, typeName);
        }
    }

    public void setObject(int index, Object object) throws SQLException {
        if (object instanceof byte[]) {
            this.setBytes(index, (byte[])object);
        } else if (object instanceof String) {
            this.setString(index, (String)object);
        } else if (object instanceof InputStream) {
            this.setBinaryStream(index, (InputStream)object, Integer.MAX_VALUE);
        } else if (object instanceof Reader) {
            this.setCharacterStream(index, (Reader)object, Integer.MAX_VALUE);
        } else if (object instanceof Blob) {
            this.setBlob(index, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(index, (Clob)object);
        } else {
            Object[] parameter = new Object[]{object};
            int method = 16;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    public void setObject(int index, Object object, int targetSqlType) throws SQLException {
        if (object instanceof byte[]) {
            this.setBytes(index, (byte[])object);
        } else if (object instanceof String) {
            this.setString(index, (String)object);
        } else if (object instanceof InputStream) {
            this.setBinaryStream(index, (InputStream)object, Integer.MAX_VALUE);
        } else if (object instanceof Reader) {
            this.setCharacterStream(index, (Reader)object, Integer.MAX_VALUE);
        } else if (object instanceof Blob) {
            this.setBlob(index, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(index, (Clob)object);
        } else {
            Object[] parameter = new Object[]{object, new Integer(targetSqlType)};
            int method = 16;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    public void setObject(int index, Object object, int targetSqlType, int scale) throws SQLException {
        if (object instanceof byte[]) {
            this.setBytes(index, (byte[])object);
        } else if (object instanceof String) {
            this.setString(index, (String)object);
        } else if (object instanceof InputStream) {
            this.setBinaryStream(index, (InputStream)object, Integer.MAX_VALUE);
        } else if (object instanceof Reader) {
            this.setCharacterStream(index, (Reader)object, Integer.MAX_VALUE);
        } else if (object instanceof Blob) {
            this.setBlob(index, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(index, (Clob)object);
        } else {
            Object[] parameter = new Object[]{object, new Integer(targetSqlType), new Integer(scale)};
            int method = 16;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    private void setObject(int index, OracleBatchParameter parameter) throws SQLException {
        Object object = parameter.getParameter(0);
        if (parameter.getParameterCount() == 1) {
            super.setObject(index, object);
        } else if (parameter.getParameterCount() == 2) {
            int targetSqlType = (Integer)parameter.getParameter(1);
            super.setObject(index, object, targetSqlType);
        } else if (parameter.getParameterCount() == 3) {
            int targetSqlType = (Integer)parameter.getParameter(1);
            int scale = (Integer)parameter.getParameter(2);
            super.setObject(index, object, targetSqlType, scale);
        }
    }

    public void setRef(int index, Ref ref) throws SQLException {
        Object[] parameter = new Object[]{ref};
        int method = 17;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setRef(int index, OracleBatchParameter parameter) throws SQLException {
        Ref ref = (Ref)parameter.getParameter(0);
        super.setRef(index, ref);
    }

    public void setShort(int index, short s) throws SQLException {
        Object[] parameter = new Object[]{new Short(s)};
        int method = 18;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setShort(int index, OracleBatchParameter parameter) throws SQLException {
        short s = (Short)parameter.getParameter(0);
        super.setShort(index, s);
    }

    public void setString(int index, String string) throws SQLException {
        if (string == null) {
            Object[] parameter = new Object[]{null};
            int method = 19;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else if (string.length() <= 1333) {
            Object[] parameter = new Object[]{string};
            int method = 19;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        } else {
            Object[] parameter = new Object[]{this.convertStringToClob(string)};
            int method = 9;
            OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
            this.oracleBatch.setParameter(index, oracleBatchParameter);
        }
    }

    private void setString(int index, OracleBatchParameter parameter) throws SQLException {
        ((oracle.jdbc.OraclePreparedStatement)this.prepStmt).setFormOfUse(index, (short)2);
        String string = (String)parameter.getParameter(0);
        super.setString(index, string);
    }

    public void setTime(int index, Time time) throws SQLException {
        Object[] parameter = new Object[]{time};
        int method = 20;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    public void setTime(int index, Time time, Calendar calendar) throws SQLException {
        Object[] parameter = new Object[]{time, calendar};
        int method = 20;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setTime(int index, OracleBatchParameter parameter) throws SQLException {
        if (parameter.getParameterCount() == 1) {
            Time time = (Time)parameter.getParameter(0);
            super.setTime(index, time);
        } else {
            Time time = (Time)parameter.getParameter(0);
            Calendar calendar = (Calendar)parameter.getParameter(1);
            super.setTime(index, time, calendar);
        }
    }

    public void setTimestamp(int index, Timestamp timestamp) throws SQLException {
        Object[] parameter = new Object[]{timestamp};
        int method = 21;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    public void setTimestamp(int index, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object[] parameter = new Object[]{timestamp, calendar};
        int method = 21;
        OracleBatchParameter oracleBatchParameter = new OracleBatchParameter(parameter, method);
        this.oracleBatch.setParameter(index, oracleBatchParameter);
    }

    private void setTimestamp(int index, OracleBatchParameter parameter) throws SQLException {
        if (parameter.getParameterCount() == 1) {
            Timestamp timestamp = (Timestamp)parameter.getParameter(0);
            super.setTimestamp(index, timestamp);
        } else {
            Timestamp timestamp = (Timestamp)parameter.getParameter(0);
            Calendar calendar = (Calendar)parameter.getParameter(1);
            super.setTimestamp(index, timestamp, calendar);
        }
    }

    private byte[] convertStreamToBytes(InputStream inputStream, int length) throws SQLException {
        byte[] buffer = new byte[length];
        int offset = 0;
        int read = 0;
        try {
            byte[] result;
            while (offset < length && (read = inputStream.read(buffer, offset, length - offset)) > -1) {
                offset += read;
            }
            if (length > offset) {
                length = offset;
                result = new byte[length];
                System.arraycopy(buffer, 0, result, 0, length);
            } else {
                result = buffer;
            }
            return result;
        }
        catch (IOException ioException) {
            StringWriter stringWriter = new StringWriter();
            ioException.printStackTrace(new PrintWriter(stringWriter));
            throw new SQLException("caused by " + stringWriter.toString(), null, 17002);
        }
    }

    private Blob convertBytesToBlob(byte[] bytes) throws SQLException {
        return this.convertStreamToBlob(new ByteArrayInputStream(bytes), bytes.length);
    }

    /*
     * WARNING - void declaration
     */
    private Blob convertStreamToBlob(InputStream inputStream, int length) throws SQLException {
        BLOB blob = BLOB.createTemporary((Connection)((OracleConnection)this.getConnection()).getWrappedConnection(), (boolean)true, (int)10);
        this.temporaryBlobs.add(blob);
        int bufferSize = blob.getBufferSize();
        byte[] buffer = new byte[bufferSize];
        OutputStream outputStream = blob.getBinaryOutputStream();
        try {
            int bytes;
            while (length > 0 && (bytes = inputStream.read(buffer)) > 0) {
                void var7_7;
                outputStream.write(buffer, 0, Math.min((int)var7_7, length));
                length -= var7_7;
            }
            outputStream.close();
        }
        catch (IOException ioException) {
            StringWriter stringWriter = new StringWriter();
            ioException.printStackTrace(new PrintWriter(stringWriter));
            throw new SQLException("caused by " + stringWriter.toString(), null, 17002);
        }
        return blob;
    }

    private String convertStreamToString(InputStream inputStream, int length) throws SQLException {
        byte[] buffer = new byte[length];
        int offset = 0;
        int read = 0;
        try {
            while (offset < length && (read = inputStream.read(buffer, offset, length - offset)) > -1) {
                offset += read;
            }
            if (length > offset) {
                length = offset;
            }
            String result = new String(buffer, 0, length, "ISO-8859-1");
            return result;
        }
        catch (IOException ioException) {
            StringWriter stringWriter = new StringWriter();
            ioException.printStackTrace(new PrintWriter(stringWriter));
            throw new SQLException("caused by " + stringWriter.toString(), null, 17002);
        }
    }

    private String convertStreamToString(Reader reader, int length) throws SQLException {
        char[] buffer = new char[length];
        int offset = 0;
        int read = 0;
        try {
            while (offset < length && (read = reader.read(buffer, offset, length - offset)) > -1) {
                offset += read;
            }
            if (length > offset) {
                length = offset;
            }
            String result = new String(buffer, 0, length);
            return result;
        }
        catch (IOException ioException) {
            StringWriter stringWriter = new StringWriter();
            ioException.printStackTrace(new PrintWriter(stringWriter));
            throw new SQLException("caused by " + stringWriter.toString(), null, 17002);
        }
    }

    private Clob convertStringToClob(String string) throws SQLException {
        return this.convertStreamToClob(new StringReader(string), string.length());
    }

    /*
     * WARNING - void declaration
     */
    private Clob convertStreamToClob(InputStream inputStream, int length) throws SQLException {
        CLOB clob = CLOB.createTemporary((Connection)((OracleConnection)this.getConnection()).getWrappedConnection(), (boolean)true, (int)10, (short)2);
        this.temporaryClobs.add(clob);
        int bufferSize = clob.getBufferSize();
        byte[] buffer = new byte[bufferSize];
        OutputStream outputStream = clob.getAsciiOutputStream();
        try {
            int bytes;
            while (length > 0 && (bytes = inputStream.read(buffer)) > 0) {
                void var7_7;
                outputStream.write(buffer, 0, Math.min((int)var7_7, length));
                length -= var7_7;
            }
            outputStream.close();
        }
        catch (IOException ioException) {
            StringWriter stringWriter = new StringWriter();
            ioException.printStackTrace(new PrintWriter(stringWriter));
            throw new SQLException("caused by " + stringWriter.toString(), null, 17002);
        }
        return clob;
    }

    /*
     * WARNING - void declaration
     */
    private Clob convertStreamToClob(Reader reader, int length) throws SQLException {
        CLOB clob = CLOB.createTemporary((Connection)((OracleConnection)this.getConnection()).getWrappedConnection(), (boolean)true, (int)10, (short)2);
        this.temporaryClobs.add(clob);
        int bufferSize = clob.getBufferSize();
        char[] buffer = new char[bufferSize];
        Writer writer = clob.getCharacterOutputStream();
        try {
            int characters;
            while (length > 0 && (characters = reader.read(buffer)) > 0) {
                void var7_7;
                writer.write(buffer, 0, Math.min((int)var7_7, length));
                length -= var7_7;
            }
            writer.close();
        }
        catch (IOException ioException) {
            StringWriter stringWriter = new StringWriter();
            ioException.printStackTrace(new PrintWriter(stringWriter));
            throw new SQLException("caused by " + stringWriter.toString(), null, 17002);
        }
        return clob;
    }

    private void cleanupTemporaryLobs() throws SQLException {
        List invalidTemporaryBlobs = ((AbstractList)this.temporaryBlobs).subList(0, Math.max(0, this.temporaryBlobs.size() - (this.oracleBatchStorage.getParameterCount() + this.oracleBatch.getParameterCount())));
        List invalidTemporaryClobs = ((AbstractList)this.temporaryClobs).subList(0, Math.max(0, this.temporaryClobs.size() - (this.oracleBatchStorage.getParameterCount() + this.oracleBatch.getParameterCount())));
        int i = 0;
        while (i < invalidTemporaryBlobs.size()) {
            ((BLOB)invalidTemporaryBlobs.get(i)).freeTemporary();
            ++i;
        }
        int i2 = 0;
        while (i2 < invalidTemporaryClobs.size()) {
            ((CLOB)invalidTemporaryClobs.get(i2)).freeTemporary();
            ++i2;
        }
        invalidTemporaryBlobs.clear();
        invalidTemporaryClobs.clear();
    }

    private void cleanupTemporaryLobsForClose() throws SQLException {
        ArrayList invalidTemporaryBlobs = this.temporaryBlobs;
        ArrayList invalidTemporaryClobs = this.temporaryClobs;
        int i = 0;
        while (i < invalidTemporaryBlobs.size()) {
            ((BLOB)invalidTemporaryBlobs.get(i)).freeTemporary();
            ++i;
        }
        int i2 = 0;
        while (i2 < invalidTemporaryClobs.size()) {
            ((CLOB)invalidTemporaryClobs.get(i2)).freeTemporary();
            ++i2;
        }
        invalidTemporaryBlobs.clear();
        invalidTemporaryClobs.clear();
    }
}

