/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.oracle;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class OraclePortingServices
extends BasicDbPortingServices {
    private PreparedStatement utcTimeStmt = null;

    public OraclePortingServices(Connection connection) {
        super(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConnectionID() throws SQLException {
        String connectionID;
        Statement statement;
        block6: {
            statement = this.connection.createStatement();
            ResultSet resultSet = null;
            connectionID = null;
            try {
                try {
                    resultSet = statement.executeQuery("SELECT \"HOST_NAME\", \"INSTANCE_NAME\" FROM   \"V$INSTANCE\" ");
                    resultSet.next();
                    connectionID = this.connection.getMetaData().getUserName() + "@" + resultSet.getString(1) + ":" + resultSet.getString(2);
                }
                catch (SQLException sqlException) {
                    SQLException auxSqlException = new SQLException("Access to Oracle dictionary view V$INSTANCE failed.", sqlException.getSQLState(), sqlException.getErrorCode());
                    auxSqlException.setNextException(sqlException);
                    throw auxSqlException;
                }
                Object var7_4 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
                throw throwable;
            }
            resultSet.close();
        }
        statement.close();
        return connectionID;
    }

    public Timestamp getUTCTimestamp() throws SQLException {
        ResultSet rs;
        if (this.utcTimeStmt == null) {
            this.utcTimeStmt = this.connection.prepareStatement("SELECT SYS_EXTRACT_UTC(SYSTIMESTAMP) FROM DUAL");
        }
        if (!(rs = this.utcTimeStmt.executeQuery()).next()) {
            throw new SQLException("Failed to get UTC timestamp on DB server");
        }
        Timestamp ts = rs.getTimestamp(1, this.utcCalendar);
        rs.close();
        return ts;
    }

    public String getSchemaName() throws SQLException {
        return this.connection.getMetaData().getUserName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseName() throws SQLException {
        String databaseName;
        Statement statement;
        block6: {
            statement = this.connection.createStatement();
            ResultSet resultSet = null;
            databaseName = null;
            try {
                try {
                    resultSet = statement.executeQuery("SELECT \"INSTANCE_NAME\" FROM   \"V$INSTANCE\" ");
                    resultSet.next();
                    databaseName = resultSet.getString(1);
                }
                catch (SQLException sqlException) {
                    SQLException auxSqlException = new SQLException("Access to Oracle dictionary view V$INSTANCE failed.", sqlException.getSQLState(), sqlException.getErrorCode());
                    auxSqlException.setNextException(sqlException);
                    throw auxSqlException;
                }
                Object var7_4 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
                throw throwable;
            }
            resultSet.close();
        }
        statement.close();
        return databaseName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseHost() throws SQLException {
        String databaseHost;
        Statement statement;
        block6: {
            statement = this.connection.createStatement();
            ResultSet resultSet = null;
            databaseHost = null;
            try {
                try {
                    resultSet = statement.executeQuery("SELECT \"HOST_NAME\" FROM   \"V$INSTANCE\" ");
                    resultSet.next();
                    databaseHost = resultSet.getString(1);
                }
                catch (SQLException sqlException) {
                    SQLException auxSqlException = new SQLException("Access to Oracle dictionary view V$INSTANCE failed.", sqlException.getSQLState(), sqlException.getErrorCode());
                    auxSqlException.setNextException(sqlException);
                    throw auxSqlException;
                }
                Object var7_4 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
                throw throwable;
            }
            resultSet.close();
        }
        statement.close();
        return databaseHost;
    }

    public int getVendorID() {
        return 5;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        return null;
    }
}

