/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.mss;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class MssPortingServices
extends BasicDbPortingServices {
    private PreparedStatement utcTimeStmt = null;

    public MssPortingServices(Connection con) {
        super(con);
    }

    public String getConnectionID() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String res = null;
        stmt = this.connection.createStatement();
        rs = stmt.executeQuery("select @@servername + ':' + convert(nvarchar,db_id()) + ':' + convert(nvarchar,user_id())");
        rs.next();
        res = rs.getString(1);
        rs.close();
        return res;
    }

    public Timestamp getUTCTimestamp() throws SQLException {
        ResultSet rs;
        if (this.utcTimeStmt == null) {
            this.utcTimeStmt = this.connection.prepareStatement("SELECT GETUTCDATE()");
        }
        if (!(rs = this.utcTimeStmt.executeQuery()).next()) {
            throw new SQLException("Failed to get UTC timestamp on DB server");
        }
        Timestamp ts = rs.getTimestamp(1, this.utcCalendar);
        rs.close();
        return ts;
    }

    public String getDatabaseProductName() throws SQLException {
        Statement stmt = null;
        String productName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("execute master..xp_msver 'ProductName'");
        if (rs.next()) {
            productName = rs.getString("Character_Value");
        }
        rs.close();
        stmt.close();
        return productName;
    }

    public String getDatabaseProductVersion() throws SQLException {
        Statement stmt = null;
        String productVersion = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("execute master..xp_msver 'ProductVersion'");
        if (rs.next()) {
            productVersion = rs.getString("Character_Value");
        }
        rs.close();
        stmt.close();
        return productVersion;
    }

    public String getUserName() throws SQLException {
        Statement stmt = null;
        String userName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select user_name()");
        if (rs.next()) {
            userName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return userName;
    }

    public String getSchemaName() throws SQLException {
        return this.getUserName();
    }

    public String getDatabaseName() throws SQLException {
        Statement stmt = null;
        String dbName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select db_name()");
        if (rs.next()) {
            dbName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return dbName;
    }

    public String getDatabaseHost() throws SQLException {
        Statement stmt = null;
        String serverName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select @@servername");
        if (rs.next()) {
            serverName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return serverName;
    }

    public int getVendorID() {
        return 4;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        Statement stmt = null;
        String version = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select @@version");
        if (rs.next()) {
            version = rs.getString(1);
        }
        rs.close();
        stmt.close();
        if (version.indexOf("64-bit") >= 0) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public boolean selectAllocatesResources(int transactionIsolationLevel) {
        return transactionIsolationLevel > 1;
    }
}

