/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.mss;

import com.sap.sql.jdbc.basic.BasicConnection;
import com.sap.sql.jdbc.mss.MssInetJdbcObjectFactory;
import com.sap.sql.jdbc.mss.MssJdbcObjectFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MssConnection
extends BasicConnection {
    private boolean mssUsed = true;

    public MssConnection(Connection aConnection) {
        super(aConnection);
        try {
            DatabaseMetaData metaData = aConnection.getMetaData();
            this.mssUsed = metaData.getDriverName().trim().startsWith("SQLServer") && metaData.toString().trim().startsWith("com.microsoft.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.factory = this.mssUsed ? new MssJdbcObjectFactory(aConnection) : new MssInetJdbcObjectFactory(aConnection);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        boolean ac = super.getAutoCommit();
        super.setTransactionIsolation(level);
        if (super.getAutoCommit() != ac) {
            super.setAutoCommit(ac);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String sqlLC = sql.toLowerCase();
        if (sqlLC.trim().startsWith("select")) {
            sqlLC.replace('\r', ' ');
            sqlLC.replace('\n', ' ');
            sqlLC.replace('\t', ' ');
            int iFor = sqlLC.indexOf(" for update");
            if (iFor > 0) {
                String rewSql = this.replaceForUpdate(sql, sqlLC);
                return super.prepareStatement(rewSql);
            }
        }
        return super.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String sqlLC = sql.toLowerCase();
        if (sqlLC.trim().startsWith("select")) {
            sqlLC.replace('\r', ' ');
            sqlLC.replace('\n', ' ');
            sqlLC.replace('\t', ' ');
            int iFor = sqlLC.indexOf(" for update");
            if (iFor > 0) {
                String rewSql = this.replaceForUpdate(sql, sqlLC);
                return super.prepareStatement(rewSql, resultSetType, resultSetConcurrency);
            }
        }
        return super.prepareStatement(sql);
    }

    private String replaceForUpdate(String sql, String sqlLC) {
        int iFor = sqlLC.indexOf(" for update");
        int iFrom = sqlLC.indexOf(" from ") + 1;
        int iHint = sqlLC.indexOf(" where ", iFrom);
        if (iHint < 0) {
            iHint = sqlLC.indexOf(" order ", iFrom);
        }
        if (iHint > 0) {
            return sql.substring(0, iHint) + " WITH (UPDLOCK HOLDLOCK)" + sql.substring(iHint, iFor);
        }
        return sql.substring(0, iFor) + " WITH (UPDLOCK HOLDLOCK)";
    }
}

