/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.internal;

import com.sap.sql.connect.OpenSQLConnectionFactory;
import com.sap.sql.jdbc.internal.DriverDataSource;
import com.sap.sql.jdbc.internal.SAPContext;
import com.sap.sql.jdbc.internal.SAPInternalDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class SAPDataSource
implements DataSource,
Referenceable,
ObjectFactory {
    public static final int TYPE_VENDORSQL = 1;
    public static final int TYPE_NATIVESQL = 2;
    public static final int TYPE_OPENSQL = 3;
    private static final String DELIMETER = "&";
    private int type;
    private DataSource dataSource;
    private String connectionName;
    private int stmtPoolSize = -1;

    public SAPDataSource() {
    }

    public SAPDataSource(DataSource dataSource, int type) {
        this.dataSource = dataSource;
        this.type = type;
    }

    public static DataSource getDataSource(String name) throws NamingException {
        DataSource ds;
        String dsName = System.getProperty("DATASOURCE");
        if (dsName == null) {
            dsName = name;
        }
        if ((ds = SAPDataSource.createDataSource(dsName)) != null) {
            return ds;
        }
        try {
            SAPInternalDataSource sds = new SAPInternalDataSource();
            sds.setDataSourceName(dsName);
            return sds;
        }
        catch (Throwable ex) {
            SAPContext ctx = new SAPContext();
            return (DataSource)ctx.lookup(dsName);
        }
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        return this.wrapConnection(conn);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Connection conn = this.dataSource.getConnection(user, password);
        return this.wrapConnection(conn);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reference getReference() throws NamingException {
        ObjectOutputStream out = null;
        try {
            try {
                Reference reference = ((Referenceable)((Object)this.dataSource)).getReference();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                out = new ObjectOutputStream(buffer);
                out.writeObject(reference);
                out.close();
                reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
                reference.add(new BinaryRefAddr("datasource", buffer.toByteArray()));
                reference.add(new StringRefAddr("type", String.valueOf(this.type)));
                Reference reference2 = reference;
                Object var6_7 = null;
                if (out == null) return reference2;
                try {
                    out.close();
                    return reference2;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return reference2;
            }
            catch (FileNotFoundException ex) {
                throw new NamingException("creation of target reference file failed");
            }
            catch (IOException ex) {
                throw new NamingException("target reference file inaccessible");
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (out == null) throw throwable;
            try {}
            catch (IOException ex) {
                throw throwable;
            }
            out.close();
            throw throwable;
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference reference = (Reference)obj;
        this.type = Integer.parseInt((String)reference.get("type").getContent());
        byte[] buffer = (byte[])reference.get("datasource").getContent();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer));
        reference = (Reference)in.readObject();
        in.close();
        Class<?> factoryClass = Class.forName(reference.getFactoryClassName());
        ObjectFactory factory = (ObjectFactory)factoryClass.newInstance();
        this.dataSource = (DataSource)factory.getObjectInstance(reference, null, null, null);
        return this;
    }

    void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setStatementPoolSize(int size) {
        this.stmtPoolSize = size;
    }

    private static DataSource createDataSource(String name) throws NamingException {
        int type;
        int index = name.indexOf("sql&");
        if (index > -1 && index < 7) {
            return SAPDataSource.createDataSourceOld(name);
        }
        if (name.startsWith("vendorsql://")) {
            type = 3;
        } else if (name.startsWith("nativesql://")) {
            type = 2;
        } else if (name.startsWith("opensql://")) {
            type = 1;
        } else {
            return null;
        }
        String props = "jdbc" + name.substring(name.indexOf("://"));
        SAPInternalDataSource ds = null;
        try {
            ds = new SAPInternalDataSource();
            ds.setDataSourceProperties(props);
            ds.setConnectionType(type);
        }
        catch (SQLException ex) {
            throw new NamingException(ex.getMessage());
        }
        return ds;
    }

    private static DataSource createDataSourceOld(String name) throws NamingException {
        String password;
        String user;
        String url;
        String classname;
        int type;
        if (name.startsWith("vendorsql")) {
            type = 1;
        } else if (name.startsWith("nativesql")) {
            type = 2;
        } else if (name.startsWith("opensql")) {
            type = 3;
        } else {
            return null;
        }
        StringTokenizer st = new StringTokenizer(name, DELIMETER);
        try {
            st.nextToken();
            classname = st.nextToken();
            url = st.nextToken();
            user = st.nextToken();
            password = st.nextToken();
        }
        catch (Exception ex) {
            throw new NamingException("Name does not follow pattern (opensql|nativesql|vendorsql)&<classname>&<url>&<user>&<password>");
        }
        SAPDataSource ds = new SAPDataSource(new DriverDataSource(classname, url, user, password), type);
        ds.setConnectionName(url);
        return ds;
    }

    private Connection wrapConnection(Connection conn) throws SQLException {
        switch (this.type) {
            case 1: {
                return conn;
            }
            case 2: {
                return OpenSQLConnectionFactory.createDirectConnection(conn, this.getProperties());
            }
            case 3: {
                return OpenSQLConnectionFactory.createCommonConnection(conn, this.getProperties());
            }
        }
        return null;
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("jndiName", this.connectionName);
        if (this.stmtPoolSize >= 0) {
            props.setProperty("com.sap.sql.jdbc.stmtpool.capacity", new Integer(this.stmtPoolSize).toString());
        }
        return props;
    }
}

