/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.internal;

import com.sap.sql.jdbc.internal.SAPDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SAPContext {
    private static final String propFilename = "com/sap/sql/jdbc/internal/context.properties";
    private String providerUrl = null;
    private File path = null;

    public SAPContext() throws NamingException {
        this.loadProperties();
    }

    public SAPContext(String url) {
        this.providerUrl = url + (url.endsWith("/") ? "" : "/");
    }

    public SAPContext(File path) {
        this.path = path;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object lookup(String name) throws NamingException {
        block17: {
            block16: {
                url = null;
                in = null;
                factoryName = null;
                try {
                    try {
                        if (this.providerUrl != null) {
                            url = this.providerUrl + name;
                            in = new ObjectInputStream(new URL(url).openStream());
                        } else {
                            file = new File(this.path, name);
                            url = file.getAbsolutePath();
                            in = new ObjectInputStream(new FileInputStream(file));
                        }
                        object = in.readObject();
                        if (object instanceof Reference) {
                            reference = (Reference)object;
                            factoryName = reference.getFactoryClassName();
                            factoryClass = Class.forName(factoryName);
                            factory = (ObjectFactory)factoryClass.newInstance();
                            instance = factory.getObjectInstance(reference, null, null, null);
                            if (instance instanceof SAPDataSource) {
                                index = name.lastIndexOf(47) + 1;
                                ((SAPDataSource)instance).setConnectionName(name.substring(index));
                            }
                            var10_17 = instance;
                            var12_18 = null;
                            if (in == null) return var10_17;
                            break block16;
                        }
                        reference = object;
                        break block17;
                    }
                    catch (IOException ex) {
                        throw new NamingException("Failed to access url input stream '" + url + "'");
                    }
                    catch (ClassNotFoundException ex) {
                        throw new NamingException("Factory class '" + factoryName + "' not found");
                    }
                    catch (InstantiationException ex) {
                        throw new NamingException("Failed to access factory class '" + factoryName + "'");
                    }
                    catch (RuntimeException rex) {
                        throw rex;
                    }
                    catch (Exception ex) {
                        throw new NamingException("Factory '" + factoryName + "' failed to create object instance");
                    }
                }
                catch (Throwable var11_24) {
                    var12_20 = null;
                    if (in == null) throw var11_24;
                    try {
                        in.close();
                        throw var11_24;
                    }
                    catch (IOException ex) {
                        throw var11_24;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 364->371)] { 
lbl52:
            // 1 sources

            in.close();
            return var10_17;
lbl54:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var10_17;
        }
        var12_19 = null;
        if (in == null) return reference;
        ** try [egrp 2[TRYBLOCK] [6 : 364->371)] { 
lbl61:
        // 1 sources

        in.close();
        return reference;
lbl63:
        // 1 sources

        catch (IOException ex) {
            // empty catch block
        }
        return reference;
    }

    public String[] list(String name) throws NamingException {
        if (this.providerUrl != null) {
            String url = null;
            Vector<String> list = new Vector<String>();
            try {
                String line;
                url = this.providerUrl + name;
                InputStream in = new URL(url).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null && line.indexOf("Parent Directory") == -1) {
                }
                while ((line = reader.readLine()) != null) {
                    String content;
                    int start = line.indexOf("<A HREF=\"");
                    if (start == -1) continue;
                    int stop = line.indexOf("\">", start += 9);
                    String reference = line.substring(start, stop);
                    if (!reference.equals(content = line.substring(start = stop + 2, stop = line.indexOf("</A>", start)).trim())) continue;
                    list.add(reference);
                }
                reader.close();
            }
            catch (IOException ex) {
                throw new NamingException("Failed to access url input stream '" + url + "'");
            }
            return list.toArray(new String[0]);
        }
        File file = new File(this.path, name);
        if (!file.exists()) {
            throw new NamingException("Failed to access file '" + file.getAbsolutePath() + "'");
        }
        String[] names = file.list();
        if (names != null) {
            return names;
        }
        return new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bind(String name, Object object) throws NamingException {
        ObjectOutputStream out = null;
        try {
            try {
                if (this.path == null) {
                    throw new NamingException("Target path not specified");
                }
                File file = new File(this.path, name);
                file.getParentFile().mkdirs();
                out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(object);
            }
            catch (FileNotFoundException ex) {
                throw new NamingException("Failed to create target object file");
            }
            catch (IOException ex) {
                throw new NamingException("Failed to access target object file");
            }
            Object var7_6 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        out.close();
        return;
    }

    public void unbind(String name) throws NamingException {
        if (this.path == null) {
            throw new NamingException("Target path not specified");
        }
        File file = new File(this.path, name);
        file.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProperties() throws NamingException {
        InputStream in = null;
        try {
            try {
                Properties prop = new Properties();
                in = this.getClass().getClassLoader().getResourceAsStream(propFilename);
                if (in == null) {
                    throw new NamingException("Properties file 'com/sap/sql/jdbc/internal/context.properties' not found");
                }
                prop.load(in);
                String url = prop.getProperty("provider.url");
                if (url == null) {
                    throw new NamingException("Property 'provider.url' not defined in properties file 'com/sap/sql/jdbc/internal/context.properties'");
                }
                this.providerUrl = url + (url.endsWith("/") ? "" : "/");
            }
            catch (IOException ex) {
                throw new NamingException("Failed to access properties file 'com/sap/sql/jdbc/internal/context.properties'");
            }
            Object var5_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        in.close();
        return;
    }
}

